package io.vertx.mutiny.ext.web.client;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.Future;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * An asynchronous HTTP / HTTP/2 client called <code>WebClient</code>.
 * <p>
 * The web client makes easy to do HTTP request/response interactions with a web server, and provides advanced
 * features like:
 * <ul>
 *   <li>Json body encoding / decoding</li>
 *   <li>request/response pumping</li>
 *   <li>error handling</li>
 * </ul>
 * <p>
 * The web client does not deprecate the , it is actually based on it and therefore inherits
 * its configuration and great features like pooling. The <code>HttpClient</code> should be used when fine grained control over the HTTP
 * requests/response is necessary.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.client.WebClient original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.client.WebClient.class)
public class WebClient implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<WebClient> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new WebClient((io.vertx.ext.web.client.WebClient) obj),
    WebClient::getDelegate
  );

  private final io.vertx.ext.web.client.WebClient delegate;
  
  public WebClient(io.vertx.ext.web.client.WebClient delegate) {
    this.delegate = delegate;
  }

  public WebClient(Object delegate) {
    this.delegate = (io.vertx.ext.web.client.WebClient)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  WebClient() {
    this.delegate = null;
  }

  @Override
  public io.vertx.ext.web.client.WebClient getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_30 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_45 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_57 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_2 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_42 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_16 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_20 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_5 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_41 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_49 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_23 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_63 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_12 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_61 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_37 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_27 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_3 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_58 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_50 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_11 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_40 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_4 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_14 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_18 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_52 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_15 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_59 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_34 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_31 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_43 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_28 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_46 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_65 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_10 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_64 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_21 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_17 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_26 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_19 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_32 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_8 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_62 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_44 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_47 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_6 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_55 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_36 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_22 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_35 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_9 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_51 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_53 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_33 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_54 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_29 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_48 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_60 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_24 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_56 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_1 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_25 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_38 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_39 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_13 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_7 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebClient that = (WebClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx the vertx instance
   * @return the created web client
   */
  public static io.vertx.mutiny.ext.web.client.WebClient create(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.web.client.WebClient ret = io.vertx.mutiny.ext.web.client.WebClient.newInstance((io.vertx.ext.web.client.WebClient)io.vertx.ext.web.client.WebClient.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param vertx the vertx instance
   * @param options the Web Client options
   * @return the created web client
   */
  public static io.vertx.mutiny.ext.web.client.WebClient create(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.web.client.WebClientOptions options) { 
    io.vertx.mutiny.ext.web.client.WebClient ret = io.vertx.mutiny.ext.web.client.WebClient.newInstance((io.vertx.ext.web.client.WebClient)io.vertx.ext.web.client.WebClient.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * @param httpClient the  to wrap
   * @return the web client
   */
  public static io.vertx.mutiny.ext.web.client.WebClient wrap(io.vertx.mutiny.core.http.HttpClient httpClient) { 
    io.vertx.mutiny.ext.web.client.WebClient ret = io.vertx.mutiny.ext.web.client.WebClient.newInstance((io.vertx.ext.web.client.WebClient)io.vertx.ext.web.client.WebClient.wrap(httpClient.getDelegate()));
    return ret;
  }

  /**
   * @param httpClient the  to wrap
   * @param options the Web Client options
   * @return the web client
   */
  public static io.vertx.mutiny.ext.web.client.WebClient wrap(io.vertx.mutiny.core.http.HttpClient httpClient, io.vertx.ext.web.client.WebClientOptions options) { 
    io.vertx.mutiny.ext.web.client.WebClient ret = io.vertx.mutiny.ext.web.client.WebClient.newInstance((io.vertx.ext.web.client.WebClient)io.vertx.ext.web.client.WebClient.wrap(httpClient.getDelegate(), options));
    return ret;
  }

  /**
   * @param method the HTTP method
   * @param port the port
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, int port, String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, port, host, requestURI), TYPE_ARG_0);
    return ret;
  }

  /**
   * @param method the HTTP method
   * @param port the port
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, int port, String host, io.vertx.mutiny.uritemplate.UriTemplate requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, port, host, requestURI.getDelegate()), TYPE_ARG_1);
    return ret;
  }

  /**
   * @param method 
   * @param serverAddress 
   * @param port 
   * @param host 
   * @param requestURI 
   * @return 
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, io.vertx.mutiny.core.net.SocketAddress serverAddress, int port, String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, serverAddress.getDelegate(), port, host, requestURI), TYPE_ARG_2);
    return ret;
  }

  /**
   * @param method 
   * @param serverAddress 
   * @param port 
   * @param host 
   * @param requestURI 
   * @return 
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, io.vertx.mutiny.core.net.SocketAddress serverAddress, int port, String host, io.vertx.mutiny.uritemplate.UriTemplate requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, serverAddress.getDelegate(), port, host, requestURI.getDelegate()), TYPE_ARG_3);
    return ret;
  }

  /**
   * @param method the HTTP method
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, host, requestURI), TYPE_ARG_4);
    return ret;
  }

  /**
   * @param method the HTTP method
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, String host, io.vertx.mutiny.uritemplate.UriTemplate requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, host, requestURI.getDelegate()), TYPE_ARG_5);
    return ret;
  }

  /**
   * @param method 
   * @param serverAddress 
   * @param host 
   * @param requestURI 
   * @return 
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, io.vertx.mutiny.core.net.SocketAddress serverAddress, String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, serverAddress.getDelegate(), host, requestURI), TYPE_ARG_6);
    return ret;
  }

  /**
   * @param method 
   * @param serverAddress 
   * @param host 
   * @param requestURI 
   * @return 
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, io.vertx.mutiny.core.net.SocketAddress serverAddress, String host, io.vertx.mutiny.uritemplate.UriTemplate requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, serverAddress.getDelegate(), host, requestURI.getDelegate()), TYPE_ARG_7);
    return ret;
  }

  /**
   * @param method the HTTP method
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, requestURI), TYPE_ARG_8);
    return ret;
  }

  /**
   * @param method the HTTP method
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, io.vertx.mutiny.uritemplate.UriTemplate requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, requestURI.getDelegate()), TYPE_ARG_9);
    return ret;
  }

  /**
   * @param method 
   * @param serverAddress 
   * @param requestURI 
   * @return 
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, io.vertx.mutiny.core.net.SocketAddress serverAddress, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, serverAddress.getDelegate(), requestURI), TYPE_ARG_10);
    return ret;
  }

  /**
   * @param method 
   * @param serverAddress 
   * @param requestURI 
   * @return 
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, io.vertx.mutiny.core.net.SocketAddress serverAddress, io.vertx.mutiny.uritemplate.UriTemplate requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, serverAddress.getDelegate(), requestURI.getDelegate()), TYPE_ARG_11);
    return ret;
  }

  /**
   * @param method the HTTP method
   * @param options the request options
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, io.vertx.core.http.RequestOptions options) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, options), TYPE_ARG_12);
    return ret;
  }

  /**
   * @param method 
   * @param serverAddress 
   * @param options 
   * @return 
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, io.vertx.mutiny.core.net.SocketAddress serverAddress, io.vertx.core.http.RequestOptions options) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, serverAddress.getDelegate(), options), TYPE_ARG_13);
    return ret;
  }

  /**
   * @param method the HTTP method
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> requestAbs(io.vertx.core.http.HttpMethod method, String absoluteURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.requestAbs(method, absoluteURI), TYPE_ARG_14);
    return ret;
  }

  /**
   * @param method the HTTP method
   * @param absoluteURI the absolute URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> requestAbs(io.vertx.core.http.HttpMethod method, io.vertx.mutiny.uritemplate.UriTemplate absoluteURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.requestAbs(method, absoluteURI.getDelegate()), TYPE_ARG_15);
    return ret;
  }

  /**
   * @param method 
   * @param serverAddress 
   * @param absoluteURI 
   * @return 
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> requestAbs(io.vertx.core.http.HttpMethod method, io.vertx.mutiny.core.net.SocketAddress serverAddress, String absoluteURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.requestAbs(method, serverAddress.getDelegate(), absoluteURI), TYPE_ARG_16);
    return ret;
  }

  /**
   * @param method 
   * @param serverAddress 
   * @param absoluteURI 
   * @return 
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> requestAbs(io.vertx.core.http.HttpMethod method, io.vertx.mutiny.core.net.SocketAddress serverAddress, io.vertx.mutiny.uritemplate.UriTemplate absoluteURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.requestAbs(method, serverAddress.getDelegate(), absoluteURI.getDelegate()), TYPE_ARG_17);
    return ret;
  }

  /**
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> get(String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.get(requestURI), TYPE_ARG_18);
    return ret;
  }

  /**
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> get(io.vertx.mutiny.uritemplate.UriTemplate requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.get(requestURI.getDelegate()), TYPE_ARG_19);
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> get(int port, String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.get(port, host, requestURI), TYPE_ARG_20);
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> get(int port, String host, io.vertx.mutiny.uritemplate.UriTemplate requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.get(port, host, requestURI.getDelegate()), TYPE_ARG_21);
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> get(String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.get(host, requestURI), TYPE_ARG_22);
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> get(String host, io.vertx.mutiny.uritemplate.UriTemplate requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.get(host, requestURI.getDelegate()), TYPE_ARG_23);
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> getAbs(String absoluteURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.getAbs(absoluteURI), TYPE_ARG_24);
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> getAbs(io.vertx.mutiny.uritemplate.UriTemplate absoluteURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.getAbs(absoluteURI.getDelegate()), TYPE_ARG_25);
    return ret;
  }

  /**
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> post(String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.post(requestURI), TYPE_ARG_26);
    return ret;
  }

  /**
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> post(io.vertx.mutiny.uritemplate.UriTemplate requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.post(requestURI.getDelegate()), TYPE_ARG_27);
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> post(int port, String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.post(port, host, requestURI), TYPE_ARG_28);
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> post(int port, String host, io.vertx.mutiny.uritemplate.UriTemplate requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.post(port, host, requestURI.getDelegate()), TYPE_ARG_29);
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> post(String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.post(host, requestURI), TYPE_ARG_30);
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> post(String host, io.vertx.mutiny.uritemplate.UriTemplate requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.post(host, requestURI.getDelegate()), TYPE_ARG_31);
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> postAbs(String absoluteURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.postAbs(absoluteURI), TYPE_ARG_32);
    return ret;
  }

  /**
   * @param absoluteURI the absoluate URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> postAbs(io.vertx.mutiny.uritemplate.UriTemplate absoluteURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.postAbs(absoluteURI.getDelegate()), TYPE_ARG_33);
    return ret;
  }

  /**
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> put(String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.put(requestURI), TYPE_ARG_34);
    return ret;
  }

  /**
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> put(io.vertx.mutiny.uritemplate.UriTemplate requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.put(requestURI.getDelegate()), TYPE_ARG_35);
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> put(int port, String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.put(port, host, requestURI), TYPE_ARG_36);
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> put(int port, String host, io.vertx.mutiny.uritemplate.UriTemplate requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.put(port, host, requestURI.getDelegate()), TYPE_ARG_37);
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> put(String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.put(host, requestURI), TYPE_ARG_38);
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> put(String host, io.vertx.mutiny.uritemplate.UriTemplate requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.put(host, requestURI.getDelegate()), TYPE_ARG_39);
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> putAbs(String absoluteURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.putAbs(absoluteURI), TYPE_ARG_40);
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> putAbs(io.vertx.mutiny.uritemplate.UriTemplate absoluteURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.putAbs(absoluteURI.getDelegate()), TYPE_ARG_41);
    return ret;
  }

  /**
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> delete(String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.delete(requestURI), TYPE_ARG_42);
    return ret;
  }

  /**
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> delete(io.vertx.mutiny.uritemplate.UriTemplate requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.delete(requestURI.getDelegate()), TYPE_ARG_43);
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> delete(int port, String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.delete(port, host, requestURI), TYPE_ARG_44);
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> delete(int port, String host, io.vertx.mutiny.uritemplate.UriTemplate requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.delete(port, host, requestURI.getDelegate()), TYPE_ARG_45);
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> delete(String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.delete(host, requestURI), TYPE_ARG_46);
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> delete(String host, io.vertx.mutiny.uritemplate.UriTemplate requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.delete(host, requestURI.getDelegate()), TYPE_ARG_47);
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> deleteAbs(String absoluteURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.deleteAbs(absoluteURI), TYPE_ARG_48);
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> deleteAbs(io.vertx.mutiny.uritemplate.UriTemplate absoluteURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.deleteAbs(absoluteURI.getDelegate()), TYPE_ARG_49);
    return ret;
  }

  /**
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> patch(String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.patch(requestURI), TYPE_ARG_50);
    return ret;
  }

  /**
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> patch(io.vertx.mutiny.uritemplate.UriTemplate requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.patch(requestURI.getDelegate()), TYPE_ARG_51);
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> patch(int port, String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.patch(port, host, requestURI), TYPE_ARG_52);
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> patch(int port, String host, io.vertx.mutiny.uritemplate.UriTemplate requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.patch(port, host, requestURI.getDelegate()), TYPE_ARG_53);
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> patch(String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.patch(host, requestURI), TYPE_ARG_54);
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> patch(String host, io.vertx.mutiny.uritemplate.UriTemplate requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.patch(host, requestURI.getDelegate()), TYPE_ARG_55);
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> patchAbs(String absoluteURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.patchAbs(absoluteURI), TYPE_ARG_56);
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> patchAbs(io.vertx.mutiny.uritemplate.UriTemplate absoluteURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.patchAbs(absoluteURI.getDelegate()), TYPE_ARG_57);
    return ret;
  }

  /**
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> head(String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.head(requestURI), TYPE_ARG_58);
    return ret;
  }

  /**
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> head(io.vertx.mutiny.uritemplate.UriTemplate requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.head(requestURI.getDelegate()), TYPE_ARG_59);
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> head(int port, String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.head(port, host, requestURI), TYPE_ARG_60);
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> head(int port, String host, io.vertx.mutiny.uritemplate.UriTemplate requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.head(port, host, requestURI.getDelegate()), TYPE_ARG_61);
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> head(String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.head(host, requestURI), TYPE_ARG_62);
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> head(String host, io.vertx.mutiny.uritemplate.UriTemplate requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.head(host, requestURI.getDelegate()), TYPE_ARG_63);
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> headAbs(String absoluteURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.headAbs(absoluteURI), TYPE_ARG_64);
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> headAbs(io.vertx.mutiny.uritemplate.UriTemplate absoluteURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.headAbs(absoluteURI.getDelegate()), TYPE_ARG_65);
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.ext.web.client.WebClient#updateSSLOptions}  but supplying a handler that will be called when the update
   * happened (or has failed).
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param options the new SSL options
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Boolean> updateSSLOptions(io.vertx.core.net.SSLOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.updateSSLOptions(options, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.web.client.WebClient#updateSSLOptions(SSLOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param options the new SSL options
   * @return the Boolean instance produced by the operation.
   */
  public Boolean updateSSLOptionsAndAwait(io.vertx.core.net.SSLOptions options) { 
    return (Boolean) updateSSLOptions(options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.web.client.WebClient#updateSSLOptions(SSLOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.web.client.WebClient#updateSSLOptions(SSLOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.web.client.WebClient#updateSSLOptions(SSLOptions)} but you don't need to compose it with other operations.
   * @param options the new SSL options
   */
  public void updateSSLOptionsAndForget(io.vertx.core.net.SSLOptions options) { 
    updateSSLOptions(options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.ext.web.client.WebClient#updateSSLOptions}  but supplying a handler that will be called when the update
   * happened (or has failed).
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param options the new SSL options
   * @param force force the update when options are equals
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Boolean> updateSSLOptions(io.vertx.core.net.SSLOptions options, boolean force) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.updateSSLOptions(options, force, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.web.client.WebClient#updateSSLOptions(SSLOptions,boolean)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param options the new SSL options
   * @param force force the update when options are equals
   * @return the Boolean instance produced by the operation.
   */
  public Boolean updateSSLOptionsAndAwait(io.vertx.core.net.SSLOptions options, boolean force) { 
    return (Boolean) updateSSLOptions(options, force).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.web.client.WebClient#updateSSLOptions(SSLOptions,boolean)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.web.client.WebClient#updateSSLOptions(SSLOptions,boolean)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.web.client.WebClient#updateSSLOptions(SSLOptions,boolean)} but you don't need to compose it with other operations.
   * @param options the new SSL options
   * @param force force the update when options are equals
   */
  public void updateSSLOptionsAndForget(io.vertx.core.net.SSLOptions options, boolean force) { 
    updateSSLOptions(options, force).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   */
  public void close() { 
    delegate.close();
  }

  public static  WebClient newInstance(io.vertx.ext.web.client.WebClient arg) {
    return arg != null ? new WebClient(arg) : null;
  }

}
