package io.vertx.mutiny.ext.web.client;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.json.JsonArray;
import java.util.List;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.json.JsonObject;

/**
 * An HTTP response.
 * <p>
 * The usual HTTP response attributes are available:
 * <ul>
 *   <li>{@link io.vertx.mutiny.core.http.HttpResponseHead#statusCode} the HTTP status code</li>
 *   <li>{@link io.vertx.mutiny.core.http.HttpResponseHead#statusMessage} the HTTP status message</li>
 *   <li>{@link io.vertx.mutiny.core.http.HttpResponseHead#headers} the HTTP headers</li>
 *   <li>{@link io.vertx.mutiny.core.http.HttpResponseHead#version} the HTTP version</li>
 * </ul>
 * <p>
 * The body of the response is returned by {@link io.vertx.mutiny.ext.web.client.HttpResponse#body} decoded as the format specified by the {@link io.vertx.mutiny.ext.web.codec.BodyCodec} that
 * built the response.
 * <p>
 * Keep in mind that using this <code>HttpResponse</code> impose to fully buffer the response body and should be used for payload
 * that can fit in memory.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.client.HttpResponse original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.client.HttpResponse.class)
public class HttpResponse<T> implements io.smallrye.mutiny.vertx.MutinyDelegate, io.vertx.mutiny.core.http.HttpResponseHead {

  public static final io.smallrye.mutiny.vertx.TypeArg<HttpResponse> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new HttpResponse((io.vertx.ext.web.client.HttpResponse) obj),
    HttpResponse::getDelegate
  );

  private final io.vertx.ext.web.client.HttpResponse<T> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_0;
  
  public HttpResponse(io.vertx.ext.web.client.HttpResponse delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public HttpResponse(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.ext.web.client.HttpResponse)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public HttpResponse(io.vertx.ext.web.client.HttpResponse delegate, io.smallrye.mutiny.vertx.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  HttpResponse() {
    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  @Override
  public io.vertx.ext.web.client.HttpResponse getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpResponse that = (HttpResponse) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public io.vertx.core.http.HttpVersion version() { 
    io.vertx.core.http.HttpVersion ret = delegate.version();
    return ret;
  }

  public int statusCode() { 
    int ret = delegate.statusCode();
    return ret;
  }

  public String statusMessage() { 
    String ret = delegate.statusMessage();
    return ret;
  }

  public io.vertx.mutiny.core.MultiMap headers() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.headers());
    cached_0 = ret;
    return ret;
  }

  public String getHeader(String arg0) { 
    String ret = delegate.getHeader(arg0);
    return ret;
  }

  public List<String> cookies() { 
    if (cached_1 != null) {
      return cached_1;
    }
    List<String> ret = delegate.cookies();
    cached_1 = ret;
    return ret;
  }

  /**
   * @return the trailers
   */
  public io.vertx.mutiny.core.MultiMap trailers() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.trailers());
    cached_2 = ret;
    return ret;
  }

  /**
   * @param trailerName the trailer name
   * @return the trailer value
   */
  public String getTrailer(String trailerName) { 
    String ret = delegate.getTrailer(trailerName);
    return ret;
  }

  /**
   * @return the response body in the format it was decoded.
   */
  public T body() { 
    if (cached_3 != null) {
      return cached_3;
    }
    T ret = (T)__typeArg_0.wrap(delegate.body());
    cached_3 = ret;
    return ret;
  }

  /**
   * @return the response body decoded as a , or <code>null</code> if a codec other than  was used
   */
  public io.vertx.mutiny.core.buffer.Buffer bodyAsBuffer() { 
    if (cached_4 != null) {
      return cached_4;
    }
    io.vertx.mutiny.core.buffer.Buffer ret = io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.bodyAsBuffer());
    cached_4 = ret;
    return ret;
  }

  /**
   * @return the list of all followed redirects, including the final location.
   */
  public List<String> followedRedirects() { 
    if (cached_5 != null) {
      return cached_5;
    }
    List<String> ret = delegate.followedRedirects();
    cached_5 = ret;
    return ret;
  }

  /**
   * @return the response body decoded as a <code>String</code>, or <code>null</code> if a codec other than  was used
   */
  public String bodyAsString() { 
    if (cached_6 != null) {
      return cached_6;
    }
    String ret = delegate.bodyAsString();
    cached_6 = ret;
    return ret;
  }

  /**
   * @param encoding 
   * @return the response body decoded as a <code>String</code> given a specific <code>encoding</code>, or <code>null</code> if a codec other than  was used
   */
  public String bodyAsString(String encoding) { 
    String ret = delegate.bodyAsString(encoding);
    return ret;
  }

  /**
   * @return the response body decoded as , or <code>null</code> if a codec other than  was used
   */
  public JsonObject bodyAsJsonObject() { 
    if (cached_7 != null) {
      return cached_7;
    }
    JsonObject ret = delegate.bodyAsJsonObject();
    cached_7 = ret;
    return ret;
  }

  /**
   * @return the response body decoded as a , or <code>null</code> if a codec other than  was used
   */
  public JsonArray bodyAsJsonArray() { 
    if (cached_8 != null) {
      return cached_8;
    }
    JsonArray ret = delegate.bodyAsJsonArray();
    cached_8 = ret;
    return ret;
  }

  /**
   * @param type 
   * @return the response body decoded as the specified <code>type</code> with the Jackson mapper, or <code>null</code> if a codec other than  was used
   */
  public <R> R bodyAsJson(java.lang.Class<R> type) { 
    R ret = (R)io.smallrye.mutiny.vertx.TypeArg.of(type).wrap(delegate.bodyAsJson(io.smallrye.mutiny.vertx.MutinyHelper.unwrap(type)));
    return ret;
  }

  public String getHeader(java.lang.CharSequence arg0) { 
    String ret = delegate.getHeader(arg0);
    return ret;
  }

  private io.vertx.mutiny.core.MultiMap cached_0;
  private List<String> cached_1;
  private io.vertx.mutiny.core.MultiMap cached_2;
  private T cached_3;
  private io.vertx.mutiny.core.buffer.Buffer cached_4;
  private List<String> cached_5;
  private String cached_6;
  private JsonObject cached_7;
  private JsonArray cached_8;
  public static <T>HttpResponse<T> newInstance(io.vertx.ext.web.client.HttpResponse arg) {
    return arg != null ? new HttpResponse<T>(arg) : null;
  }


  public static <T>HttpResponse<T> newInstance(io.vertx.ext.web.client.HttpResponse arg, io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_T) {
    return arg != null ? new HttpResponse<T>(arg, __typeArg_T) : null;
  }

}
