/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.tracing;

import io.sentry.BaggageHeader;
import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.SpanStatus;
import io.sentry.util.Objects;
import io.sentry.util.TracingUtils;
import io.sentry.util.UrlUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

public class SentrySpanClientWebRequestFilter
implements ExchangeFilterFunction {
    @NotNull
    private final IHub hub;

    public SentrySpanClientWebRequestFilter(@NotNull IHub hub) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
    }

    @NotNull
    public Mono<ClientResponse> filter(@NotNull ClientRequest request, @NotNull ExchangeFunction next) {
        ISpan activeSpan = this.hub.getSpan();
        if (activeSpan == null) {
            this.addBreadcrumb(request, null);
            return next.exchange(this.maybeAddHeaders(request, null));
        }
        ISpan span = activeSpan.startChild("http.client");
        // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull UrlUtils.UrlDetails urlDetails = UrlUtils.parse((String)request.url().toString());
        span.setDescription(request.method().name() + " " + urlDetails.getUrlOrFallback());
        urlDetails.applyToSpan(span);
        ClientRequest clientRequestWithSentryTraceHeader = this.maybeAddHeaders(request, span);
        return next.exchange(clientRequestWithSentryTraceHeader).flatMap(response -> {
            span.setData("http.response.status_code", (Object)response.statusCode().value());
            span.setStatus(SpanStatus.fromHttpStatusCode((int)response.statusCode().value()));
            this.addBreadcrumb(request, (ClientResponse)response);
            span.finish();
            return Mono.just((Object)response);
        }).onErrorMap(throwable -> {
            span.setThrowable(throwable);
            span.setStatus(SpanStatus.INTERNAL_ERROR);
            this.addBreadcrumb(request, null);
            span.finish();
            return throwable;
        });
    }

    private ClientRequest maybeAddHeaders(@NotNull ClientRequest request, @Nullable ISpan span) {
        ClientRequest.Builder requestBuilder = ClientRequest.from((ClientRequest)request);
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable TracingUtils.TracingHeaders tracingHeaders = TracingUtils.traceIfAllowed((IHub)this.hub, (String)request.url().toString(), (List)request.headers().get((Object)"baggage"), (ISpan)span);
        if (tracingHeaders != null) {
            requestBuilder.header(tracingHeaders.getSentryTraceHeader().getName(), new String[]{tracingHeaders.getSentryTraceHeader().getValue()});
            @Nullable BaggageHeader baggageHeader = tracingHeaders.getBaggageHeader();
            if (baggageHeader != null) {
                requestBuilder.headers(httpHeaders -> {
                    httpHeaders.remove((Object)"baggage");
                    httpHeaders.add(baggageHeader.getName(), baggageHeader.getValue());
                });
            }
        }
        return requestBuilder.build();
    }

    private void addBreadcrumb(@NotNull ClientRequest request, @Nullable ClientResponse response) {
        Breadcrumb breadcrumb = Breadcrumb.http((String)request.url().toString(), (String)request.method().name(), response != null ? Integer.valueOf(response.statusCode().value()) : null);
        Hint hint = new Hint();
        hint.set("springExchangeFilter:request", (Object)request);
        if (response != null) {
            hint.set("springExchangeFilter:response", (Object)response);
        }
        this.hub.addBreadcrumb(breadcrumb, hint);
    }
}

