/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.netty.buffer.ByteBufAllocator;
import io.netty.util.IllegalReferenceCountException;
import io.rsocket.DuplexConnection;
import io.rsocket.Payload;
import io.rsocket.core.LeasePermitHandler;
import io.rsocket.core.PayloadValidationUtils;
import io.rsocket.core.RequesterLeaseTracker;
import io.rsocket.core.RequesterResponderSupport;
import io.rsocket.core.SendUtils;
import io.rsocket.core.StateUtils;
import io.rsocket.frame.FrameType;
import io.rsocket.plugins.RequestInterceptor;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.util.annotation.NonNull;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class SlowFireAndForgetRequesterMono
extends Mono<Void>
implements LeasePermitHandler,
Subscription,
Scannable {
    volatile long state;
    static final AtomicLongFieldUpdater<SlowFireAndForgetRequesterMono> STATE = AtomicLongFieldUpdater.newUpdater(SlowFireAndForgetRequesterMono.class, "state");
    final Payload payload;
    final ByteBufAllocator allocator;
    final int mtu;
    final int maxFrameLength;
    final RequesterResponderSupport requesterResponderSupport;
    final DuplexConnection connection;
    @Nullable
    final RequesterLeaseTracker requesterLeaseTracker;
    @Nullable
    final RequestInterceptor requestInterceptor;
    CoreSubscriber<? super Void> actual;

    SlowFireAndForgetRequesterMono(Payload payload, RequesterResponderSupport requesterResponderSupport) {
        this.allocator = requesterResponderSupport.getAllocator();
        this.payload = payload;
        this.mtu = requesterResponderSupport.getMtu();
        this.maxFrameLength = requesterResponderSupport.getMaxFrameLength();
        this.requesterResponderSupport = requesterResponderSupport;
        this.connection = requesterResponderSupport.getDuplexConnection();
        this.requestInterceptor = requesterResponderSupport.getRequestInterceptor();
        this.requesterLeaseTracker = requesterResponderSupport.getRequesterLeaseTracker();
    }

    public void subscribe(CoreSubscriber<? super Void> actual) {
        RequesterLeaseTracker requesterLeaseTracker = this.requesterLeaseTracker;
        boolean leaseEnabled = requesterLeaseTracker != null;
        long previousState = StateUtils.markSubscribed(STATE, this, !leaseEnabled);
        if (StateUtils.isSubscribedOrTerminated(previousState)) {
            IllegalStateException e = new IllegalStateException("FireAndForgetMono allows only a single Subscriber");
            RequestInterceptor requestInterceptor = this.requestInterceptor;
            if (requestInterceptor != null) {
                requestInterceptor.onReject(e, FrameType.REQUEST_FNF, null);
            }
            Operators.error(actual, (Throwable)e);
            return;
        }
        Payload p = this.payload;
        int mtu = this.mtu;
        try {
            if (!PayloadValidationUtils.isValid(mtu, this.maxFrameLength, p, false)) {
                StateUtils.lazyTerminate(STATE, this);
                IllegalArgumentException e = new IllegalArgumentException(String.format("The payload is too big to be send as a single frame with a max frame length %s. Consider enabling fragmentation.", this.maxFrameLength));
                RequestInterceptor requestInterceptor = this.requestInterceptor;
                if (requestInterceptor != null) {
                    requestInterceptor.onReject(e, FrameType.REQUEST_FNF, p.metadata());
                }
                p.release();
                Operators.error(actual, (Throwable)e);
                return;
            }
        }
        catch (IllegalReferenceCountException e) {
            StateUtils.lazyTerminate(STATE, this);
            RequestInterceptor requestInterceptor = this.requestInterceptor;
            if (requestInterceptor != null) {
                requestInterceptor.onReject(e, FrameType.REQUEST_FNF, null);
            }
            Operators.error(actual, (Throwable)e);
            return;
        }
        this.actual = actual;
        actual.onSubscribe((Subscription)this);
        if (leaseEnabled) {
            requesterLeaseTracker.issue(this);
            return;
        }
        this.sendFirstFrame(p);
    }

    @Override
    public boolean handlePermit() {
        long previousState = StateUtils.markReadyToSendFirstFrame(STATE, this);
        if (StateUtils.isTerminated(previousState)) {
            return false;
        }
        this.sendFirstFrame(this.payload);
        return true;
    }

    void sendFirstFrame(Payload p) {
        int streamId;
        CoreSubscriber<? super Void> actual = this.actual;
        try {
            streamId = this.requesterResponderSupport.getNextStreamId();
        }
        catch (Throwable t) {
            StateUtils.lazyTerminate(STATE, this);
            Throwable ut = Exceptions.unwrap((Throwable)t);
            RequestInterceptor requestInterceptor = this.requestInterceptor;
            if (requestInterceptor != null) {
                requestInterceptor.onReject(ut, FrameType.REQUEST_FNF, p.metadata());
            }
            p.release();
            actual.onError(ut);
            return;
        }
        RequestInterceptor interceptor = this.requestInterceptor;
        if (interceptor != null) {
            interceptor.onStart(streamId, FrameType.REQUEST_FNF, p.metadata());
        }
        try {
            if (StateUtils.isTerminated(this.state)) {
                p.release();
                if (interceptor != null) {
                    interceptor.onCancel(streamId, FrameType.REQUEST_FNF);
                }
                return;
            }
            SendUtils.sendReleasingPayload(streamId, FrameType.REQUEST_FNF, this.mtu, p, this.connection, this.allocator, true);
        }
        catch (Throwable e) {
            StateUtils.lazyTerminate(STATE, this);
            if (interceptor != null) {
                interceptor.onTerminate(streamId, FrameType.REQUEST_FNF, e);
            }
            actual.onError(e);
            return;
        }
        StateUtils.lazyTerminate(STATE, this);
        if (interceptor != null) {
            interceptor.onTerminate(streamId, FrameType.REQUEST_FNF, null);
        }
        actual.onComplete();
    }

    public void request(long n) {
    }

    public void cancel() {
        long previousState = StateUtils.markTerminated(STATE, this);
        if (StateUtils.isTerminated(previousState)) {
            return;
        }
        if (!StateUtils.isReadyToSendFirstFrame(previousState)) {
            this.payload.release();
        }
    }

    @Override
    public final void handlePermitError(Throwable cause) {
        long previousState = StateUtils.markTerminated(STATE, this);
        if (StateUtils.isTerminated(previousState)) {
            Operators.onErrorDropped((Throwable)cause, (Context)this.actual.currentContext());
            return;
        }
        Payload p = this.payload;
        RequestInterceptor requestInterceptor = this.requestInterceptor;
        if (requestInterceptor != null) {
            requestInterceptor.onReject(cause, FrameType.REQUEST_RESPONSE, p.metadata());
        }
        p.release();
        this.actual.onError(cause);
    }

    public Object scanUnsafe(Scannable.Attr key) {
        return null;
    }

    @NonNull
    public String stepName() {
        return "source(FireAndForgetMono)";
    }
}

