/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.netty.buffer.ByteBufAllocator;
import io.rsocket.Availability;
import io.rsocket.DuplexConnection;
import io.rsocket.frame.LeaseFrameCodec;
import io.rsocket.lease.Lease;
import io.rsocket.lease.LeaseSender;
import io.rsocket.lease.MissingLeaseException;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.publisher.BaseSubscriber;
import reactor.util.annotation.Nullable;

final class ResponderLeaseTracker
extends BaseSubscriber<Lease>
implements Disposable,
Availability {
    final String tag;
    final ByteBufAllocator allocator;
    final DuplexConnection connection;
    @Nullable
    volatile MutableLease currentLease;

    ResponderLeaseTracker(String tag, DuplexConnection connection, LeaseSender leaseSender) {
        this.tag = tag;
        this.connection = connection;
        this.allocator = connection.alloc();
        leaseSender.send().subscribe((CoreSubscriber)this);
    }

    @Nullable
    Throwable use() {
        MutableLease lease = this.currentLease;
        String tag = this.tag;
        if (lease == null) {
            return new MissingLeaseException(String.format("[%s] Lease was not issued yet", tag));
        }
        if (ResponderLeaseTracker.isExpired(lease)) {
            return new MissingLeaseException(String.format("[%s] Missing leases. Lease is expired", tag));
        }
        int allowedRequests = lease.allowedRequests;
        int remainingRequests = lease.remainingRequests;
        if (remainingRequests <= 0) {
            return new MissingLeaseException(String.format("[%s] Missing leases. Issued [%s] request allowance is used", tag, allowedRequests));
        }
        lease.remainingRequests = remainingRequests - 1;
        return null;
    }

    protected void hookOnNext(Lease lease) {
        int allowedRequests = lease.numberOfRequests();
        int ttl = lease.timeToLiveInMillis();
        long expireAt = lease.expirationTime();
        this.currentLease = new MutableLease(allowedRequests, expireAt);
        this.connection.sendFrame(0, LeaseFrameCodec.encode(this.allocator, ttl, allowedRequests, lease.metadata()));
    }

    @Override
    public double availability() {
        MutableLease lease = this.currentLease;
        if (lease == null || ResponderLeaseTracker.isExpired(lease)) {
            return 0.0;
        }
        return (double)lease.remainingRequests / (double)lease.allowedRequests;
    }

    static boolean isExpired(MutableLease currentLease) {
        return System.currentTimeMillis() >= currentLease.expireAt;
    }

    static final class MutableLease {
        final int allowedRequests;
        final long expireAt;
        int remainingRequests;

        MutableLease(int allowedRequests, long expireAt) {
            this.allowedRequests = allowedRequests;
            this.expireAt = expireAt;
            this.remainingRequests = allowedRequests;
        }
    }
}

