/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.attribute;

import io.quarkus.vertx.http.runtime.attribute.CompositeExchangeAttribute;
import io.quarkus.vertx.http.runtime.attribute.ConstantExchangeAttribute;
import io.quarkus.vertx.http.runtime.attribute.ExchangeAttribute;
import io.quarkus.vertx.http.runtime.attribute.ExchangeAttributeBuilder;
import io.quarkus.vertx.http.runtime.attribute.ExchangeAttributeWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import org.jboss.logging.Logger;

public class ExchangeAttributeParser {
    private static final Logger log = Logger.getLogger(ExchangeAttributeParser.class);
    private final List<ExchangeAttributeBuilder> builders;
    private final List<ExchangeAttributeWrapper> wrappers;

    public ExchangeAttributeParser(List<ExchangeAttributeWrapper> wrappers) {
        this(ExchangeAttributeParser.class.getClassLoader(), wrappers);
    }

    public ExchangeAttributeParser(ClassLoader classLoader, List<ExchangeAttributeWrapper> wrappers) {
        this.wrappers = wrappers;
        ServiceLoader<ExchangeAttributeBuilder> loader = ServiceLoader.load(ExchangeAttributeBuilder.class, classLoader);
        ArrayList<ExchangeAttributeBuilder> builders = new ArrayList<ExchangeAttributeBuilder>();
        for (ExchangeAttributeBuilder instance : loader) {
            builders.add(instance);
        }
        builders.sort(new Comparator<ExchangeAttributeBuilder>(){

            @Override
            public int compare(ExchangeAttributeBuilder o1, ExchangeAttributeBuilder o2) {
                return Integer.compare(o2.priority(), o1.priority());
            }
        });
        this.builders = Collections.unmodifiableList(builders);
    }

    public ExchangeAttribute parse(String valueString) {
        ArrayList<ExchangeAttribute> attributes = new ArrayList<ExchangeAttribute>();
        int pos = 0;
        int state = 0;
        block11: for (int i = 0; i < valueString.length(); ++i) {
            char c = valueString.charAt(i);
            switch (state) {
                case 0: {
                    if (c != '%' && c != '$') continue block11;
                    if (pos != i) {
                        attributes.add(this.wrap(this.parseSingleToken(valueString.substring(pos, i))));
                        pos = i;
                    }
                    if (c == '%') {
                        state = 1;
                        continue block11;
                    }
                    state = 3;
                    continue block11;
                }
                case 1: {
                    if (c == '{') {
                        state = 2;
                        continue block11;
                    }
                    if (c == '%') {
                        attributes.add(this.wrap(new ConstantExchangeAttribute("%")));
                        pos = i + 1;
                        state = 0;
                        continue block11;
                    }
                    attributes.add(this.wrap(this.parseSingleToken(valueString.substring(pos, i + 1))));
                    pos = i + 1;
                    state = 0;
                    continue block11;
                }
                case 2: {
                    if (c != '}') continue block11;
                    attributes.add(this.wrap(this.parseSingleToken(valueString.substring(pos, i + 1))));
                    pos = i + 1;
                    state = 0;
                    continue block11;
                }
                case 3: {
                    if (c == '{') {
                        state = 4;
                        continue block11;
                    }
                    if (c == '$') {
                        attributes.add(this.wrap(new ConstantExchangeAttribute("$")));
                        pos = i + 1;
                        state = 0;
                        continue block11;
                    }
                    attributes.add(this.wrap(this.parseSingleToken(valueString.substring(pos, i + 1))));
                    pos = i + 1;
                    state = 0;
                    continue block11;
                }
                case 4: {
                    if (c != '}') continue block11;
                    attributes.add(this.wrap(this.parseSingleToken(valueString.substring(pos, i + 1))));
                    pos = i + 1;
                    state = 0;
                }
            }
        }
        switch (state) {
            case 0: 
            case 1: 
            case 3: {
                if (pos == valueString.length()) break;
                attributes.add(this.wrap(this.parseSingleToken(valueString.substring(pos))));
                break;
            }
            case 2: 
            case 4: {
                throw new RuntimeException("Mismatched braces: " + valueString);
            }
        }
        if (attributes.size() == 1) {
            return (ExchangeAttribute)attributes.get(0);
        }
        return new CompositeExchangeAttribute(attributes.toArray(new ExchangeAttribute[attributes.size()]));
    }

    public ExchangeAttribute parseSingleToken(String token) {
        for (ExchangeAttributeBuilder builder : this.builders) {
            ExchangeAttribute res = builder.build(token);
            if (res == null) continue;
            return res;
        }
        if (token.startsWith("%")) {
            log.errorf("Unknown token %s", (Object)token);
        }
        return new ConstantExchangeAttribute(token);
    }

    private ExchangeAttribute wrap(ExchangeAttribute attribute) {
        ExchangeAttribute res = attribute;
        for (ExchangeAttributeWrapper w : this.wrappers) {
            res = w.wrap(res);
        }
        return res;
    }
}

