/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.quarkus.runtime.configuration.TrimmedStringConverter;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;

public interface FormAuthConfig {
    @WithDefault(value="/login.html")
    public Optional<String> loginPage();

    public Optional<Set<@WithConverter(value=TrimmedStringConverter.class) String>> loginPageQueryParams();

    @WithDefault(value="j_username")
    public String usernameParameter();

    @WithDefault(value="j_password")
    public String passwordParameter();

    @WithDefault(value="/error.html")
    public Optional<String> errorPage();

    @WithDefault(value="${quarkus.http.auth.form.login-page-query-params:}")
    public Optional<Set<@WithConverter(value=TrimmedStringConverter.class) String>> errorPageQueryParams();

    @WithDefault(value="/index.html")
    public Optional<String> landingPage();

    @WithDefault(value="${quarkus.http.auth.form.login-page-query-params:}")
    public Optional<Set<@WithConverter(value=TrimmedStringConverter.class) String>> landingPageQueryParams();

    @WithDefault(value="quarkus-redirect-location")
    public String locationCookie();

    @WithDefault(value="PT30M")
    public Duration timeout();

    @WithDefault(value="PT1M")
    public Duration newCookieInterval();

    @WithDefault(value="quarkus-credential")
    public String cookieName();

    @WithDefault(value="/")
    public Optional<String> cookiePath();

    public Optional<String> cookieDomain();

    @WithDefault(value="false")
    public boolean httpOnlyCookie();

    @WithDefault(value="strict")
    public CookieSameSite cookieSameSite();

    public Optional<Duration> cookieMaxAge();

    @WithDefault(value="/j_security_check")
    public String postLocation();

    public static enum CookieSameSite {
        STRICT,
        LAX,
        NONE;

    }
}

