/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ContextInstanceHandle;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.impl.ComputingCache;
import io.quarkus.arc.impl.ContextInstanceHandleImpl;
import io.undertow.servlet.handlers.ServletRequestContext;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.Destroyed;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Event;
import jakarta.servlet.annotation.WebListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

@WebListener
public class HttpSessionContext
implements InjectableContext,
HttpSessionListener {
    private static final String CONTEXTUAL_INSTANCES_KEY = HttpSessionContext.class.getName() + ".contextualInstances";
    private static final ThreadLocal<HttpSession> DESTRUCT_SESSION = new ThreadLocal();
    private static final Logger LOG = Logger.getLogger(HttpSessionContext.class);

    public Class<? extends Annotation> getScope() {
        return SessionScoped.class;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        HttpSession session = this.session(true);
        if (session == null) {
            throw new ContextNotActiveException();
        }
        InjectableBean bean = (InjectableBean)contextual;
        ComputingCache<Key, ContextInstanceHandle<?>> contextualInstances = this.getContextualInstances(session);
        if (creationalContext != null) {
            return (T)((ContextInstanceHandle)contextualInstances.getValue((Object)new Key(creationalContext, bean.getIdentifier()))).get();
        }
        InstanceHandle handle = (InstanceHandle)contextualInstances.getValueIfPresent((Object)Key.of(bean.getIdentifier()));
        return (T)(handle != null ? handle.get() : null);
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    public boolean isActive() {
        return this.session(true) != null;
    }

    public InjectableContext.ContextState getState() {
        return new InjectableContext.ContextState(){

            public Map<InjectableBean<?>, Object> getContextualInstances() {
                HttpSession session = HttpSessionContext.this.session(false);
                if (session != null) {
                    return HttpSessionContext.this.getContextualInstances(session).getPresentValues().stream().collect(Collectors.toMap(InstanceHandle::getBean, InstanceHandle::get));
                }
                return Collections.emptyMap();
            }
        };
    }

    public void destroy(Contextual<?> contextual) {
        HttpSession session = this.session(true);
        if (session == null) {
            throw new ContextNotActiveException();
        }
        InjectableBean bean = (InjectableBean)contextual;
        InstanceHandle instanceHandle = (InstanceHandle)this.getContextualInstances(session).remove((Object)Key.of(bean.getIdentifier()));
        if (instanceHandle != null) {
            instanceHandle.destroy();
        }
    }

    public void destroy() {
        HttpSession session = this.session(true);
        if (session == null) {
            throw new ContextNotActiveException();
        }
        this.destroy(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy(HttpSession session) {
        HttpSessionContext httpSessionContext = this;
        synchronized (httpSessionContext) {
            ComputingCache<Key, ContextInstanceHandle<?>> instances = this.getContextualInstances(session);
            for (ContextInstanceHandle instance : instances.getPresentValues()) {
                ContextInstanceHandle val = (ContextInstanceHandle)instances.remove((Object)Key.of(instance.getBean().getIdentifier()));
                if (val == null) continue;
                try {
                    val.destroy();
                }
                catch (Exception e) {
                    LOG.errorf((Throwable)e, "Unable to destroy bean instance: %s", val.get());
                }
            }
            if (!instances.isEmpty()) {
                LOG.warnf("Some @SessionScoped beans were created during destruction of the session context: %s\n\t- potential @PreDestroy callbacks declared on the beans were not invoked\n\t- in general, @SessionScoped beans should not call other @SessionScoped beans in a @PreDestroy callback", instances.getPresentValues().stream().map(InstanceHandle::getBean).collect(Collectors.toList()));
            }
            instances.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComputingCache<Key, ContextInstanceHandle<?>> getContextualInstances(HttpSession session) {
        ComputingCache contextualInstances = (ComputingCache)session.getAttribute(CONTEXTUAL_INSTANCES_KEY);
        if (contextualInstances == null) {
            HttpSessionContext httpSessionContext = this;
            synchronized (httpSessionContext) {
                contextualInstances = (ComputingCache)session.getAttribute(CONTEXTUAL_INSTANCES_KEY);
                if (contextualInstances == null) {
                    contextualInstances = new ComputingCache(key -> {
                        InjectableBean bean = Arc.container().bean(key.beanIdentifier);
                        if (key.creationalContext == null) {
                            throw new IllegalStateException("Cannot create bean ");
                        }
                        return new ContextInstanceHandleImpl(bean, bean.create(key.creationalContext), key.creationalContext);
                    });
                    session.setAttribute(CONTEXTUAL_INSTANCES_KEY, (Object)contextualInstances);
                }
            }
        }
        return contextualInstances;
    }

    private HttpSession session(boolean create) {
        HttpSession session = null;
        try {
            session = ((HttpServletRequest)ServletRequestContext.requireCurrent().getServletRequest()).getSession(create);
        }
        catch (IllegalStateException ignored) {
            session = DESTRUCT_SESSION.get();
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        Event event = Arc.container().beanManager().getEvent();
        event.select(HttpSession.class, new Annotation[]{BeforeDestroyed.Literal.SESSION}).fire((Object)session);
        try {
            DESTRUCT_SESSION.set(session);
            this.destroy(session);
            event.select(HttpSession.class, new Annotation[]{Destroyed.Literal.SESSION}).fire((Object)session);
        }
        finally {
            DESTRUCT_SESSION.remove();
        }
    }

    public void sessionCreated(HttpSessionEvent se) {
        Arc.container().beanManager().getEvent().select(HttpSession.class, new Annotation[]{Initialized.Literal.SESSION}).fire((Object)se.getSession());
    }

    static class Key {
        CreationalContext<?> creationalContext;
        String beanIdentifier;

        static Key of(String beanIdentifier) {
            return new Key(null, beanIdentifier);
        }

        public Key(CreationalContext<?> creationalContext, String beanIdentifier) {
            this.creationalContext = creationalContext;
            this.beanIdentifier = beanIdentifier;
        }

        public int hashCode() {
            return Objects.hash(this.beanIdentifier);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            return Objects.equals(this.beanIdentifier, other.beanIdentifier);
        }
    }
}

