/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.metrics.runtime;

import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.MetricType;

public class MetadataHolder {
    private String name;
    private MetricType metricType;
    private String description;
    private String displayName;
    private String unit;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public void setMetricType(MetricType metricType) {
        this.metricType = metricType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public static MetadataHolder from(Metadata metadata) {
        MetadataHolder result = new MetadataHolder();
        result.name = metadata.getName();
        result.metricType = metadata.getTypeRaw();
        result.description = metadata.getDescription();
        result.displayName = metadata.getDisplayName();
        result.unit = metadata.getUnit();
        return result;
    }

    public Metadata toMetadata() {
        MetadataBuilder builder = Metadata.builder().withName(this.name);
        if (this.description != null) {
            builder.withDescription(this.description);
        }
        if (this.displayName != null) {
            builder.withDisplayName(this.displayName);
        }
        return builder.withType(this.metricType).withUnit(this.unit).build();
    }
}

