/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime.standalone;

import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.vertx.core.http.HttpServerRequest;
import java.security.Principal;
import javax.ws.rs.core.SecurityContext;

public class QuarkusResteasySecurityContext
implements SecurityContext {
    private final HttpServerRequest request;

    public QuarkusResteasySecurityContext(HttpServerRequest request) {
        this.request = request;
    }

    public Principal getUserPrincipal() {
        SecurityIdentity user = CurrentIdentityAssociation.current();
        return user.isAnonymous() ? null : user.getPrincipal();
    }

    public boolean isUserInRole(String role) {
        SecurityIdentity user = CurrentIdentityAssociation.current();
        if (role.equals("**")) {
            return !user.isAnonymous();
        }
        return user.hasRole(role);
    }

    public boolean isSecure() {
        return this.request.isSSL();
    }

    public String getAuthenticationScheme() {
        String authorizationValue = this.request.getHeader("Authorization");
        if (authorizationValue == null) {
            return null;
        }
        return authorizationValue.split(" ")[0].trim();
    }
}

