/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.runtime.AuthenticationCompletionExceptionMapper;
import io.quarkus.resteasy.runtime.AuthenticationFailedExceptionMapper;
import io.quarkus.resteasy.runtime.AuthenticationRedirectExceptionMapper;
import io.quarkus.resteasy.runtime.CompositeExceptionMapper;
import io.quarkus.resteasy.runtime.ExceptionMapperRecorder;
import io.quarkus.resteasy.runtime.ForbiddenExceptionMapper;
import io.quarkus.resteasy.runtime.JaxRsSecurityConfig;
import io.quarkus.resteasy.runtime.NotFoundExceptionMapper;
import io.quarkus.resteasy.runtime.SecurityContextFilter;
import io.quarkus.resteasy.runtime.UnauthorizedExceptionMapper;
import io.quarkus.resteasy.runtime.vertx.JsonArrayReader;
import io.quarkus.resteasy.runtime.vertx.JsonArrayWriter;
import io.quarkus.resteasy.runtime.vertx.JsonObjectReader;
import io.quarkus.resteasy.runtime.vertx.JsonObjectWriter;
import io.quarkus.resteasy.server.common.deployment.ResteasyDeploymentBuildItem;
import io.quarkus.security.spi.AdditionalSecuredClassesBuildItem;
import io.quarkus.security.spi.SecurityTransformerUtils;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.quarkus.vertx.http.deployment.devmode.RouteDescriptionBuildItem;
import io.quarkus.vertx.http.runtime.devmode.AdditionalRouteDescription;
import io.quarkus.vertx.http.runtime.devmode.RouteDescription;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public class ResteasyBuiltinsProcessor {
    protected static final String META_INF_RESOURCES = "META-INF/resources";

    @BuildStep
    void setUpDenyAllJaxRs(CombinedIndexBuildItem index, JaxRsSecurityConfig config, ResteasyDeploymentBuildItem resteasyDeployment, BuildProducer<AdditionalSecuredClassesBuildItem> additionalSecuredClasses) {
        if (config.denyJaxRs && resteasyDeployment != null) {
            ArrayList<ClassInfo> classes = new ArrayList<ClassInfo>();
            List resourceClasses = resteasyDeployment.getDeployment().getScannedResourceClasses();
            for (String className : resourceClasses) {
                ClassInfo classInfo = index.getIndex().getClassByName(DotName.createSimple((String)className));
                if (SecurityTransformerUtils.hasSecurityAnnotation((ClassInfo)classInfo)) continue;
                classes.add(classInfo);
            }
            additionalSecuredClasses.produce((BuildItem)new AdditionalSecuredClassesBuildItem(classes));
        } else if (config.defaultRolesAllowed.isPresent() && resteasyDeployment != null) {
            ArrayList<ClassInfo> classes = new ArrayList<ClassInfo>();
            List resourceClasses = resteasyDeployment.getDeployment().getScannedResourceClasses();
            for (String className : resourceClasses) {
                ClassInfo classInfo = index.getIndex().getClassByName(DotName.createSimple((String)className));
                if (SecurityTransformerUtils.hasSecurityAnnotation((ClassInfo)classInfo)) continue;
                classes.add(classInfo);
            }
            additionalSecuredClasses.produce((BuildItem)new AdditionalSecuredClassesBuildItem(classes, config.defaultRolesAllowed));
        }
    }

    @BuildStep
    void setUpSecurity(BuildProducer<ResteasyJaxrsProviderBuildItem> providers, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItem, Capabilities capabilities) {
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(UnauthorizedExceptionMapper.class.getName()));
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(ForbiddenExceptionMapper.class.getName()));
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(AuthenticationFailedExceptionMapper.class.getName()));
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(AuthenticationRedirectExceptionMapper.class.getName()));
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(AuthenticationCompletionExceptionMapper.class.getName()));
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(CompositeExceptionMapper.class.getName()));
        if (capabilities.isPresent("io.quarkus.security")) {
            providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(SecurityContextFilter.class.getName()));
            additionalBeanBuildItem.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(SecurityContextFilter.class));
        }
    }

    @BuildStep
    void vertxProviders(BuildProducer<ResteasyJaxrsProviderBuildItem> providers, Capabilities capabilities) {
        if (capabilities.isPresent("io.quarkus.jackson")) {
            providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(JsonArrayReader.class.getName()));
            providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(JsonArrayWriter.class.getName()));
            providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(JsonObjectReader.class.getName()));
            providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(JsonObjectWriter.class.getName()));
        }
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep(onlyIf={IsDevelopment.class})
    void setupExceptionMapper(BuildProducer<ResteasyJaxrsProviderBuildItem> providers, HttpRootPathBuildItem httpRoot, ExceptionMapperRecorder recorder) {
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(NotFoundExceptionMapper.class.getName()));
        recorder.setHttpRoot(httpRoot.getRootPath());
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep(onlyIf={IsDevelopment.class})
    void addStaticResourcesExceptionMapper(ApplicationArchivesBuildItem applicationArchivesBuildItem, ExceptionMapperRecorder recorder) {
        recorder.setStaticResourceRoots(applicationArchivesBuildItem.getAllApplicationArchives().stream().map(i -> i.getChildPath(META_INF_RESOURCES)).filter(p -> p != null).map(p -> p.toAbsolutePath().toString()).collect(Collectors.toSet()));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep(onlyIf={IsDevelopment.class})
    void addAdditionalEndpointsExceptionMapper(List<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints, ExceptionMapperRecorder recorder, HttpRootPathBuildItem httpRoot) {
        List endpoints = displayableEndpoints.stream().map(displayableAdditionalBuildItem -> new AdditionalRouteDescription(displayableAdditionalBuildItem.getEndpoint(httpRoot), displayableAdditionalBuildItem.getDescription())).sorted().collect(Collectors.toList());
        recorder.setAdditionalEndpoints(endpoints);
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep(onlyIf={IsDevelopment.class})
    void addReactiveRoutesExceptionMapper(List<RouteDescriptionBuildItem> routeDescriptions, ExceptionMapperRecorder recorder, HttpRootPathBuildItem httpRoot) {
        ArrayList<RouteDescription> reactiveRoutes = new ArrayList<RouteDescription>();
        for (RouteDescriptionBuildItem description : routeDescriptions) {
            reactiveRoutes.add(description.getDescription());
        }
        recorder.setReactiveRoutes(reactiveRoutes);
    }
}

