/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import java.nio.file.Path;
import java.util.Objects;

public final class TemplatePathBuildItem
extends MultiBuildItem {
    static final String TAGS = "tags/";
    private final String path;
    private final String content;
    private final Path fullPath;
    private final String extensionInfo;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public TemplatePathBuildItem(String path, Path fullPath, String content) {
        this(Objects.requireNonNull(path), Objects.requireNonNull(content), Objects.requireNonNull(fullPath), null);
    }

    private TemplatePathBuildItem(String path, String content, Path fullPath, String extensionInfo) {
        this.path = path;
        this.content = content;
        this.fullPath = fullPath;
        this.extensionInfo = extensionInfo;
    }

    public String getPath() {
        return this.path;
    }

    public Path getFullPath() {
        return this.fullPath;
    }

    public String getContent() {
        return this.content;
    }

    public String getExtensionInfo() {
        return this.extensionInfo;
    }

    public boolean isTag() {
        return this.path.startsWith(TAGS);
    }

    public boolean isRegular() {
        return !this.isTag();
    }

    public boolean isFileBased() {
        return this.fullPath != null;
    }

    public String getSourceInfo() {
        return this.isFileBased() ? this.getFullPath().toString() : this.extensionInfo;
    }

    public static class Builder {
        private String path;
        private String content;
        private Path fullPath;
        private String extensionInfo;

        public Builder path(String path) {
            this.path = Objects.requireNonNull(path);
            return this;
        }

        public Builder content(String content) {
            this.content = Objects.requireNonNull(content);
            return this;
        }

        public Builder fullPath(Path fullPath) {
            this.fullPath = Objects.requireNonNull(fullPath);
            return this;
        }

        public Builder extensionInfo(String info) {
            this.extensionInfo = info;
            return this;
        }

        public TemplatePathBuildItem build() {
            if (this.fullPath == null && this.extensionInfo == null) {
                throw new IllegalStateException("Templates that are not backed by a file must provide extension info");
            }
            return new TemplatePathBuildItem(this.path, this.content, this.fullPath, this.extensionInfo);
        }
    }
}

