/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.regex.Pattern;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public final class TemplateExtensionMethodBuildItem
extends MultiBuildItem {
    private final MethodInfo method;
    private final String matchName;
    private final String matchRegex;
    private final Pattern matchPattern;
    private final Type matchType;
    private final int priority;
    private final String namespace;

    public TemplateExtensionMethodBuildItem(MethodInfo method, String matchName, String matchRegex, Type matchType, int priority, String namespace) {
        this.method = method;
        this.matchName = matchName;
        this.matchRegex = matchRegex;
        this.matchType = matchType;
        this.priority = priority;
        this.namespace = namespace;
        this.matchPattern = matchRegex == null || matchRegex.isEmpty() ? null : Pattern.compile(matchRegex);
    }

    public MethodInfo getMethod() {
        return this.method;
    }

    public String getMatchName() {
        return this.matchName;
    }

    public String getMatchRegex() {
        return this.matchRegex;
    }

    public Type getMatchType() {
        return this.matchType;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getNamespace() {
        return this.namespace;
    }

    boolean matchesClass(ClassInfo clazz) {
        return this.matchType.name().equals((Object)clazz.name());
    }

    boolean matchesName(String name) {
        if (this.matchPattern != null) {
            return this.matchPattern.matcher(name).matches();
        }
        return "*".equals(this.matchName) ? true : this.matchName.equals(name);
    }

    boolean hasNamespace() {
        return this.namespace != null && !this.namespace.isEmpty();
    }
}

