/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment.devservices.keycloak;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDockerWorking;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerAddress;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.oidc.deployment.OidcBuildStep;
import io.quarkus.oidc.deployment.devservices.OidcDevServicesBuildItem;
import io.quarkus.oidc.deployment.devservices.OidcDevServicesUtils;
import io.quarkus.oidc.deployment.devservices.keycloak.DevServicesConfig;
import io.quarkus.oidc.deployment.devservices.keycloak.KeycloakBuildTimeConfig;
import io.quarkus.oidc.deployment.devservices.keycloak.KeycloakDevServicesConfigBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.RolesRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.util.JsonSerialization;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class KeycloakDevServicesProcessor {
    static volatile Vertx vertxInstance;
    private static final Logger LOG;
    private static final String CONFIG_PREFIX = "quarkus.oidc.";
    private static final String TENANT_ENABLED_CONFIG_KEY = "quarkus.oidc.tenant-enabled";
    private static final String AUTH_SERVER_URL_CONFIG_KEY = "quarkus.oidc.auth-server-url";
    private static final String CLIENT_AUTH_SERVER_URL_CONFIG_KEY = "client.quarkus.oidc.auth-server-url";
    private static final String APPLICATION_TYPE_CONFIG_KEY = "quarkus.oidc.application-type";
    private static final String CLIENT_ID_CONFIG_KEY = "quarkus.oidc.client-id";
    private static final String CLIENT_SECRET_CONFIG_KEY = "quarkus.oidc.credentials.secret";
    private static final String KEYCLOAK_URL_KEY = "keycloak.url";
    private static final String KEYCLOAK_CONTAINER_NAME = "keycloak";
    private static final int KEYCLOAK_PORT = 8080;
    private static final String KEYCLOAK_LEGACY_IMAGE_VERSION_PART = "-legacy";
    private static final String KEYCLOAK_ADMIN_USER = "admin";
    private static final String KEYCLOAK_ADMIN_PASSWORD = "admin";
    private static final String KEYCLOAK_WILDFLY_FRONTEND_URL = "KEYCLOAK_FRONTEND_URL";
    private static final String KEYCLOAK_WILDFLY_USER_PROP = "KEYCLOAK_USER";
    private static final String KEYCLOAK_WILDFLY_PASSWORD_PROP = "KEYCLOAK_PASSWORD";
    private static final String KEYCLOAK_WILDFLY_IMPORT_PROP = "KEYCLOAK_IMPORT";
    private static final String KEYCLOAK_WILDFLY_DB_VENDOR = "H2";
    private static final String KEYCLOAK_WILDFLY_VENDOR_PROP = "DB_VENDOR";
    private static final String KEYCLOAK_QUARKUS_HOSTNAME = "KC_HOSTNAME";
    private static final String KEYCLOAK_QUARKUS_ADMIN_PROP = "KEYCLOAK_ADMIN";
    private static final String KEYCLOAK_QUARKUS_ADMIN_PASSWORD_PROP = "KEYCLOAK_ADMIN_PASSWORD";
    private static final String KEYCLOAK_QUARKUS_START_CMD = "start --http-enabled=true --hostname-strict=false --hostname-strict-https=false";
    private static final String JAVA_OPTS = "JAVA_OPTS";
    private static final String KEYCLOAK_DOCKER_REALM_PATH = "/tmp/realm.json";
    private static final String OIDC_USERS = "oidc.users";
    private static final String DEV_SERVICE_LABEL = "quarkus-dev-service-keycloak";
    private static final ContainerLocator keycloakDevModeContainerLocator;
    private static volatile DevServicesResultBuildItem.RunningDevService devService;
    static volatile DevServicesConfig capturedDevServicesConfiguration;
    private static volatile boolean first;
    private static volatile FileTime capturedRealmFileLastModifiedDate;
    private final IsDockerWorking isDockerWorking = new IsDockerWorking(true);

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={OidcBuildStep.IsEnabled.class, GlobalDevServicesConfig.Enabled.class})
    public DevServicesResultBuildItem startKeycloakContainer(BuildProducer<KeycloakDevServicesConfigBuildItem> keycloakBuildItemBuildProducer, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, Optional<OidcDevServicesBuildItem> oidcProviderBuildItem, KeycloakBuildTimeConfig config, CuratedApplicationShutdownBuildItem closeBuildItem, LaunchModeBuildItem launchMode, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig devServicesConfig) {
        if (oidcProviderBuildItem.isPresent()) {
            return null;
        }
        DevServicesConfig currentDevServicesConfiguration = config.devservices;
        if (devService != null) {
            FileTime currentRealmFileLastModifiedDate;
            boolean restartRequired;
            boolean bl = restartRequired = !currentDevServicesConfiguration.equals(capturedDevServicesConfiguration);
            if (!restartRequired && (currentRealmFileLastModifiedDate = this.getRealmFileLastModifiedDate(currentDevServicesConfiguration.realmPath)) != null && !currentRealmFileLastModifiedDate.equals(capturedRealmFileLastModifiedDate)) {
                restartRequired = true;
                capturedRealmFileLastModifiedDate = currentRealmFileLastModifiedDate;
            }
            if (!restartRequired) {
                return devService.toBuildItem();
            }
            try {
                devService.close();
            }
            catch (Throwable e) {
                LOG.error((Object)"Failed to stop Keycloak container", e);
            }
            devService = null;
            capturedDevServicesConfiguration = null;
        }
        capturedDevServicesConfiguration = currentDevServicesConfiguration;
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "KeyCloak Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        if (vertxInstance == null) {
            vertxInstance = Vertx.vertx();
        }
        try {
            DevServicesResultBuildItem.RunningDevService newDevService = this.startContainer(keycloakBuildItemBuildProducer, !devServicesSharedNetworkBuildItem.isEmpty(), devServicesConfig.timeout);
            if (newDevService == null) {
                compressor.close();
                return null;
            }
            devService = newDevService;
            if (first) {
                first = false;
                Runnable closeTask = new Runnable(){

                    @Override
                    public void run() {
                        if (devService != null) {
                            try {
                                devService.close();
                            }
                            catch (Throwable t) {
                                LOG.error((Object)"Failed to stop Keycloak container", t);
                            }
                        }
                        if (vertxInstance != null) {
                            try {
                                vertxInstance.close();
                            }
                            catch (Throwable t) {
                                LOG.error((Object)"Failed to close Vertx instance", t);
                            }
                        }
                        first = true;
                        devService = null;
                        capturedDevServicesConfiguration = null;
                        vertxInstance = null;
                        capturedRealmFileLastModifiedDate = null;
                    }
                };
                closeBuildItem.addCloseTask(closeTask, true);
            }
            capturedRealmFileLastModifiedDate = this.getRealmFileLastModifiedDate(KeycloakDevServicesProcessor.capturedDevServicesConfiguration.realmPath);
            compressor.close();
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        LOG.info((Object)"Dev Services for Keycloak started.");
        return devService.toBuildItem();
    }

    private String startURL(String host, Integer port, boolean isKeyCloakX) {
        return "http://" + host + ":" + port + (isKeyCloakX ? "" : "/auth");
    }

    private Map<String, String> prepareConfiguration(BuildProducer<KeycloakDevServicesConfigBuildItem> keycloakBuildItemBuildProducer, String internalURL, String hostURL, RealmRepresentation realmRep, boolean keycloakX) {
        String realmName = realmRep != null ? realmRep.getRealm() : this.getDefaultRealmName();
        String authServerInternalUrl = this.realmsURL(internalURL, realmName);
        String clientAuthServerBaseUrl = hostURL != null ? hostURL : internalURL;
        String clientAuthServerUrl = this.realmsURL(clientAuthServerBaseUrl, realmName);
        String oidcClientId = KeycloakDevServicesProcessor.getOidcClientId();
        String oidcClientSecret = KeycloakDevServicesProcessor.getOidcClientSecret();
        String oidcApplicationType = KeycloakDevServicesProcessor.getOidcApplicationType();
        boolean createDefaultRealm = realmRep == null && KeycloakDevServicesProcessor.capturedDevServicesConfiguration.createRealm;
        Map<String, String> users = this.getUsers(KeycloakDevServicesProcessor.capturedDevServicesConfiguration.users, createDefaultRealm);
        if (createDefaultRealm) {
            this.createDefaultRealm(clientAuthServerBaseUrl, users, oidcClientId, oidcClientSecret);
        } else if (realmRep != null && keycloakX) {
            this.createRealm(clientAuthServerBaseUrl, realmRep);
        }
        HashMap<String, String> configProperties = new HashMap<String, String>();
        configProperties.put(KEYCLOAK_URL_KEY, internalURL);
        configProperties.put(AUTH_SERVER_URL_CONFIG_KEY, authServerInternalUrl);
        configProperties.put(CLIENT_AUTH_SERVER_URL_CONFIG_KEY, clientAuthServerUrl);
        configProperties.put(APPLICATION_TYPE_CONFIG_KEY, oidcApplicationType);
        configProperties.put(CLIENT_ID_CONFIG_KEY, oidcClientId);
        configProperties.put(CLIENT_SECRET_CONFIG_KEY, oidcClientSecret);
        keycloakBuildItemBuildProducer.produce((BuildItem)new KeycloakDevServicesConfigBuildItem(configProperties, Map.of(OIDC_USERS, users)));
        return configProperties;
    }

    private String realmsURL(String baseURL, String realmName) {
        return baseURL + "/realms/" + realmName;
    }

    private String getDefaultRealmName() {
        return KeycloakDevServicesProcessor.capturedDevServicesConfiguration.realmName.orElse("quarkus");
    }

    private DevServicesResultBuildItem.RunningDevService startContainer(BuildProducer<KeycloakDevServicesConfigBuildItem> keycloakBuildItemBuildProducer, boolean useSharedNetwork, Optional<Duration> timeout) {
        if (!KeycloakDevServicesProcessor.capturedDevServicesConfiguration.enabled) {
            LOG.debug((Object)"Not starting Dev Services for Keycloak as it has been disabled in the config");
            return null;
        }
        if (!KeycloakDevServicesProcessor.isOidcTenantEnabled()) {
            LOG.debug((Object)"Not starting Dev Services for Keycloak as 'quarkus.oidc.tenant.enabled' is false");
            return null;
        }
        if (ConfigUtils.isPropertyPresent((String)AUTH_SERVER_URL_CONFIG_KEY)) {
            LOG.debug((Object)"Not starting Dev Services for Keycloak as 'quarkus.oidc.auth-server-url' has been provided");
            return null;
        }
        if (!this.isDockerWorking.getAsBoolean()) {
            LOG.warn((Object)"Please configure 'quarkus.oidc.auth-server-url' or get a working docker instance");
            return null;
        }
        Optional maybeContainerAddress = keycloakDevModeContainerLocator.locateContainer(KeycloakDevServicesProcessor.capturedDevServicesConfiguration.serviceName, KeycloakDevServicesProcessor.capturedDevServicesConfiguration.shared, LaunchMode.current());
        String imageName = KeycloakDevServicesProcessor.capturedDevServicesConfiguration.imageName;
        DockerImageName dockerImageName = DockerImageName.parse((String)imageName).asCompatibleSubstituteFor(imageName);
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultKeycloakContainerSupplier = () -> {
            QuarkusOidcContainer oidcContainer = new QuarkusOidcContainer(dockerImageName, KeycloakDevServicesProcessor.capturedDevServicesConfiguration.port, useSharedNetwork, KeycloakDevServicesProcessor.capturedDevServicesConfiguration.realmPath, KeycloakDevServicesProcessor.capturedDevServicesConfiguration.serviceName, KeycloakDevServicesProcessor.capturedDevServicesConfiguration.shared, KeycloakDevServicesProcessor.capturedDevServicesConfiguration.javaOpts);
            timeout.ifPresent(arg_0 -> ((QuarkusOidcContainer)oidcContainer).withStartupTimeout(arg_0));
            oidcContainer.start();
            String internalUrl = this.startURL(oidcContainer.getHost(), oidcContainer.getPort(), oidcContainer.keycloakX);
            String hostUrl = oidcContainer.useSharedNetwork ? this.startURL("localhost", oidcContainer.fixedExposedPort.getAsInt(), oidcContainer.keycloakX) : null;
            Map<String, String> configs = this.prepareConfiguration(keycloakBuildItemBuildProducer, internalUrl, hostUrl, oidcContainer.realmRep, oidcContainer.keycloakX);
            return new DevServicesResultBuildItem.RunningDevService(KEYCLOAK_CONTAINER_NAME, oidcContainer.getContainerId(), () -> ((QuarkusOidcContainer)oidcContainer).close(), configs);
        };
        return maybeContainerAddress.map(containerAddress -> {
            Map<String, String> configs = this.prepareConfiguration(keycloakBuildItemBuildProducer, this.getSharedContainerUrl((ContainerAddress)containerAddress), this.getSharedContainerUrl((ContainerAddress)containerAddress), null, false);
            return new DevServicesResultBuildItem.RunningDevService(KEYCLOAK_CONTAINER_NAME, containerAddress.getId(), null, configs);
        }).orElseGet(defaultKeycloakContainerSupplier);
    }

    private static boolean isKeycloakX(DockerImageName dockerImageName) {
        return KeycloakDevServicesProcessor.capturedDevServicesConfiguration.keycloakXImage.isPresent() ? KeycloakDevServicesProcessor.capturedDevServicesConfiguration.keycloakXImage.get() : !dockerImageName.getVersionPart().endsWith(KEYCLOAK_LEGACY_IMAGE_VERSION_PART);
    }

    private String getSharedContainerUrl(ContainerAddress containerAddress) {
        return "http://" + ("0.0.0.0".equals(containerAddress.getHost()) ? "localhost" : containerAddress.getHost()) + ":" + containerAddress.getPort();
    }

    private FileTime getRealmFileLastModifiedDate(Optional<String> realm) {
        if (realm.isPresent()) {
            Path realmPath = Paths.get(realm.get(), new String[0]);
            try {
                return Files.getLastModifiedTime(realmPath, new LinkOption[0]);
            }
            catch (IOException ex) {
                LOG.tracef("Unable to get the last modified date of the realm file %s", (Object)realmPath);
            }
        }
        return null;
    }

    private void createDefaultRealm(String keycloakUrl, Map<String, String> users, String oidcClientId, String oidcClientSecret) {
        RealmRepresentation realm = this.createRealmRep();
        realm.getClients().add(this.createClient(oidcClientId, oidcClientSecret));
        for (Map.Entry<String, String> entry : users.entrySet()) {
            realm.getUsers().add(this.createUser(entry.getKey(), entry.getValue(), this.getUserRoles(entry.getKey())));
        }
        this.createRealm(keycloakUrl, realm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRealm(String keycloakUrl, RealmRepresentation realm) {
        try (WebClient client = OidcDevServicesUtils.createWebClient(vertxInstance);){
            String token = OidcDevServicesUtils.getPasswordAccessToken(client, keycloakUrl + "/realms/master/protocol/openid-connect/token", "admin-cli", null, "admin", "admin", null, KeycloakDevServicesProcessor.capturedDevServicesConfiguration.webClienTimeout);
            HttpResponse createRealmResponse = (HttpResponse)client.postAbs(keycloakUrl + "/admin/realms").putHeader(HttpHeaders.CONTENT_TYPE.toString(), "application/json").putHeader(HttpHeaders.AUTHORIZATION.toString(), "Bearer " + token).sendBuffer(Buffer.buffer().appendString(JsonSerialization.writeValueAsString((Object)realm))).await().atMost(KeycloakDevServicesProcessor.capturedDevServicesConfiguration.webClienTimeout);
            if (createRealmResponse.statusCode() > 299) {
                LOG.errorf("Realm %s can not be created %d - %s ", (Object)realm.getRealm(), (Object)createRealmResponse.statusCode(), (Object)createRealmResponse.statusMessage());
            }
            Uni realmStatusCodeUni = client.getAbs(keycloakUrl + "/realms/" + realm.getRealm()).send().onItem().transform(resp -> {
                LOG.debugf("Realm status: %d", resp.statusCode());
                if (resp.statusCode() == 200) {
                    return 200;
                }
                throw new RealmEndpointAccessException(resp.statusCode());
            }).onFailure(KeycloakDevServicesProcessor.realmEndpointNotAvailable()).retry().withBackOff(Duration.ofSeconds(2L), Duration.ofSeconds(2L)).expireIn(10000L).onFailure().transform(t -> t.getCause());
            realmStatusCodeUni.await().atMost(Duration.ofSeconds(10L));
        }
    }

    public static Predicate<? super Throwable> realmEndpointNotAvailable() {
        return t -> t instanceof ConnectException || t instanceof RealmEndpointAccessException && ((RealmEndpointAccessException)t).getErrorStatus() == 404;
    }

    private Map<String, String> getUsers(Map<String, String> configuredUsers, boolean createRealm) {
        if (configuredUsers.isEmpty() && createRealm) {
            LinkedHashMap<String, String> users = new LinkedHashMap<String, String>();
            users.put("alice", "alice");
            users.put("bob", "bob");
            return users;
        }
        return configuredUsers;
    }

    private List<String> getUserRoles(String user) {
        List<String> roles = KeycloakDevServicesProcessor.capturedDevServicesConfiguration.roles.get(user);
        return roles == null ? ("alice".equals(user) ? List.of("admin", "user") : List.of("user")) : roles;
    }

    private RealmRepresentation createRealmRep() {
        RealmRepresentation realm = new RealmRepresentation();
        realm.setRealm(this.getDefaultRealmName());
        realm.setEnabled(Boolean.valueOf(true));
        realm.setUsers(new ArrayList());
        realm.setClients(new ArrayList());
        RolesRepresentation roles = new RolesRepresentation();
        ArrayList realmRoles = new ArrayList();
        roles.setRealm(realmRoles);
        realm.setRoles(roles);
        if (KeycloakDevServicesProcessor.capturedDevServicesConfiguration.roles.isEmpty()) {
            realm.getRoles().getRealm().add(new RoleRepresentation("user", null, false));
            realm.getRoles().getRealm().add(new RoleRepresentation("admin", null, false));
        } else {
            HashSet<String> allRoles = new HashSet<String>();
            for (List<String> distinctRoles : KeycloakDevServicesProcessor.capturedDevServicesConfiguration.roles.values()) {
                for (String role : distinctRoles) {
                    if (allRoles.contains(role)) continue;
                    allRoles.add(role);
                    realm.getRoles().getRealm().add(new RoleRepresentation(role, null, false));
                }
            }
        }
        return realm;
    }

    private ClientRepresentation createClient(String clientId, String oidcClientSecret) {
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(clientId);
        client.setRedirectUris(List.of("*"));
        client.setPublicClient(Boolean.valueOf(false));
        client.setSecret(oidcClientSecret);
        client.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
        client.setServiceAccountsEnabled(Boolean.valueOf(true));
        client.setImplicitFlowEnabled(Boolean.valueOf(true));
        client.setEnabled(Boolean.valueOf(true));
        client.setRedirectUris(List.of("*"));
        client.setDefaultClientScopes(List.of("microprofile-jwt"));
        return client;
    }

    private UserRepresentation createUser(String username, String password, List<String> realmRoles) {
        UserRepresentation user = new UserRepresentation();
        user.setUsername(username);
        user.setEnabled(Boolean.valueOf(true));
        user.setCredentials(new ArrayList());
        user.setRealmRoles(realmRoles);
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setType("password");
        credential.setValue(password);
        credential.setTemporary(Boolean.valueOf(false));
        user.getCredentials().add(credential);
        return user;
    }

    private static boolean isOidcTenantEnabled() {
        return ConfigProvider.getConfig().getOptionalValue(TENANT_ENABLED_CONFIG_KEY, Boolean.class).orElse(true);
    }

    private static String getOidcApplicationType() {
        return ConfigProvider.getConfig().getOptionalValue(APPLICATION_TYPE_CONFIG_KEY, String.class).orElse("service");
    }

    private static String getOidcClientId() {
        return ConfigProvider.getConfig().getOptionalValue(CLIENT_ID_CONFIG_KEY, String.class).orElse("quarkus-app");
    }

    private static String getOidcClientSecret() {
        return ConfigProvider.getConfig().getOptionalValue(CLIENT_SECRET_CONFIG_KEY, String.class).orElse("secret");
    }

    static {
        LOG = Logger.getLogger(KeycloakDevServicesProcessor.class);
        keycloakDevModeContainerLocator = new ContainerLocator(DEV_SERVICE_LABEL, 8080);
        first = true;
    }

    static class RealmEndpointAccessException
    extends RuntimeException {
        private final int errorStatus;

        public RealmEndpointAccessException(int errorStatus) {
            this.errorStatus = errorStatus;
        }

        public int getErrorStatus() {
            return this.errorStatus;
        }
    }

    private static class QuarkusOidcContainer
    extends GenericContainer<QuarkusOidcContainer> {
        private final OptionalInt fixedExposedPort;
        private final boolean useSharedNetwork;
        private final Optional<String> realmPath;
        private final String containerLabelValue;
        private final Optional<String> javaOpts;
        private final boolean sharedContainer;
        private String hostName;
        private final boolean keycloakX;
        private RealmRepresentation realmRep;

        public QuarkusOidcContainer(DockerImageName dockerImageName, OptionalInt fixedExposedPort, boolean useSharedNetwork, Optional<String> realmPath, String containerLabelValue, boolean sharedContainer, Optional<String> javaOpts) {
            super(dockerImageName);
            this.useSharedNetwork = useSharedNetwork;
            this.realmPath = realmPath;
            this.containerLabelValue = containerLabelValue;
            this.sharedContainer = sharedContainer;
            this.javaOpts = javaOpts;
            this.keycloakX = KeycloakDevServicesProcessor.isKeycloakX(dockerImageName);
            if (sharedContainer && fixedExposedPort.isEmpty()) {
                fixedExposedPort = OptionalInt.of(this.findRandomPort());
            }
            this.fixedExposedPort = fixedExposedPort;
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)KeycloakDevServicesProcessor.KEYCLOAK_CONTAINER_NAME);
                if (this.keycloakX) {
                    this.addEnv(KeycloakDevServicesProcessor.KEYCLOAK_QUARKUS_HOSTNAME, "localhost");
                } else {
                    this.addEnv(KeycloakDevServicesProcessor.KEYCLOAK_WILDFLY_FRONTEND_URL, "http://localhost:" + this.fixedExposedPort.getAsInt());
                }
            }
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), 8080);
            } else {
                this.addExposedPort(8080);
            }
            if (this.sharedContainer && LaunchMode.current() == LaunchMode.DEVELOPMENT) {
                this.withLabel(KeycloakDevServicesProcessor.DEV_SERVICE_LABEL, this.containerLabelValue);
            }
            if (this.javaOpts.isPresent()) {
                this.addEnv(KeycloakDevServicesProcessor.JAVA_OPTS, this.javaOpts.get());
            }
            if (this.keycloakX) {
                this.addEnv(KeycloakDevServicesProcessor.KEYCLOAK_QUARKUS_ADMIN_PROP, "admin");
                this.addEnv(KeycloakDevServicesProcessor.KEYCLOAK_QUARKUS_ADMIN_PASSWORD_PROP, "admin");
                this.withCommand(KeycloakDevServicesProcessor.KEYCLOAK_QUARKUS_START_CMD + (String)(this.useSharedNetwork ? " --hostname-port=" + this.fixedExposedPort.getAsInt() : ""));
            } else {
                this.addEnv(KeycloakDevServicesProcessor.KEYCLOAK_WILDFLY_USER_PROP, "admin");
                this.addEnv(KeycloakDevServicesProcessor.KEYCLOAK_WILDFLY_PASSWORD_PROP, "admin");
                this.addEnv(KeycloakDevServicesProcessor.KEYCLOAK_WILDFLY_VENDOR_PROP, KeycloakDevServicesProcessor.KEYCLOAK_WILDFLY_DB_VENDOR);
            }
            if (this.realmPath.isPresent()) {
                URL realmPathUrl = null;
                realmPathUrl = Thread.currentThread().getContextClassLoader().getResource(this.realmPath.get());
                if (realmPathUrl != null) {
                    this.realmRep = this.readRealmFile(realmPathUrl, this.realmPath.get());
                    if (!this.keycloakX) {
                        this.withClasspathResourceMapping(this.realmPath.get(), KeycloakDevServicesProcessor.KEYCLOAK_DOCKER_REALM_PATH, BindMode.READ_ONLY);
                    }
                } else {
                    Path filePath = Paths.get(this.realmPath.get(), new String[0]);
                    if (Files.exists(filePath, new LinkOption[0])) {
                        if (!this.keycloakX) {
                            this.withFileSystemBind(this.realmPath.get(), KeycloakDevServicesProcessor.KEYCLOAK_DOCKER_REALM_PATH, BindMode.READ_ONLY);
                        }
                        this.realmRep = this.readRealmFile(filePath.toUri(), this.realmPath.get());
                    } else {
                        LOG.debugf("Realm %s resource is not available", (Object)this.realmPath.get());
                    }
                }
            }
            if (this.realmRep != null && !this.keycloakX) {
                this.addEnv(KeycloakDevServicesProcessor.KEYCLOAK_WILDFLY_IMPORT_PROP, KeycloakDevServicesProcessor.KEYCLOAK_DOCKER_REALM_PATH);
            }
            LOG.infof("Using %s powered Keycloak distribution", (Object)(this.keycloakX ? "Quarkus" : "WildFly"));
            super.setWaitStrategy((WaitStrategy)Wait.forLogMessage((String)".*Keycloak.*started.*", (int)1));
        }

        private Integer findRandomPort() {
            Integer n;
            ServerSocket socket = new ServerSocket(0);
            try {
                n = socket.getLocalPort();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            socket.close();
            return n;
        }

        private RealmRepresentation readRealmFile(URI uri, String realmPath) {
            try {
                return this.readRealmFile(uri.toURL(), realmPath);
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }

        private RealmRepresentation readRealmFile(URL url, String realmPath) {
            RealmRepresentation realmRepresentation;
            block8: {
                InputStream is = url.openStream();
                try {
                    realmRepresentation = (RealmRepresentation)JsonSerialization.readValue((InputStream)is, RealmRepresentation.class);
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        LOG.errorf("Realm %s resource can not be opened: %s", (Object)realmPath, (Object)ex.getMessage());
                        return null;
                    }
                }
                is.close();
            }
            return realmRepresentation;
        }

        public String getHost() {
            if (this.useSharedNetwork) {
                return this.hostName;
            }
            return super.getHost();
        }

        public int getPort() {
            if (this.useSharedNetwork) {
                return 8080;
            }
            if (this.fixedExposedPort.isPresent()) {
                return this.fixedExposedPort.getAsInt();
            }
            return this.getFirstMappedPort();
        }
    }
}

