/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.quarkus.micrometer.runtime.binder.vertx.VertxNetworkMetrics;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.TCPMetrics;
import java.util.HashMap;
import java.util.Map;

public class VertxTcpMetrics
extends VertxNetworkMetrics
implements TCPMetrics<Map<String, Object>> {
    private static final String CONNECTED_SOCKET_SAMPLE = "CONNECTED_SOCKET_SAMPLE";
    final String nameConnections;

    VertxTcpMetrics(MeterRegistry registry, String prefix) {
        super(registry, prefix);
        this.nameConnections = prefix + ".connections";
    }

    public Map<String, Object> connected(SocketAddress remoteAddress, String remoteName) {
        HashMap<String, Object> socketMetric = new HashMap<String, Object>();
        socketMetric.put(CONNECTED_SOCKET_SAMPLE, LongTaskTimer.builder((String)this.nameConnections).register(this.registry).start());
        return socketMetric;
    }

    public void disconnected(Map<String, Object> socketMetric, SocketAddress remoteAddress) {
        if (socketMetric == null) {
            return;
        }
        LongTaskTimer.Sample sample = (LongTaskTimer.Sample)socketMetric.get(CONNECTED_SOCKET_SAMPLE);
        if (sample != null) {
            sample.stop();
        }
    }
}

