/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mailer.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.mailer.deployment.MailerBuildItem;
import io.quarkus.mailer.runtime.BlockingMailerImpl;
import io.quarkus.mailer.runtime.MailClientProducer;
import io.quarkus.mailer.runtime.MailConfig;
import io.quarkus.mailer.runtime.MailConfigRecorder;
import io.quarkus.mailer.runtime.MockMailboxImpl;
import io.quarkus.mailer.runtime.ReactiveMailerImpl;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.vertx.deployment.VertxBuildItem;
import io.vertx.ext.mail.MailClient;

public class MailerProcessor {
    @BuildStep
    AdditionalBeanBuildItem registerClients() {
        return AdditionalBeanBuildItem.unremovableOf(MailClientProducer.class);
    }

    @BuildStep
    AdditionalBeanBuildItem registerMailers() {
        return AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{ReactiveMailerImpl.class, BlockingMailerImpl.class, MockMailboxImpl.class}).build();
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem("mailer");
    }

    @BuildStep
    void registerAuthClass(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"io.vertx.ext.mail.impl.sasl.AuthDigestMD5", "io.vertx.ext.mail.impl.sasl.AuthCramSHA256", "io.vertx.ext.mail.impl.sasl.AuthCramSHA1", "io.vertx.ext.mail.impl.sasl.AuthCramMD5", "io.vertx.ext.mail.impl.sasl.AuthDigestMD5", "io.vertx.ext.mail.impl.sasl.AuthPlain", "io.vertx.ext.mail.impl.sasl.AuthLogin"}));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    MailerBuildItem build(BuildProducer<FeatureBuildItem> feature, MailConfigRecorder recorder, VertxBuildItem vertx, BeanContainerBuildItem beanContainer, LaunchModeBuildItem launchMode, ShutdownContextBuildItem shutdown, MailConfig config) {
        feature.produce((BuildItem)new FeatureBuildItem("mailer"));
        RuntimeValue client = recorder.configureTheClient(vertx.getVertx(), beanContainer.getValue(), config, (ShutdownContext)shutdown);
        recorder.configureTheMailer(beanContainer.getValue(), config, launchMode.getLaunchMode());
        return new MailerBuildItem((RuntimeValue<MailClient>)client);
    }
}

