/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.tools.config;

import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.platform.descriptor.loader.QuarkusPlatformDescriptorLoader;
import io.quarkus.platform.descriptor.loader.QuarkusPlatformDescriptorLoaderContext;
import io.quarkus.platform.tools.DefaultMessageWriter;
import io.quarkus.platform.tools.MessageWriter;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;

public class QuarkusPlatformConfig {
    private static final int STANDALONE = 0;
    private static final int GLOBAL = 1;
    private static final int THREAD_LOCAL = 2;
    private static final AtomicReference<QuarkusPlatformConfig> globalConfig = new AtomicReference();
    private static final ThreadLocal<QuarkusPlatformConfig> threadLocalConfig = new ThreadLocal();
    private final MessageWriter log;
    private final QuarkusPlatformDescriptor platformDescr;

    public static Builder builder() {
        return new Builder(0);
    }

    public static Builder defaultConfigBuilder() {
        return new Builder(1);
    }

    public static Builder threadLocalConfigBuilder() {
        return new Builder(2);
    }

    public static QuarkusPlatformConfig newInstance() {
        return QuarkusPlatformConfig.builder().build();
    }

    public static synchronized QuarkusPlatformConfig getGlobalDefault() {
        QuarkusPlatformConfig c = globalConfig.get();
        if (c != null) {
            return c;
        }
        return QuarkusPlatformConfig.defaultConfigBuilder().build();
    }

    public static boolean hasGlobalDefault() {
        return globalConfig.get() != null;
    }

    public static QuarkusPlatformConfig getThreadLocal() {
        QuarkusPlatformConfig c = threadLocalConfig.get();
        if (c != null) {
            return c;
        }
        return QuarkusPlatformConfig.threadLocalConfigBuilder().build();
    }

    public static boolean hasThreadLocal() {
        return threadLocalConfig.get() != null;
    }

    public static void clearThreadLocal() {
        threadLocalConfig.remove();
    }

    private static void assertNoGlobalConfig() {
        if (globalConfig.get() != null) {
            throw new IllegalStateException("The global instance of " + QuarkusPlatformConfig.class.getName() + " has already been initialized");
        }
    }

    private static void assertNoThreadLocalConfig() {
        if (threadLocalConfig.get() != null) {
            throw new IllegalStateException("The thread local instance of " + QuarkusPlatformConfig.class.getName() + " has already been initialized");
        }
    }

    private QuarkusPlatformConfig(Builder builder) {
        this.log = builder.getMessageWriter();
        this.platformDescr = builder.getPlatformDescriptor();
        if (builder.type == 1) {
            QuarkusPlatformConfig.assertNoGlobalConfig();
            globalConfig.set(this);
        } else if (builder.type == 2) {
            QuarkusPlatformConfig.assertNoThreadLocalConfig();
            threadLocalConfig.set(this);
        }
    }

    public MessageWriter getMessageWriter() {
        return this.log;
    }

    public QuarkusPlatformDescriptor getPlatformDescriptor() {
        return this.platformDescr;
    }

    public static class Builder {
        private int type = 0;
        private MessageWriter log;
        private QuarkusPlatformDescriptor platformDescr;

        private Builder(int type) {
            if (type == 1) {
                QuarkusPlatformConfig.assertNoGlobalConfig();
            } else if (type == 2) {
                QuarkusPlatformConfig.assertNoThreadLocalConfig();
            }
            this.type = type;
        }

        public Builder setMessageWriter(MessageWriter msgWriter) {
            this.log = msgWriter;
            return this;
        }

        private MessageWriter getMessageWriter() {
            return this.log == null ? (this.log = new DefaultMessageWriter()) : this.log;
        }

        public Builder setPlatformDescriptor(QuarkusPlatformDescriptor platformDescr) {
            this.platformDescr = platformDescr;
            return this;
        }

        private QuarkusPlatformDescriptor getPlatformDescriptor() {
            if (this.platformDescr != null) {
                return this.platformDescr;
            }
            Iterator<QuarkusPlatformDescriptorLoader> i = ServiceLoader.load(QuarkusPlatformDescriptorLoader.class).iterator();
            if (!i.hasNext()) {
                throw new IllegalStateException("Failed to locate an implementation of " + QuarkusPlatformDescriptorLoader.class.getName() + " on the classpath");
            }
            QuarkusPlatformDescriptorLoader dl = i.next();
            if (i.hasNext()) {
                StringBuilder buf = new StringBuilder();
                buf.append("Found multiple implementations of ").append(QuarkusPlatformDescriptorLoader.class.getName()).append("on the classpath: ").append(dl.getClass().getName());
                while (i.hasNext()) {
                    buf.append(", ").append(i.next().getClass().getName());
                }
                throw new IllegalStateException(buf.toString());
            }
            this.platformDescr = dl.load(new QuarkusPlatformDescriptorLoaderContext(){

                public MessageWriter getMessageWriter() {
                    return this.getMessageWriter();
                }
            });
            return this.platformDescr;
        }

        public QuarkusPlatformConfig build() {
            return new QuarkusPlatformConfig(this);
        }
    }
}

