/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.buildfile;

import io.quarkus.bootstrap.model.AppArtifactCoords;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.buildfile.BuildFile;
import io.quarkus.devtools.project.extensions.Extensions;
import io.quarkus.maven.utilities.MojoUtils;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;

public class MavenBuildFile
extends BuildFile {
    private AtomicReference<Model> modelRef = new AtomicReference();

    public MavenBuildFile(Path projectDirPath, QuarkusPlatformDescriptor platformDescriptor) {
        super(projectDirPath, platformDescriptor);
    }

    @Override
    public void writeToDisk() throws IOException {
        if (this.getModel() == null) {
            return;
        }
        try (ByteArrayOutputStream pomOutputStream = new ByteArrayOutputStream();){
            MojoUtils.write(this.getModel(), pomOutputStream);
            this.writeToProjectFile(BuildTool.MAVEN.getDependenciesFile(), pomOutputStream.toByteArray());
        }
    }

    @Override
    protected void addDependencyInBuildFile(AppArtifactCoords coords) throws IOException {
        if (this.getModel() != null) {
            Dependency d = new Dependency();
            d.setGroupId(coords.getGroupId());
            d.setArtifactId(coords.getArtifactId());
            d.setVersion(coords.getVersion());
            if (coords.getClassifier() != null && !coords.getClassifier().isEmpty()) {
                d.setClassifier(coords.getClassifier());
            }
            d.setType(coords.getType());
            this.getModel().addDependency(d);
        }
    }

    @Override
    protected void removeDependencyFromBuildFile(AppArtifactKey key) throws IOException {
        if (this.getModel() != null) {
            this.getModel().getDependencies().removeIf(d -> Objects.equals(Extensions.toKey(d), key));
        }
    }

    @Override
    public List<Dependency> getDependencies() throws IOException {
        return this.getModel() == null ? Collections.emptyList() : this.getModel().getDependencies();
    }

    @Override
    protected boolean containsBOM(String groupId, String artifactId) throws IOException {
        if (this.getModel() == null || this.getModel().getDependencyManagement() == null) {
            return false;
        }
        List dependencies = this.getModel().getDependencyManagement().getDependencies();
        return dependencies.stream().filter(dependency -> "import".equals(dependency.getScope())).filter(dependency -> "pom".equals(dependency.getType())).anyMatch(dependency -> dependency.getArtifactId().equals(MojoUtils.TEMPLATE_PROPERTY_QUARKUS_PLATFORM_ARTIFACT_ID_VALUE) && dependency.getGroupId().equals(MojoUtils.TEMPLATE_PROPERTY_QUARKUS_PLATFORM_GROUP_ID_VALUE));
    }

    @Override
    protected void refreshData() {
        this.modelRef.set(null);
    }

    @Override
    public String getProperty(String propertyName) throws IOException {
        if (this.getModel() == null) {
            return null;
        }
        return this.getModel().getProperties().getProperty(propertyName);
    }

    @Override
    public BuildTool getBuildTool() {
        return BuildTool.MAVEN;
    }

    private Model getModel() throws IOException {
        return this.modelRef.updateAndGet(model -> {
            if (model == null) {
                try {
                    return this.initModel();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return model;
        });
    }

    private Model initModel() throws IOException {
        byte[] content = this.readProjectFile(BuildTool.MAVEN.getDependenciesFile());
        return MojoUtils.readPom(new ByteArrayInputStream(content));
    }
}

