/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.commands.file;

import io.quarkus.cli.commands.file.BuildFile;
import io.quarkus.cli.commands.writer.ProjectWriter;
import io.quarkus.dependencies.Extension;
import io.quarkus.generators.BuildTool;
import io.quarkus.maven.utilities.MojoUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.function.Consumer;
import org.apache.maven.model.Dependency;

public class GradleBuildFile
extends BuildFile {
    protected static final String BUILD_GRADLE_PATH = "build.gradle";
    private static final String SETTINGS_GRADLE_PATH = "settings.gradle";
    private static final String GRADLE_PROPERTIES_PATH = "gradle.properties";
    private String settingsContent = "";
    private String buildContent = "";
    private Properties propertiesContent = new Properties();

    public GradleBuildFile(ProjectWriter writer) throws IOException {
        super(writer, BuildTool.GRADLE);
    }

    @Override
    public void close() throws IOException {
        this.write(SETTINGS_GRADLE_PATH, this.settingsContent);
        this.write(BUILD_GRADLE_PATH, this.buildContent);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.propertiesContent.store(out, "Gradle properties");
        this.write(GRADLE_PROPERTIES_PATH, out.toString(StandardCharsets.UTF_8.toString()));
    }

    @Override
    public void completeFile(String groupId, String artifactId, String version) throws IOException {
        this.init();
        this.completeSettingsContent(artifactId);
        this.completeBuildContent(groupId, version);
        this.completeProperties();
    }

    protected void init() throws IOException {
        if (this.getWriter().exists(SETTINGS_GRADLE_PATH)) {
            byte[] settings = this.getWriter().getContent(SETTINGS_GRADLE_PATH);
            this.settingsContent = new String(settings, StandardCharsets.UTF_8);
        }
        if (this.getWriter().exists(BUILD_GRADLE_PATH)) {
            byte[] build = this.getWriter().getContent(BUILD_GRADLE_PATH);
            this.buildContent = new String(build, StandardCharsets.UTF_8);
        }
        if (this.getWriter().exists(GRADLE_PROPERTIES_PATH)) {
            byte[] properties = this.getWriter().getContent(GRADLE_PROPERTIES_PATH);
            this.propertiesContent.load(new ByteArrayInputStream(properties));
        }
    }

    private void completeBuildContent(String groupId, String version) {
        String versionLine;
        String groupLine;
        StringBuilder res = new StringBuilder(this.buildContent);
        if (!this.buildContent.contains("io.quarkus:quarkus-gradle-plugin")) {
            res.append(System.lineSeparator());
            res.append("buildscript {").append(System.lineSeparator());
            res.append("    repositories {").append(System.lineSeparator());
            res.append("        mavenLocal()").append(System.lineSeparator());
            res.append("    }").append(System.lineSeparator());
            res.append("    dependencies {").append(System.lineSeparator());
            res.append("        classpath \"io.quarkus:quarkus-gradle-plugin:").append(MojoUtils.getPluginVersion()).append("\"").append(System.lineSeparator());
            res.append("    }").append(System.lineSeparator());
            res.append("}").append(System.lineSeparator());
        }
        if (!this.buildContent.contains("apply plugin: 'io.quarkus'") && !this.buildContent.contains("id 'io.quarkus'")) {
            res.append(System.lineSeparator()).append("apply plugin: 'io.quarkus'").append(System.lineSeparator());
        }
        if (!this.containsBOM()) {
            res.append(System.lineSeparator());
            res.append("dependencies {").append(System.lineSeparator());
            res.append("    implementation enforcedPlatform(\"io.quarkus:quarkus-bom:${quarkusVersion}\")").append(System.lineSeparator());
            res.append("    implementation 'io.quarkus:quarkus-resteasy'").append(System.lineSeparator());
            res.append("    testImplementation 'io.quarkus:quarkus-junit5'").append(System.lineSeparator());
            res.append("    testImplementation 'io.rest-assured:rest-assured'").append(System.lineSeparator());
            res.append("}").append(System.lineSeparator());
        }
        if (!this.buildContent.contains(groupLine = "group '" + groupId + "'")) {
            res.append(System.lineSeparator()).append(groupLine).append(System.lineSeparator());
        }
        if (!this.buildContent.contains(versionLine = "version '" + version + "'")) {
            res.append(System.lineSeparator()).append(versionLine).append(System.lineSeparator());
        }
        this.buildContent = res.toString();
    }

    private void completeSettingsContent(String artifactId) {
        StringBuilder res = new StringBuilder(this.settingsContent);
        if (!this.settingsContent.contains("io.quarkus:quarkus-gradle-plugin")) {
            res.append(System.lineSeparator());
            res.append("pluginManagement {").append(System.lineSeparator());
            res.append("    repositories {").append(System.lineSeparator());
            res.append("        mavenLocal()").append(System.lineSeparator());
            res.append("        mavenCentral()").append(System.lineSeparator());
            res.append("        gradlePluginPortal()").append(System.lineSeparator());
            res.append("    }").append(System.lineSeparator());
            res.append("    resolutionStrategy {").append(System.lineSeparator());
            res.append("        eachPlugin {").append(System.lineSeparator());
            res.append("            if (requested.id.id == 'io.quarkus') {").append(System.lineSeparator());
            res.append("                useModule(\"io.quarkus:quarkus-gradle-plugin:${quarkusVersion}\")").append(System.lineSeparator());
            res.append("            }").append(System.lineSeparator());
            res.append("        }").append(System.lineSeparator());
            res.append("    }").append(System.lineSeparator());
            res.append("}").append(System.lineSeparator());
        }
        if (!this.settingsContent.contains("rootProject.name")) {
            res.append(System.lineSeparator()).append("rootProject.name='").append(artifactId).append("'").append(System.lineSeparator());
        }
        this.settingsContent = res.toString();
    }

    private void completeProperties() {
        if (this.propertiesContent.getProperty("quarkusVersion") == null) {
            this.propertiesContent.setProperty("quarkusVersion", MojoUtils.getPluginVersion());
        }
    }

    @Override
    protected void addDependencyInBuildFile(Dependency dependency) {
        StringBuilder newBuildContent = new StringBuilder();
        this.readLineByLine(this.buildContent, new AppendDependency(newBuildContent, dependency));
        this.buildContent = newBuildContent.toString();
    }

    private void readLineByLine(String content, Consumer<String> lineConsumer) {
        try (Scanner scanner = new Scanner(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));){
            while (scanner.hasNextLine()) {
                String currentLine = scanner.nextLine();
                lineConsumer.accept(currentLine);
            }
        }
    }

    @Override
    protected boolean hasDependency(Extension extension) {
        return this.getDependencies().stream().anyMatch(d -> extension.getGroupId().equals(d.getGroupId()) && extension.getArtifactId().equals(d.getArtifactId()));
    }

    @Override
    protected boolean containsBOM() {
        return this.buildContent.contains("enforcedPlatform(\"io.quarkus:quarkus-bom:");
    }

    @Override
    public List<Dependency> getDependencies() {
        return Collections.emptyList();
    }

    @Override
    public String getProperty(String propertyName) {
        return this.propertiesContent.getProperty(propertyName);
    }

    @Override
    protected List<Dependency> getManagedDependencies() {
        return Collections.emptyList();
    }

    protected String getBuildContent() {
        return this.buildContent;
    }

    private static class AppendDependency
    implements Consumer<String> {
        private StringBuilder newContent;
        private Dependency dependency;

        public AppendDependency(StringBuilder newContent, Dependency dependency) {
            this.newContent = newContent;
            this.dependency = dependency;
        }

        @Override
        public void accept(String currentLine) {
            this.newContent.append(currentLine).append(System.lineSeparator());
            if (currentLine.startsWith("dependencies {")) {
                this.newContent.append("    implementation '").append(this.dependency.getGroupId()).append(":").append(this.dependency.getArtifactId());
                if (this.dependency.getVersion() != null && !this.dependency.getVersion().isEmpty()) {
                    this.newContent.append(":").append(this.dependency.getVersion());
                }
                this.newContent.append("'").append(System.lineSeparator());
            }
        }
    }
}

