/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dev;

import io.quarkus.deployment.devmode.HotReplacementContext;
import io.quarkus.deployment.devmode.HotReplacementSetup;
import io.quarkus.dev.ClassLoaderCompiler;
import io.quarkus.dev.DevModeContext;
import io.quarkus.dev.DevModeMain;
import io.quarkus.runtime.Timing;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class RuntimeUpdatesProcessor
implements HotReplacementContext {
    private static final String CLASS_EXTENSION = ".class";
    private static final Logger log = Logger.getLogger((String)RuntimeUpdatesProcessor.class.getPackage().getName());
    private final DevModeContext context;
    private final ClassLoaderCompiler compiler;
    private volatile Map<String, Boolean> watchedFilePaths = Collections.emptyMap();
    private volatile boolean firstScanDone = false;
    private final Map<Path, Long> sourceFileTimestamps = new ConcurrentHashMap<Path, Long>();
    private final Map<Path, Long> watchedFileTimestamps = new ConcurrentHashMap<Path, Long>();
    private final Map<Path, Long> classFileChangeTimeStamps = new ConcurrentHashMap<Path, Long>();
    private final Map<Path, Path> classFilePathToSourceFilePath = new ConcurrentHashMap<Path, Path>();
    private final Map<String, Set<Path>> correspondingResources = new ConcurrentHashMap<String, Set<Path>>();
    private final List<Runnable> preScanSteps = new CopyOnWriteArrayList<Runnable>();
    private final List<Consumer<Set<String>>> noRestartChangesConsumers = new CopyOnWriteArrayList<Consumer<Set<String>>>();
    private final List<HotReplacementSetup> hotReplacementSetup = new ArrayList<HotReplacementSetup>();
    private final DevModeMain devModeMain;

    public RuntimeUpdatesProcessor(DevModeContext context, ClassLoaderCompiler compiler, DevModeMain devModeMain) {
        this.context = context;
        this.compiler = compiler;
        this.devModeMain = devModeMain;
    }

    public Path getClassesDir() {
        Iterator<DevModeContext.ModuleInfo> iterator = this.context.getModules().iterator();
        if (iterator.hasNext()) {
            DevModeContext.ModuleInfo i = iterator.next();
            return Paths.get(i.getResourcePath(), new String[0]);
        }
        return null;
    }

    public List<Path> getSourcesDir() {
        return this.context.getModules().stream().flatMap(m -> m.getSourcePaths().stream()).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
    }

    public List<Path> getResourcesDir() {
        ArrayList<Path> ret = new ArrayList<Path>();
        for (DevModeContext.ModuleInfo i : this.context.getModules()) {
            if (i.getResourcePath() == null) continue;
            ret.add(Paths.get(i.getResourcePath(), new String[0]));
        }
        Collections.reverse(ret);
        return ret;
    }

    public Throwable getDeploymentProblem() {
        return DevModeMain.compileProblem != null ? DevModeMain.compileProblem : DevModeMain.deploymentProblem;
    }

    public boolean isTest() {
        return this.context.isTest();
    }

    public boolean doScan(boolean userInitiated) throws IOException {
        boolean restartNeeded;
        long startNanoseconds = System.nanoTime();
        for (Runnable step : this.preScanSteps) {
            try {
                step.run();
            }
            catch (Throwable t) {
                log.error((Object)"Pre Scan step failed", t);
            }
        }
        boolean classChanged = this.checkForChangedClasses();
        Set<String> filesChanged = this.checkForFileChange();
        boolean bl = restartNeeded = classChanged || DevModeMain.deploymentProblem != null && userInitiated;
        if (!restartNeeded && !filesChanged.isEmpty()) {
            restartNeeded = filesChanged.stream().map(this.watchedFilePaths::get).anyMatch(Boolean.TRUE::equals);
        }
        if (restartNeeded) {
            this.devModeMain.restartApp(filesChanged);
            log.infof("Hot replace total time: %ss ", (Object)Timing.convertToBigDecimalSeconds((long)(System.nanoTime() - startNanoseconds)));
            return true;
        }
        if (!filesChanged.isEmpty()) {
            for (Consumer<Set<String>> consumer : this.noRestartChangesConsumers) {
                try {
                    consumer.accept(filesChanged);
                }
                catch (Throwable t) {
                    log.error((Object)"Changed files consumer failed", t);
                }
            }
            log.infof("Files changed but restart not needed - notified extensions in: %ss ", (Object)Timing.convertToBigDecimalSeconds((long)(System.nanoTime() - startNanoseconds)));
        }
        return false;
    }

    public void addPreScanStep(Runnable runnable) {
        this.preScanSteps.add(runnable);
    }

    public void consumeNoRestartChanges(Consumer<Set<String>> consumer) {
        this.noRestartChangesConsumers.add(consumer);
    }

    boolean checkForChangedClasses() throws IOException {
        boolean hasChanges = false;
        boolean ignoreFirstScanChanges = !this.firstScanDone;
        for (DevModeContext.ModuleInfo module : this.context.getModules()) {
            ArrayList<Path> moduleChangedSourceFilePaths = new ArrayList<Path>();
            for (String sourcePath : module.getSourcePaths()) {
                Set changedSourceFiles;
                try (Stream<Path> sourcesStream = Files.walk(Paths.get(sourcePath, new String[0]), new FileVisitOption[0]);){
                    changedSourceFiles = ((Stream)sourcesStream.parallel()).filter(p -> this.matchingHandledExtension((Path)p).isPresent() && this.sourceFileWasRecentModified((Path)p, ignoreFirstScanChanges)).map(Path::toFile).collect(Collectors.toCollection(ConcurrentSkipListSet::new));
                }
                if (changedSourceFiles.isEmpty()) continue;
                log.info((Object)("Changed source files detected, recompiling " + changedSourceFiles));
                try {
                    Set changedPaths = changedSourceFiles.stream().map(File::toPath).collect(Collectors.toSet());
                    moduleChangedSourceFilePaths.addAll(changedPaths);
                    this.compiler.compile(sourcePath, changedSourceFiles.stream().collect(Collectors.groupingBy(this::getFileExtension, Collectors.toSet())));
                    DevModeMain.compileProblem = null;
                }
                catch (Exception e) {
                    DevModeMain.compileProblem = e;
                    return false;
                }
            }
            if (!this.checkForClassFilesChangesInModule(module, moduleChangedSourceFilePaths, ignoreFirstScanChanges)) continue;
            hasChanges = true;
        }
        this.firstScanDone = true;
        return hasChanges;
    }

    private boolean checkForClassFilesChangesInModule(DevModeContext.ModuleInfo module, List<Path> moduleChangedSourceFiles, boolean isInitialRun) {
        boolean hasChanges;
        boolean bl = hasChanges = !moduleChangedSourceFiles.isEmpty();
        if (module.getClassesPath() == null) {
            return hasChanges;
        }
        try {
            for (String folder : module.getClassesPath().split(File.pathSeparator)) {
                Path moduleClassesPath = Paths.get(folder, new String[0]);
                try (Stream<Path> classesStream = Files.walk(moduleClassesPath, new FileVisitOption[0]);){
                    Set classFilePaths = ((Stream)classesStream.parallel()).filter(path -> path.toString().endsWith(CLASS_EXTENSION)).collect(Collectors.toSet());
                    for (Path classFilePath : classFilePaths) {
                        Path sourceFilePath = this.retrieveSourceFilePathForClassFile(classFilePath, moduleChangedSourceFiles, module);
                        if (sourceFilePath != null) {
                            if (!sourceFilePath.toFile().exists()) {
                                this.cleanUpClassFile(classFilePath);
                                this.sourceFileTimestamps.remove(sourceFilePath);
                                hasChanges = true;
                                continue;
                            }
                            this.classFilePathToSourceFilePath.put(classFilePath, sourceFilePath);
                            if (this.classFileWasRecentModified(classFilePath, isInitialRun)) {
                                hasChanges = true;
                                continue;
                            }
                            if (!moduleChangedSourceFiles.contains(sourceFilePath)) continue;
                            this.cleanUpClassFile(classFilePath);
                            hasChanges = true;
                            continue;
                        }
                        if (!this.classFileWasRecentModified(classFilePath, isInitialRun)) continue;
                        hasChanges = true;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return hasChanges;
    }

    private Path retrieveSourceFilePathForClassFile(Path classFilePath, List<Path> moduleChangedSourceFiles, DevModeContext.ModuleInfo module) {
        Path sourceFilePath = this.classFilePathToSourceFilePath.get(classFilePath);
        if (sourceFilePath == null || moduleChangedSourceFiles.contains(sourceFilePath)) {
            sourceFilePath = this.compiler.findSourcePath(classFilePath, module.getSourcePaths(), module.getClassesPath());
        }
        return sourceFilePath;
    }

    private void cleanUpClassFile(Path classFilePath) throws IOException {
        Files.deleteIfExists(classFilePath);
        this.classFileChangeTimeStamps.remove(classFilePath);
        this.classFilePathToSourceFilePath.remove(classFilePath);
    }

    private Optional<String> matchingHandledExtension(Path p) {
        return this.compiler.allHandledExtensions().stream().filter(e -> p.toString().endsWith((String)e)).findFirst();
    }

    private String getFileExtension(File file) {
        String name = file.getName();
        int lastIndexOf = name.lastIndexOf(46);
        if (lastIndexOf == -1) {
            return "";
        }
        return name.substring(lastIndexOf);
    }

    Set<String> checkForFileChange() {
        HashSet<String> ret = new HashSet<String>();
        for (DevModeContext.ModuleInfo module : this.context.getModules()) {
            Path root;
            Set moduleResources = this.correspondingResources.computeIfAbsent(module.getName(), m -> Collections.newSetFromMap(new ConcurrentHashMap()));
            boolean doCopy = true;
            String rootPath = module.getResourcePath();
            if (rootPath == null) {
                rootPath = module.getClassesPath();
                doCopy = false;
            }
            if (rootPath == null || !Files.exists(root = Paths.get(rootPath, new String[0]), new LinkOption[0]) || !Files.isReadable(root)) continue;
            Path classesDir = Paths.get(module.getClassesPath(), new String[0]);
            if (doCopy) {
                try {
                    HashSet seen = new HashSet(moduleResources);
                    try (Stream<Path> walk = Files.walk(root, new FileVisitOption[0]);){
                        walk.forEach(path -> {
                            block15: {
                                try {
                                    Path relative = root.relativize((Path)path);
                                    Path target = classesDir.resolve(relative);
                                    seen.remove(target);
                                    if (this.watchedFileTimestamps.containsKey(path)) break block15;
                                    moduleResources.add(target);
                                    if (Files.exists(target, new LinkOption[0]) && Files.getLastModifiedTime(target, new LinkOption[0]).toMillis() >= Files.getLastModifiedTime(path, new LinkOption[0]).toMillis()) break block15;
                                    if (Files.isDirectory(path, new LinkOption[0])) {
                                        Files.createDirectories(target, new FileAttribute[0]);
                                        break block15;
                                    }
                                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                                    byte[] data = Files.readAllBytes(path);
                                    try (FileOutputStream out = new FileOutputStream(target.toFile());){
                                        out.write(data);
                                    }
                                }
                                catch (Exception e) {
                                    log.error((Object)"Failed to copy resources", (Throwable)e);
                                }
                            }
                        });
                    }
                    for (Path i : seen) {
                        moduleResources.remove(i);
                        if (Files.isDirectory(i, new LinkOption[0])) continue;
                        Files.delete(i);
                    }
                }
                catch (IOException e) {
                    log.error((Object)"Failed to copy resources", (Throwable)e);
                }
            }
            for (String path2 : this.watchedFilePaths.keySet()) {
                Path file = root.resolve(path2);
                if (file.toFile().exists()) {
                    try {
                        Long existing;
                        long value = Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
                        if (value <= (existing = this.watchedFileTimestamps.get(file))) continue;
                        ret.add(path2);
                        log.infof("File change detected: %s", (Object)file);
                        if (doCopy && !Files.isDirectory(file, new LinkOption[0])) {
                            Path target = classesDir.resolve(path2);
                            byte[] data = Files.readAllBytes(file);
                            try (FileOutputStream out = new FileOutputStream(target.toFile());){
                                out.write(data);
                            }
                        }
                        this.watchedFileTimestamps.put(file, value);
                        continue;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                this.watchedFileTimestamps.put(file, 0L);
                Path target = classesDir.resolve(path2);
                try {
                    Files.deleteIfExists(target);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
        return ret;
    }

    private boolean sourceFileWasRecentModified(Path sourcePath, boolean ignoreFirstScanChanges) {
        return this.checkIfFileModified(sourcePath, this.sourceFileTimestamps, ignoreFirstScanChanges);
    }

    private boolean classFileWasRecentModified(Path classFilePath, boolean ignoreFirstScanChanges) {
        return this.checkIfFileModified(classFilePath, this.classFileChangeTimeStamps, ignoreFirstScanChanges);
    }

    private boolean checkIfFileModified(Path path, Map<Path, Long> pathModificationTimes, boolean ignoreFirstScanChanges) {
        try {
            long lastModificationTime = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
            Long lastRecordedChange = pathModificationTimes.get(path);
            if (lastRecordedChange == null) {
                pathModificationTimes.put(path, lastModificationTime);
                return !ignoreFirstScanChanges;
            }
            if (lastRecordedChange != lastModificationTime) {
                pathModificationTimes.put(path, lastModificationTime);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public RuntimeUpdatesProcessor setWatchedFilePaths(Map<String, Boolean> watchedFilePaths) {
        this.watchedFilePaths = watchedFilePaths;
        this.watchedFileTimestamps.clear();
        for (DevModeContext.ModuleInfo module : this.context.getModules()) {
            String rootPath = module.getResourcePath();
            if (rootPath == null) {
                rootPath = module.getClassesPath();
            }
            if (rootPath == null) continue;
            Path root = Paths.get(rootPath, new String[0]);
            for (String path : watchedFilePaths.keySet()) {
                Path config = root.resolve(path);
                if (config.toFile().exists()) {
                    try {
                        FileTime lastModifiedTime = Files.getLastModifiedTime(config, new LinkOption[0]);
                        this.watchedFileTimestamps.put(config, lastModifiedTime.toMillis());
                        continue;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                this.watchedFileTimestamps.put(config, 0L);
            }
        }
        return this;
    }

    public void addHotReplacementSetup(HotReplacementSetup service) {
        this.hotReplacementSetup.add(service);
    }

    public void startupFailed() {
        for (HotReplacementSetup i : this.hotReplacementSetup) {
            i.handleFailedInitialStart();
        }
    }
}

