/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import io.quarkus.registry.RuntimeInfoProvider;
import io.quarkus.registry.ValueRegistry;
import io.smallrye.config.SmallRyeConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class ValueRegistryImpl
implements ValueRegistry {
    private final Map<String, ValueRegistry.RuntimeInfo<?>> values = new ConcurrentHashMap();

    private ValueRegistryImpl() {
    }

    public <T> void register(ValueRegistry.RuntimeKey<T> key, T value) {
        if (key == null || key.key() == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        this.registerInfo(key, (ValueRegistry.RuntimeInfo<T>)ValueRegistry.RuntimeInfo.SimpleRuntimeInfo.of(value));
    }

    public <T> void registerInfo(ValueRegistry.RuntimeKey<T> key, ValueRegistry.RuntimeInfo<T> runtimeInfo) {
        if (key == null || key.key() == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (runtimeInfo == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        ValueRegistry.RuntimeInfo<T> mapValue = this.values.putIfAbsent(key.key(), runtimeInfo);
        if (mapValue != null) {
            throw new IllegalArgumentException("Key already registered " + key.key());
        }
    }

    public <T> boolean containsKey(ValueRegistry.RuntimeKey<T> key) {
        return this.values.containsKey(key.key());
    }

    public <T> T get(ValueRegistry.RuntimeKey<T> key) {
        ValueRegistry.RuntimeInfo<?> runtimeInfo = this.values.get(key.key());
        if (runtimeInfo == null) {
            throw new IllegalArgumentException("Key " + key.key() + " not found");
        }
        return (T)runtimeInfo.get((ValueRegistry)this);
    }

    public <T> T getOrDefault(ValueRegistry.RuntimeKey<T> key, T defaultValue) {
        ValueRegistry.RuntimeInfo<?> runtimeInfo = this.values.get(key.key());
        return (T)(runtimeInfo == null ? defaultValue : runtimeInfo.get((ValueRegistry)this));
    }

    public ValueRegistry.RuntimeInfo<?> get(String key) {
        return this.values.get(key);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean discoverInfos;
        private final List<RuntimeInfoProvider.RuntimeSource> sources = new ArrayList<RuntimeInfoProvider.RuntimeSource>();

        private Builder() {
        }

        public Builder addDiscoveredInfos() {
            this.discoverInfos = true;
            return this;
        }

        public Builder withRuntimeSource(SmallRyeConfig config) {
            this.sources.add(new ConfigRuntimeSource((Config)config));
            return this;
        }

        public ValueRegistry build() {
            ValueRegistryImpl valueRegistry = new ValueRegistryImpl();
            if (this.discoverInfos) {
                ServiceLoader<RuntimeInfoProvider> infoProviders = ServiceLoader.load(RuntimeInfoProvider.class);
                for (RuntimeInfoProvider runtimeInfoProvider : infoProviders) {
                    runtimeInfoProvider.register((ValueRegistry)valueRegistry, new RuntimeInfoProvider.RuntimeSource(){

                        public <T> T get(ValueRegistry.RuntimeKey<T> key) {
                            for (RuntimeInfoProvider.RuntimeSource source : sources) {
                                Object value = source.get(key);
                                if (value == null) continue;
                                return (T)value;
                            }
                            return null;
                        }
                    });
                }
            }
            return valueRegistry;
        }
    }

    public static class ConfigRuntimeSource
    implements RuntimeInfoProvider.RuntimeSource {
        private final Config config;

        ConfigRuntimeSource(Config config) {
            this.config = config;
        }

        public <T> T get(ValueRegistry.RuntimeKey<T> key) {
            return this.config.getOptionalValue(key.key(), key.type()).orElse(null);
        }

        public static RuntimeInfoProvider.RuntimeSource runtimeSource(Config config) {
            return new ConfigRuntimeSource(config);
        }

        public static RuntimeInfoProvider.RuntimeSource runtimeSource() {
            return new ConfigRuntimeSource(ConfigProvider.getConfig());
        }
    }
}

