/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.annotation.Priority;
import org.eclipse.microprofile.config.spi.Converter;
import org.wildfly.common.net.Inet;

@Priority(value=200)
public class InetAddressConverter
implements Converter<InetAddress> {
    public InetAddress convert(String value) {
        if (value.isEmpty()) {
            return null;
        }
        InetAddress parsed = Inet.parseInetAddress((String)value);
        if (parsed != null) {
            return parsed;
        }
        try {
            return InetAddress.getByName(value);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Unable to resolve \"" + value + "\"", e);
        }
    }
}

