/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ValueRegistryRuntimeInfoProviderBuildItem;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.registry.RuntimeInfoProvider;

class ValueRegistryProcessor {
    ValueRegistryProcessor() {
    }

    @BuildStep
    void discoverRuntimeInfos(BuildProducer<ValueRegistryRuntimeInfoProviderBuildItem> runtimeInfoProviders) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (String service : ServiceUtil.classNamesNamedIn(classLoader, "META-INF/services/" + RuntimeInfoProvider.class.getName())) {
            if (!QuarkusClassLoader.isClassPresentAtRuntime((String)service)) continue;
            Class<?> provider = classLoader.loadClass(service);
            runtimeInfoProviders.produce(new ValueRegistryRuntimeInfoProviderBuildItem(provider));
        }
    }
}

