/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.testing;

import io.quarkus.deployment.dev.testing.TestClassResult;
import io.quarkus.deployment.dev.testing.TestResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;

public class TestState {
    final Map<String, Map<UniqueId, TestResult>> resultsByClass = new HashMap<String, Map<UniqueId, TestResult>>();
    final Set<UniqueId> failing = new HashSet<UniqueId>();
    final Set<UniqueId> dynamicIds = new HashSet<UniqueId>();

    public List<String> getClassNames() {
        return new ArrayList<String>(this.resultsByClass.keySet()).stream().sorted().collect(Collectors.toList());
    }

    public List<TestClassResult> getPassingClasses() {
        ArrayList<TestClassResult> ret = new ArrayList<TestClassResult>();
        for (Map.Entry<String, Map<UniqueId, TestResult>> i : this.resultsByClass.entrySet()) {
            ArrayList<TestResult> passing = new ArrayList<TestResult>();
            ArrayList<TestResult> failing = new ArrayList<TestResult>();
            ArrayList<TestResult> skipped = new ArrayList<TestResult>();
            long time = 0L;
            for (TestResult j : i.getValue().values()) {
                if (j.getTestExecutionResult().getStatus() == TestExecutionResult.Status.FAILED) {
                    failing.add(j);
                } else if (j.getTestExecutionResult().getStatus() == TestExecutionResult.Status.ABORTED) {
                    skipped.add(j);
                } else {
                    passing.add(j);
                }
                if (!j.getUniqueId().getLastSegment().getType().equals("class")) continue;
                time = j.getTime();
            }
            if (!failing.isEmpty()) continue;
            TestClassResult p = new TestClassResult(i.getKey(), passing, failing, skipped, time);
            ret.add(p);
        }
        Collections.sort(ret);
        return ret;
    }

    public List<TestClassResult> getFailingClasses() {
        ArrayList<TestClassResult> ret = new ArrayList<TestClassResult>();
        for (Map.Entry<String, Map<UniqueId, TestResult>> i : this.resultsByClass.entrySet()) {
            long time = 0L;
            ArrayList<TestResult> passing = new ArrayList<TestResult>();
            ArrayList<TestResult> failing = new ArrayList<TestResult>();
            ArrayList<TestResult> skipped = new ArrayList<TestResult>();
            for (TestResult j : i.getValue().values()) {
                if (j.getTestExecutionResult().getStatus() == TestExecutionResult.Status.FAILED) {
                    failing.add(j);
                } else if (j.getTestExecutionResult().getStatus() == TestExecutionResult.Status.ABORTED) {
                    skipped.add(j);
                } else {
                    passing.add(j);
                }
                if (!j.getUniqueId().getLastSegment().getType().equals("class")) continue;
                time = j.getTime();
            }
            if (failing.isEmpty()) continue;
            TestClassResult p = new TestClassResult(i.getKey(), passing, failing, skipped, time);
            ret.add(p);
        }
        Collections.sort(ret);
        return ret;
    }

    public synchronized void updateResults(Map<String, Map<UniqueId, TestResult>> latest) {
        for (Map.Entry<String, Map<UniqueId, TestResult>> entry : latest.entrySet()) {
            Map<UniqueId, TestResult> existing = this.resultsByClass.get(entry.getKey());
            if (existing == null) {
                this.resultsByClass.put(entry.getKey(), entry.getValue());
            } else {
                existing.putAll(entry.getValue());
            }
            for (Map.Entry<UniqueId, TestResult> r : entry.getValue().entrySet()) {
                if (r.getValue().getTestExecutionResult().getStatus() == TestExecutionResult.Status.FAILED) {
                    this.failing.add(r.getKey());
                    continue;
                }
                this.failing.remove(r.getKey());
            }
        }
    }

    public synchronized void classesRemoved(Set<String> classNames) {
        for (String i : classNames) {
            this.resultsByClass.remove(i);
        }
    }

    public Map<String, Map<UniqueId, TestResult>> getCurrentResults() {
        return Collections.unmodifiableMap(this.resultsByClass);
    }

    public int getTotalFailures() {
        int count = 0;
        for (Map<UniqueId, TestResult> i : this.resultsByClass.values()) {
            for (TestResult j : i.values()) {
                if (j.getTestExecutionResult().getStatus() != TestExecutionResult.Status.FAILED) continue;
                ++count;
            }
        }
        return count;
    }

    public List<TestResult> getHistoricFailures(Map<String, Map<UniqueId, TestResult>> currentResults) {
        ArrayList<TestResult> ret = new ArrayList<TestResult>();
        for (Map.Entry<String, Map<UniqueId, TestResult>> entry : this.resultsByClass.entrySet()) {
            for (TestResult j : entry.getValue().values()) {
                if (j.getTestExecutionResult().getStatus() != TestExecutionResult.Status.FAILED || currentResults.containsKey(entry.getKey()) && currentResults.get(entry.getKey()).containsKey(j.getUniqueId())) continue;
                ret.add(j);
            }
        }
        return ret;
    }

    public boolean isFailed(TestDescriptor testDescriptor) {
        return this.failing.contains(testDescriptor.getUniqueId());
    }

    public void pruneDeletedTests(Set<UniqueId> allDiscoveredIds, Set<UniqueId> dynamicIds) {
        Set dynamicParents = dynamicIds.stream().map(UniqueId::removeLastSegment).collect(Collectors.toSet());
        this.dynamicIds.removeIf(s -> {
            if (dynamicIds.contains(s)) {
                return false;
            }
            UniqueId parent = s.removeLastSegment();
            if (dynamicParents.contains(parent)) {
                return true;
            }
            return !allDiscoveredIds.contains(parent);
        });
        this.dynamicIds.addAll(dynamicIds);
        this.failing.removeIf(i -> !allDiscoveredIds.contains(i) && !this.dynamicIds.contains(i));
        for (Map.Entry<String, Map<UniqueId, TestResult>> cr : this.resultsByClass.entrySet()) {
            cr.getValue().entrySet().removeIf(s -> !allDiscoveredIds.contains(s.getKey()) && !this.dynamicIds.contains(s.getKey()));
        }
        this.resultsByClass.entrySet().removeIf(s -> ((Map)s.getValue()).isEmpty());
    }
}

