/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg;

import io.quarkus.deployment.pkg.ManifestConfig;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.List;
import java.util.Optional;
import java.util.Set;

@ConfigRoot
public class PackageConfig {
    public static final String JAR = "jar";
    public static final String UBER_JAR = "uber-jar";
    public static final String FAST_JAR = "fast-jar";
    public static final String MUTABLE_JAR = "mutable-jar";
    @Deprecated
    public static final String LEGACY = "legacy";
    public static final String LEGACY_JAR = "legacy-jar";
    public static final String NATIVE = "native";
    public static final String NATIVE_SOURCES = "native-sources";
    @ConfigItem(defaultValue="jar")
    public String type;
    @ConfigItem
    public ManifestConfig manifest;
    @ConfigItem
    public Optional<String> mainClass;
    @ConfigItem
    public Optional<List<String>> userConfiguredIgnoredEntries;
    @ConfigItem
    public Optional<Set<String>> includedOptionalDependencies;
    @ConfigItem(defaultValue="false")
    public boolean filterOptionalDependencies;
    @ConfigItem(defaultValue="-runner")
    public String runnerSuffix;
    @ConfigItem
    public Optional<String> outputDirectory;
    @ConfigItem
    public Optional<String> outputName;
    @ConfigItem
    public boolean createAppcds;
    @ConfigItem
    public Optional<String> appcdsBuilderImage;
    @ConfigItem(defaultValue="true")
    public boolean appcdsUseContainer;
    @ConfigItem
    public Optional<String> userProvidersDirectory;
    @ConfigItem(defaultValue="true")
    public boolean includeDependencyList;
    @ConfigItem
    @Deprecated(forRemoval=true)
    public FernflowerConfig fernflower;
    @ConfigItem
    public QuiltFlowerConfig quiltflower;
    @ConfigItem
    public boolean writeTransformedBytecodeToBuildOutput;

    public boolean isAnyJarType() {
        return this.type.equalsIgnoreCase(JAR) || this.type.equalsIgnoreCase(FAST_JAR) || this.type.equalsIgnoreCase(UBER_JAR) || this.type.equalsIgnoreCase(LEGACY_JAR) || this.type.equalsIgnoreCase(LEGACY) || this.type.equalsIgnoreCase(MUTABLE_JAR);
    }

    public boolean isFastJar() {
        return this.type.equalsIgnoreCase(JAR) || this.type.equalsIgnoreCase(FAST_JAR) || this.type.equalsIgnoreCase(MUTABLE_JAR);
    }

    public boolean isLegacyJar() {
        return this.type.equalsIgnoreCase(LEGACY_JAR) || this.type.equalsIgnoreCase(LEGACY);
    }

    public boolean isUberJar() {
        return this.type.equalsIgnoreCase(UBER_JAR);
    }

    @ConfigGroup
    public static class QuiltFlowerConfig {
        @ConfigItem(defaultValue="false")
        public boolean enabled;
        @ConfigItem(defaultValue="1.8.1")
        public String version;
        @ConfigItem(defaultValue="${user.home}/.quarkus")
        public String jarDirectory;
    }

    @ConfigGroup
    @Deprecated(forRemoval=true)
    public static class FernflowerConfig {
        @ConfigItem(defaultValue="false")
        public boolean enabled;
        @ConfigItem(defaultValue="dbf407a655")
        public String hash;
        @ConfigItem(defaultValue="${user.home}/.quarkus")
        public String jarDirectory;
    }
}

