/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.bootstrap.BootstrapDebug;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.gizmo.ClassOutput;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GeneratedClassGizmoAdaptor
implements ClassOutput {
    private final BuildProducer<GeneratedClassBuildItem> classOutput;
    private final boolean applicationClass;
    private final Map<String, StringWriter> sources;

    public GeneratedClassGizmoAdaptor(BuildProducer<GeneratedClassBuildItem> classOutput, boolean applicationClass) {
        this.classOutput = classOutput;
        this.applicationClass = applicationClass;
        this.sources = BootstrapDebug.DEBUG_SOURCES_DIR != null ? new ConcurrentHashMap() : null;
    }

    public void write(String className, byte[] bytes) {
        StringWriter sw;
        String source = null;
        if (this.sources != null && (sw = this.sources.get(className)) != null) {
            source = sw.toString();
        }
        this.classOutput.produce(new GeneratedClassBuildItem(this.applicationClass, className, bytes, source));
    }

    public Writer getSourceWriter(String className) {
        if (this.sources != null) {
            StringWriter writer = new StringWriter();
            this.sources.put(className, writer);
            return writer;
        }
        return super.getSourceWriter(className);
    }
}

