/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem.nativeimage;

import io.quarkus.builder.item.MultiBuildItem;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;

public final class ServiceProviderBuildItem
extends MultiBuildItem {
    public static final String SPI_ROOT = "META-INF/services/";
    private final String serviceInterface;
    private final List<String> providers;

    public static ServiceProviderBuildItem allProviders(String serviceInterfaceClassName, Path serviceInterfaceDescriptorFile) throws IOException {
        if (serviceInterfaceClassName == null || serviceInterfaceClassName.trim().isEmpty()) {
            throw new IllegalArgumentException("service interface name cannot be null or blank");
        }
        if (serviceInterfaceDescriptorFile == null) {
            throw new IllegalArgumentException("service interface descriptor file path cannot be null");
        }
        LinkedHashSet<String> classNames = new LinkedHashSet<String>();
        List<String> lines = Files.readAllLines(serviceInterfaceDescriptorFile, StandardCharsets.UTF_8);
        for (String line : lines) {
            int commentIndex = line.indexOf(35);
            if (commentIndex >= 0) {
                line = line.substring(0, commentIndex);
            }
            if ((line = line.trim()).length() == 0) continue;
            classNames.add(line);
        }
        return new ServiceProviderBuildItem(serviceInterfaceClassName, new ArrayList<String>(classNames));
    }

    public ServiceProviderBuildItem(String serviceInterfaceClassName, String ... providerClassNames) {
        this(serviceInterfaceClassName, Arrays.asList(providerClassNames));
    }

    public ServiceProviderBuildItem(String serviceInterfaceClassName, List<String> providers) {
        this.serviceInterface = Objects.requireNonNull(serviceInterfaceClassName, "The service interface must not be `null`");
        this.providers = providers;
        if (this.serviceInterface.length() == 0) {
            throw new IllegalArgumentException("The serviceDescriptorFile interface cannot be blank");
        }
        providers.forEach(s -> {
            if (s == null || s.length() == 0) {
                throw new IllegalArgumentException("The provider class name cannot be null or blank");
            }
        });
    }

    public List<String> providers() {
        return this.providers;
    }

    public String serviceDescriptorFile() {
        return SPI_ROOT + this.serviceInterface;
    }
}

