/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.DeploymentClassLoaderBuildItem;
import io.quarkus.deployment.builditem.GeneratedNativeImageClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceDirectoryBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveFieldBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeReinitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.builditem.nativeimage.UnsafeAccessedFieldBuildItem;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.runtime.ResourceHelper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public class NativeImageAutoFeatureStep {
    private static final String GRAAL_AUTOFEATURE = "io/quarkus/runner/AutoFeature";
    private static final MethodDescriptor IMAGE_SINGLETONS_LOOKUP = MethodDescriptor.ofMethod(ImageSingletons.class, (String)"lookup", Object.class, (Class[])new Class[]{Class.class});
    private static final MethodDescriptor INITIALIZE_AT_RUN_TIME = MethodDescriptor.ofMethod(RuntimeClassInitialization.class, (String)"initializeAtRunTime", Void.TYPE, (Class[])new Class[]{Class[].class});
    private static final MethodDescriptor RERUN_INITIALIZATION = MethodDescriptor.ofMethod((Object)"org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport", (String)"rerunInitialization", Void.TYPE, (Object[])new Object[]{Class.class, String.class});
    static final String RUNTIME_REFLECTION = RuntimeReflection.class.getName();
    static final String BEFORE_ANALYSIS_ACCESS = Feature.BeforeAnalysisAccess.class.getName();
    static final String DYNAMIC_PROXY_REGISTRY = "com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry";
    static final String LOCALIZATION_SUPPORT = "com.oracle.svm.core.jdk.LocalizationSupport";

    @BuildStep
    List<NativeImageResourceBuildItem> registerPackageResources(List<NativeImageResourceDirectoryBuildItem> nativeImageResourceDirectories, DeploymentClassLoaderBuildItem classLoader) throws IOException, URISyntaxException {
        ArrayList<NativeImageResourceBuildItem> resources = new ArrayList<NativeImageResourceBuildItem>();
        for (NativeImageResourceDirectoryBuildItem nativeImageResourceDirectory : nativeImageResourceDirectories) {
            String path = classLoader.getClassLoader().getResource(nativeImageResourceDirectory.getPath()).getPath();
            File resourceFile = Paths.get(new URL(path.substring(0, path.indexOf("!"))).toURI()).toFile();
            JarFile jarFile = new JarFile(resourceFile);
            Throwable throwable = null;
            try {
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String resourceName = entry.getName();
                    if (entry.isDirectory() || !resourceName.startsWith(nativeImageResourceDirectory.getPath()) || resourceName.endsWith(".class")) continue;
                    resources.add(new NativeImageResourceBuildItem(resourceName));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (jarFile == null) continue;
                if (throwable != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                jarFile.close();
            }
        }
        return resources;
    }

    /*
     * WARNING - void declaration
     */
    @BuildStep
    void generateFeature(final BuildProducer<GeneratedNativeImageClassBuildItem> nativeImageClass, List<RuntimeInitializedClassBuildItem> runtimeInitializedClassBuildItems, List<RuntimeReinitializedClassBuildItem> runtimeReinitializedClassBuildItems, List<NativeImageProxyDefinitionBuildItem> proxies, List<NativeImageResourceBuildItem> resources, List<NativeImageResourceBundleBuildItem> resourceBundles, List<ReflectiveMethodBuildItem> reflectiveMethods, List<ReflectiveFieldBuildItem> reflectiveFields, List<ReflectiveClassBuildItem> reflectiveClassBuildItems, List<ServiceProviderBuildItem> serviceProviderBuildItems, List<UnsafeAccessedFieldBuildItem> unsafeAccessedFields) {
        ResultHandle thisClass;
        ClassCreator file = new ClassCreator(new ClassOutput(){

            public void write(String s, byte[] bytes) {
                nativeImageClass.produce(new GeneratedNativeImageClassBuildItem(s, bytes));
            }
        }, GRAAL_AUTOFEATURE, null, Object.class.getName(), new String[]{Feature.class.getName()});
        file.addAnnotation("com.oracle.svm.core.annotate.AutomaticFeature");
        MethodCreator beforeAn = file.getMethodCreator("beforeAnalysis", "V", new String[]{BEFORE_ANALYSIS_ACCESS});
        TryBlock overallCatch = beforeAn.tryBlock();
        ResultHandle beforeAnalysisParam = beforeAn.getMethodParam(0);
        for (UnsafeAccessedFieldBuildItem unsafeAccessedFieldBuildItem : unsafeAccessedFields) {
            TryBlock tc = overallCatch.tryBlock();
            ResultHandle resultHandle = tc.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class}), new ResultHandle[]{tc.load(unsafeAccessedFieldBuildItem.getDeclaringClass())});
            ResultHandle fieldHandle = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredField", Field.class, (Class[])new Class[]{String.class}), resultHandle, new ResultHandle[]{tc.load(unsafeAccessedFieldBuildItem.getFieldName())});
            tc.invokeInterfaceMethod(MethodDescriptor.ofMethod(Feature.BeforeAnalysisAccess.class, (String)"registerAsUnsafeAccessed", Void.TYPE, (Class[])new Class[]{Field.class}), beforeAnalysisParam, new ResultHandle[]{fieldHandle});
            CatchBlockCreator cc = tc.addCatch(Throwable.class);
            cc.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc.getCaughtException(), new ResultHandle[0]);
        }
        if (!runtimeInitializedClassBuildItems.isEmpty()) {
            void var19_35;
            thisClass = overallCatch.loadClass(GRAAL_AUTOFEATURE);
            ResultHandle resultHandle = overallCatch.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getClassLoader", ClassLoader.class, (Class[])new Class[0]), thisClass, new ResultHandle[0]);
            ResultHandle classes = overallCatch.newArray(Class.class, overallCatch.load(runtimeInitializedClassBuildItems.size()));
            boolean bl = false;
            while (var19_35 < runtimeInitializedClassBuildItems.size()) {
                TryBlock tc = overallCatch.tryBlock();
                ResultHandle clazz = tc.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class}), new ResultHandle[]{tc.load(runtimeInitializedClassBuildItems.get((int)var19_35).getClassName()), tc.load(false), resultHandle});
                tc.writeArrayValue(classes, (int)var19_35, clazz);
                CatchBlockCreator cc = tc.addCatch(Throwable.class);
                cc.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc.getCaughtException(), new ResultHandle[0]);
                ++var19_35;
            }
            overallCatch.invokeStaticMethod(INITIALIZE_AT_RUN_TIME, new ResultHandle[]{classes});
        }
        if (!runtimeReinitializedClassBuildItems.isEmpty()) {
            thisClass = overallCatch.loadClass(GRAAL_AUTOFEATURE);
            ResultHandle resultHandle = overallCatch.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getClassLoader", ClassLoader.class, (Class[])new Class[0]), thisClass, new ResultHandle[0]);
            Iterator<Object> initSingleton = overallCatch.invokeStaticMethod(IMAGE_SINGLETONS_LOOKUP, new ResultHandle[]{overallCatch.loadClass("org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport")});
            ResultHandle resultHandle2 = overallCatch.load("Quarkus");
            for (RuntimeReinitializedClassBuildItem runtimeReinitializedClass : runtimeReinitializedClassBuildItems) {
                TryBlock tc = overallCatch.tryBlock();
                ResultHandle clazz = tc.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class}), new ResultHandle[]{tc.load(runtimeReinitializedClass.getClassName()), tc.load(false), resultHandle});
                tc.invokeInterfaceMethod(RERUN_INITIALIZATION, initSingleton, new ResultHandle[]{clazz, resultHandle2});
                CatchBlockCreator cc = tc.addCatch(Throwable.class);
                cc.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc.getCaughtException(), new ResultHandle[0]);
            }
        }
        if (!proxies.isEmpty()) {
            ResultHandle proxySupportClass = overallCatch.loadClass(DYNAMIC_PROXY_REGISTRY);
            ResultHandle resultHandle = overallCatch.invokeStaticMethod(IMAGE_SINGLETONS_LOOKUP, new ResultHandle[]{proxySupportClass});
            for (NativeImageProxyDefinitionBuildItem nativeImageProxyDefinitionBuildItem : proxies) {
                ResultHandle array = overallCatch.newArray(Class.class, overallCatch.load(nativeImageProxyDefinitionBuildItem.getClasses().size()));
                int i = 0;
                for (String p : nativeImageProxyDefinitionBuildItem.getClasses()) {
                    ResultHandle clazz = overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class}), new ResultHandle[]{overallCatch.load(p)});
                    overallCatch.writeArrayValue(array, i++, clazz);
                }
                overallCatch.invokeInterfaceMethod(MethodDescriptor.ofMethod((Object)DYNAMIC_PROXY_REGISTRY, (String)"addProxyClass", Void.TYPE, (Object[])new Object[]{Class[].class}), resultHandle, new ResultHandle[]{array});
            }
        }
        for (NativeImageResourceBuildItem nativeImageResourceBuildItem : resources) {
            for (String string : nativeImageResourceBuildItem.getResources()) {
                overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod(ResourceHelper.class, (String)"registerResources", Void.TYPE, (Class[])new Class[]{String.class}), new ResultHandle[]{overallCatch.load(string)});
            }
        }
        for (ServiceProviderBuildItem serviceProviderBuildItem : serviceProviderBuildItems) {
            overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod(ResourceHelper.class, (String)"registerResources", Void.TYPE, (Class[])new Class[]{String.class}), new ResultHandle[]{overallCatch.load(serviceProviderBuildItem.serviceDescriptorFile())});
        }
        if (!resourceBundles.isEmpty()) {
            ResultHandle locClass = overallCatch.loadClass(LOCALIZATION_SUPPORT);
            ResultHandle resultHandle = overallCatch.marshalAsArray(Class.class, new ResultHandle[]{overallCatch.loadClass(String.class)});
            Iterator<Object> registerMethod = overallCatch.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethod", Method.class, (Class[])new Class[]{String.class, Class[].class}), locClass, new ResultHandle[]{overallCatch.load("addBundleToCache"), resultHandle});
            overallCatch.invokeVirtualMethod(MethodDescriptor.ofMethod(AccessibleObject.class, (String)"setAccessible", Void.TYPE, (Class[])new Class[]{Boolean.TYPE}), registerMethod, new ResultHandle[]{overallCatch.load(true)});
            ResultHandle resultHandle3 = overallCatch.invokeStaticMethod(IMAGE_SINGLETONS_LOOKUP, new ResultHandle[]{locClass});
            for (NativeImageResourceBundleBuildItem i : resourceBundles) {
                String p;
                TryBlock et = overallCatch.tryBlock();
                et.invokeVirtualMethod(MethodDescriptor.ofMethod(Method.class, (String)"invoke", Object.class, (Class[])new Class[]{Object.class, Object[].class}), registerMethod, new ResultHandle[]{resultHandle3, et.marshalAsArray(Object.class, new ResultHandle[]{et.load(i.getBundleName())})});
                p = et.addCatch(Throwable.class);
            }
        }
        int count = 0;
        LinkedHashMap<String, ReflectionInfo> linkedHashMap = new LinkedHashMap<String, ReflectionInfo>();
        for (ReflectiveClassBuildItem reflectiveClassBuildItem : reflectiveClassBuildItems) {
            this.addReflectiveClass(linkedHashMap, reflectiveClassBuildItem.isConstructors(), reflectiveClassBuildItem.isMethods(), reflectiveClassBuildItem.isFields(), reflectiveClassBuildItem.areFinalFieldsWritable(), reflectiveClassBuildItem.isWeak(), reflectiveClassBuildItem.getClassNames().toArray(new String[0]));
        }
        for (ReflectiveFieldBuildItem reflectiveFieldBuildItem : reflectiveFields) {
            this.addReflectiveField(linkedHashMap, reflectiveFieldBuildItem);
        }
        for (ReflectiveMethodBuildItem reflectiveMethodBuildItem : reflectiveMethods) {
            this.addReflectiveMethod(linkedHashMap, reflectiveMethodBuildItem);
        }
        for (ServiceProviderBuildItem serviceProviderBuildItem : serviceProviderBuildItems) {
            this.addReflectiveClass(linkedHashMap, true, false, false, false, false, serviceProviderBuildItem.providers().toArray(new String[0]));
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            ResultHandle fhandle;
            String type;
            ResultHandle paramArray;
            ResultHandle farray;
            MethodCreator mv = file.getMethodCreator("registerClass" + count++, "V", new String[0]);
            mv.setModifiers(10);
            overallCatch.invokeStaticMethod(mv.getMethodDescriptor(), new ResultHandle[0]);
            TryBlock tc = mv.tryBlock();
            ResultHandle clazz = tc.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class}), new ResultHandle[]{tc.load((String)entry.getKey())});
            ResultHandle constructors = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredConstructors", Constructor[].class, (Class[])new Class[0]), clazz, new ResultHandle[0]);
            ResultHandle methods = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethods", Method[].class, (Class[])new Class[0]), clazz, new ResultHandle[0]);
            ResultHandle fields = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredFields", Field[].class, (Class[])new Class[0]), clazz, new ResultHandle[0]);
            if (!((ReflectionInfo)entry.getValue()).weak) {
                ResultHandle carray = tc.newArray(Class.class, tc.load(1));
                tc.writeArrayValue(carray, 0, clazz);
                tc.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Class[].class}), new ResultHandle[]{carray});
            }
            if (((ReflectionInfo)entry.getValue()).constructors) {
                tc.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{constructors});
            } else if (!((ReflectionInfo)entry.getValue()).ctorSet.isEmpty()) {
                farray = tc.newArray(Constructor.class, tc.load(1));
                for (ReflectiveMethodBuildItem ctor : ((ReflectionInfo)entry.getValue()).ctorSet) {
                    paramArray = tc.newArray(Class.class, tc.load(ctor.getParams().length));
                    for (int i = 0; i < ctor.getParams().length; ++i) {
                        type = ctor.getParams()[i];
                        tc.writeArrayValue(paramArray, i, tc.loadClass(type));
                    }
                    fhandle = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredConstructor", Constructor.class, (Class[])new Class[]{Class[].class}), clazz, new ResultHandle[]{paramArray});
                    tc.writeArrayValue(farray, 0, fhandle);
                    tc.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{farray});
                }
            }
            if (((ReflectionInfo)entry.getValue()).methods) {
                tc.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{methods});
            } else if (!((ReflectionInfo)entry.getValue()).methodSet.isEmpty()) {
                farray = tc.newArray(Method.class, tc.load(1));
                for (ReflectiveMethodBuildItem method : ((ReflectionInfo)entry.getValue()).methodSet) {
                    paramArray = tc.newArray(Class.class, tc.load(method.getParams().length));
                    for (int i = 0; i < method.getParams().length; ++i) {
                        type = method.getParams()[i];
                        tc.writeArrayValue(paramArray, i, tc.loadClass(type));
                    }
                    fhandle = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethod", Method.class, (Class[])new Class[]{String.class, Class[].class}), clazz, new ResultHandle[]{tc.load(method.getName()), paramArray});
                    tc.writeArrayValue(farray, 0, fhandle);
                    tc.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{farray});
                }
            }
            if (((ReflectionInfo)entry.getValue()).fields) {
                tc.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Boolean.TYPE, Field[].class}), new ResultHandle[]{tc.load(((ReflectionInfo)entry.getValue()).finalFieldsWritable), fields});
            } else if (!((ReflectionInfo)entry.getValue()).fieldSet.isEmpty()) {
                farray = tc.newArray(Field.class, tc.load(1));
                for (String field : ((ReflectionInfo)entry.getValue()).fieldSet) {
                    ResultHandle fhandle2 = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredField", Field.class, (Class[])new Class[]{String.class}), clazz, new ResultHandle[]{tc.load(field)});
                    tc.writeArrayValue(farray, 0, fhandle2);
                    tc.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Field[].class}), new ResultHandle[]{farray});
                }
            }
            CatchBlockCreator cc = tc.addCatch(Throwable.class);
            mv.returnValue(null);
        }
        CatchBlockCreator print = overallCatch.addCatch(Throwable.class);
        print.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), print.getCaughtException(), new ResultHandle[0]);
        beforeAn.loadClass("io.quarkus.runner.ApplicationImpl");
        beforeAn.returnValue(null);
        file.close();
    }

    public void addReflectiveMethod(Map<String, ReflectionInfo> reflectiveClasses, ReflectiveMethodBuildItem methodInfo) {
        String cl = methodInfo.getDeclaringClass();
        ReflectionInfo existing = reflectiveClasses.get(cl);
        if (existing == null) {
            existing = new ReflectionInfo(false, false, false, false, false);
            reflectiveClasses.put(cl, existing);
        }
        if (methodInfo.getName().equals("<init>")) {
            existing.ctorSet.add(methodInfo);
        } else {
            existing.methodSet.add(methodInfo);
        }
    }

    public void addReflectiveClass(Map<String, ReflectionInfo> reflectiveClasses, boolean constructors, boolean method, boolean fields, boolean finalFieldsWritable, boolean weak, String ... className) {
        for (String cl : className) {
            ReflectionInfo existing = reflectiveClasses.get(cl);
            if (existing == null) {
                reflectiveClasses.put(cl, new ReflectionInfo(constructors, method, fields, finalFieldsWritable, weak));
                continue;
            }
            if (constructors) {
                existing.constructors = true;
            }
            if (method) {
                existing.methods = true;
            }
            if (!fields) continue;
            existing.fields = true;
        }
    }

    public void addReflectiveField(Map<String, ReflectionInfo> reflectiveClasses, ReflectiveFieldBuildItem fieldInfo) {
        String cl = fieldInfo.getDeclaringClass();
        ReflectionInfo existing = reflectiveClasses.get(cl);
        if (existing == null) {
            existing = new ReflectionInfo(false, false, false, false, false);
            reflectiveClasses.put(cl, existing);
        }
        existing.fieldSet.add(fieldInfo.getName());
    }

    static final class ReflectionInfo {
        boolean constructors;
        boolean methods;
        boolean fields;
        boolean finalFieldsWritable;
        boolean weak;
        Set<String> fieldSet = new HashSet<String>();
        Set<ReflectiveMethodBuildItem> methodSet = new HashSet<ReflectiveMethodBuildItem>();
        Set<ReflectiveMethodBuildItem> ctorSet = new HashSet<ReflectiveMethodBuildItem>();

        private ReflectionInfo(boolean constructors, boolean methods, boolean fields, boolean finalFieldsWritable, boolean weak) {
            this.methods = methods;
            this.fields = fields;
            this.constructors = constructors;
            this.finalFieldsWritable = finalFieldsWritable;
            this.weak = weak;
        }
    }
}

