/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.deployment;

import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.AutoInjectAnnotationBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.cache.CacheManager;
import io.quarkus.cache.deployment.AdditionalCacheNameBuildItem;
import io.quarkus.cache.deployment.CacheAnnotationsTransformer;
import io.quarkus.cache.deployment.CacheDeploymentConstants;
import io.quarkus.cache.deployment.CacheNamesBuildItem;
import io.quarkus.cache.deployment.RestClientMethodEnhancer;
import io.quarkus.cache.deployment.exception.ClassTargetException;
import io.quarkus.cache.deployment.exception.KeyGeneratorConstructorException;
import io.quarkus.cache.deployment.exception.PrivateMethodTargetException;
import io.quarkus.cache.deployment.exception.UnsupportedRepeatedAnnotationException;
import io.quarkus.cache.deployment.exception.VoidReturnTypeTargetException;
import io.quarkus.cache.runtime.CacheInvalidateAllInterceptor;
import io.quarkus.cache.runtime.CacheInvalidateInterceptor;
import io.quarkus.cache.runtime.CacheManagerRecorder;
import io.quarkus.cache.runtime.CacheResultInterceptor;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.DeploymentException;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

class CacheProcessor {
    private static final Logger LOGGER = Logger.getLogger(CacheProcessor.class);

    CacheProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.CACHE);
    }

    @BuildStep
    AutoInjectAnnotationBuildItem autoInjectCacheName() {
        return new AutoInjectAnnotationBuildItem(new DotName[]{CacheDeploymentConstants.CACHE_NAME});
    }

    @BuildStep
    AnnotationsTransformerBuildItem annotationsTransformer() {
        return new AnnotationsTransformerBuildItem((AnnotationsTransformer)new CacheAnnotationsTransformer());
    }

    @BuildStep
    void validateCacheAnnotationsAndProduceCacheNames(CombinedIndexBuildItem combinedIndex, List<AdditionalCacheNameBuildItem> additionalCacheNames, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors, BuildProducer<CacheNamesBuildItem> cacheNames, BeanDiscoveryFinishedBuildItem beanDiscoveryFinished) {
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        HashSet<String> names = new HashSet<String>();
        HashSet<DotName> keyGenerators = new HashSet<DotName>();
        for (DotName bindingName : CacheDeploymentConstants.INTERCEPTOR_BINDINGS) {
            for (AnnotationInstance binding : combinedIndex.getIndex().getAnnotations(bindingName)) {
                throwables.addAll(this.validateInterceptorBindingTarget(binding, binding.target()));
                this.findCacheKeyGenerator(binding, binding.target()).ifPresent(keyGenerators::add);
                if (binding.target().kind() != AnnotationTarget.Kind.METHOD) continue;
                names.add(binding.value("cacheName").asString());
            }
        }
        for (DotName containerName : CacheDeploymentConstants.INTERCEPTOR_BINDING_CONTAINERS) {
            for (AnnotationInstance container : combinedIndex.getIndex().getAnnotations(containerName)) {
                MethodInfo methodInfo;
                for (AnnotationInstance binding : container.value("value").asNestedArray()) {
                    throwables.addAll(this.validateInterceptorBindingTarget(binding, container.target()));
                    this.findCacheKeyGenerator(binding, container.target()).ifPresent(keyGenerators::add);
                    names.add(binding.value("cacheName").asString());
                }
                if (container.target().kind() != AnnotationTarget.Kind.METHOD || (methodInfo = container.target().asMethod()).declaringClass().classAnnotation(CacheDeploymentConstants.REGISTER_REST_CLIENT) == null) continue;
                throwables.add(new UnsupportedRepeatedAnnotationException(methodInfo));
            }
        }
        for (AnnotationInstance qualifier : combinedIndex.getIndex().getAnnotations(CacheDeploymentConstants.CACHE_NAME)) {
            if (qualifier.target().kind() == AnnotationTarget.Kind.METHOD) continue;
            names.add(qualifier.value().asString());
        }
        for (AdditionalCacheNameBuildItem additionalCacheName : additionalCacheNames) {
            names.add(additionalCacheName.getName());
        }
        cacheNames.produce((BuildItem)new CacheNamesBuildItem(names));
        if (!keyGenerators.isEmpty()) {
            throwables.addAll(this.validateKeyGeneratorsDefaultConstructor(combinedIndex, beanDiscoveryFinished, keyGenerators));
        }
        validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(throwables.toArray(new Throwable[0])));
    }

    private List<Throwable> validateInterceptorBindingTarget(AnnotationInstance binding, AnnotationTarget target) {
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        switch (target.kind()) {
            case CLASS: {
                ClassInfo classInfo = target.asClass();
                if (CacheDeploymentConstants.INTERCEPTORS.contains(classInfo.name())) break;
                throwables.add(new ClassTargetException(classInfo.name(), binding.name()));
                break;
            }
            case METHOD: {
                MethodInfo methodInfo = target.asMethod();
                if (Modifier.isPrivate(methodInfo.flags())) {
                    throwables.add(new PrivateMethodTargetException(methodInfo, binding.name()));
                }
                if (!CacheDeploymentConstants.CACHE_RESULT.equals((Object)binding.name())) break;
                if (methodInfo.returnType().kind() == Type.Kind.VOID) {
                    throwables.add(new VoidReturnTypeTargetException(methodInfo));
                    break;
                }
                if (!CacheDeploymentConstants.MULTI.equals((Object)methodInfo.returnType().name())) break;
                LOGGER.warnf("@CacheResult is not currently supported on a method returning %s [class=%s, method=%s]", (Object)CacheDeploymentConstants.MULTI, (Object)methodInfo.declaringClass().name(), (Object)methodInfo.name());
                break;
            }
            default: {
                throw new DeploymentException("Unexpected cache interceptor binding target: " + target.kind());
            }
        }
        return throwables;
    }

    private Optional<DotName> findCacheKeyGenerator(AnnotationInstance binding, AnnotationTarget target) {
        AnnotationValue keyGenerator;
        if (target.kind() == AnnotationTarget.Kind.METHOD && (CacheDeploymentConstants.CACHE_RESULT.equals((Object)binding.name()) || CacheDeploymentConstants.CACHE_INVALIDATE.equals((Object)binding.name())) && (keyGenerator = binding.value("keyGenerator")) != null) {
            return Optional.of(keyGenerator.asClass().name());
        }
        return Optional.empty();
    }

    private List<Throwable> validateKeyGeneratorsDefaultConstructor(CombinedIndexBuildItem combinedIndex, BeanDiscoveryFinishedBuildItem beanDiscoveryFinished, Set<DotName> keyGenerators) {
        List managedBeans = beanDiscoveryFinished.getBeans().stream().filter(BeanInfo::isClassBean).map(BeanInfo::getBeanClass).collect(Collectors.toList());
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        for (DotName keyGenClassName : keyGenerators) {
            ClassInfo keyGenClassInfo;
            if (managedBeans.contains(keyGenClassName) || (keyGenClassInfo = combinedIndex.getIndex().getClassByName(keyGenClassName)).hasNoArgsConstructor()) continue;
            throwables.add(new KeyGeneratorConstructorException(keyGenClassInfo));
        }
        return throwables;
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    SyntheticBeanBuildItem configureCacheManagerSyntheticBean(CacheNamesBuildItem cacheNames, CacheManagerRecorder cacheManagerRecorder, Optional<MetricsCapabilityBuildItem> metricsCapability) {
        boolean micrometerSupported = metricsCapability.isPresent() && metricsCapability.get().metricsSupported("micrometer");
        Supplier cacheManagerSupplier = micrometerSupported ? cacheManagerRecorder.getCacheManagerSupplierWithMicrometerMetrics(cacheNames.getNames()) : cacheManagerRecorder.getCacheManagerSupplierWithoutMetrics(cacheNames.getNames());
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(CacheManager.class).scope(ApplicationScoped.class)).supplier(cacheManagerSupplier).setRuntimeInit().done();
    }

    @BuildStep
    List<BytecodeTransformerBuildItem> enhanceRestClientMethods(CombinedIndexBuildItem combinedIndex, BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        ArrayList<BytecodeTransformerBuildItem> bytecodeTransformers = new ArrayList<BytecodeTransformerBuildItem>();
        boolean cacheInvalidate = false;
        boolean cacheResult = false;
        boolean cacheInvalidateAll = false;
        for (AnnotationInstance registerRestClientAnnotation : combinedIndex.getIndex().getAnnotations(CacheDeploymentConstants.REGISTER_REST_CLIENT)) {
            if (registerRestClientAnnotation.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            ClassInfo classInfo = registerRestClientAnnotation.target().asClass();
            for (MethodInfo methodInfo : classInfo.methods()) {
                boolean transform = false;
                if (methodInfo.hasAnnotation(CacheDeploymentConstants.CACHE_INVALIDATE) || methodInfo.hasAnnotation(CacheDeploymentConstants.CACHE_INVALIDATE_LIST)) {
                    transform = true;
                    cacheInvalidate = true;
                }
                if (methodInfo.hasAnnotation(CacheDeploymentConstants.CACHE_RESULT)) {
                    transform = true;
                    cacheResult = true;
                }
                if (methodInfo.hasAnnotation(CacheDeploymentConstants.CACHE_INVALIDATE_ALL) || methodInfo.hasAnnotation(CacheDeploymentConstants.CACHE_INVALIDATE_ALL_LIST)) {
                    cacheInvalidateAll = true;
                }
                if (!transform) continue;
                short[] cacheKeyParameterPositions = this.getCacheKeyParameterPositions(methodInfo);
                bytecodeTransformers.add(new BytecodeTransformerBuildItem(classInfo.toString(), (BiFunction)new RestClientMethodEnhancer(methodInfo.name(), cacheKeyParameterPositions)));
            }
        }
        if (cacheResult) {
            unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames((String[])new String[]{CacheResultInterceptor.class.getName()}));
        }
        if (cacheInvalidate) {
            unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames((String[])new String[]{CacheInvalidateInterceptor.class.getName()}));
        }
        if (cacheInvalidateAll) {
            unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames((String[])new String[]{CacheInvalidateAllInterceptor.class.getName()}));
        }
        return bytecodeTransformers;
    }

    private short[] getCacheKeyParameterPositions(MethodInfo methodInfo) {
        ArrayList<Short> positions = new ArrayList<Short>();
        for (AnnotationInstance annotation : methodInfo.annotations(CacheDeploymentConstants.CACHE_KEY)) {
            positions.add(annotation.target().asMethodParameter().position());
        }
        short[] result = new short[positions.size()];
        for (int i = 0; i < positions.size(); ++i) {
            result[i] = (Short)positions.get(i);
        }
        return result;
    }
}

