/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.classloading;

import io.quarkus.bootstrap.classloading.ClassLoaderEventListener;
import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.ClassPathResource;
import io.quarkus.bootstrap.classloading.DriverRemover;
import io.quarkus.bootstrap.classloading.JarClassPathElement;
import io.quarkus.bootstrap.classloading.MemoryClassPathElement;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.logging.Logger;

public class QuarkusClassLoader
extends ClassLoader
implements Closeable {
    private static final Logger log = Logger.getLogger(QuarkusClassLoader.class);
    protected static final String META_INF_SERVICES = "META-INF/services/";
    protected static final String JAVA = "java.";
    private final String name;
    private final List<ClassPathElement> elements;
    private final ConcurrentMap<ClassPathElement, ProtectionDomain> protectionDomains = new ConcurrentHashMap<ClassPathElement, ProtectionDomain>();
    private final ConcurrentMap<String, Package> definedPackages = new ConcurrentHashMap<String, Package>();
    private final ClassLoader parent;
    private final boolean parentFirst;
    private final boolean aggregateParentResources;
    private final List<ClassPathElement> bannedElements;
    private final List<ClassPathElement> parentFirstElements;
    private final List<ClassPathElement> lesserPriorityElements;
    private final List<ClassLoaderEventListener> classLoaderEventListeners;
    private volatile MemoryClassPathElement resettableElement;
    private volatile MemoryClassPathElement transformedClasses;
    private volatile ClassLoaderState state;
    private final List<Runnable> closeTasks = new ArrayList<Runnable>();
    static final ClassLoader PLATFORM_CLASS_LOADER;
    private boolean closed;
    private volatile boolean driverLoaded;

    public static List<ClassPathElement> getElements(String resourceName, boolean localOnly) {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        if (!(ccl instanceof QuarkusClassLoader)) {
            throw new IllegalStateException("The current classloader is not an instance of " + QuarkusClassLoader.class.getName() + " but " + ccl.getClass().getName());
        }
        return ((QuarkusClassLoader)ccl).getElementsWithResource(resourceName, localOnly);
    }

    public List<ClassPathElement> getAllElements(boolean localOnly) {
        ArrayList<ClassPathElement> ret = new ArrayList<ClassPathElement>();
        if (this.parent instanceof QuarkusClassLoader && !localOnly) {
            ret.addAll(((QuarkusClassLoader)this.parent).getAllElements(localOnly));
        }
        ret.addAll(this.elements);
        return ret;
    }

    public static boolean isClassPresentAtRuntime(String className) {
        return QuarkusClassLoader.isResourcePresentAtRuntime(className.replace('.', '/') + ".class");
    }

    public static boolean isResourcePresentAtRuntime(String resourcePath) {
        for (ClassPathElement cpe : QuarkusClassLoader.getElements(resourcePath, false)) {
            if (!cpe.isRuntime()) continue;
            return true;
        }
        return false;
    }

    private QuarkusClassLoader(Builder builder) {
        super(builder.parent);
        this.name = builder.name;
        this.elements = builder.elements;
        this.bannedElements = builder.bannedElements;
        this.parentFirstElements = builder.parentFirstElements;
        this.lesserPriorityElements = builder.lesserPriorityElements;
        this.parent = builder.parent;
        this.parentFirst = builder.parentFirst;
        this.resettableElement = builder.resettableElement;
        this.transformedClasses = new MemoryClassPathElement(builder.transformedClasses, true);
        this.aggregateParentResources = builder.aggregateParentResources;
        this.classLoaderEventListeners = builder.classLoaderEventListeners.isEmpty() ? Collections.emptyList() : builder.classLoaderEventListeners;
        this.setDefaultAssertionStatus(builder.assertionsEnabled);
    }

    public static Builder builder(String name, ClassLoader parent, boolean parentFirst) {
        return new Builder(name, parent, parentFirst);
    }

    private String sanitizeName(String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParentFirst(String name) {
        if (name.startsWith(JAVA)) {
            return true;
        }
        boolean interrupted = Thread.interrupted();
        try {
            ClassLoaderState state = this.getState();
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                String resourceName = this.sanitizeName(name).replace('.', '/') + ".class";
                boolean bl = this.parentFirst(resourceName, state);
                return bl;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private boolean parentFirst(String name, ClassLoaderState state) {
        return this.parentFirst || state.parentFirstResources.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(Map<String, byte[]> generatedResources, Map<String, byte[]> transformedClasses) {
        if (this.resettableElement == null) {
            throw new IllegalStateException("Classloader is not resettable");
        }
        QuarkusClassLoader quarkusClassLoader = this;
        synchronized (quarkusClassLoader) {
            this.transformedClasses = new MemoryClassPathElement(transformedClasses, true);
            this.resettableElement.reset(generatedResources);
            this.state = null;
        }
    }

    @Override
    public Enumeration<URL> getResources(String unsanitisedName) throws IOException {
        return this.getResources(unsanitisedName, false);
    }

    public Enumeration<URL> getResources(String unsanitisedName, boolean parentAlreadyFoundResources) throws IOException {
        for (ClassLoaderEventListener l : this.classLoaderEventListeners) {
            l.enumeratingResourceURLs(unsanitisedName, this.name);
        }
        ClassLoaderState state = this.getState();
        String name = this.sanitizeName(unsanitisedName);
        boolean banned = state.bannedResources.contains(name);
        if (name.startsWith(META_INF_SERVICES)) {
            try {
                Class<?> c = this.loadClass(name.substring(META_INF_SERVICES.length()));
                if (c.getClassLoader() == this) {
                    banned = true;
                }
            }
            catch (ClassNotFoundException c) {
                // empty catch block
            }
        }
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>();
        ClassPathElement[] providers = state.loadableResources.get(name);
        if (providers != null) {
            boolean endsWithTrailingSlash = unsanitisedName.endsWith("/");
            for (ClassPathElement element : providers) {
                ClassPathResource res = element.getResource(name);
                if (endsWithTrailingSlash) {
                    if (!res.isDirectory()) continue;
                    try {
                        resources.add(new URL(res.getUrl().toString() + "/"));
                        continue;
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }
                resources.add(res.getUrl());
            }
        } else if (name.isEmpty()) {
            for (ClassPathElement i : this.elements) {
                ClassPathResource res = i.getResource("");
                if (res == null) continue;
                resources.add(res.getUrl());
            }
        }
        if (!banned && (resources.isEmpty() && !parentAlreadyFoundResources || this.aggregateParentResources)) {
            Enumeration<URL> res = this.parent instanceof QuarkusClassLoader ? ((QuarkusClassLoader)this.parent).getResources(unsanitisedName, !resources.isEmpty()) : this.parent.getResources(unsanitisedName);
            while (res.hasMoreElements()) {
                resources.add(res.nextElement());
            }
        }
        return Collections.enumeration(resources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private ClassLoaderState getState() {
        ClassLoaderState state = this.state;
        if (state == null) {
            QuarkusClassLoader quarkusClassLoader = this;
            synchronized (quarkusClassLoader) {
                state = this.state;
                if (state == null) {
                    HashMap<String, List<ClassPathElement>> elementMap = new HashMap<String, List<ClassPathElement>>();
                    for (ClassPathElement classPathElement : this.elements) {
                        for (String string : classPathElement.getProvidedResources()) {
                            if (string.startsWith("/")) {
                                throw new RuntimeException("Resources cannot start with /, " + string + " is incorrect provided by " + classPathElement);
                            }
                            if (this.transformedClasses.getResource(string) != null) {
                                elementMap.put(string, Collections.singletonList(this.transformedClasses));
                                continue;
                            }
                            ArrayList<ClassPathElement> list = (ArrayList<ClassPathElement>)elementMap.get(string);
                            if (list == null) {
                                list = new ArrayList<ClassPathElement>(2);
                                elementMap.put(string, list);
                            }
                            list.add(classPathElement);
                        }
                    }
                    HashMap<String, ClassPathElement[]> finalElements = new HashMap<String, ClassPathElement[]>();
                    for (Map.Entry entry : elementMap.entrySet()) {
                        void var7_17;
                        List list = (List)entry.getValue();
                        if (!this.lesserPriorityElements.isEmpty() && list.size() > 1) {
                            ArrayList<ClassPathElement> entryNormalPriorityElements = new ArrayList<ClassPathElement>(list.size());
                            ArrayList<ClassPathElement> entryLesserPriorityElements = new ArrayList<ClassPathElement>(list.size());
                            for (ClassPathElement classPathElement : list) {
                                if (this.lesserPriorityElements.contains(classPathElement)) {
                                    entryLesserPriorityElements.add(classPathElement);
                                    continue;
                                }
                                entryNormalPriorityElements.add(classPathElement);
                            }
                            ArrayList<ClassPathElement> arrayList = new ArrayList<ClassPathElement>(list.size());
                            arrayList.addAll(entryNormalPriorityElements);
                            arrayList.addAll(entryLesserPriorityElements);
                        }
                        finalElements.put((String)entry.getKey(), var7_17.toArray(new ClassPathElement[var7_17.size()]));
                    }
                    HashSet<String> hashSet = new HashSet<String>();
                    for (ClassPathElement classPathElement : this.bannedElements) {
                        hashSet.addAll(classPathElement.getProvidedResources());
                    }
                    HashSet<String> hashSet2 = new HashSet<String>();
                    for (ClassPathElement i : this.parentFirstElements) {
                        hashSet2.addAll(i.getProvidedResources());
                    }
                    this.state = new ClassLoaderState(finalElements, hashSet, hashSet2);
                    return this.state;
                }
            }
        }
        return state;
    }

    @Override
    public URL getResource(String unsanitisedName) {
        for (ClassLoaderEventListener l : this.classLoaderEventListeners) {
            l.gettingURLFromResource(unsanitisedName, this.name);
        }
        String name = this.sanitizeName(unsanitisedName);
        ClassLoaderState state = this.getState();
        if (state.bannedResources.contains(name)) {
            return null;
        }
        boolean endsWithTrailingSlash = unsanitisedName.endsWith("/");
        if (name.endsWith(".class") && !endsWithTrailingSlash) {
            ClassPathElement[] providers = state.loadableResources.get(name);
            if (providers != null) {
                ClassPathResource resource = providers[0].getResource(name);
                if (resource == null) {
                    throw new IllegalStateException(providers[0] + " from " + this.getName() + " (closed=" + this.isClosed() + ") was expected to provide " + name + " but failed");
                }
                return resource.getUrl();
            }
        } else {
            for (ClassPathElement i : this.elements) {
                ClassPathResource res = i.getResource(name);
                if (res == null) continue;
                if (endsWithTrailingSlash) {
                    if (!res.isDirectory()) continue;
                    try {
                        return new URL(res.getUrl().toString() + "/");
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }
                return res.getUrl();
            }
        }
        return this.parent.getResource(unsanitisedName);
    }

    @Override
    public InputStream getResourceAsStream(String unsanitisedName) {
        for (ClassLoaderEventListener l : this.classLoaderEventListeners) {
            l.openResourceStream(unsanitisedName, this.name);
        }
        String name = this.sanitizeName(unsanitisedName);
        ClassLoaderState state = this.getState();
        if (state.bannedResources.contains(name)) {
            return null;
        }
        if (name.endsWith(".class")) {
            ClassPathElement[] providers = state.loadableResources.get(name);
            if (providers != null) {
                return new ByteArrayInputStream(providers[0].getResource(name).getData());
            }
        } else {
            for (ClassPathElement i : this.elements) {
                ClassPathResource res = i.getResource(name);
                if (res == null) continue;
                if (res.isDirectory()) {
                    try {
                        return res.getUrl().openStream();
                    }
                    catch (IOException e) {
                        log.debug((Object)("Ignoring exception that occurred while opening a stream for resource " + unsanitisedName), (Throwable)e);
                        continue;
                    }
                }
                return new ByteArrayInputStream(res.getData());
            }
        }
        return this.parent.getResourceAsStream(unsanitisedName);
    }

    @Override
    protected Class<?> findClass(String moduleName, String name) {
        try {
            return this.loadClass(name, false);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ClassPathElement classPathElement;
        ClassPathResource classPathElementResource;
        ClassPathElement[] resource;
        ClassLoaderState state;
        boolean interrupted;
        block18: {
            for (ClassLoaderEventListener l : this.classLoaderEventListeners) {
                l.loadClass(name, this.name);
            }
            if (name.startsWith(JAVA)) {
                return this.parent.loadClass(name);
            }
            interrupted = Thread.interrupted();
            try {
                state = this.getState();
                Object object = this.getClassLoadingLock(name);
                // MONITORENTER : object
                Class<?> c = this.findLoadedClass(name);
                if (c == null) break block18;
                Class<?> clazz = c;
                // MONITOREXIT : object
                if (!interrupted) return clazz;
                Thread.currentThread().interrupt();
                return clazz;
            }
            catch (Throwable throwable) {
                if (!interrupted) throw throwable;
                Thread.currentThread().interrupt();
                throw throwable;
            }
        }
        String resourceName = this.sanitizeName(name).replace('.', '/') + ".class";
        if (state.bannedResources.contains(resourceName)) {
            throw new ClassNotFoundException(name);
        }
        boolean parentFirst = this.parentFirst(resourceName, state);
        if (parentFirst) {
            try {
                Class<?> clazz = this.parent.loadClass(name);
                // MONITOREXIT : object
                if (!interrupted) return clazz;
                Thread.currentThread().interrupt();
                return clazz;
            }
            catch (ClassNotFoundException ignore) {
                log.tracef("Class %s not found in parent first load from %s", (Object)name, (Object)this.parent);
            }
        }
        if ((resource = state.loadableResources.get(resourceName)) != null && (classPathElementResource = (classPathElement = resource[0]).getResource(resourceName)) != null) {
            byte[] data = classPathElementResource.getData();
            this.definePackage(name, classPathElement);
            Class<?> cl = this.defineClass(name, data, 0, data.length, this.protectionDomains.computeIfAbsent(classPathElement, ce -> ce.getProtectionDomain(this)));
            if (Driver.class.isAssignableFrom(cl)) {
                this.driverLoaded = true;
            }
            Class<?> clazz = cl;
            // MONITOREXIT : object
            if (!interrupted) return clazz;
            Thread.currentThread().interrupt();
            return clazz;
        }
        if (!parentFirst) {
            Class<?> clazz = this.parent.loadClass(name);
            // MONITOREXIT : object
            if (!interrupted) return clazz;
            Thread.currentThread().interrupt();
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void definePackage(String name, ClassPathElement classPathElement) {
        String pkgName = this.getPackageNameFromClassName(name);
        if (pkgName != null && this.definedPackages.get(pkgName) == null) {
            Object object = this.getClassLoadingLock(pkgName);
            synchronized (object) {
                if (this.definedPackages.get(pkgName) == null) {
                    Manifest mf = classPathElement.getManifest();
                    if (mf != null) {
                        Attributes ma = mf.getMainAttributes();
                        this.definedPackages.put(pkgName, this.definePackage(pkgName, ma.getValue(Attributes.Name.SPECIFICATION_TITLE), ma.getValue(Attributes.Name.SPECIFICATION_VERSION), ma.getValue(Attributes.Name.SPECIFICATION_VENDOR), ma.getValue(Attributes.Name.IMPLEMENTATION_TITLE), ma.getValue(Attributes.Name.IMPLEMENTATION_VERSION), ma.getValue(Attributes.Name.IMPLEMENTATION_VENDOR), null));
                        return;
                    }
                    this.definedPackages.put(pkgName, this.definePackage(pkgName, null, null, null, null, null, null, null));
                }
            }
        }
    }

    private String getPackageNameFromClassName(String className) {
        int index = className.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return className.substring(0, index);
    }

    public List<ClassPathElement> getElementsWithResource(String name) {
        return this.getElementsWithResource(name, false);
    }

    public List<ClassPathElement> getElementsWithResource(String name, boolean localOnly) {
        ClassPathElement[] classPathElements;
        ArrayList<ClassPathElement> ret = new ArrayList<ClassPathElement>();
        if (this.parent instanceof QuarkusClassLoader && !localOnly) {
            ret.addAll(((QuarkusClassLoader)this.parent).getElementsWithResource(name));
        }
        if ((classPathElements = this.getState().loadableResources.get(name)) == null) {
            return ret;
        }
        ret.addAll(Arrays.asList(classPathElements));
        return ret;
    }

    public List<String> getLocalClassNames() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String name : this.getState().loadableResources.keySet()) {
            if (!name.endsWith(".class")) continue;
            ret.add(name.substring(0, name.length() - 6).replace('/', '.'));
        }
        return ret;
    }

    public Class<?> visibleDefineClass(String name, byte[] b, int off, int len) throws ClassFormatError {
        return super.defineClass(name, b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCloseTask(Runnable task) {
        List<Runnable> list = this.closeTasks;
        synchronized (list) {
            this.closeTasks.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ClassPathElement ignored;
        ArrayList<Runnable> tasks;
        QuarkusClassLoader quarkusClassLoader = this;
        synchronized (quarkusClassLoader) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        Iterator<ClassPathElement> iterator = this.closeTasks;
        synchronized (iterator) {
            tasks = new ArrayList<Runnable>(this.closeTasks);
        }
        for (Runnable i : tasks) {
            try {
                i.run();
            }
            catch (Throwable t) {
                log.error((Object)"Failed to run close task", t);
            }
        }
        if (this.driverLoaded) {
            try (InputStream is = this.getClass().getResourceAsStream("DriverRemover.class");){
                byte[] data = JarClassPathElement.readStreamContents(is);
                Runnable r = (Runnable)this.defineClass(DriverRemover.class.getName(), data, 0, data.length).getConstructor(ClassLoader.class).newInstance(this);
                r.run();
            }
            catch (Exception e) {
                log.debug((Object)"Failed to clean up DB drivers");
            }
        }
        for (ClassPathElement element : this.elements) {
            try {
                ignored = element;
                if (ignored == null) continue;
                ignored.close();
            }
            catch (Exception e) {
                log.error((Object)("Failed to close " + element), (Throwable)e);
            }
        }
        for (ClassPathElement element : this.bannedElements) {
            try {
                ignored = element;
                if (ignored == null) continue;
                ignored.close();
            }
            catch (Exception e) {
                log.error((Object)("Failed to close " + element), (Throwable)e);
            }
        }
        ResourceBundle.clearCache(this);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String toString() {
        return "QuarkusClassLoader:" + this.name + "@" + Integer.toHexString(this.hashCode());
    }

    public ClassLoader parent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    static {
        QuarkusClassLoader.registerAsParallelCapable();
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)ClassLoader.class.getDeclaredMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        PLATFORM_CLASS_LOADER = cl;
    }

    static final class ClassLoaderState {
        final Map<String, ClassPathElement[]> loadableResources;
        final Set<String> bannedResources;
        final Set<String> parentFirstResources;

        ClassLoaderState(Map<String, ClassPathElement[]> loadableResources, Set<String> bannedResources, Set<String> parentFirstResources) {
            this.loadableResources = loadableResources;
            this.bannedResources = bannedResources;
            this.parentFirstResources = parentFirstResources;
        }
    }

    public static class Builder {
        final String name;
        final ClassLoader parent;
        final List<ClassPathElement> elements = new ArrayList<ClassPathElement>();
        final List<ClassPathElement> bannedElements = new ArrayList<ClassPathElement>();
        final List<ClassPathElement> parentFirstElements = new ArrayList<ClassPathElement>();
        final List<ClassPathElement> lesserPriorityElements = new ArrayList<ClassPathElement>();
        final boolean parentFirst;
        MemoryClassPathElement resettableElement;
        private Map<String, byte[]> transformedClasses = Collections.emptyMap();
        boolean aggregateParentResources;
        boolean assertionsEnabled;
        private final ArrayList<ClassLoaderEventListener> classLoaderEventListeners = new ArrayList(5);

        public Builder(String name, ClassLoader parent, boolean parentFirst) {
            this.name = name;
            this.parent = parent;
            this.parentFirst = parentFirst;
        }

        public Builder addElement(ClassPathElement element) {
            log.debugf("Adding elements %s to QuarkusClassLoader %s", (Object)element, (Object)this.name);
            this.elements.add(element);
            return this;
        }

        public Builder setResettableElement(MemoryClassPathElement resettableElement) {
            this.resettableElement = resettableElement;
            return this;
        }

        public Builder addParentFirstElement(ClassPathElement element) {
            log.debugf("Adding parent first element %s to QuarkusClassLoader %s", (Object)element, (Object)this.name);
            this.parentFirstElements.add(element);
            return this;
        }

        public Builder addBannedElement(ClassPathElement element) {
            this.bannedElements.add(element);
            return this;
        }

        public Builder addLesserPriorityElement(ClassPathElement element) {
            this.lesserPriorityElements.add(element);
            return this;
        }

        public Builder setAggregateParentResources(boolean aggregateParentResources) {
            this.aggregateParentResources = aggregateParentResources;
            return this;
        }

        public Builder setAssertionsEnabled(boolean assertionsEnabled) {
            this.assertionsEnabled = assertionsEnabled;
            return this;
        }

        public Builder setTransformedClasses(Map<String, byte[]> transformedClasses) {
            this.transformedClasses = transformedClasses;
            return this;
        }

        public Builder addClassLoaderEventListeners(List<ClassLoaderEventListener> classLoadListeners) {
            this.classLoaderEventListeners.addAll(classLoadListeners);
            return this;
        }

        public QuarkusClassLoader build() {
            if (this.resettableElement != null && !this.elements.contains(this.resettableElement)) {
                this.elements.add(0, this.resettableElement);
            }
            this.classLoaderEventListeners.trimToSize();
            return new QuarkusClassLoader(this);
        }
    }
}

