/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.AppArtifact;
import java.io.Serializable;
import java.util.Objects;

public class AppDependency
implements Serializable {
    public static final int OPTIONAL_FLAG = 1;
    public static final int DIRECT_FLAG = 2;
    public static final int RUNTIME_CP_FLAG = 4;
    public static final int DEPLOYMENT_CP_FLAG = 8;
    public static final int RUNTIME_EXTENSION_ARTIFACT_FLAG = 16;
    private final AppArtifact artifact;
    private final String scope;
    private final int flags;

    public AppDependency(AppArtifact artifact, String scope, int ... flags) {
        this(artifact, scope, false, flags);
    }

    public AppDependency(AppArtifact artifact, String scope, boolean optional, int ... flags) {
        this.artifact = artifact;
        this.scope = scope;
        int tmpFlags = optional ? 1 : 0;
        for (int f : flags) {
            tmpFlags |= f;
        }
        this.flags = tmpFlags;
    }

    public AppArtifact getArtifact() {
        return this.artifact;
    }

    public String getScope() {
        return this.scope;
    }

    public boolean isOptional() {
        return this.isFlagSet(1);
    }

    public boolean isDirect() {
        return this.isFlagSet(2);
    }

    public boolean isRuntimeExtensionArtifact() {
        return this.isFlagSet(16);
    }

    public boolean isRuntimeCp() {
        return this.isFlagSet(4);
    }

    public boolean isDeploymentCp() {
        return this.isFlagSet(8);
    }

    public boolean isFlagSet(int flag) {
        return (this.flags & flag) > 0;
    }

    public int getFlags() {
        return this.flags;
    }

    public int hashCode() {
        return Objects.hash(this.artifact, this.flags, this.scope);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AppDependency other = (AppDependency)obj;
        return Objects.equals(this.artifact, other.artifact) && this.flags == other.flags && Objects.equals(this.scope, other.scope);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.artifact.append(buf).append('(');
        if (this.isDirect()) {
            buf.append("direct ");
        }
        if (this.isOptional()) {
            buf.append("optional ");
        }
        if (this.isRuntimeExtensionArtifact()) {
            buf.append("extension ");
        }
        if (this.isRuntimeCp()) {
            buf.append("runtime-cp ");
        }
        if (this.isDeploymentCp()) {
            buf.append("deployment-cp ");
        }
        return buf.append(this.scope).append(')').toString();
    }
}

