/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.ConfigPropertyBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanConfigurator;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.arc.runtime.ConfigBeanCreator;
import io.quarkus.arc.runtime.ConfigMappingCreator;
import io.quarkus.arc.runtime.ConfigRecorder;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ConfigClassBuildItem;
import io.quarkus.deployment.builditem.ConfigurationBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.configuration.ConfigMappingUtils;
import io.quarkus.deployment.configuration.definition.RootDefinition;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.inject.ConfigProducer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.CreationException;
import org.eclipse.microprofile.config.ConfigValue;
import org.eclipse.microprofile.config.inject.ConfigProperties;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class ConfigBuildStep {
    private static final DotName MP_CONFIG_PROPERTY_NAME = DotName.createSimple((String)ConfigProperty.class.getName());
    private static final DotName MP_CONFIG_PROPERTIES_NAME = DotName.createSimple((String)ConfigProperties.class.getName());
    private static final DotName MP_CONFIG_VALUE_NAME = DotName.createSimple((String)ConfigValue.class.getName());
    private static final DotName MAP_NAME = DotName.createSimple((String)Map.class.getName());
    private static final DotName SET_NAME = DotName.createSimple((String)Set.class.getName());
    private static final DotName LIST_NAME = DotName.createSimple((String)List.class.getName());
    private static final DotName SUPPLIER_NAME = DotName.createSimple((String)Supplier.class.getName());
    private static final DotName CONFIG_VALUE_NAME = DotName.createSimple((String)io.smallrye.config.ConfigValue.class.getName());
    public static final AnnotationInstance[] EMPTY_ANNOTATION_INSTANCES = new AnnotationInstance[0];

    @BuildStep
    void additionalBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(ConfigProducer.class));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(ConfigProperties.class));
    }

    @BuildStep
    void analyzeConfigPropertyInjectionPoints(BeanDiscoveryFinishedBuildItem beanDiscovery, BuildProducer<ConfigPropertyBuildItem> configProperties, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        HashSet<Type> customBeanTypes = new HashSet<Type>();
        for (InjectionPointInfo injectionPoint : beanDiscovery.getInjectionPoints()) {
            String propertyName;
            AnnotationInstance configProperty;
            if (injectionPoint.hasDefaultedQualifier() || (configProperty = injectionPoint.getRequiredQualifier(MP_CONFIG_PROPERTY_NAME)) == null) continue;
            AnnotationValue nameValue = configProperty.value("name");
            AnnotationValue defaultValue = configProperty.value("defaultValue");
            if (nameValue != null) {
                propertyName = nameValue.asString();
            } else if (injectionPoint.isField()) {
                FieldInfo field = injectionPoint.getTarget().asField();
                propertyName = this.getPropertyName(field.name(), field.declaringClass());
            } else if (injectionPoint.isParam()) {
                MethodInfo method = injectionPoint.getTarget().asMethod();
                propertyName = this.getPropertyName(method.parameterName(injectionPoint.getPosition()), method.declaringClass());
            } else {
                throw new IllegalStateException("Unsupported injection point target: " + injectionPoint);
            }
            Type injectedType = injectionPoint.getType();
            if (!ConfigBuildStep.isHandledByProducers(injectedType)) {
                customBeanTypes.add(injectedType);
            }
            if (DotNames.OPTIONAL.equals((Object)injectedType.name()) || DotNames.OPTIONAL_INT.equals((Object)injectedType.name()) || DotNames.OPTIONAL_LONG.equals((Object)injectedType.name()) || DotNames.OPTIONAL_DOUBLE.equals((Object)injectedType.name()) || DotNames.PROVIDER.equals((Object)injectedType.name()) || SUPPLIER_NAME.equals((Object)injectedType.name()) || CONFIG_VALUE_NAME.equals((Object)injectedType.name()) || MP_CONFIG_VALUE_NAME.equals((Object)injectedType.name())) continue;
            String propertyDefaultValue = null;
            if (defaultValue != null && ("org.eclipse.microprofile.config.configproperty.unconfigureddvalue".equals(defaultValue.asString()) || !"".equals(defaultValue.asString()))) {
                propertyDefaultValue = defaultValue.asString();
            }
            configProperties.produce((BuildItem)new ConfigPropertyBuildItem(propertyName, injectedType, propertyDefaultValue));
        }
        for (Type type : customBeanTypes) {
            if (type.kind() != Type.Kind.ARRAY) {
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{type.name().toString()}));
            }
            DotName implClazz = type.kind() == Type.Kind.ARRAY ? DotName.createSimple((String)ConfigBeanCreator.class.getName()) : type.name();
            syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(implClazz).creator(ConfigBeanCreator.class)).providerType(type)).types(new Type[]{type})).addQualifier(MP_CONFIG_PROPERTY_NAME)).param("requiredType", type.name().toString())).done());
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void validateConfigProperties(ConfigRecorder recorder, List<ConfigPropertyBuildItem> configProperties, BeanContainerBuildItem beanContainer, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        for (ConfigPropertyBuildItem item : configProperties) {
            Type requiredType = item.getPropertyType();
            String propertyType = requiredType.name().toString();
            if (requiredType.kind() == Type.Kind.PRIMITIVE) continue;
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{propertyType}));
        }
        HashSet<ConfigRecorder.ConfigValidationMetadata> propertiesToValidate = new HashSet<ConfigRecorder.ConfigValidationMetadata>();
        for (ConfigPropertyBuildItem configProperty : configProperties) {
            String rawTypeName = configProperty.getPropertyType().name().toString();
            List actualTypeArgumentNames = Collections.emptyList();
            if (configProperty.getPropertyType().kind() == Type.Kind.PARAMETERIZED_TYPE) {
                List argumentTypes = configProperty.getPropertyType().asParameterizedType().arguments();
                actualTypeArgumentNames = new ArrayList(argumentTypes.size());
                for (Type argumentType : argumentTypes) {
                    actualTypeArgumentNames.add(argumentType.name().toString());
                    if (argumentType.kind() == Type.Kind.PRIMITIVE) continue;
                    reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{argumentType.name().toString()}));
                }
            }
            propertiesToValidate.add(new ConfigRecorder.ConfigValidationMetadata(configProperty.getPropertyName(), rawTypeName, actualTypeArgumentNames, configProperty.getDefaultValue()));
        }
        recorder.validateConfigProperties(propertiesToValidate);
    }

    @BuildStep
    void registerConfigRootsAsBeans(ConfigurationBuildItem configItem, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        for (RootDefinition rootDefinition : configItem.getReadResult().getAllRoots()) {
            if (rootDefinition.getConfigPhase() != ConfigPhase.BUILD_AND_RUN_TIME_FIXED && rootDefinition.getConfigPhase() != ConfigPhase.RUN_TIME) continue;
            Class configRootClass = rootDefinition.getConfigurationClass();
            syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(configRootClass).types(new Class[]{configRootClass})).scope(Dependent.class)).creator(mc -> {
                ResultHandle configRoot = mc.readStaticField(rootDefinition.getDescriptor());
                mc.ifNull(configRoot).trueBranch().throwException(CreationException.class, String.format("Config root [%s] with config phase [%s] not initialized yet.", configRootClass.getName(), rootDefinition.getConfigPhase().name()));
                mc.returnValue(configRoot);
            })).done());
        }
    }

    @BuildStep
    AnnotationsTransformerBuildItem vetoMPConfigProperties() {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return AnnotationTarget.Kind.CLASS.equals((Object)kind);
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                if (context.getAnnotations().stream().anyMatch(annotation -> annotation.name().equals((Object)MP_CONFIG_PROPERTIES_NAME))) {
                    ((Transformation)((Transformation)context.transform().add(DotNames.VETOED, new AnnotationValue[0])).add(DotNames.UNREMOVABLE, new AnnotationValue[0])).done();
                }
            }
        });
    }

    @BuildStep
    void generateConfigClasses(CombinedIndexBuildItem combinedIndex, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ConfigClassBuildItem> configClasses) {
        ConfigMappingUtils.generateConfigClasses((CombinedIndexBuildItem)combinedIndex, generatedClasses, reflectiveClasses, configClasses, (DotName)ConfigMappingUtils.CONFIG_MAPPING_NAME);
        ConfigMappingUtils.generateConfigClasses((CombinedIndexBuildItem)combinedIndex, generatedClasses, reflectiveClasses, configClasses, (DotName)MP_CONFIG_PROPERTIES_NAME);
    }

    @BuildStep
    void beanConfigClasses(List<ConfigClassBuildItem> configClasses, BeanRegistrationPhaseBuildItem beanRegistrationPhase, CombinedIndexBuildItem combinedIndex, BuildProducer<BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem> beanConfigurationRegistry) {
        for (ConfigClassBuildItem configClass : configClasses) {
            if (configClass.getGeneratedClasses().isEmpty()) continue;
            ArrayList<AnnotationInstance> qualifiers = new ArrayList<AnnotationInstance>();
            if (configClass.isProperties()) {
                qualifiers.add(AnnotationInstance.create((DotName)MP_CONFIG_PROPERTIES_NAME, null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"prefix", (String)configClass.getPrefix())}));
            }
            this.collectTypes(combinedIndex, configClass);
            beanConfigurationRegistry.produce((BuildItem)new BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)beanRegistrationPhase.getContext().configure(configClass.getConfigClass()).types(this.collectTypes(combinedIndex, configClass))).qualifiers(qualifiers.toArray(EMPTY_ANNOTATION_INSTANCES))).creator(ConfigMappingCreator.class)).param("type", configClass.getConfigClass())).param("prefix", configClass.getPrefix())));
        }
    }

    private Type[] collectTypes(CombinedIndexBuildItem combinedIndex, ConfigClassBuildItem configClass) {
        DotName configIfaceName;
        IndexView index = combinedIndex.getIndex();
        ClassInfo configIfaceInfo = index.getClassByName(configIfaceName = DotName.createSimple((String)configClass.getConfigClass().getName()));
        if (configIfaceInfo == null || configIfaceInfo.interfaceNames().isEmpty()) {
            return new Type[]{Type.create((DotName)configIfaceName, (Type.Kind)Type.Kind.CLASS)};
        }
        HashSet<DotName> allIfaces = new HashSet<DotName>();
        allIfaces.add(configIfaceName);
        ConfigBuildStep.collectInterfacesRec(configIfaceInfo, index, allIfaces);
        Type[] result = new Type[allIfaces.size()];
        int i = 0;
        for (DotName iface : allIfaces) {
            result[i++] = Type.create((DotName)iface, (Type.Kind)Type.Kind.CLASS);
        }
        return result;
    }

    private static void collectInterfacesRec(ClassInfo current, IndexView index, Set<DotName> result) {
        List interfaces = current.interfaceNames();
        if (interfaces.isEmpty()) {
            return;
        }
        for (DotName iface : interfaces) {
            ClassInfo classByName = index.getClassByName(iface);
            if (classByName == null) continue;
            result.add(iface);
            ConfigBuildStep.collectInterfacesRec(classByName, index, result);
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void registerConfigClasses(RecorderContext context, ConfigRecorder recorder, List<ConfigClassBuildItem> configClasses) throws Exception {
        context.registerNonDefaultConstructor(ConfigMappings.ConfigClassWithPrefix.class.getDeclaredConstructor(Class.class, String.class), configClassWithPrefix -> Stream.of(configClassWithPrefix.getKlass(), configClassWithPrefix.getPrefix()).collect(Collectors.toList()));
        recorder.registerConfigProperties(configClasses.stream().filter(ConfigClassBuildItem::isProperties).map(configProperties -> ConfigMappings.ConfigClassWithPrefix.configClassWithPrefix((Class)configProperties.getConfigClass(), (String)configProperties.getPrefix())).collect(Collectors.toSet()));
    }

    private String getPropertyName(String name, ClassInfo declaringClass) {
        StringBuilder builder = new StringBuilder();
        if (declaringClass.enclosingClass() == null) {
            builder.append(declaringClass.name());
        } else {
            builder.append(declaringClass.enclosingClass()).append(".").append(declaringClass.simpleName());
        }
        return builder.append(".").append(name).toString();
    }

    public static boolean isHandledByProducers(Type type) {
        if (type.kind() == Type.Kind.ARRAY) {
            return false;
        }
        if (type.kind() == Type.Kind.PRIMITIVE) {
            return true;
        }
        return DotNames.STRING.equals((Object)type.name()) || DotNames.OPTIONAL.equals((Object)type.name()) || DotNames.OPTIONAL_INT.equals((Object)type.name()) || DotNames.OPTIONAL_LONG.equals((Object)type.name()) || DotNames.OPTIONAL_DOUBLE.equals((Object)type.name()) || MAP_NAME.equals((Object)type.name()) || SET_NAME.equals((Object)type.name()) || LIST_NAME.equals((Object)type.name()) || DotNames.LONG.equals((Object)type.name()) || DotNames.FLOAT.equals((Object)type.name()) || DotNames.INTEGER.equals((Object)type.name()) || DotNames.BOOLEAN.equals((Object)type.name()) || DotNames.DOUBLE.equals((Object)type.name()) || DotNames.SHORT.equals((Object)type.name()) || DotNames.BYTE.equals((Object)type.name()) || DotNames.CHARACTER.equals((Object)type.name()) || SUPPLIER_NAME.equals((Object)type.name()) || CONFIG_VALUE_NAME.equals((Object)type.name()) || MP_CONFIG_VALUE_NAME.equals((Object)type.name());
    }
}

