/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanRegistrarBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.ConfigPropertyBuildItem;
import io.quarkus.arc.processor.BeanConfigurator;
import io.quarkus.arc.processor.BeanRegistrar;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.runtime.ConfigBeanCreator;
import io.quarkus.arc.runtime.ConfigRecorder;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ConfigurationBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.configuration.definition.RootDefinition;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.smallrye.config.inject.ConfigProducer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.CreationException;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class ConfigBuildStep {
    private static final DotName CONFIG_PROPERTY_NAME = DotName.createSimple((String)ConfigProperty.class.getName());
    private static final DotName SET_NAME = DotName.createSimple((String)Set.class.getName());
    private static final DotName LIST_NAME = DotName.createSimple((String)List.class.getName());

    @BuildStep
    AdditionalBeanBuildItem bean() {
        return new AdditionalBeanBuildItem(ConfigProducer.class);
    }

    @BuildStep
    void analyzeConfigPropertyInjectionPoints(BeanRegistrationPhaseBuildItem beanRegistrationPhase, BuildProducer<ConfigPropertyBuildItem> configProperties, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem> beanConfigurators) {
        HashSet<Type> customBeanTypes = new HashSet<Type>();
        for (InjectionPointInfo injectionPoint : (Collection)beanRegistrationPhase.getContext().get(BuildExtension.Key.INJECTION_POINTS)) {
            String propertyName;
            AnnotationInstance configProperty;
            if (injectionPoint.hasDefaultedQualifier() || (configProperty = injectionPoint.getRequiredQualifier(CONFIG_PROPERTY_NAME)) == null) continue;
            AnnotationValue nameValue = configProperty.value("name");
            AnnotationValue defaultValue = configProperty.value("defaultValue");
            if (nameValue != null) {
                propertyName = nameValue.asString();
            } else if (injectionPoint.isField()) {
                FieldInfo field = injectionPoint.getTarget().asField();
                propertyName = this.getPropertyName(field.name(), field.declaringClass());
            } else if (injectionPoint.isParam()) {
                MethodInfo method = injectionPoint.getTarget().asMethod();
                propertyName = this.getPropertyName(method.parameterName(injectionPoint.getPosition()), method.declaringClass());
            } else {
                throw new IllegalStateException("Unsupported injection point target: " + injectionPoint);
            }
            Type requiredType = injectionPoint.getRequiredType();
            if (!this.isHandledByProducers(requiredType)) {
                customBeanTypes.add(requiredType);
            }
            if (DotNames.OPTIONAL.equals((Object)requiredType.name()) || defaultValue != null && !"org.eclipse.microprofile.config.configproperty.unconfigureddvalue".equals(defaultValue.asString())) continue;
            configProperties.produce((BuildItem)new ConfigPropertyBuildItem(propertyName, requiredType));
        }
        for (Type type : customBeanTypes) {
            if (type.kind() != Type.Kind.ARRAY) {
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{type.name().toString()}));
            }
            beanConfigurators.produce((BuildItem)new BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)beanRegistrationPhase.getContext().configure(type.kind() == Type.Kind.ARRAY ? DotName.createSimple((String)ConfigBeanCreator.class.getName()) : type.name()).creator(ConfigBeanCreator.class)).providerType(type)).types(new Type[]{type})).qualifiers(new AnnotationInstance[]{AnnotationInstance.create((DotName)CONFIG_PROPERTY_NAME, null, Collections.emptyList())})).param("requiredType", type.name().toString())));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void validateConfigProperties(ConfigRecorder recorder, List<ConfigPropertyBuildItem> configProperties, BeanContainerBuildItem beanContainer, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        for (ConfigPropertyBuildItem item : configProperties) {
            Type requiredType = item.getPropertyType();
            String propertyType = requiredType.name().toString();
            if (requiredType.kind() == Type.Kind.PRIMITIVE) continue;
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{propertyType}));
        }
        Map propNamesToClasses = configProperties.stream().collect(Collectors.groupingBy(ConfigPropertyBuildItem::getPropertyName, Collectors.mapping(c -> c.getPropertyType().name().toString(), Collectors.toSet())));
        recorder.validateConfigProperties(propNamesToClasses);
    }

    @BuildStep
    BeanRegistrarBuildItem registerConfigRootsAsBeans(final ConfigurationBuildItem configItem) {
        return new BeanRegistrarBuildItem(new BeanRegistrar(){

            public void register(BeanRegistrar.RegistrationContext context) {
                for (RootDefinition rootDefinition : configItem.getReadResult().getAllRoots()) {
                    if (rootDefinition.getConfigPhase() != ConfigPhase.BUILD_AND_RUN_TIME_FIXED && rootDefinition.getConfigPhase() != ConfigPhase.RUN_TIME) continue;
                    Class configRootClass = rootDefinition.getConfigurationClass();
                    ((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)context.configure(configRootClass).types(new Class[]{configRootClass})).scope(Dependent.class)).creator(mc -> {
                        ResultHandle configRoot = mc.readStaticField(rootDefinition.getDescriptor());
                        mc.ifNull(configRoot).trueBranch().throwException(CreationException.class, String.format("Config root [%s] with config phase [%s] not initialized yet.", configRootClass.getName(), rootDefinition.getConfigPhase().name()));
                        mc.returnValue(configRoot);
                    })).done();
                }
            }
        });
    }

    private String getPropertyName(String name, ClassInfo declaringClass) {
        StringBuilder builder = new StringBuilder();
        if (declaringClass.enclosingClass() == null) {
            builder.append(declaringClass.name());
        } else {
            builder.append(declaringClass.enclosingClass()).append(".").append(declaringClass.simpleName());
        }
        return builder.append(".").append(name).toString();
    }

    private boolean isHandledByProducers(Type type) {
        if (type.kind() == Type.Kind.ARRAY) {
            return false;
        }
        if (type.kind() == Type.Kind.PRIMITIVE) {
            return true;
        }
        return DotNames.STRING.equals((Object)type.name()) || DotNames.OPTIONAL.equals((Object)type.name()) || SET_NAME.equals((Object)type.name()) || LIST_NAME.equals((Object)type.name()) || DotNames.LONG.equals((Object)type.name()) || DotNames.FLOAT.equals((Object)type.name()) || DotNames.INTEGER.equals((Object)type.name()) || DotNames.BOOLEAN.equals((Object)type.name()) || DotNames.DOUBLE.equals((Object)type.name()) || DotNames.SHORT.equals((Object)type.name()) || DotNames.BYTE.equals((Object)type.name()) || DotNames.CHARACTER.equals((Object)type.name());
    }
}

