/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.MemoryOrder;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.StackMapBuilder;
import io.quarkus.gizmo2.impl.constant.VarHandleConst;
import io.smallrye.classfile.CodeBuilder;
import io.smallrye.common.constraint.Assert;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.util.ListIterator;
import java.util.function.BiConsumer;

abstract class ReadModifyWrite
extends Item {
    private final String op;
    private final Item value;
    private final MemoryOrder mode;
    private final VarHandleConst handle;
    private final MethodTypeDesc opDesc;

    protected ReadModifyWrite(ClassDesc type, GenericType genericType, String op, Item value, MemoryOrder mode, VarHandleConst handle, MethodTypeDesc opDesc) {
        super(type, genericType);
        this.op = op;
        this.value = value;
        this.mode = mode;
        this.handle = handle;
        this.opDesc = opDesc;
    }

    @Override
    protected void forEachDependency(ListIterator<Item> itr, BiConsumer<Item, ListIterator<Item>> op) {
        this.value.process(itr, op);
        this.forEachCoordinateDependency(itr, op);
        this.handle.process(itr, op);
    }

    protected void forEachCoordinateDependency(ListIterator<Item> itr, BiConsumer<Item, ListIterator<Item>> op) {
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block, StackMapBuilder smb) {
        cb.invokevirtual(ConstantDescs.CD_VarHandle, switch (this.mode) {
            case MemoryOrder.Volatile -> "getAnd" + this.op;
            case MemoryOrder.Acquire -> "getAnd" + this.op + "Acquire";
            case MemoryOrder.Release -> "getAnd" + this.op + "Release";
            default -> throw Assert.impossibleSwitchCase((Object)((Object)this.mode));
        }, this.opDesc);
        smb.pop();
        this.popCoordinates(smb);
        smb.pop();
        smb.push(this.type());
        smb.wroteCode();
    }

    protected void popCoordinates(StackMapBuilder smb) {
    }
}

