/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.GenericTypes;
import io.quarkus.gizmo2.InvokeKind;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.MemoryOrder;
import io.quarkus.gizmo2.TypeKind;
import io.quarkus.gizmo2.Var;
import io.quarkus.gizmo2.creator.AnonymousClassCreator;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ConstructorCreator;
import io.quarkus.gizmo2.creator.LambdaCreator;
import io.quarkus.gizmo2.creator.StaticMethodCreator;
import io.quarkus.gizmo2.creator.SwitchCreator;
import io.quarkus.gizmo2.creator.TryCreator;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.Descs;
import io.quarkus.gizmo2.desc.InterfaceMethodDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.gizmo2.impl.AnonymousClassCreatorImpl;
import io.quarkus.gizmo2.impl.ArrayStore;
import io.quarkus.gizmo2.impl.AssignableImpl;
import io.quarkus.gizmo2.impl.BinOp;
import io.quarkus.gizmo2.impl.BlockHeader;
import io.quarkus.gizmo2.impl.Box;
import io.quarkus.gizmo2.impl.Break;
import io.quarkus.gizmo2.impl.CheckCast;
import io.quarkus.gizmo2.impl.ClassSwitchCreatorImpl;
import io.quarkus.gizmo2.impl.Cmp;
import io.quarkus.gizmo2.impl.Conversions;
import io.quarkus.gizmo2.impl.Dup;
import io.quarkus.gizmo2.impl.EnumSwitchCreatorImpl;
import io.quarkus.gizmo2.impl.GotoCase;
import io.quarkus.gizmo2.impl.GotoDefault;
import io.quarkus.gizmo2.impl.GotoStart;
import io.quarkus.gizmo2.impl.If;
import io.quarkus.gizmo2.impl.IfRel;
import io.quarkus.gizmo2.impl.IfZero;
import io.quarkus.gizmo2.impl.InstanceMethodCreatorImpl;
import io.quarkus.gizmo2.impl.InstanceOf;
import io.quarkus.gizmo2.impl.IntSwitchCreatorImpl;
import io.quarkus.gizmo2.impl.Invoke;
import io.quarkus.gizmo2.impl.InvokeDynamic;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.LambdaAsAnonClassCreatorImpl;
import io.quarkus.gizmo2.impl.LambdaAsMethodCreatorImpl;
import io.quarkus.gizmo2.impl.LineNumber;
import io.quarkus.gizmo2.impl.LocalVarImpl;
import io.quarkus.gizmo2.impl.LongSwitchCreatorImpl;
import io.quarkus.gizmo2.impl.MethodCreatorImpl;
import io.quarkus.gizmo2.impl.MonitorEnter;
import io.quarkus.gizmo2.impl.MonitorExit;
import io.quarkus.gizmo2.impl.Neg;
import io.quarkus.gizmo2.impl.New;
import io.quarkus.gizmo2.impl.NewArrayResult;
import io.quarkus.gizmo2.impl.NewEmptyArray;
import io.quarkus.gizmo2.impl.NewResult;
import io.quarkus.gizmo2.impl.Preconditions;
import io.quarkus.gizmo2.impl.PrimitiveCast;
import io.quarkus.gizmo2.impl.Rel;
import io.quarkus.gizmo2.impl.RelZero;
import io.quarkus.gizmo2.impl.Return;
import io.quarkus.gizmo2.impl.StackMapBuilder;
import io.quarkus.gizmo2.impl.StringSwitchCreatorImpl;
import io.quarkus.gizmo2.impl.SwitchCreatorImpl;
import io.quarkus.gizmo2.impl.ThisExpr;
import io.quarkus.gizmo2.impl.Throw;
import io.quarkus.gizmo2.impl.TryCreatorImpl;
import io.quarkus.gizmo2.impl.TryFinally;
import io.quarkus.gizmo2.impl.TypeCreatorImpl;
import io.quarkus.gizmo2.impl.Unbox;
import io.quarkus.gizmo2.impl.UncheckedCast;
import io.quarkus.gizmo2.impl.Util;
import io.quarkus.gizmo2.impl.Yield;
import io.quarkus.gizmo2.impl.constant.ConstImpl;
import io.quarkus.gizmo2.impl.constant.IntConst;
import io.quarkus.gizmo2.impl.constant.NullConst;
import io.smallrye.classfile.ClassBuilder;
import io.smallrye.classfile.ClassFile;
import io.smallrye.classfile.ClassFileElement;
import io.smallrye.classfile.ClassModel;
import io.smallrye.classfile.CodeBuilder;
import io.smallrye.classfile.Label;
import io.smallrye.classfile.MethodModel;
import io.smallrye.classfile.Opcode;
import io.smallrye.classfile.TypeAnnotation;
import io.smallrye.classfile.attribute.InnerClassInfo;
import io.smallrye.classfile.attribute.InnerClassesAttribute;
import io.smallrye.classfile.attribute.NestHostAttribute;
import io.smallrye.common.constraint.Assert;
import java.lang.annotation.RetentionPolicy;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.DynamicCallSiteDesc;
import java.lang.constant.MethodHandleDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public final class BlockCreatorImpl
extends Item
implements BlockCreator {
    private static final int ST_ACTIVE = 0;
    private static final int ST_NESTED = 1;
    private static final int ST_DONE = 2;
    private final TypeCreatorImpl owner;
    private final CodeBuilder outerCodeBuilder;
    private final BlockCreatorImpl parent;
    private final int depth;
    private final String methodNameForLambdas;
    private final ArrayList<Item> items = new ArrayList(40);
    private boolean breakTarget;
    private boolean branchTarget;
    TryFinally tryFinally;
    private int state;
    private final Label startLabel;
    private final Label endLabel;
    private final Item input;
    private final ClassDesc outputType;
    private final ClassDesc returnType;
    private Consumer<BlockCreator> loopAction;
    private String nestSite;
    private String finishSite;
    private List<Consumer<BlockCreator>> postInits;

    BlockCreatorImpl(TypeCreatorImpl owner, CodeBuilder outerCodeBuilder, ClassDesc returnType, String methodNameForLambdas) {
        this(owner, outerCodeBuilder, null, ConstantDescs.CD_void, ConstImpl.ofVoid(), ConstantDescs.CD_void, returnType, methodNameForLambdas);
    }

    BlockCreatorImpl(BlockCreatorImpl parent) {
        this(parent, ConstImpl.ofVoid(), ConstantDescs.CD_void);
    }

    BlockCreatorImpl(BlockCreatorImpl parent, ClassDesc inputType) {
        this(parent.owner, parent.outerCodeBuilder, parent, inputType, ConstImpl.ofVoid(), ConstantDescs.CD_void, parent.returnType, parent.methodNameForLambdas);
    }

    BlockCreatorImpl(BlockCreatorImpl parent, Item input, ClassDesc outputType) {
        this(parent.owner, parent.outerCodeBuilder, parent, input.type(), input, outputType, parent.returnType, parent.methodNameForLambdas);
    }

    BlockCreatorImpl(BlockCreatorImpl parent, ClassDesc inputType, ClassDesc outputType) {
        this(parent.owner, parent.outerCodeBuilder, parent, inputType, ConstImpl.ofVoid(), outputType, parent.returnType, parent.methodNameForLambdas);
    }

    private BlockCreatorImpl(TypeCreatorImpl owner, CodeBuilder outerCodeBuilder, BlockCreatorImpl parent, ClassDesc inputType, Item input, ClassDesc outputType, ClassDesc returnType, String methodNameForLambdas) {
        this.outerCodeBuilder = outerCodeBuilder;
        this.parent = parent;
        this.owner = owner;
        this.depth = parent == null ? 0 : parent.depth + 1;
        this.methodNameForLambdas = methodNameForLambdas;
        this.postInits = parent == null ? List.of() : parent.postInits;
        this.startLabel = this.newLabel();
        this.endLabel = this.newLabel();
        this.input = input;
        if (Util.isVoid(inputType)) {
            this.items.add(BlockHeader.VOID);
        } else {
            this.items.add(new BlockHeader(inputType));
        }
        this.outputType = outputType;
        this.returnType = returnType;
    }

    BlockCreatorImpl parent() {
        return this.parent;
    }

    TryFinally tryFinally() {
        BlockCreatorImpl current = this;
        while (current != null) {
            if (current.tryFinally != null) {
                return current.tryFinally;
            }
            current = current.parent;
        }
        return null;
    }

    Label newLabel() {
        return this.outerCodeBuilder.newLabel();
    }

    ClassDesc returnType() {
        return this.returnType;
    }

    public void breakTarget() {
        this.breakTarget = true;
    }

    public void branchTarget() {
        this.branchTarget = true;
    }

    @Override
    protected void computeType() {
        this.initType(this.outputType);
    }

    @Override
    public boolean active() {
        return this.state == 0;
    }

    @Override
    public boolean done() {
        return this.state == 2;
    }

    @Override
    public boolean mayFallThrough() {
        if (this.active()) {
            // empty if block
        }
        return this.breakTarget || this.getLast().mayFallThrough();
    }

    @Override
    public void pop(ListIterator<Item> itr) {
        Yield yield;
        if (this.isVoid()) {
            super.pop(itr);
            return;
        }
        assert (this.mayFallThrough());
        if (this.breakTarget) {
            super.pop(itr);
            return;
        }
        Item tailItem = this.getLast();
        if (tailItem instanceof Yield && !(yield = (Yield)tailItem).value().isVoid()) {
            ListIterator<Item> subItr = this.iterator();
            tailItem.revoke(subItr);
            this.addItemUnchecked(Yield.YIELD_VOID, subItr);
        } else {
            super.pop(itr);
        }
    }

    private void markDone() {
        this.state = 2;
        this.finishSite = Util.trackCaller();
    }

    @Override
    public boolean isContainedBy(BlockCreator other) {
        return this == other || this.parent != null && this.parent.isContainedBy(other);
    }

    @Override
    public LocalVar localVar(String name, ClassDesc type, Expr value) {
        return this.localVar0(new LocalVarImpl(this, name, type, null), value);
    }

    @Override
    public LocalVar localVar(String name, GenericType type, Expr value) {
        return this.localVar0(new LocalVarImpl(this, name, null, type), value);
    }

    private LocalVar localVar0(LocalVarImpl lv, Expr value) {
        this.addItem(lv.allocator());
        this.set((Assignable)lv, value);
        return lv;
    }

    @Override
    public Expr get(Assignable var, MemoryOrder mode) {
        return this.addItem(((AssignableImpl)var).emitGet(this, mode));
    }

    @Override
    public void set(Assignable var, Expr value, MemoryOrder mode) {
        Item newValue = Conversions.convert(value, var.type());
        this.addItem(((AssignableImpl)var).emitSet(this, newValue, mode));
    }

    @Override
    public void andAssign(Assignable var, Expr arg) {
        this.set(var, this.and((Expr)var, arg));
    }

    @Override
    public void orAssign(Assignable var, Expr arg) {
        this.set(var, this.or((Expr)var, arg));
    }

    @Override
    public void xorAssign(Assignable var, Expr arg) {
        this.set(var, this.xor((Expr)var, arg));
    }

    @Override
    public void shlAssign(Assignable var, Expr arg) {
        this.set(var, this.shl((Expr)var, arg));
    }

    @Override
    public void shrAssign(Assignable var, Expr arg) {
        this.set(var, this.shr((Expr)var, arg));
    }

    @Override
    public void ushrAssign(Assignable var, Expr arg) {
        this.set(var, this.ushr((Expr)var, arg));
    }

    @Override
    public void addAssign(Assignable var, Expr arg) {
        if (arg instanceof Const) {
            Const c = (Const)arg;
            this.inc(var, c);
        } else {
            this.set(var, this.add((Expr)var, arg));
        }
    }

    @Override
    public void subAssign(Assignable var, Expr arg) {
        if (arg instanceof Const) {
            Const c = (Const)arg;
            this.dec(var, c);
        } else {
            this.set(var, this.sub((Expr)var, arg));
        }
    }

    @Override
    public void mulAssign(Assignable var, Expr arg) {
        this.set(var, this.mul((Expr)var, arg));
    }

    @Override
    public void divAssign(Assignable var, Expr arg) {
        this.set(var, this.div((Expr)var, arg));
    }

    @Override
    public void remAssign(Assignable var, Expr arg) {
        this.set(var, this.rem((Expr)var, arg));
    }

    @Override
    public Expr box(Expr a) {
        if (Conversions.isPrimitiveWrapper(a.type())) {
            return a;
        }
        return this.addItem(new Box(a));
    }

    @Override
    public Expr unbox(Expr a) {
        if (Conversions.isPrimitive(a.type())) {
            return a;
        }
        return this.addItem(new Unbox(a));
    }

    @Override
    public Expr switchEnum(ClassDesc outputType, Expr enumExpr, Consumer<SwitchCreator> builder) {
        EnumSwitchCreatorImpl sci = new EnumSwitchCreatorImpl(this, enumExpr, outputType);
        sci.accept(builder);
        this.addItem(sci);
        return sci;
    }

    @Override
    public Expr switch_(ClassDesc outputType, Expr expr, Consumer<SwitchCreator> builder) {
        SwitchCreatorImpl sci = switch (expr.type().descriptorString()) {
            case "I", "S", "B", "Z", "C" -> new IntSwitchCreatorImpl(this, expr, outputType);
            case "J" -> new LongSwitchCreatorImpl(this, expr, outputType);
            case "Ljava/lang/String;" -> new StringSwitchCreatorImpl(this, expr, outputType);
            case "Ljava/lang/Class;" -> new ClassSwitchCreatorImpl(this, expr, outputType);
            default -> throw new UnsupportedOperationException("Switch type " + String.valueOf(expr.type()) + " not supported");
        };
        sci.accept(builder);
        this.addItem(sci);
        return sci;
    }

    @Override
    public void gotoCase(SwitchCreator switch_, Const case_) {
        SwitchCreatorImpl sci = (SwitchCreatorImpl)switch_;
        if (!sci.contains(this)) {
            throw new IllegalArgumentException("The given switch statement does not enclose this block");
        }
        this.addItem(new GotoCase(switch_, case_));
    }

    @Override
    public void gotoDefault(SwitchCreator switch_) {
        this.addItem(new GotoDefault(switch_));
    }

    @Override
    public Expr iterate(Expr items) {
        return this.invokeInterface(Descs.MD_Iterable.iterator, items);
    }

    @Override
    public Expr currentThread() {
        return this.invokeStatic(Descs.MD_Thread.currentThread);
    }

    @Override
    public void close(Expr closeable) {
        this.invokeInterface(Descs.MD_AutoCloseable.close, closeable);
    }

    @Override
    public void inc(Assignable var, Const amount) {
        ((AssignableImpl)var).emitInc(this, amount);
    }

    @Override
    public void dec(Assignable var, Const amount) {
        ((AssignableImpl)var).emitDec(this, amount);
    }

    @Override
    public Expr compareAndExchange(Assignable var, Expr expected, Expr update, MemoryOrder order) {
        return this.addItem(((AssignableImpl)var).emitCompareAndExchange(this, (Item)expected, (Item)update, order));
    }

    @Override
    public Expr getAndSet(Assignable var, Expr newValue, MemoryOrder order) {
        return this.addItem(((AssignableImpl)var).emitReadModifyWrite(this, "Set", (Item)newValue, order));
    }

    @Override
    public Expr getAndAdd(Assignable var, Expr amount, MemoryOrder order) {
        return this.addItem(((AssignableImpl)var).emitReadModifyWrite(this, "Add", (Item)amount, order));
    }

    @Override
    public Expr getAndBitwiseOr(Assignable var, Expr other, MemoryOrder order) {
        return this.addItem(((AssignableImpl)var).emitReadModifyWrite(this, "BitwiseOr", (Item)other, order));
    }

    @Override
    public Expr getAndBitwiseAnd(Assignable var, Expr other, MemoryOrder order) {
        return this.addItem(((AssignableImpl)var).emitReadModifyWrite(this, "BitwiseAnd", (Item)other, order));
    }

    @Override
    public Expr getAndBitwiseXor(Assignable var, Expr other, MemoryOrder order) {
        return this.addItem(((AssignableImpl)var).emitReadModifyWrite(this, "BitwiseXor", (Item)other, order));
    }

    @Override
    public Expr compareAndSet(Assignable var, Expr expected, Expr update) {
        return this.addItem(((AssignableImpl)var).emitCompareAndSet(this, (Item)expected, (Item)update, false, MemoryOrder.Volatile));
    }

    @Override
    public Expr weakCompareAndSet(Assignable var, Expr expected, Expr update, MemoryOrder order) {
        return this.addItem(((AssignableImpl)var).emitCompareAndSet(this, (Item)expected, (Item)update, true, order));
    }

    @Override
    public Expr newEmptyArray(ClassDesc componentType, Expr size) {
        return this.addItem(new NewEmptyArray(componentType, (Item)size));
    }

    @Override
    public <T> Expr newArray(ClassDesc componentType, List<T> values, Function<T, ? extends Expr> mapper) {
        this.checkActive();
        int size = values.size();
        NewEmptyArray nea = new NewEmptyArray(componentType, ConstImpl.of(size));
        if (size == 0) {
            return this.addItem(nea);
        }
        ArrayList<ArrayStore> stores = new ArrayList<ArrayStore>(size);
        for (int i = 0; i < size; ++i) {
            Expr mapped = mapper.apply(values.get(i));
            stores.add(new ArrayStore(new Dup(nea), ConstImpl.of(i), (Item)mapped, componentType));
        }
        ListIterator<Item> itr = this.iterator();
        NewArrayResult result = new NewArrayResult(nea, Util.reinterpretCast(stores));
        result.insert(itr);
        for (int i = size - 1; i >= 0; --i) {
            ArrayStore store = (ArrayStore)stores.get(i);
            store.insert(itr);
            store.value().insertIfUnbound(itr);
            store.index().insert(itr);
            store.arrayExpr().insert(itr);
        }
        nea.insert(itr);
        ((Item)nea.length()).insert(itr);
        return result;
    }

    private Expr relZero(Expr a, If.Kind kind) {
        switch (a.typeKind().asLoadable()) {
            case INT: 
            case REFERENCE: {
                return this.addItem(new RelZero(a, kind));
            }
            case LONG: {
                return this.relZero(this.cmp(a, Const.of(0, a.typeKind())), kind);
            }
            case FLOAT: 
            case DOUBLE: {
                return this.relZero(this.cmpg(a, Const.of(0, a.typeKind())), kind);
            }
        }
        throw Assert.impossibleSwitchCase((Object)((Object)a.typeKind().asLoadable()));
    }

    private Expr rel(Expr a, Expr b, If.Kind kind) {
        Optional promotedType;
        ClassDesc operandType = a.type();
        Optional<Object> optional = promotedType = Conversions.numericPromotionRequired(kind, a.type(), b.type()) ? Conversions.numericPromotion(a.type(), b.type()) : Optional.empty();
        if (promotedType.isPresent()) {
            operandType = (ClassDesc)promotedType.get();
            a = Conversions.convert(a, operandType);
            b = Conversions.convert(b, operandType);
        }
        TypeKind typeKind = TypeKind.from(operandType).asLoadable();
        switch (typeKind) {
            case INT: {
                IntConst bc;
                IntConst ac;
                if (a instanceof IntConst && (ac = (IntConst)a).intValue() == 0) {
                    boolean shouldNotInvert = kind == If.Kind.EQ || kind == If.Kind.NE;
                    return this.relZero(b, shouldNotInvert ? kind : kind.invert());
                }
                if (b instanceof IntConst && (bc = (IntConst)b).intValue() == 0) {
                    return this.relZero(a, kind);
                }
                return this.addItem(new Rel(a, b, kind));
            }
            case LONG: {
                return this.relZero(this.cmp(a, b), kind);
            }
            case FLOAT: 
            case DOUBLE: {
                return this.relZero(this.cmpg(a, b), kind);
            }
            case REFERENCE: {
                if (a instanceof NullConst) {
                    return this.relZero(b, kind);
                }
                if (b instanceof NullConst) {
                    return this.relZero(a, kind);
                }
                return this.addItem(new Rel(a, b, kind));
            }
        }
        throw Assert.impossibleSwitchCase((Object)((Object)typeKind));
    }

    @Override
    public Expr eq(Expr a, Expr b) {
        return this.rel(a, b, If.Kind.EQ);
    }

    @Override
    public Expr ne(Expr a, Expr b) {
        return this.rel(a, b, If.Kind.NE);
    }

    @Override
    public Expr lt(Expr a, Expr b) {
        return this.rel(a, b, If.Kind.LT);
    }

    @Override
    public Expr gt(Expr a, Expr b) {
        return this.rel(a, b, If.Kind.GT);
    }

    @Override
    public Expr le(Expr a, Expr b) {
        return this.rel(a, b, If.Kind.LE);
    }

    @Override
    public Expr ge(Expr a, Expr b) {
        return this.rel(a, b, If.Kind.GE);
    }

    @Override
    public Expr cmp(Expr a, Expr b) {
        return this.addItem(new Cmp(a, b, Cmp.Kind.CMP));
    }

    @Override
    public Expr cmpl(Expr a, Expr b) {
        return this.addItem(new Cmp(a, b, Cmp.Kind.CMPL));
    }

    @Override
    public Expr cmpg(Expr a, Expr b) {
        return this.addItem(new Cmp(a, b, Cmp.Kind.CMPG));
    }

    @Override
    public Expr and(Expr a, Expr b) {
        return this.addItem(new BinOp(a, b, BinOp.Kind.AND));
    }

    @Override
    public Expr or(Expr a, Expr b) {
        return this.addItem(new BinOp(a, b, BinOp.Kind.OR));
    }

    @Override
    public Expr xor(Expr a, Expr b) {
        return this.addItem(new BinOp(a, b, BinOp.Kind.XOR));
    }

    @Override
    public Expr complement(Expr a) {
        return this.xor(a, Const.of(-1, a.typeKind()));
    }

    @Override
    public Expr shl(Expr a, Expr b) {
        return this.addItem(new BinOp(a, b, BinOp.Kind.SHL));
    }

    @Override
    public Expr shr(Expr a, Expr b) {
        return this.addItem(new BinOp(a, b, BinOp.Kind.SHR));
    }

    @Override
    public Expr ushr(Expr a, Expr b) {
        return this.addItem(new BinOp(a, b, BinOp.Kind.USHR));
    }

    @Override
    public Expr add(Expr a, Expr b) {
        return this.addItem(new BinOp(a, b, BinOp.Kind.ADD));
    }

    @Override
    public Expr sub(Expr a, Expr b) {
        ConstImpl c;
        if (a instanceof ConstImpl && (c = (ConstImpl)a).isZero()) {
            return this.neg(b);
        }
        return this.addItem(new BinOp(a, b, BinOp.Kind.SUB));
    }

    @Override
    public Expr mul(Expr a, Expr b) {
        return this.addItem(new BinOp(a, b, BinOp.Kind.MUL));
    }

    @Override
    public Expr div(Expr a, Expr b) {
        return this.addItem(new BinOp(a, b, BinOp.Kind.DIV));
    }

    @Override
    public Expr rem(Expr a, Expr b) {
        return this.addItem(new BinOp(a, b, BinOp.Kind.REM));
    }

    @Override
    public Expr neg(Expr a) {
        return this.addItem(new Neg(a));
    }

    @Override
    public Expr lambda(MethodDesc sam, ClassDesc samOwner, Consumer<LambdaCreator> builder) {
        if (this.owner.gizmo.lambdasAsAnonymousClasses()) {
            return this.newAnonymousClass(samOwner, (AnonymousClassCreator acc) -> acc.method(sam, imc -> builder.accept(new LambdaAsAnonClassCreatorImpl((AnonymousClassCreatorImpl)acc, (InstanceMethodCreatorImpl)imc))));
        }
        return this.lambdaDebug(sam, samOwner, builder);
    }

    private Expr lambdaDebug(MethodDesc sam, ClassDesc samOwner, Consumer<LambdaCreator> builder) {
        ConstantDesc samType = sam.type();
        String name = "lambda$" + this.methodNameForLambdas + "$" + this.owner.lambdaAndAnonClassCounter++;
        ArrayList captures = new ArrayList();
        MethodDesc lambdaMethod = this.owner.staticMethod(name, arg_0 -> BlockCreatorImpl.lambda$lambdaDebug$7((MethodTypeDesc)samType, builder, samOwner, captures, arg_0));
        return this.invokeDynamic(DynamicCallSiteDesc.of(ConstantDescs.ofCallsiteBootstrap(Descs.CD_LambdaMetafactory, "metafactory", ConstantDescs.CD_CallSite, ConstantDescs.CD_MethodType, ConstantDescs.CD_MethodHandle, ConstantDescs.CD_MethodType), sam.name(), MethodTypeDesc.of(samOwner, (ClassDesc[])captures.stream().map(Expr::type).toArray(ClassDesc[]::new)), samType, MethodHandleDesc.ofMethod(DirectMethodHandleDesc.Kind.STATIC, lambdaMethod.owner(), lambdaMethod.name(), (MethodTypeDesc)lambdaMethod.type()), samType), captures);
    }

    @Override
    public Expr newAnonymousClass(ConstructorDesc superCtor, List<? extends Expr> args, Consumer<AnonymousClassCreator> builder) {
        ClassDesc ownerDesc = this.owner.type();
        int idx = this.owner.lambdaAndAnonClassCounter++;
        String ds = ownerDesc.descriptorString();
        ClassDesc desc = ClassDesc.ofDescriptor(ds.substring(0, ds.length() - 1) + "$" + idx + ";");
        ClassFile cf = this.owner.gizmo.createClassFile();
        ArrayList captureExprs = new ArrayList();
        byte[] bytes = cf.build(desc, zb -> {
            zb.withVersion(this.owner.version().major(), 0);
            zb.with((ClassFileElement)NestHostAttribute.of((ClassDesc)ownerDesc));
            zb.with((ClassFileElement)InnerClassesAttribute.of((InnerClassInfo[])new InnerClassInfo[]{InnerClassInfo.of((ClassDesc)desc, Optional.of(ownerDesc), Optional.empty(), (int)0)}));
            AnonymousClassCreatorImpl tc = new AnonymousClassCreatorImpl(this.owner.gizmo, desc, this.owner.output(), (ClassBuilder)zb, superCtor, captureExprs);
            tc.preAccept();
            builder.accept(tc);
            tc.freezeCaptures();
            tc.constructor(cc -> tc.ctorSetups().forEach((Consumer<Consumer<ConstructorCreator>>)((Consumer<Consumer>)action -> action.accept(cc))));
            tc.postAccept();
        });
        ClassModel cm = cf.parse(bytes);
        List methods = cm.methods();
        MethodModel ourCtor = (MethodModel)methods.get(methods.size() - 1);
        this.owner.output().write(desc, bytes);
        this.owner.addNestMember(desc);
        return this.new_(ConstructorDesc.of(desc, ourCtor.methodTypeSymbol()), Stream.concat(args.stream(), captureExprs.stream()).toList());
    }

    @Override
    public Expr cast(Expr a, GenericType toGenType) {
        ClassDesc toType = toGenType.desc();
        if (a.type().isPrimitive()) {
            if (toType.isPrimitive()) {
                return this.addItem(new PrimitiveCast(a, toGenType.desc()));
            }
            if (Util.equals(toType, Conversions.boxingConversion(a.type()).orElse(null))) {
                return this.box(a);
            }
            throw new IllegalArgumentException("Cannot cast primitive value of type '" + a.type().displayName() + "' to object type '" + toType.displayName() + "'");
        }
        if (Util.equals(toType, Conversions.unboxingConversion(a.type()).orElse(null))) {
            return this.unbox(a);
        }
        if (toType.isPrimitive()) {
            throw new IllegalArgumentException("Cannot cast object value of type '" + a.type().displayName() + "' to primitive type '" + toType.displayName() + "'");
        }
        return this.addItem(new CheckCast(a, null, toGenType));
    }

    @Override
    public Expr cast(Expr a, ClassDesc toType) {
        if (Util.equals(a.type(), toType)) {
            return a;
        }
        if (a.type().isPrimitive()) {
            if (toType.isPrimitive()) {
                return this.addItem(new PrimitiveCast(a, toType));
            }
            if (Util.equals(toType, Conversions.boxingConversion(a.type()).orElse(null))) {
                return this.box(a);
            }
            throw new IllegalArgumentException("Cannot cast primitive value of type '" + a.type().displayName() + "' to object type '" + toType.displayName() + "'");
        }
        if (Util.equals(toType, Conversions.unboxingConversion(a.type()).orElse(null))) {
            return this.unbox(a);
        }
        if (toType.isPrimitive()) {
            throw new IllegalArgumentException("Cannot cast object value of type '" + a.type().displayName() + "' to primitive type '" + toType.displayName() + "'");
        }
        return this.addItem(new CheckCast(a, toType, null));
    }

    @Override
    public Expr uncheckedCast(Expr a, ClassDesc toType) {
        if (Util.equals(a.type(), toType)) {
            return a;
        }
        if (a.type().isPrimitive()) {
            throw new IllegalArgumentException("Cannot apply unchecked cast to primitive value: " + a.type().displayName());
        }
        if (toType.isPrimitive()) {
            throw new IllegalArgumentException("Cannot apply unchecked cast to primitive type: " + toType.displayName());
        }
        return this.addItem(new UncheckedCast(a, toType, null));
    }

    @Override
    public Expr uncheckedCast(Expr a, GenericType toType) {
        if (a.type().isPrimitive()) {
            throw new IllegalArgumentException("Cannot apply unchecked cast to primitive value: " + a.type().displayName());
        }
        if (toType.desc().isPrimitive()) {
            throw new IllegalArgumentException("Cannot apply unchecked cast to primitive type: " + toType.desc().displayName());
        }
        return this.addItem(new UncheckedCast(a, null, toType));
    }

    @Override
    public Expr instanceOf(Expr obj, ClassDesc type) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        return this.addItem(new InstanceOf(obj, type, null));
    }

    @Override
    public Expr instanceOf(Expr obj, GenericType type) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        return this.addItem(new InstanceOf(obj, null, type));
    }

    @Override
    public Expr new_(GenericType genericType, ConstructorDesc ctor, List<? extends Expr> args) {
        Assert.checkNotNullParam((String)"genericType", (Object)genericType);
        Assert.checkNotNullParam((String)"ctor", (Object)ctor);
        Assert.checkNotNullParam((String)"args", args);
        this.checkActive();
        if (!Util.equals(ctor.owner(), genericType.desc())) {
            throw new IllegalArgumentException("Generic type %s does not match constructor type %s".formatted(genericType, ctor.owner()));
        }
        return this.new0(genericType, ctor, args);
    }

    @Override
    public Expr new_(ConstructorDesc ctor, List<? extends Expr> args) {
        Assert.checkNotNullParam((String)"ctor", (Object)ctor);
        Assert.checkNotNullParam((String)"args", args);
        return this.new0(null, ctor, args);
    }

    private NewResult new0(GenericType genericType, ConstructorDesc ctor, List<? extends Expr> args) {
        New new_ = new New(ctor.owner(), genericType);
        Dup dup_ = new Dup(new_);
        ListIterator<Item> itr = this.iterator();
        for (int i = args.size() - 1; i >= 0; --i) {
            Item arg = (Item)args.get(i);
            if (!arg.bound()) continue;
            arg.verify(itr);
        }
        dup_.insert(itr);
        new_.insert(itr);
        Invoke invoke = new Invoke(ctor, dup_, args, genericType);
        this.addItem(invoke);
        return this.addItem(new NewResult(new_, invoke));
    }

    @Override
    public Expr invokeStatic(GenericType genericReturnType, MethodDesc method, List<? extends Expr> args) {
        if (!Util.equals(method.returnType(), genericReturnType.desc())) {
            throw new IllegalArgumentException("Generic type %s does not match method return type %s".formatted(genericReturnType, method.returnType()));
        }
        return this.addItem(new Invoke(Opcode.INVOKESTATIC, method, null, args, genericReturnType));
    }

    @Override
    public Expr invokeStatic(MethodDesc method, List<? extends Expr> args) {
        return this.addItem(new Invoke(Opcode.INVOKESTATIC, method, null, args, null));
    }

    @Override
    public Expr invokeVirtual(GenericType genericReturnType, MethodDesc method, Expr instance, List<? extends Expr> args) {
        if (!Util.equals(method.returnType(), genericReturnType.desc())) {
            throw new IllegalArgumentException("Generic type %s does not match method return type %s".formatted(genericReturnType, method.returnType()));
        }
        return this.addItem(new Invoke(Opcode.INVOKEVIRTUAL, method, instance, args, genericReturnType));
    }

    @Override
    public Expr invokeVirtual(MethodDesc method, Expr instance, List<? extends Expr> args) {
        return this.addItem(new Invoke(Opcode.INVOKEVIRTUAL, method, instance, args, null));
    }

    @Override
    public Expr invokeSpecial(GenericType genericReturnType, MethodDesc method, Expr instance, List<? extends Expr> args) {
        if (!Util.equals(method.returnType(), genericReturnType.desc())) {
            throw new IllegalArgumentException("Generic type %s does not match method return type %s".formatted(genericReturnType, method.returnType()));
        }
        return this.addItem(new Invoke(Opcode.INVOKESPECIAL, method, instance, args, genericReturnType));
    }

    @Override
    public Expr invokeSpecial(MethodDesc method, Expr instance, List<? extends Expr> args) {
        return this.addItem(new Invoke(Opcode.INVOKESPECIAL, method, instance, args, null));
    }

    @Override
    public Expr invokeSpecial(ConstructorDesc ctor, Expr instance, List<? extends Expr> args) {
        Invoke invoke = new Invoke(ctor, instance, args, GenericTypes.GT_void);
        this.addItem(invoke);
        if (instance instanceof ThisExpr) {
            for (Consumer<BlockCreator> postInit : this.postInits) {
                postInit.accept(this);
            }
        }
        return invoke;
    }

    @Override
    public Expr invokeInterface(GenericType genericReturnType, MethodDesc method, Expr instance, List<? extends Expr> args) {
        if (!(method instanceof InterfaceMethodDesc)) {
            throw new IllegalArgumentException("Cannot emit `invokeinterface` for " + String.valueOf(method) + "; must be InterfaceMethodDesc");
        }
        if (!Util.equals(method.returnType(), genericReturnType.desc())) {
            throw new IllegalArgumentException("Generic type %s does not match method return type %s".formatted(genericReturnType, method.returnType()));
        }
        return this.addItem(new Invoke(Opcode.INVOKEINTERFACE, method, instance, args, genericReturnType));
    }

    @Override
    public Expr invokeInterface(MethodDesc method, Expr instance, List<? extends Expr> args) {
        if (!(method instanceof InterfaceMethodDesc)) {
            throw new IllegalArgumentException("Cannot emit `invokeinterface` for " + String.valueOf(method) + "; must be InterfaceMethodDesc");
        }
        return this.addItem(new Invoke(Opcode.INVOKEINTERFACE, method, instance, args, null));
    }

    @Override
    public Expr invokeDynamic(DynamicCallSiteDesc callSiteDesc, List<? extends Expr> args) {
        return this.addItem(new InvokeDynamic(args, callSiteDesc));
    }

    @Override
    public void forEach(Expr fn, BiConsumer<BlockCreator, ? super LocalVar> builder) {
        this.block(fn, (b0, fn0) -> {
            LocalVar items = b0.localVar("$$items" + this.depth, (Expr)fn0);
            if (items.type().isArray()) {
                Expr lv = items.length();
                Expr length = lv instanceof Const ? lv : b0.localVar("$$length" + this.depth, lv);
                LocalVar idx = b0.localVar("$$idx" + this.depth, Const.of(0));
                b0.block(b1 -> b1.if_(b1.lt((Expr)idx, length), b2 -> {
                    LocalVar val = b2.localVar("$$val" + this.depth, items.elem(idx));
                    builder.accept((BlockCreator)b2, val);
                    if (b2.active()) {
                        b2.inc(idx);
                        b2.goto_((BlockCreator)b1);
                    }
                }));
            } else {
                LocalVar itr = b0.localVar("$$itr" + this.depth, b0.iterate(items));
                b0.block(b1 -> b1.if_(b1.withIterator(itr).hasNext(), b2 -> {
                    LocalVar val = b2.localVar("$$val" + this.depth, b2.withIterator(itr).next());
                    ((BlockCreatorImpl)b2).loopAction = bb -> bb.goto_((BlockCreator)b1);
                    builder.accept((BlockCreator)b2, val);
                    if (b2.active()) {
                        b2.goto_((BlockCreator)b1);
                    }
                }));
            }
        });
    }

    void block(Expr arg, BiConsumer<BlockCreator, Expr> nested) {
        BlockCreatorImpl block = new BlockCreatorImpl(this, (Item)arg, ConstantDescs.CD_void);
        this.nesting(() -> block.accept(nested));
        this.addItem(block);
    }

    @Override
    public void block(Consumer<BlockCreator> nested) {
        this.checkActive();
        BlockCreatorImpl block = new BlockCreatorImpl(this);
        this.nesting(() -> block.accept(nested));
        this.addItem(block);
    }

    @Override
    public Expr blockExpr(ClassDesc type, Consumer<BlockCreator> nested) {
        this.checkActive();
        BlockCreatorImpl block = new BlockCreatorImpl(this, ConstImpl.ofVoid(), type);
        this.nesting(() -> block.accept(nested));
        this.addItem(block);
        return block;
    }

    public void accept(BiConsumer<? super BlockCreatorImpl, Expr> handler) {
        this.checkActive();
        Item input = this.getFirst();
        handler.accept(this, input);
        this.finish();
    }

    public void accept(Consumer<? super BlockCreatorImpl> handler) {
        this.checkActive();
        handler.accept(this);
        this.finish();
    }

    private void finish() {
        Yield yield;
        Expr val;
        ListIterator<Item> itr;
        Item last;
        if (!this.done()) {
            this.addItem(Yield.YIELD_VOID);
        }
        if ((last = Util.peekPrevious(itr = this.iterator())) instanceof Yield && (val = (yield = (Yield)last).value()).typeKind() != this.typeKind()) {
            if (val.typeKind() == TypeKind.VOID) {
                throw new IllegalStateException("Block did not yield a value of type " + String.valueOf((Object)this.typeKind()) + " (did you forget to call `yield(val)`?)");
            }
            throw new IllegalStateException("Block yielded value of wrong type (expected a " + String.valueOf((Object)this.typeKind()) + " but got " + String.valueOf(val.type()) + ")");
        }
        last.verify(itr);
        BlockCreatorImpl.cleanStack(this.iterator());
        this.markDone();
    }

    @Override
    public void ifInstanceOf(Expr obj, ClassDesc type, BiConsumer<BlockCreator, ? super LocalVar> ifTrue) {
        this.doIf(this.instanceOf(obj, type), bc -> ifTrue.accept((BlockCreator)bc, bc.localVar("$$instance" + this.depth, bc.cast(obj, type))), null);
    }

    @Override
    public void ifNotInstanceOf(Expr obj, ClassDesc type, Consumer<BlockCreator> ifFalse) {
        this.doIf(this.instanceOf(obj, type), null, ifFalse);
    }

    @Override
    public void ifInstanceOfElse(Expr obj, ClassDesc type, BiConsumer<BlockCreator, ? super LocalVar> ifTrue, Consumer<BlockCreator> ifFalse) {
        this.doIf(this.instanceOf(obj, type), bc -> ifTrue.accept((BlockCreator)bc, bc.localVar("$$instance" + this.depth, bc.cast(obj, type))), ifFalse);
    }

    private If doIfInsn(ClassDesc type, Expr cond, BlockCreatorImpl wt, BlockCreatorImpl wf) {
        if (((Item)cond).bound()) {
            ListIterator<Item> itr = this.iterator();
            Item prevItem = Util.peekPrevious(itr);
            if (prevItem == cond) {
                if (cond instanceof Rel) {
                    Rel rel = (Rel)cond;
                    IfRel ifRel = new IfRel(type, rel.kind(), wt, wf, rel.left(), rel.right());
                    itr.set(ifRel);
                    if (!ifRel.mayFallThrough()) {
                        this.markDone();
                    }
                    return ifRel;
                }
                if (cond instanceof RelZero) {
                    RelZero rz = (RelZero)cond;
                    IfZero ifZero = new IfZero(type, rz.kind(), wt, wf, rz.input(), false);
                    itr.set(ifZero);
                    if (!ifZero.mayFallThrough()) {
                        this.markDone();
                    }
                    return ifZero;
                }
            }
        } else {
            if (cond instanceof Rel) {
                Rel rel = (Rel)cond;
                return this.addItem(new IfRel(type, rel.kind(), wt, wf, rel.left(), rel.right()));
            }
            if (cond instanceof RelZero) {
                RelZero rz = (RelZero)cond;
                return this.addItem(new IfZero(type, rz.kind(), wt, wf, rz.input(), false));
            }
        }
        return this.addItem(new IfZero(type, If.Kind.NE, wt, wf, (Item)cond, true));
    }

    private void doIf(Expr cond, Consumer<BlockCreator> whenTrue, Consumer<BlockCreator> whenFalse) {
        BlockCreatorImpl wt = whenTrue == null ? null : new BlockCreatorImpl(this);
        BlockCreatorImpl wf = whenFalse == null ? null : new BlockCreatorImpl(this);
        this.nesting(() -> {
            if (wt != null) {
                wt.accept(whenTrue);
            }
            if (wf != null) {
                wf.accept(whenFalse);
            }
        });
        this.doIfInsn(ConstantDescs.CD_void, cond, wt, wf);
    }

    @Override
    public Expr cond(ClassDesc type, Expr cond, Consumer<BlockCreator> whenTrue, Consumer<BlockCreator> whenFalse) {
        BlockCreatorImpl wt = new BlockCreatorImpl(this, ConstImpl.ofVoid(), type);
        BlockCreatorImpl wf = new BlockCreatorImpl(this, ConstImpl.ofVoid(), type);
        this.nesting(() -> {
            wt.accept(whenTrue);
            wf.accept(whenFalse);
        });
        return this.doIfInsn(type, cond, wt, wf);
    }

    @Override
    public void if_(Expr cond, Consumer<BlockCreator> whenTrue) {
        this.doIf(cond, whenTrue, null);
    }

    @Override
    public void ifNot(Expr cond, Consumer<BlockCreator> whenFalse) {
        this.doIf(cond, null, whenFalse);
    }

    @Override
    public void ifElse(Expr cond, Consumer<BlockCreator> whenTrue, Consumer<BlockCreator> whenFalse) {
        this.doIf(cond, whenTrue, whenFalse);
    }

    @Override
    public void break_(BlockCreator outer) {
        ((BlockCreatorImpl)outer).breakTarget = true;
        if (outer != this) {
            this.addItem(new Break(outer));
        }
        this.markDone();
    }

    @Override
    public void continue_(BlockCreator loop) {
        BlockCreatorImpl bci = (BlockCreatorImpl)loop;
        Consumer<BlockCreator> action = bci.loopAction;
        if (action == null) {
            throw new IllegalArgumentException("Can only continue a loop");
        }
        action.accept(this);
    }

    @Override
    public void goto_(BlockCreator outer) {
        ((BlockCreatorImpl)outer).branchTarget = true;
        if (!outer.contains(this)) {
            throw new IllegalStateException("Invalid block nesting");
        }
        this.addItem(new GotoStart(outer));
        this.markDone();
    }

    @Override
    public void loop(Consumer<BlockCreator> body) {
        this.block(b0 -> {
            ((BlockCreatorImpl)b0).loopAction = bb -> bb.goto_((BlockCreator)b0);
            body.accept((BlockCreator)b0);
            if (b0.active()) {
                b0.gotoStart();
            }
        });
    }

    @Override
    public void while_(Consumer<BlockCreator> cond, Consumer<BlockCreator> body) {
        this.block(b0 -> b0.if_(b0.blockExpr(ConstantDescs.CD_boolean, cond), b1 -> {
            ((BlockCreatorImpl)b1).loopAction = bb -> bb.goto_((BlockCreator)b0);
            body.accept((BlockCreator)b1);
            if (b1.active()) {
                b1.goto_((BlockCreator)b0);
            }
        }));
    }

    @Override
    public void doWhile(Consumer<BlockCreator> body, Consumer<BlockCreator> cond) {
        this.block(b0 -> {
            b0.block(b1 -> {
                ((BlockCreatorImpl)b1).loopAction = bb -> bb.break_((BlockCreator)b1);
                body.accept((BlockCreator)b1);
            });
            if (b0.active()) {
                b0.if_(b0.blockExpr(ConstantDescs.CD_boolean, cond), b1 -> b1.goto_((BlockCreator)b0));
            }
        });
    }

    @Override
    public void try_(Consumer<TryCreator> body) {
        TryCreatorImpl tci = new TryCreatorImpl(this);
        tci.accept(body);
        tci.addTo(this);
    }

    @Override
    public void autoClose(Expr resource, BiConsumer<BlockCreator, ? super LocalVar> body) {
        if (resource instanceof LocalVar) {
            LocalVar lv = (LocalVar)resource;
            this.autoClose(lv, (BlockCreator b0) -> body.accept((BlockCreator)b0, lv));
        } else {
            this.block(resource, (b0, opened) -> {
                LocalVar rsrc = b0.localVar("$$resource" + this.depth, (Expr)opened);
                this.autoClose(rsrc, (BlockCreator b1) -> body.accept((BlockCreator)b1, rsrc));
            });
        }
    }

    @Override
    public void autoClose(Var resource, Consumer<BlockCreator> body) {
        this.try_(t1 -> {
            t1.body(body);
            t1.catch_(ConstantDescs.CD_Throwable, "e2", (b2, e2) -> {
                b2.try_(t3 -> {
                    t3.body(b4 -> b4.close(resource));
                    t3.catch_(ConstantDescs.CD_Throwable, "e4", (b4, e4) -> b4.withThrowable((Expr)e2).addSuppressed((Expr)e4));
                });
                b2.throw_((Expr)e2);
            });
        });
        if (this.active()) {
            this.close(resource);
        }
    }

    void monitorEnter(Item monitor) {
        this.addItem(new MonitorEnter(monitor));
    }

    void monitorExit(Item monitor) {
        this.addItem(new MonitorExit(monitor));
    }

    @Override
    public void synchronized_(Expr monitor, Consumer<BlockCreator> body) {
        this.block(monitor, (b0, mon) -> {
            LocalVar mv = b0.localVar("$$monitor" + this.depth, (Expr)mon);
            ((BlockCreatorImpl)b0).monitorEnter((Item)((Object)mv));
            b0.try_(t1 -> {
                t1.body(body);
                t1.finally_(b2 -> ((BlockCreatorImpl)b2).monitorExit((Item)((Object)mv)));
            });
        });
    }

    @Override
    public void locked(Expr jucLock, Consumer<BlockCreator> body) {
        this.block(jucLock, (b0, lock) -> {
            LocalVar lv = b0.localVar("$$lock" + this.depth, (Expr)lock);
            b0.invokeInterface(Descs.MD_Lock.lock, lv);
            b0.try_(t1 -> {
                t1.body(body);
                t1.finally_(b2 -> b2.invokeInterface(Descs.MD_Lock.unlock, lv));
            });
        });
    }

    @Override
    public void returnNull() {
        this.return_(ConstImpl.ofNull(this.returnType));
    }

    @Override
    public void return_() {
        this.addItem(Return.RETURN_VOID);
    }

    @Override
    public void return_(Expr val) {
        if (Util.isVoid(this.returnType) && !val.isVoid()) {
            throw new IllegalArgumentException("Attempted to return a value from a `void`-returning method");
        }
        this.addItem((val = Conversions.convert(val, this.returnType)).equals(Const.ofVoid()) ? Return.RETURN_VOID : new Return(val));
    }

    @Override
    public void throw_(Expr val) {
        this.addItem(new Throw(val));
    }

    @Override
    public void yield(Expr val) {
        this.addItem((val = Conversions.convert(val, this.outputType)).equals(Const.ofVoid()) ? Yield.YIELD_VOID : new Yield(val));
    }

    @Override
    public Expr exprHashCode(Expr expr) {
        return switch (expr.typeKind()) {
            default -> throw new IncompatibleClassChangeError();
            case TypeKind.BOOLEAN -> this.invokeStatic((MethodDesc)Descs.MD_Boolean.hashCode, expr);
            case TypeKind.BYTE -> this.invokeStatic((MethodDesc)Descs.MD_Byte.hashCode, expr);
            case TypeKind.SHORT -> this.invokeStatic((MethodDesc)Descs.MD_Short.hashCode, expr);
            case TypeKind.CHAR -> this.invokeStatic((MethodDesc)Descs.MD_Character.hashCode, expr);
            case TypeKind.INT -> this.invokeStatic((MethodDesc)Descs.MD_Integer.hashCode, expr);
            case TypeKind.LONG -> this.invokeStatic((MethodDesc)Descs.MD_Long.hashCode, expr);
            case TypeKind.FLOAT -> this.invokeStatic((MethodDesc)Descs.MD_Float.hashCode, expr);
            case TypeKind.DOUBLE -> this.invokeStatic((MethodDesc)Descs.MD_Double.hashCode, expr);
            case TypeKind.REFERENCE -> {
                ConstImpl c;
                if (expr instanceof ConstImpl && (c = (ConstImpl)expr).isNonZero()) {
                    yield this.invokeVirtual(Descs.MD_Object.hashCode, c);
                }
                yield this.invokeStatic((MethodDesc)Descs.MD_Objects.hashCode, expr);
            }
            case TypeKind.VOID -> Const.of(0);
        };
    }

    @Override
    public Expr exprEquals(Expr a, Expr b) {
        return switch (a.typeKind()) {
            case TypeKind.REFERENCE -> {
                switch (b.typeKind()) {
                    case REFERENCE: {
                        ConstImpl c;
                        if (a instanceof ConstImpl && (c = (ConstImpl)a).isNonZero()) {
                            yield this.invokeVirtual((MethodDesc)Descs.MD_Object.equals, (Expr)c, b);
                        }
                        if (b instanceof ConstImpl && (c = (ConstImpl)b).isNonZero()) {
                            yield this.invokeVirtual((MethodDesc)Descs.MD_Object.equals, (Expr)c, a);
                        }
                        yield this.invokeStatic((MethodDesc)Descs.MD_Objects.equals, a, b);
                    }
                }
                yield this.exprEquals(a, this.box(b));
            }
            default -> {
                switch (b.typeKind()) {
                    case REFERENCE: {
                        yield this.exprEquals(this.box(a), b);
                    }
                }
                yield this.eq(a, b);
            }
        };
    }

    @Override
    public Expr exprToString(Expr expr) {
        ConstImpl c;
        if (expr.typeKind() == TypeKind.REFERENCE && expr instanceof ConstImpl && (c = (ConstImpl)expr).isNonZero()) {
            return this.invokeVirtual(Descs.MD_Object.toString, c);
        }
        return this.invokeStatic((MethodDesc)Descs.MD_String.valueOf(expr.type()), expr);
    }

    @Override
    public Expr arrayHashCode(Expr expr) {
        Preconditions.requireArray(expr);
        ClassDesc componentType = expr.type().componentType();
        if (componentType.isArray()) {
            return this.invokeStatic((MethodDesc)Descs.MD_Arrays.deepHashCode, expr);
        }
        return this.invokeStatic((MethodDesc)Descs.MD_Arrays.hashCode(componentType), expr);
    }

    @Override
    public Expr arrayEquals(Expr a, Expr b) {
        Preconditions.requireArray(a);
        Preconditions.requireArray(b);
        Preconditions.requireSameTypeKind(a.type().componentType(), b.type().componentType());
        ClassDesc componentType = a.type().componentType();
        if (componentType.isArray()) {
            return this.invokeStatic((MethodDesc)Descs.MD_Arrays.deepEquals, a, b);
        }
        return this.invokeStatic((MethodDesc)Descs.MD_Arrays.equals(componentType), a, b);
    }

    @Override
    public Expr arrayToString(Expr expr) {
        Preconditions.requireArray(expr);
        ClassDesc componentType = expr.type().componentType();
        if (componentType.isArray()) {
            return this.invokeStatic((MethodDesc)Descs.MD_Arrays.deepToString, expr);
        }
        return this.invokeStatic((MethodDesc)Descs.MD_Arrays.toString(componentType), expr);
    }

    @Override
    public Expr classForName(Expr className) {
        return this.invokeStatic((MethodDesc)Descs.MD_Class.forName, className);
    }

    @Override
    public <T> Expr listOf(List<T> items, Function<T, ? extends Expr> mapper) {
        ArrayList<Expr> exprs = new ArrayList<Expr>();
        for (T item : items) {
            exprs.add(mapper.apply(item));
        }
        int size = exprs.size();
        if (size <= 10) {
            return this.invokeStatic((MethodDesc)Descs.MD_List.of_n(size), exprs);
        }
        return this.invokeStatic((MethodDesc)Descs.MD_List.of_array, this.newArray(Object.class, exprs));
    }

    @Override
    public <T> Expr setOf(List<T> items, Function<T, ? extends Expr> mapper) {
        ArrayList<Expr> exprs = new ArrayList<Expr>();
        for (T item : items) {
            exprs.add(mapper.apply(item));
        }
        int size = exprs.size();
        if (size <= 10) {
            return this.invokeStatic((MethodDesc)Descs.MD_Set.of_n(size), exprs);
        }
        return this.invokeStatic((MethodDesc)Descs.MD_Set.of_array, this.newArray(Object.class, exprs));
    }

    @Override
    public Expr mapOf(List<? extends Expr> items) {
        int size = (items = List.copyOf(items)).size();
        if (size % 2 != 0) {
            throw new IllegalArgumentException("Invalid number of items: " + String.valueOf(items));
        }
        if (size <= 20) {
            return this.invokeStatic((MethodDesc)Descs.MD_Map.of_n(size >> 1), items);
        }
        throw new UnsupportedOperationException("Maps with more than 10 entries are not supported");
    }

    @Override
    public Expr mapEntry(Expr key, Expr value) {
        return this.invokeStatic((MethodDesc)Descs.MD_Map.entry, key, value);
    }

    @Override
    public Expr optionalOf(Expr value) {
        return this.invokeStatic((MethodDesc)Descs.MD_Optional.of, value);
    }

    @Override
    public Expr optionalOfNullable(Expr value) {
        return this.invokeStatic((MethodDesc)Descs.MD_Optional.ofNullable, value);
    }

    @Override
    public Expr optionalEmpty() {
        return this.invokeStatic(Descs.MD_Optional.empty);
    }

    @Override
    public void line(int lineNumber) {
        this.addItem(new LineNumber(lineNumber));
    }

    @Override
    public void printf(String format, List<? extends Expr> values) {
        this.invokeVirtual((MethodDesc)Descs.MD_PrintStream.printf, (Expr)Expr.staticField(Descs.FD_System.out), (Expr)Const.of(format), this.newArray(ConstantDescs.CD_Object, values));
    }

    @Override
    public void assert_(Consumer<BlockCreator> assertion, String message) {
        this.if_(Const.ofInvoke(Const.ofMethodHandle(InvokeKind.VIRTUAL, Descs.MD_Class.desiredAssertionStatus), Const.of(this.owner.type())), b0 -> b0.ifNot(b0.blockExpr(ConstantDescs.CD_boolean, assertion), b1 -> b1.throw_(b1.new_(ConstructorDesc.of(AssertionError.class, Object.class), (Expr)Const.of(message)))));
    }

    @Override
    protected void forEachDependency(ListIterator<Item> itr, BiConsumer<Item, ListIterator<Item>> op) {
        this.input.process(itr, op);
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block, StackMapBuilder smb) {
        StackMapBuilder.Saved saved = smb.save();
        if (this.branchTarget) {
            smb.addFrameInfo(cb);
        }
        cb.block(bcb -> {
            bcb.labelBinding(this.startLabel);
            ArrayList<Item> items = this.items;
            int sz = items.size();
            for (int i = 0; i < sz; ++i) {
                ((Item)items.get(i)).writeCode((CodeBuilder)bcb, this, smb);
            }
            bcb.labelBinding(this.endLabel);
        });
        smb.restore(saved);
        if (!Util.isVoid(this.input.type())) {
            smb.pop();
        }
        if (!Util.isVoid(this.outputType)) {
            smb.push(this.outputType);
        }
        if (this.breakTarget) {
            smb.addFrameInfo(cb);
        }
    }

    @Override
    public void writeAnnotations(RetentionPolicy retention, ArrayList<TypeAnnotation> annotations) {
        ArrayList<Item> items = this.items;
        int sz = items.size();
        for (int i = 0; i < sz; ++i) {
            ((Item)items.get(i)).writeAnnotations(retention, annotations);
        }
    }

    void postInit(List<Consumer<BlockCreator>> postInits) {
        this.postInits = postInits;
    }

    <I extends Item> I addItem(I item) {
        this.checkActive();
        return this.addItemUnchecked(item, this.iterator());
    }

    private <I extends Item> I addItemUnchecked(I item, ListIterator<Item> itr) {
        item.insert(itr);
        item.forEachDependency(itr, Item::insertIfUnbound);
        if (!item.mayFallThrough() || item instanceof Yield) {
            this.markDone();
        }
        return item;
    }

    private void checkActive() {
        if (this.state == 2) {
            if (this.finishSite == null) {
                throw new IllegalStateException("This block has already been finished\nTo track callers and get an improved exception message, add the system property `gizmo.debug`");
            }
            throw new IllegalStateException("This block has already been finished at " + this.finishSite);
        }
        if (this.state == 1) {
            if (this.nestSite == null) {
                throw new IllegalStateException("This block is currently not active, because a nested block is being created\nTo track callers and get an improved exception message, add the system property `gizmo.debug`");
            }
            throw new IllegalStateException("This block is currently not active, because a nested block is being created, starting at " + this.nestSite);
        }
        if (!this.active()) {
            throw new IllegalStateException("This block is not active");
        }
    }

    Label startLabel() {
        return this.startLabel;
    }

    Label endLabel() {
        return this.endLabel;
    }

    static void cleanStack(ListIterator<Item> itr) {
        while (itr.hasPrevious()) {
            Util.peekPrevious(itr).pop(itr);
        }
    }

    void nesting(Runnable action) {
        this.checkActive();
        this.state = 1;
        this.nestSite = Util.trackCaller();
        try {
            action.run();
        }
        finally {
            this.state = 0;
            this.nestSite = null;
        }
    }

    ListIterator<Item> iterator() {
        return this.items.listIterator(this.items.size());
    }

    @Override
    protected void insert(ListIterator<Item> itr) {
        Item last;
        if (this.items.size() == 2 && Util.equals((last = this.items.get(1)).type(), this.input.type())) {
            last.insert(itr);
            return;
        }
        super.insert(itr);
    }

    Item getFirst() {
        return this.items.get(0);
    }

    Item getLast() {
        return this.items.get(this.items.size() - 1);
    }

    private static /* synthetic */ void lambda$lambdaDebug$7(MethodTypeDesc samType, Consumer builder, ClassDesc samOwner, List captures, StaticMethodCreator mc) {
        mc.private_();
        mc.synthetic();
        mc.returning(samType.returnType());
        builder.accept(new LambdaAsMethodCreatorImpl(samOwner, samType, (MethodCreatorImpl)((Object)mc), captures));
    }

    private static /* synthetic */ ClassDesc[] lambda$lambda$6(int x$0) {
        return new ClassDesc[x$0];
    }

    private /* synthetic */ void lambda$lambda$5(ClassDesc desc, ArrayList captureExprs, MethodDesc sam, Consumer builder, ClassBuilder zb) {
        zb.withVersion(this.owner.version().major(), 0);
        AnonymousClassCreatorImpl tc = new AnonymousClassCreatorImpl(this.owner.gizmo, desc, this.owner.output(), zb, ConstructorDesc.of(Object.class, new Class[0]), captureExprs);
        if (sam instanceof InterfaceMethodDesc) {
            tc.implements_(sam.owner());
        }
        tc.method(sam, imc -> {
            imc.public_();
            LambdaAsAnonClassCreatorImpl lc = new LambdaAsAnonClassCreatorImpl(tc, (InstanceMethodCreatorImpl)imc);
            tc.preAccept();
            builder.accept(lc);
            tc.freezeCaptures();
            tc.constructor(cc -> tc.ctorSetups().forEach((Consumer<Consumer<ConstructorCreator>>)((Consumer<Consumer>)action -> action.accept(cc))));
            tc.postAccept();
        });
    }
}

