/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.bcextensions.AnnotationInfoImpl;
import io.quarkus.arc.processor.bcextensions.DeclarationInfoImpl;
import io.quarkus.arc.processor.bcextensions.MethodInfoImpl;
import io.quarkus.arc.processor.bcextensions.TypeImpl;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.declarations.MethodInfo;
import jakarta.enterprise.lang.model.declarations.ParameterInfo;
import jakarta.enterprise.lang.model.types.Type;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.Declaration;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.MutableAnnotationOverlay;

class ParameterInfoImpl
extends DeclarationInfoImpl<MethodParameterInfo>
implements ParameterInfo {
    ParameterInfoImpl(IndexView jandexIndex, MutableAnnotationOverlay annotationOverlay, MethodParameterInfo jandexDeclaration) {
        super(jandexIndex, annotationOverlay, jandexDeclaration);
    }

    public String name() {
        return ((MethodParameterInfo)this.jandexDeclaration).nameOrDefault();
    }

    public Type type() {
        return TypeImpl.fromJandexType(this.jandexIndex, this.annotationOverlay, ((MethodParameterInfo)this.jandexDeclaration).type());
    }

    public MethodInfo declaringMethod() {
        return new MethodInfoImpl(this.jandexIndex, this.annotationOverlay, ((MethodParameterInfo)this.jandexDeclaration).method());
    }

    @Override
    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        DotName annotationName = DotName.createSimple(annotationType);
        for (AnnotationInstance annotation : this.annotationOverlay.annotations((Declaration)((MethodParameterInfo)this.jandexDeclaration).method())) {
            if (!annotation.name().equals((Object)annotationName) || annotation.target() == null || annotation.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER || annotation.target().asMethodParameter().position() != ((MethodParameterInfo)this.jandexDeclaration).position()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAnnotation(Predicate<AnnotationInfo> predicate) {
        for (AnnotationInstance annotation : this.annotationOverlay.annotations((Declaration)((MethodParameterInfo)this.jandexDeclaration).method())) {
            if (!predicate.test(new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlay, annotation)) || annotation.target() == null || annotation.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER || annotation.target().asMethodParameter().position() != ((MethodParameterInfo)this.jandexDeclaration).position()) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T extends Annotation> AnnotationInfo annotation(Class<T> annotationType) {
        DotName annotationName = DotName.createSimple(annotationType);
        for (AnnotationInstance annotation : this.annotationOverlay.annotations((Declaration)((MethodParameterInfo)this.jandexDeclaration).method())) {
            if (!annotation.name().equals((Object)annotationName) || annotation.target() == null || annotation.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER || annotation.target().asMethodParameter().position() != ((MethodParameterInfo)this.jandexDeclaration).position()) continue;
            return new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlay, annotation);
        }
        return null;
    }

    @Override
    public <T extends Annotation> Collection<AnnotationInfo> repeatableAnnotation(Class<T> annotationType) {
        ArrayList<AnnotationInfoImpl> result = new ArrayList<AnnotationInfoImpl>();
        for (AnnotationInstance annotation : this.annotationOverlay.annotationsWithRepeatable((Declaration)((MethodParameterInfo)this.jandexDeclaration).method(), annotationType)) {
            if (annotation.target() == null || annotation.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER || annotation.target().asMethodParameter().position() != ((MethodParameterInfo)this.jandexDeclaration).position()) continue;
            result.add(new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlay, annotation));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Collection<AnnotationInfo> annotations(Predicate<AnnotationInfo> predicate) {
        ArrayList<AnnotationInfoImpl> result = new ArrayList<AnnotationInfoImpl>();
        for (AnnotationInstance annotation : this.annotationOverlay.annotations((Declaration)((MethodParameterInfo)this.jandexDeclaration).method())) {
            AnnotationInfoImpl annotationInfo;
            if (annotation.target() == null || annotation.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER || annotation.target().asMethodParameter().position() != ((MethodParameterInfo)this.jandexDeclaration).position() || !predicate.test(annotationInfo = new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlay, annotation))) continue;
            result.add(annotationInfo);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Collection<AnnotationInfo> annotations() {
        ArrayList<AnnotationInfoImpl> result = new ArrayList<AnnotationInfoImpl>();
        for (AnnotationInstance annotation : this.annotationOverlay.annotations((Declaration)((MethodParameterInfo)this.jandexDeclaration).method())) {
            if (annotation.target() == null || annotation.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER || annotation.target().asMethodParameter().position() != ((MethodParameterInfo)this.jandexDeclaration).position()) continue;
            result.add(new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlay, annotation));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public String toString() {
        return "parameter " + this.name() + " of method " + String.valueOf(((MethodParameterInfo)this.jandexDeclaration).method());
    }
}

