/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.logging;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import io.micrometer.core.lang.Nullable;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.filter.AbstractFilter;

@NonNullApi
@NonNullFields
public class Log4j2Metrics
implements MeterBinder,
AutoCloseable {
    private static final String METER_NAME = "log4j2.events";
    private final Iterable<Tag> tags;
    private final LoggerContext loggerContext;
    @Nullable
    private MetricsFilter metricsFilter;

    public Log4j2Metrics() {
        this(Collections.emptyList());
    }

    public Log4j2Metrics(Iterable<Tag> tags) {
        this(tags, (LoggerContext)LogManager.getContext((boolean)false));
    }

    public Log4j2Metrics(Iterable<Tag> tags, LoggerContext loggerContext) {
        this.tags = tags;
        this.loggerContext = loggerContext;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        this.metricsFilter = new MetricsFilter(registry, this.tags);
        this.metricsFilter.start();
        Configuration configuration = this.loggerContext.getConfiguration();
        configuration.getLoggerConfig("").addFilter((Filter)this.metricsFilter);
        this.loggerContext.updateLoggers(configuration);
    }

    @Override
    public void close() {
        if (this.metricsFilter != null) {
            Configuration configuration = this.loggerContext.getConfiguration();
            configuration.getLoggerConfig("").removeFilter((Filter)this.metricsFilter);
            this.loggerContext.updateLoggers(configuration);
            this.metricsFilter.stop();
        }
    }

    @NonNullApi
    @NonNullFields
    class MetricsFilter
    extends AbstractFilter {
        private final Counter fatalCounter;
        private final Counter errorCounter;
        private final Counter warnCounter;
        private final Counter infoCounter;
        private final Counter debugCounter;
        private final Counter traceCounter;

        MetricsFilter(MeterRegistry registry, Iterable<Tag> tags) {
            this.fatalCounter = Counter.builder(Log4j2Metrics.METER_NAME).tags(tags).tags("level", "fatal").description("Number of fatal level log events").baseUnit("events").register(registry);
            this.errorCounter = Counter.builder(Log4j2Metrics.METER_NAME).tags(tags).tags("level", "error").description("Number of error level log events").baseUnit("events").register(registry);
            this.warnCounter = Counter.builder(Log4j2Metrics.METER_NAME).tags(tags).tags("level", "warn").description("Number of warn level log events").baseUnit("events").register(registry);
            this.infoCounter = Counter.builder(Log4j2Metrics.METER_NAME).tags(tags).tags("level", "info").description("Number of info level log events").baseUnit("events").register(registry);
            this.debugCounter = Counter.builder(Log4j2Metrics.METER_NAME).tags(tags).tags("level", "debug").description("Number of debug level log events").baseUnit("events").register(registry);
            this.traceCounter = Counter.builder(Log4j2Metrics.METER_NAME).tags(tags).tags("level", "trace").description("Number of trace level log events").baseUnit("events").register(registry);
        }

        public Filter.Result filter(LogEvent event) {
            switch (event.getLevel().getStandardLevel()) {
                case FATAL: {
                    this.fatalCounter.increment();
                    break;
                }
                case ERROR: {
                    this.errorCounter.increment();
                    break;
                }
                case WARN: {
                    this.warnCounter.increment();
                    break;
                }
                case INFO: {
                    this.infoCounter.increment();
                    break;
                }
                case DEBUG: {
                    this.debugCounter.increment();
                    break;
                }
                case TRACE: {
                    this.traceCounter.increment();
                    break;
                }
            }
            return Filter.Result.NEUTRAL;
        }
    }
}

