/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.io.mzml.data;

import com.google.common.collect.Range;
import io.github.msdk.MSDKRuntimeException;
import io.github.msdk.datamodel.ActivationInfo;
import io.github.msdk.datamodel.IsolationInfo;
import io.github.msdk.datamodel.MsScan;
import io.github.msdk.datamodel.MsScanType;
import io.github.msdk.datamodel.MsSpectrumType;
import io.github.msdk.datamodel.PolarityType;
import io.github.msdk.datamodel.RawDataFile;
import io.github.msdk.datamodel.SimpleIsolationInfo;
import io.github.msdk.io.mzml.MzMLFileImportMethod;
import io.github.msdk.io.mzml.data.MzMLBinaryDataInfo;
import io.github.msdk.io.mzml.data.MzMLCVGroup;
import io.github.msdk.io.mzml.data.MzMLCVParam;
import io.github.msdk.io.mzml.data.MzMLIsolationWindow;
import io.github.msdk.io.mzml.data.MzMLPeaksDecoder;
import io.github.msdk.io.mzml.data.MzMLPrecursorElement;
import io.github.msdk.io.mzml.data.MzMLPrecursorList;
import io.github.msdk.io.mzml.data.MzMLProductList;
import io.github.msdk.io.mzml.data.MzMLRawDataFile;
import io.github.msdk.io.mzml.data.MzMLScan;
import io.github.msdk.io.mzml.data.MzMLScanList;
import io.github.msdk.io.mzml.data.MzMLScanWindow;
import io.github.msdk.io.mzml.data.MzMLScanWindowList;
import io.github.msdk.spectra.centroidprofiledetection.SpectrumTypeDetectionAlgorithm;
import io.github.msdk.util.MsSpectrumUtil;
import io.github.msdk.util.tolerances.MzTolerance;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MzMLMsScan
implements MsScan {
    @Nonnull
    private final MzMLRawDataFile dataFile;
    @Nonnull
    private InputStream inputStream;
    @Nonnull
    private final String id;
    @Nonnull
    private final Integer scanNumber;
    private final int numOfDataPoints;
    private MzMLCVGroup cvParams;
    private MzMLPrecursorList precursorList;
    private MzMLProductList productList;
    private MzMLScanList scanList;
    private MzMLBinaryDataInfo mzBinaryDataInfo;
    private MzMLBinaryDataInfo intensityBinaryDataInfo;
    private MsSpectrumType spectrumType;
    private Float tic;
    private Float retentionTime;
    private Range<Double> mzRange;
    private Range<Double> mzScanWindowRange;
    private double[] mzValues;
    private float[] intensityValues;
    private Logger logger = LoggerFactory.getLogger(MzMLFileImportMethod.class);

    public MzMLMsScan(MzMLRawDataFile dataFile, InputStream is, String id, Integer scanNumber, int numOfDataPoints) {
        this.cvParams = new MzMLCVGroup();
        this.precursorList = new MzMLPrecursorList();
        this.productList = new MzMLProductList();
        this.scanList = new MzMLScanList();
        this.dataFile = dataFile;
        this.inputStream = is;
        this.id = id;
        this.scanNumber = scanNumber;
        this.numOfDataPoints = numOfDataPoints;
        this.mzBinaryDataInfo = null;
        this.intensityBinaryDataInfo = null;
        this.spectrumType = null;
        this.tic = null;
        this.retentionTime = null;
        this.mzRange = null;
        this.mzScanWindowRange = null;
        this.mzValues = null;
        this.intensityValues = null;
    }

    public MzMLCVGroup getCVParams() {
        return this.cvParams;
    }

    public MzMLBinaryDataInfo getMzBinaryDataInfo() {
        return this.mzBinaryDataInfo;
    }

    public void setMzBinaryDataInfo(MzMLBinaryDataInfo mzBinaryDataInfo) {
        this.mzBinaryDataInfo = mzBinaryDataInfo;
    }

    public MzMLBinaryDataInfo getIntensityBinaryDataInfo() {
        return this.intensityBinaryDataInfo;
    }

    public void setIntensityBinaryDataInfo(MzMLBinaryDataInfo intensityBinaryDataInfo) {
        this.intensityBinaryDataInfo = intensityBinaryDataInfo;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public MzMLPrecursorList getPrecursorList() {
        return this.precursorList;
    }

    public MzMLProductList getProductList() {
        return this.productList;
    }

    public MzMLScanList getScanList() {
        return this.scanList;
    }

    public String getId() {
        return this.id;
    }

    public Integer getNumberOfDataPoints() {
        return this.getMzBinaryDataInfo().getArrayLength();
    }

    public double[] getMzValues(double[] array) {
        if (this.mzValues == null) {
            if (this.getMzBinaryDataInfo().getArrayLength() != this.numOfDataPoints) {
                this.logger.warn("m/z binary data array contains a different array length from the default array length of the scan (#" + this.getScanNumber() + ")");
            }
            try {
                this.mzValues = MzMLPeaksDecoder.decodeToDouble(this.inputStream, this.getMzBinaryDataInfo(), array);
            }
            catch (Exception e) {
                throw new MSDKRuntimeException((Throwable)e);
            }
        }
        if (array == null || array.length < this.getNumberOfDataPoints()) {
            array = new double[this.getNumberOfDataPoints().intValue()];
            System.arraycopy(this.mzValues, 0, array, 0, this.numOfDataPoints);
        }
        return array;
    }

    public float[] getIntensityValues(float[] array) {
        if (this.intensityValues == null) {
            if (this.getIntensityBinaryDataInfo().getArrayLength() != this.numOfDataPoints) {
                this.logger.warn("Intensity binary data array contains a different array length from the default array length of the scan (#" + this.getScanNumber() + ")");
            }
            try {
                this.intensityValues = MzMLPeaksDecoder.decodeToFloat(this.inputStream, this.getIntensityBinaryDataInfo(), array);
            }
            catch (Exception e) {
                throw new MSDKRuntimeException((Throwable)e);
            }
        }
        if (array == null || array.length < this.numOfDataPoints) {
            array = new float[this.numOfDataPoints];
            System.arraycopy(this.intensityValues, 0, array, 0, this.numOfDataPoints);
        }
        return array;
    }

    public MsSpectrumType getSpectrumType() {
        if (this.spectrumType == null) {
            if (this.getCVValue("MS:1000127").isPresent()) {
                this.spectrumType = MsSpectrumType.CENTROIDED;
            }
            if (this.getCVValue("MS:1000128").isPresent()) {
                this.spectrumType = MsSpectrumType.PROFILE;
            }
            if (this.spectrumType != null) {
                return this.spectrumType;
            }
            this.spectrumType = SpectrumTypeDetectionAlgorithm.detectSpectrumType((double[])this.getMzValues(), (float[])this.getIntensityValues(), (Integer)this.numOfDataPoints);
        }
        return this.spectrumType;
    }

    public Float getTIC() {
        if (this.tic == null) {
            try {
                this.tic = MsSpectrumUtil.getTIC((float[])this.getIntensityValues(), (Integer)this.getNumberOfDataPoints());
            }
            catch (NumberFormatException e) {
                throw new MSDKRuntimeException("Could not convert TIC value in mzML file to a float\n" + e);
            }
        }
        return this.tic;
    }

    public Range<Double> getMzRange() {
        if (this.mzRange == null) {
            Optional<String> cvv = this.getCVValue("MS:1000528");
            Optional<String> cvv1 = this.getCVValue("MS:1000527");
            if (!cvv.isPresent() || !cvv1.isPresent()) {
                this.mzRange = MsSpectrumUtil.getMzRange((double[])this.getMzValues(), (Integer)this.getMzBinaryDataInfo().getArrayLength());
                return this.mzRange;
            }
            try {
                this.mzRange = Range.closed((Comparable)Double.valueOf(cvv.get()), (Comparable)Double.valueOf(cvv1.get()));
            }
            catch (NumberFormatException e) {
                throw new MSDKRuntimeException("Could not convert mz range value in mzML file to a double\n" + e);
            }
        }
        return this.mzRange;
    }

    public RawDataFile getRawDataFile() {
        return this.dataFile;
    }

    public Integer getScanNumber() {
        return this.scanNumber;
    }

    public String getScanDefinition() {
        Optional<String> scanDefinition = Optional.empty();
        if (!this.getScanList().getScans().isEmpty()) {
            scanDefinition = this.getCVValue(this.getScanList().getScans().get(0), "MS:1000512");
        }
        return scanDefinition.orElse("");
    }

    public String getMsFunction() {
        return null;
    }

    public Integer getMsLevel() {
        Integer msLevel = 1;
        Optional<String> value = this.getCVValue("MS:1000511");
        if (value.isPresent()) {
            msLevel = Integer.parseInt(value.get());
        }
        return msLevel;
    }

    public MsScanType getMsScanType() {
        return MsScanType.UNKNOWN;
    }

    public Range<Double> getScanningRange() {
        Optional<MzMLScanWindowList> scanWindowList;
        if (this.mzScanWindowRange == null && !this.getScanList().getScans().isEmpty() && (scanWindowList = this.getScanList().getScans().get(0).getScanWindowList()).isPresent() && !scanWindowList.get().getScanWindows().isEmpty()) {
            MzMLScanWindow scanWindow = scanWindowList.get().getScanWindows().get(0);
            Optional<String> cvv = this.getCVValue(scanWindow, "MS:1000501");
            Optional<String> cvv1 = this.getCVValue(scanWindow, "MS:1000500");
            if (!cvv.isPresent() || !cvv1.isPresent()) {
                this.mzScanWindowRange = this.getMzRange();
                return this.mzScanWindowRange;
            }
            try {
                this.mzScanWindowRange = Range.closed((Comparable)Double.valueOf(cvv.get()), (Comparable)Double.valueOf(cvv1.get()));
            }
            catch (NumberFormatException e) {
                throw new MSDKRuntimeException("Could not convert scan window range value in mzML file to a double\n" + e);
            }
        }
        return this.mzScanWindowRange;
    }

    public PolarityType getPolarity() {
        if (this.getCVValue("MS:1000130").isPresent()) {
            return PolarityType.POSITIVE;
        }
        if (this.getCVValue("MS:1000129").isPresent()) {
            return PolarityType.NEGATIVE;
        }
        if (!this.getScanList().getScans().isEmpty()) {
            MzMLScan scan = this.getScanList().getScans().get(0);
            if (this.getCVValue(scan, "MS:1000130").isPresent()) {
                return PolarityType.POSITIVE;
            }
            if (this.getCVValue(scan, "MS:1000129").isPresent()) {
                return PolarityType.NEGATIVE;
            }
        }
        return PolarityType.UNKNOWN;
    }

    public ActivationInfo getSourceInducedFragmentation() {
        return null;
    }

    public List<IsolationInfo> getIsolations() {
        if (this.precursorList.getPrecursorElements().size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<SimpleIsolationInfo> isolations = new ArrayList<SimpleIsolationInfo>();
        for (MzMLPrecursorElement precursor : this.precursorList.getPrecursorElements()) {
            Optional<Object> precursorMz = Optional.empty();
            Optional<Object> precursorCharge = Optional.empty();
            Optional<Object> isolationWindowTarget = Optional.empty();
            Optional<Object> isolationWindowLower = Optional.empty();
            Optional<Object> isolationWindowUpper = Optional.empty();
            if (!precursor.getSelectedIonList().isPresent()) {
                return Collections.emptyList();
            }
            for (MzMLCVGroup mzMLCVGroup : precursor.getSelectedIonList().get().getSelectedIonList()) {
                precursorMz = this.getCVValue(mzMLCVGroup, "MS:1000744");
                if (!precursorMz.isPresent()) {
                    precursorMz = this.getCVValue(mzMLCVGroup, "MS:1000040");
                }
                precursorCharge = this.getCVValue(mzMLCVGroup, "MS:1000041");
            }
            if (precursor.getIsolationWindow().isPresent()) {
                MzMLIsolationWindow isolationWindow = precursor.getIsolationWindow().get();
                isolationWindowTarget = this.getCVValue(isolationWindow, "MS:1000827");
                isolationWindowLower = this.getCVValue(isolationWindow, "MS:1000828");
                isolationWindowUpper = this.getCVValue(isolationWindow, "MS:1000829");
            }
            if (!precursorMz.isPresent()) continue;
            if (!isolationWindowTarget.isPresent()) {
                isolationWindowTarget = precursorMz;
            }
            if (!isolationWindowLower.isPresent()) {
                isolationWindowLower = Optional.ofNullable("0.5");
            }
            if (!isolationWindowUpper.isPresent()) {
                isolationWindowUpper = Optional.ofNullable("0.5");
            }
            Range isolationRange = Range.closed((Comparable)Double.valueOf(Double.valueOf((String)isolationWindowTarget.get()) - Double.valueOf((String)isolationWindowLower.get())), (Comparable)Double.valueOf(Double.valueOf((String)isolationWindowTarget.get()) + Double.valueOf((String)isolationWindowLower.get())));
            Integer n = precursorCharge.isPresent() ? Integer.valueOf((String)precursorCharge.get()) : null;
            SimpleIsolationInfo isolation = new SimpleIsolationInfo(isolationRange, null, Double.valueOf((String)precursorMz.get()), n, null);
            isolations.add(isolation);
        }
        return Collections.unmodifiableList(isolations);
    }

    public Float getRetentionTime() {
        if (this.retentionTime != null) {
            return this.retentionTime;
        }
        if (!this.getScanList().getScans().isEmpty()) {
            block18: for (MzMLCVParam param : this.getScanList().getScans().get(0).getCVParamsList()) {
                String accession = param.getAccession();
                Optional<String> unitAccession = param.getUnitAccession();
                Optional<String> value = param.getValue();
                block6 : switch (accession) {
                    case "MS:1000016": 
                    case "MS:1000894": 
                    case "MS:1000895": 
                    case "MS:1000896": {
                        if (!value.isPresent()) {
                            throw new IllegalStateException("For retention time cvParam the `value` must have been specified");
                        }
                        if (unitAccession.isPresent()) {
                            switch (param.getUnitAccession().get()) {
                                case "MS:1000038": 
                                case "UO:0000031": {
                                    this.retentionTime = Float.valueOf(Float.parseFloat(value.get()) * 60.0f);
                                    break block6;
                                }
                                case "UO:0000010": {
                                    this.retentionTime = Float.valueOf(Float.parseFloat(value.get()));
                                    break block6;
                                }
                            }
                            throw new IllegalStateException("Unknown time unit encountered: [" + unitAccession + "]");
                        }
                        this.retentionTime = Float.valueOf(Float.parseFloat(value.get()));
                        break;
                    }
                    default: {
                        continue block18;
                    }
                }
            }
        }
        return this.retentionTime;
    }

    public MzTolerance getMzTolerance() {
        return null;
    }

    public Optional<String> getCVValue(String accession) {
        return this.getCVValue(this.cvParams, accession);
    }

    public Optional<String> getCVValue(MzMLCVGroup group, String accession) {
        for (MzMLCVParam cvParam : group.getCVParamsList()) {
            if (!cvParam.getAccession().equals(accession)) continue;
            Optional<String> value = cvParam.getValue();
            if (!value.isPresent()) {
                value = Optional.ofNullable("");
            }
            return value;
        }
        return Optional.empty();
    }
}

