/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.io.mzml.data;

import io.github.msdk.io.mzml.data.MzMLArrayType;
import io.github.msdk.io.mzml.data.MzMLBitLength;
import io.github.msdk.io.mzml.data.MzMLCompressionType;
import javax.annotation.Nonnull;

public class MzMLBinaryDataInfo {
    private final int encodedLength;
    private final int arrayLength;
    private long position;
    @Nonnull
    private MzMLCompressionType compressionType;
    private MzMLBitLength bitLength;
    private MzMLArrayType arrayType;

    public MzMLBinaryDataInfo(int encodedLength, int arrayLength) {
        this.encodedLength = encodedLength;
        this.arrayLength = arrayLength;
        this.compressionType = MzMLCompressionType.NO_COMPRESSION;
    }

    public MzMLBitLength getBitLength() {
        return this.bitLength;
    }

    public void setBitLength(String bitLengthAccession) {
        this.bitLength = this.getBitLength(bitLengthAccession);
    }

    public void setBitLength(MzMLBitLength bitLength) {
        this.bitLength = bitLength;
    }

    public boolean isBitLengthAccession(String bitLengthAccession) {
        return this.getBitLength(bitLengthAccession) != null;
    }

    public MzMLBitLength getBitLength(String accession) {
        for (MzMLBitLength bitLength : MzMLBitLength.values()) {
            if (!bitLength.getValue().equals(accession)) continue;
            return bitLength;
        }
        return null;
    }

    public MzMLCompressionType getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(String compressionTypeAccession) {
        this.compressionType = this.getCompressionType(compressionTypeAccession);
    }

    public void setCompressionType(MzMLCompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public boolean isCompressionTypeAccession(String compressionTypeAccession) {
        return this.getCompressionType(compressionTypeAccession) != null;
    }

    public MzMLCompressionType getCompressionType(String accession) {
        for (MzMLCompressionType compressionType : MzMLCompressionType.values()) {
            if (!compressionType.getAccession().equals(accession)) continue;
            return compressionType;
        }
        return null;
    }

    public MzMLArrayType getArrayType() {
        return this.arrayType;
    }

    public void setArrayType(String arrayTypeAccession) {
        this.arrayType = this.getArrayType(arrayTypeAccession);
    }

    public void setArrayType(MzMLArrayType arrayType) {
        this.arrayType = arrayType;
    }

    public boolean isArrayTypeAccession(String arrayTypeAccession) {
        return this.getArrayType(arrayTypeAccession) != null;
    }

    public MzMLArrayType getArrayType(String accession) {
        for (MzMLArrayType arrayType : MzMLArrayType.values()) {
            if (!arrayType.getAccession().equals(accession)) continue;
            return arrayType;
        }
        return null;
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public int getEncodedLength() {
        return this.encodedLength;
    }

    public int getArrayLength() {
        return this.arrayLength;
    }
}

