/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.util.tolerances;

import com.google.common.collect.Range;
import io.github.msdk.util.tolerances.MzTolerance;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MaximumMzTolerance
implements MzTolerance {
    private static final Double MILLION = 1000000.0;
    @Nonnull
    private final Double mzTolerance;
    @Nonnull
    private final Double ppmTolerance;

    public MaximumMzTolerance(@Nonnull Double toleranceMZ, @Nonnull Double tolerancePPM) {
        this.mzTolerance = toleranceMZ;
        this.ppmTolerance = tolerancePPM;
    }

    @Nonnull
    public Double getMzTolerance() {
        return this.mzTolerance;
    }

    @Nonnull
    public Double getPpmTolerance() {
        return this.ppmTolerance;
    }

    @Override
    @Nonnull
    public Range<Double> getToleranceRange(@Nonnull Double mzValue) {
        Double absoluteTolerance = Math.max(this.mzTolerance, mzValue / MILLION * this.ppmTolerance);
        return Range.closed((Comparable)Double.valueOf(mzValue - absoluteTolerance), (Comparable)Double.valueOf(mzValue + absoluteTolerance));
    }

    public String toString() {
        return this.mzTolerance + " m/z or " + this.ppmTolerance + " ppm";
    }
}

