/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.util;

import com.google.common.base.Preconditions;
import io.github.msdk.datamodel.MsScan;
import io.github.msdk.datamodel.RawDataFile;
import io.github.msdk.datamodel.SimpleMsScan;
import javax.annotation.Nonnull;

public class MsScanUtil {
    @Nonnull
    public static SimpleMsScan clone(@Nonnull MsScan scan, @Nonnull Boolean copyDataPoints) {
        Preconditions.checkNotNull((Object)scan);
        Preconditions.checkNotNull((Object)copyDataPoints);
        SimpleMsScan newScan = new SimpleMsScan(scan.getScanNumber(), scan.getMsFunction());
        newScan.setPolarity(scan.getPolarity());
        newScan.setMsScanType(scan.getMsScanType());
        newScan.setScanningRange(scan.getScanningRange());
        newScan.setRetentionTime(scan.getRetentionTime());
        newScan.setMsLevel(scan.getMsLevel());
        newScan.setSourceInducedFragmentation(scan.getSourceInducedFragmentation());
        newScan.getIsolations().addAll(scan.getIsolations());
        if (copyDataPoints.booleanValue()) {
            double[] mzValues = scan.getMzValues();
            float[] intensityValues = scan.getIntensityValues();
            newScan.setDataPoints(mzValues, intensityValues, scan.getNumberOfDataPoints());
        }
        return newScan;
    }

    public String msScanToString(@Nonnull MsScan scan) {
        StringBuilder buf = new StringBuilder();
        buf.append("Scan ");
        RawDataFile rawDataFile2 = scan.getRawDataFile();
        if (rawDataFile2 != null && rawDataFile2.getOriginalFile() != null) {
            buf.append(rawDataFile2.getOriginalFilename());
            buf.append(" ");
        }
        if (scan.getMsFunction() != null) {
            buf.append(scan.getMsFunction());
            buf.append(" ");
        }
        buf.append("#");
        buf.append(scan.getScanNumber());
        return buf.toString();
    }
}

