/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.datamodel;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import io.github.msdk.MSDKRuntimeException;
import io.github.msdk.datamodel.AbstractMsSpectrum;
import io.github.msdk.datamodel.ActivationInfo;
import io.github.msdk.datamodel.IsolationInfo;
import io.github.msdk.datamodel.MsScan;
import io.github.msdk.datamodel.MsScanType;
import io.github.msdk.datamodel.PolarityType;
import io.github.msdk.datamodel.RawDataFile;
import io.github.msdk.util.tolerances.MzTolerance;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleMsScan
extends AbstractMsSpectrum
implements MsScan {
    @Nullable
    private RawDataFile dataFile;
    @Nonnull
    private Integer scanNumber;
    @Nullable
    private String scanDefinition;
    @Nullable
    private String msFunction;
    @Nonnull
    private Integer msLevel = 1;
    @Nonnull
    private PolarityType polarity = PolarityType.UNKNOWN;
    @Nonnull
    private MsScanType msScanType = MsScanType.UNKNOWN;
    @Nullable
    private MzTolerance mzTolerance;
    @Nullable
    private Range<Double> scanningRange;
    @Nullable
    private Float rt;
    @Nullable
    private ActivationInfo sourceInducedFragInfo;
    @Nonnull
    private final List<IsolationInfo> isolations = new LinkedList<IsolationInfo>();

    public SimpleMsScan(@Nonnull Integer scanNumber) {
        this(scanNumber, null);
    }

    public SimpleMsScan(@Nonnull Integer scanNumber, String msFunction) {
        Preconditions.checkNotNull((Object)scanNumber);
        this.scanNumber = scanNumber;
        this.msFunction = msFunction;
    }

    @Override
    @Nullable
    public RawDataFile getRawDataFile() {
        return this.dataFile;
    }

    public void setRawDataFile(@Nonnull RawDataFile newRawDataFile) {
        if (this.dataFile != null && this.dataFile != newRawDataFile) {
            throw new MSDKRuntimeException("Cannot set the raw data file reference to this scan, because it has already been set");
        }
        this.dataFile = newRawDataFile;
    }

    @Override
    @Nonnull
    public Integer getScanNumber() {
        return this.scanNumber;
    }

    public void setScanNumber(@Nonnull Integer scanNumber) {
        Preconditions.checkNotNull((Object)scanNumber);
        this.scanNumber = scanNumber;
    }

    @Override
    @Nullable
    public String getScanDefinition() {
        return this.scanDefinition;
    }

    public void setScanDefinition(@Nullable String scanDefinition) {
        this.scanDefinition = scanDefinition;
    }

    @Override
    @Nullable
    public String getMsFunction() {
        return this.msFunction;
    }

    public void setMsFunction(@Nullable String newFunction) {
        this.msFunction = newFunction;
    }

    @Override
    @Nullable
    public Integer getMsLevel() {
        return this.msLevel;
    }

    public void setMsLevel(@Nonnull Integer msLevel) {
        this.msLevel = msLevel;
    }

    @Override
    @Nullable
    public Range<Double> getScanningRange() {
        return this.scanningRange;
    }

    public void setScanningRange(@Nullable Range<Double> newScanRange) {
        this.scanningRange = newScanRange;
    }

    @Override
    @Nonnull
    public PolarityType getPolarity() {
        return this.polarity;
    }

    public void setPolarity(@Nonnull PolarityType newPolarity) {
        Preconditions.checkNotNull((Object)((Object)newPolarity));
        this.polarity = newPolarity;
    }

    @Override
    @Nonnull
    public MsScanType getMsScanType() {
        return this.msScanType;
    }

    public void setMsScanType(@Nonnull MsScanType newMsScanType) {
        Preconditions.checkNotNull((Object)((Object)newMsScanType));
        this.msScanType = newMsScanType;
    }

    @Override
    public MzTolerance getMzTolerance() {
        return this.mzTolerance;
    }

    @Override
    public void setMzTolerance(MzTolerance mzTolerance) {
        this.mzTolerance = mzTolerance;
    }

    @Override
    @Nullable
    public Float getRetentionTime() {
        return this.rt;
    }

    public void setRetentionTime(@Nullable Float rt) {
        this.rt = rt;
    }

    @Override
    @Nullable
    public ActivationInfo getSourceInducedFragmentation() {
        return this.sourceInducedFragInfo;
    }

    public void setSourceInducedFragmentation(@Nullable ActivationInfo newFragmentationInfo) {
        this.sourceInducedFragInfo = newFragmentationInfo;
    }

    @Override
    @Nonnull
    public List<IsolationInfo> getIsolations() {
        return this.isolations;
    }
}

