/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client.ghsa;

import io.github.jeremylong.openvulnerability.client.HttpAsyncClientSupplier;
import io.github.jeremylong.openvulnerability.client.ghsa.GitHubSecurityAdvisoryClient;
import java.time.ZonedDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GitHubSecurityAdvisoryClientBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(GitHubSecurityAdvisoryClientBuilder.class);
    private String apiKey;
    private String endpoint;
    private String classifications;
    private ZonedDateTime updatedSince;
    private ZonedDateTime publishedSince;
    private HttpAsyncClientSupplier httpClientSupplier;

    private GitHubSecurityAdvisoryClientBuilder() {
    }

    public static GitHubSecurityAdvisoryClientBuilder aGitHubSecurityAdvisoryClient() {
        return new GitHubSecurityAdvisoryClientBuilder();
    }

    public GitHubSecurityAdvisoryClientBuilder withApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public GitHubSecurityAdvisoryClientBuilder withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public GitHubSecurityAdvisoryClientBuilder withClassifications(String classifications) {
        this.classifications = classifications;
        return this;
    }

    public GitHubSecurityAdvisoryClientBuilder withUpdatedSinceFilter(ZonedDateTime utcUpdatedSince) {
        this.updatedSince = utcUpdatedSince;
        return this;
    }

    public GitHubSecurityAdvisoryClientBuilder withPublishedSinceFilter(ZonedDateTime utcStartDate) {
        this.publishedSince = utcStartDate;
        return this;
    }

    public GitHubSecurityAdvisoryClientBuilder withHttpClientSupplier(HttpAsyncClientSupplier httpClientSupplier) {
        this.httpClientSupplier = httpClientSupplier;
        return this;
    }

    public GitHubSecurityAdvisoryClient build() {
        GitHubSecurityAdvisoryClient client = new GitHubSecurityAdvisoryClient(this.apiKey, this.endpoint, this.httpClientSupplier);
        if (this.classifications != null) {
            client.setClassifications(this.classifications);
        }
        if (this.publishedSince != null) {
            client.setPublishedSinceFilter(this.publishedSince);
        }
        if (this.updatedSince != null) {
            client.setUpdatedSinceFilter(this.updatedSince);
        }
        return client;
    }
}

