/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.impl;

import io.github.dmlloyd.classfile.Attribute;
import io.github.dmlloyd.classfile.Attributes;
import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.CodeElement;
import io.github.dmlloyd.classfile.CodeModel;
import io.github.dmlloyd.classfile.CustomAttribute;
import io.github.dmlloyd.classfile.Label;
import io.github.dmlloyd.classfile.Opcode;
import io.github.dmlloyd.classfile.TypeKind;
import io.github.dmlloyd.classfile.attribute.CharacterRangeTableAttribute;
import io.github.dmlloyd.classfile.attribute.CodeAttribute;
import io.github.dmlloyd.classfile.attribute.LineNumberTableAttribute;
import io.github.dmlloyd.classfile.attribute.LocalVariableTableAttribute;
import io.github.dmlloyd.classfile.attribute.LocalVariableTypeTableAttribute;
import io.github.dmlloyd.classfile.constantpool.ClassEntry;
import io.github.dmlloyd.classfile.constantpool.ConstantPoolBuilder;
import io.github.dmlloyd.classfile.constantpool.FieldRefEntry;
import io.github.dmlloyd.classfile.constantpool.InterfaceMethodRefEntry;
import io.github.dmlloyd.classfile.constantpool.InvokeDynamicEntry;
import io.github.dmlloyd.classfile.constantpool.LoadableConstantEntry;
import io.github.dmlloyd.classfile.constantpool.MemberRefEntry;
import io.github.dmlloyd.classfile.constantpool.MethodRefEntry;
import io.github.dmlloyd.classfile.constantpool.Utf8Entry;
import io.github.dmlloyd.classfile.impl.AbstractDirectBuilder;
import io.github.dmlloyd.classfile.impl.AbstractElement;
import io.github.dmlloyd.classfile.impl.AbstractPoolEntry;
import io.github.dmlloyd.classfile.impl.AbstractPseudoInstruction;
import io.github.dmlloyd.classfile.impl.BufWriterImpl;
import io.github.dmlloyd.classfile.impl.BufferedCodeBuilder;
import io.github.dmlloyd.classfile.impl.BytecodeHelpers;
import io.github.dmlloyd.classfile.impl.ClassFileImpl;
import io.github.dmlloyd.classfile.impl.CodeImpl;
import io.github.dmlloyd.classfile.impl.LabelContext;
import io.github.dmlloyd.classfile.impl.LabelImpl;
import io.github.dmlloyd.classfile.impl.MethodInfo;
import io.github.dmlloyd.classfile.impl.SplitConstantPool;
import io.github.dmlloyd.classfile.impl.StackCounter;
import io.github.dmlloyd.classfile.impl.StackMapGenerator;
import io.github.dmlloyd.classfile.impl.TerminalCodeBuilder;
import io.github.dmlloyd.classfile.impl.UnboundAttribute;
import io.github.dmlloyd.classfile.impl.Util;
import io.github.dmlloyd.classfile.instruction.CharacterRange;
import io.github.dmlloyd.classfile.instruction.ExceptionCatch;
import io.github.dmlloyd.classfile.instruction.LocalVariable;
import io.github.dmlloyd.classfile.instruction.LocalVariableType;
import io.github.dmlloyd.classfile.instruction.SwitchCase;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public final class DirectCodeBuilder
extends AbstractDirectBuilder<CodeModel>
implements TerminalCodeBuilder {
    private static final CharacterRange[] EMPTY_CHARACTER_RANGE = new CharacterRange[0];
    private static final LocalVariable[] EMPTY_LOCAL_VARIABLE_ARRAY = new LocalVariable[0];
    private static final LocalVariableType[] EMPTY_LOCAL_VARIABLE_TYPE_ARRAY = new LocalVariableType[0];
    private static final DeferredLabel[] EMPTY_DEFERRED_LABEL_ARRAY = new DeferredLabel[0];
    final List<AbstractPseudoInstruction.ExceptionCatchImpl> handlers = new ArrayList<AbstractPseudoInstruction.ExceptionCatchImpl>();
    private CharacterRange[] characterRanges = EMPTY_CHARACTER_RANGE;
    private LocalVariable[] localVariables = EMPTY_LOCAL_VARIABLE_ARRAY;
    private LocalVariableType[] localVariableTypes = EMPTY_LOCAL_VARIABLE_TYPE_ARRAY;
    private int characterRangesCount = 0;
    private int localVariablesCount = 0;
    private int localVariableTypesCount = 0;
    private final boolean transformDeferredJumps;
    private final boolean transformKnownJumps;
    private final Label startLabel;
    private final Label endLabel;
    final MethodInfo methodInfo;
    final BufWriterImpl bytecodesBufWriter;
    private CodeAttribute mruParent;
    private int[] mruParentTable;
    private Map<CodeAttribute, int[]> parentMap;
    private DedupLineNumberTableAttribute lineNumberWriter;
    private int topLocal;
    private DeferredLabel[] deferredLabels = EMPTY_DEFERRED_LABEL_ARRAY;
    private int deferredLabelsCount = 0;
    private int maxStackHint = -1;
    private int maxLocalsHint = -1;
    private UnboundAttribute<CodeAttribute> content = null;

    public static UnboundAttribute<CodeAttribute> build(MethodInfo methodInfo, Consumer<? super CodeBuilder> handler, SplitConstantPool constantPool, ClassFileImpl context, CodeModel original) {
        DirectCodeBuilder cb;
        try {
            cb = new DirectCodeBuilder(methodInfo, constantPool, context, original, false);
            handler.accept(cb);
            cb.buildContent();
        }
        catch (LabelOverflowException loe) {
            if (context.fixShortJumps()) {
                cb = new DirectCodeBuilder(methodInfo, constantPool, context, original, true);
                handler.accept(cb);
                cb.buildContent();
            }
            throw loe;
        }
        return cb.content;
    }

    private DirectCodeBuilder(MethodInfo methodInfo, SplitConstantPool constantPool, ClassFileImpl context, CodeModel original, boolean transformDeferredJumps) {
        super(constantPool, context);
        BufWriterImpl bufWriterImpl;
        this.setOriginal(original);
        this.methodInfo = methodInfo;
        this.transformDeferredJumps = transformDeferredJumps;
        this.transformKnownJumps = context.fixShortJumps();
        if (original instanceof CodeImpl) {
            CodeImpl cai = (CodeImpl)original;
            bufWriterImpl = new BufWriterImpl(constantPool, context, cai.codeLength());
        } else {
            bufWriterImpl = new BufWriterImpl(constantPool, context);
        }
        this.bytecodesBufWriter = bufWriterImpl;
        this.startLabel = new LabelImpl(this, 0);
        this.endLabel = new LabelImpl(this, -1);
        this.topLocal = TerminalCodeBuilder.setupTopLocal(methodInfo, original);
    }

    @Override
    public CodeBuilder with(CodeElement element) {
        if (element instanceof AbstractElement) {
            AbstractElement ae = (AbstractElement)((Object)element);
            ae.writeTo(this);
        } else {
            this.writeAttribute((CustomAttribute)Objects.requireNonNull(element));
        }
        return this;
    }

    @Override
    public Label newLabel() {
        return new LabelImpl(this, -1);
    }

    @Override
    public Label startLabel() {
        return this.startLabel;
    }

    @Override
    public Label endLabel() {
        return this.endLabel;
    }

    @Override
    public int receiverSlot() {
        return this.methodInfo.receiverSlot();
    }

    @Override
    public int parameterSlot(int paramNo) {
        return this.methodInfo.parameterSlot(paramNo);
    }

    @Override
    public int curTopLocal() {
        return this.topLocal;
    }

    @Override
    public int allocateLocal(TypeKind typeKind) {
        int retVal = this.topLocal;
        this.topLocal += typeKind.slotSize();
        return retVal;
    }

    public int curPc() {
        return this.bytecodesBufWriter.size();
    }

    public MethodInfo methodInfo() {
        return this.methodInfo;
    }

    public static void withMaxs(CodeBuilder cob, int stacks, int locals) {
        DirectCodeBuilder dcb = (DirectCodeBuilder)cob;
        dcb.maxStackHint = stacks;
        dcb.maxLocalsHint = locals;
    }

    private void writeExceptionHandlers(BufWriterImpl buf) {
        int pos = buf.size();
        int handlersSize = this.handlers.size();
        buf.writeU2(handlersSize);
        if (handlersSize > 0) {
            this.writeExceptionHandlers(buf, pos);
        }
    }

    private void writeExceptionHandlers(BufWriterImpl buf, int pos) {
        int handlersSize = this.handlers.size();
        for (AbstractPseudoInstruction.ExceptionCatchImpl h : this.handlers) {
            int startPc = this.labelToBci(h.tryStart());
            int endPc = this.labelToBci(h.tryEnd());
            int handlerPc = this.labelToBci(h.handler());
            if (startPc == -1 || endPc == -1 || handlerPc == -1) {
                if (this.context.dropDeadLabels()) {
                    --handlersSize;
                    continue;
                }
                throw new IllegalArgumentException("Unbound label in exception handler");
            }
            buf.writeU2U2U2(startPc, endPc, handlerPc);
            buf.writeIndexOrZero(h.catchTypeEntry());
            ++handlersSize;
        }
        if (handlersSize < this.handlers.size()) {
            buf.patchU2(pos, handlersSize);
        }
    }

    private void buildContent() {
        if (this.content != null) {
            return;
        }
        this.setLabelTarget(this.endLabel);
        this.processDeferredLabels();
        if (this.context.passDebugElements()) {
            UnboundAttribute.AdHocAttribute<Attribute<CharacterRangeTableAttribute>> a;
            if (this.characterRangesCount > 0) {
                a = new UnboundAttribute.AdHocAttribute<CharacterRangeTableAttribute>(Attributes.characterRangeTable()){

                    @Override
                    public void writeBody(BufWriterImpl b) {
                        int pos = b.size();
                        int crSize = DirectCodeBuilder.this.characterRangesCount;
                        b.writeU2(crSize);
                        for (int i = 0; i < DirectCodeBuilder.this.characterRangesCount; ++i) {
                            CharacterRange cr = DirectCodeBuilder.this.characterRanges[i];
                            int start = DirectCodeBuilder.this.labelToBci(cr.startScope());
                            int end = DirectCodeBuilder.this.labelToBci(cr.endScope());
                            if (start == -1 || end == -1) {
                                if (DirectCodeBuilder.this.context.dropDeadLabels()) {
                                    --crSize;
                                    continue;
                                }
                                throw new IllegalArgumentException("Unbound label in character range");
                            }
                            b.writeU2U2(start, end - 1);
                            b.writeIntInt(cr.characterRangeStart(), cr.characterRangeEnd());
                            b.writeU2(cr.flags());
                        }
                        if (crSize < DirectCodeBuilder.this.characterRangesCount) {
                            b.patchU2(pos, crSize);
                        }
                    }

                    @Override
                    public Utf8Entry attributeName() {
                        return DirectCodeBuilder.this.constantPool.utf8Entry("CharacterRangeTable");
                    }
                };
                this.attributes.withAttribute(a);
            }
            if (this.localVariablesCount > 0) {
                a = new UnboundAttribute.AdHocAttribute<LocalVariableTableAttribute>(Attributes.localVariableTable()){

                    @Override
                    public void writeBody(BufWriterImpl b) {
                        int pos = b.size();
                        int lvSize = DirectCodeBuilder.this.localVariablesCount;
                        b.writeU2(lvSize);
                        for (int i = 0; i < DirectCodeBuilder.this.localVariablesCount; ++i) {
                            LocalVariable l = DirectCodeBuilder.this.localVariables[i];
                            if (Util.writeLocalVariable(b, l)) continue;
                            if (DirectCodeBuilder.this.context.dropDeadLabels()) {
                                --lvSize;
                                continue;
                            }
                            throw new IllegalArgumentException("Unbound label in local variable type");
                        }
                        if (lvSize < DirectCodeBuilder.this.localVariablesCount) {
                            b.patchU2(pos, lvSize);
                        }
                    }

                    @Override
                    public Utf8Entry attributeName() {
                        return DirectCodeBuilder.this.constantPool.utf8Entry("LocalVariableTable");
                    }
                };
                this.attributes.withAttribute(a);
            }
            if (this.localVariableTypesCount > 0) {
                a = new UnboundAttribute.AdHocAttribute<LocalVariableTypeTableAttribute>(Attributes.localVariableTypeTable()){

                    @Override
                    public void writeBody(BufWriterImpl b) {
                        int pos = b.size();
                        int lvtSize = DirectCodeBuilder.this.localVariableTypesCount;
                        b.writeU2(lvtSize);
                        for (int i = 0; i < DirectCodeBuilder.this.localVariableTypesCount; ++i) {
                            LocalVariableType l = DirectCodeBuilder.this.localVariableTypes[i];
                            if (Util.writeLocalVariable(b, l)) continue;
                            if (DirectCodeBuilder.this.context.dropDeadLabels()) {
                                --lvtSize;
                                continue;
                            }
                            throw new IllegalArgumentException("Unbound label in local variable type");
                        }
                        if (lvtSize < DirectCodeBuilder.this.localVariableTypesCount) {
                            b.patchU2(pos, lvtSize);
                        }
                    }

                    @Override
                    public Utf8Entry attributeName() {
                        return DirectCodeBuilder.this.constantPool.utf8Entry("LocalVariableTypeTable");
                    }
                };
                this.attributes.withAttribute(a);
            }
        }
        if (this.lineNumberWriter != null) {
            this.attributes.withAttribute(this.lineNumberWriter);
        }
        this.content = new UnboundAttribute.AdHocAttribute<CodeAttribute>(Attributes.code()){

            private void writeCounters(boolean codeMatch, BufWriterImpl buf) {
                if (codeMatch) {
                    CodeImpl originalAttribute = (CodeImpl)DirectCodeBuilder.this.original;
                    buf.writeU2U2(originalAttribute.maxStack(), originalAttribute.maxLocals());
                } else if (DirectCodeBuilder.this.maxLocalsHint >= 0 && DirectCodeBuilder.this.maxStackHint >= 0) {
                    buf.writeU2U2(DirectCodeBuilder.this.maxStackHint, DirectCodeBuilder.this.maxLocalsHint);
                } else {
                    StackCounter cntr = StackCounter.of(DirectCodeBuilder.this, buf);
                    buf.writeU2U2(cntr.maxStack(), cntr.maxLocals());
                }
            }

            private void generateStackMaps(BufWriterImpl buf) throws IllegalArgumentException {
                DirectCodeBuilder dcb = DirectCodeBuilder.this;
                StackMapGenerator gen = StackMapGenerator.of(dcb, buf);
                dcb.attributes.withAttribute(gen.stackMapTableAttribute());
                buf.writeU2U2(gen.maxStack(), gen.maxLocals());
            }

            private void tryGenerateStackMaps(boolean codeMatch, BufWriterImpl buf) {
                if (buf.getMajorVersion() >= 50) {
                    try {
                        this.generateStackMaps(buf);
                    }
                    catch (IllegalArgumentException e) {
                        if (buf.getMajorVersion() == 50) {
                            this.writeCounters(codeMatch, buf);
                        }
                        throw e;
                    }
                } else {
                    this.writeCounters(codeMatch, buf);
                }
            }

            @Override
            public void writeBody(BufWriterImpl buf) {
                DirectCodeBuilder dcb = DirectCodeBuilder.this;
                int codeLength = DirectCodeBuilder.this.curPc();
                if (codeLength == 0 || codeLength >= 65536) {
                    throw new IllegalArgumentException(String.format("Code length %d is outside the allowed range in %s%s", codeLength, dcb.methodInfo.methodName().stringValue(), dcb.methodInfo.methodTypeSymbol().displayDescriptor()));
                }
                boolean codeMatch = dcb.original != null && DirectCodeBuilder.this.codeAndExceptionsMatch(codeLength);
                buf.setLabelContext(dcb, codeMatch);
                ClassFileImpl context = dcb.context;
                if (context.stackMapsWhenRequired()) {
                    if (codeMatch) {
                        dcb.attributes.withAttribute(((CodeModel)dcb.original).findAttribute(Attributes.stackMapTable()).orElse(null));
                        this.writeCounters(true, buf);
                    } else {
                        this.tryGenerateStackMaps(false, buf);
                    }
                } else if (context.generateStackMaps()) {
                    this.generateStackMaps(buf);
                } else if (context.dropStackMaps()) {
                    this.writeCounters(codeMatch, buf);
                }
                buf.writeInt(codeLength);
                buf.writeBytes(dcb.bytecodesBufWriter);
                dcb.writeExceptionHandlers(buf);
                dcb.attributes.writeTo(buf);
                buf.setLabelContext(null, false);
            }

            @Override
            public Utf8Entry attributeName() {
                return DirectCodeBuilder.this.constantPool.utf8Entry("Code");
            }
        };
    }

    private boolean codeAndExceptionsMatch(int codeLength) {
        boolean codeAttributesMatch;
        CodeImpl cai;
        Object object = this.original;
        if (object instanceof CodeImpl && this.canWriteDirect((cai = (CodeImpl)object).constantPool())) {
            boolean bl = codeAttributesMatch = cai.codeLength == this.curPc() && cai.compareCodeBytes(this.bytecodesBufWriter, 0, codeLength);
            if (codeAttributesMatch) {
                BufWriterImpl bw = new BufWriterImpl(this.constantPool, this.context);
                this.writeExceptionHandlers(bw);
                codeAttributesMatch = cai.classReader.compare(bw, 0, cai.exceptionHandlerPos, bw.size());
            }
        } else {
            codeAttributesMatch = false;
        }
        return codeAttributesMatch;
    }

    private void processDeferredLabels() {
        for (int i = 0; i < this.deferredLabelsCount; ++i) {
            DeferredLabel dl = this.deferredLabels[i];
            int branchOffset = this.labelToBci(dl.label) - dl.instructionPc;
            if (dl.size == 2) {
                if ((short)branchOffset != branchOffset) {
                    throw new LabelOverflowException();
                }
                this.bytecodesBufWriter.patchU2(dl.labelPc, branchOffset);
                continue;
            }
            assert (dl.size == 4);
            this.bytecodesBufWriter.patchInt(dl.labelPc, branchOffset);
        }
    }

    public void writeBytecode(Opcode opcode) {
        assert (!opcode.isWide());
        this.bytecodesBufWriter.writeU1(opcode.bytecode());
    }

    public void writeLocalVar(Opcode opcode, int slot) {
        if (opcode.isWide()) {
            this.bytecodesBufWriter.writeU2U2(opcode.bytecode(), slot);
        } else {
            this.bytecodesBufWriter.writeU1U1(opcode.bytecode(), slot);
        }
    }

    private void writeLocalVar(int bytecode, int slot) {
        if (slot < 256) {
            this.bytecodesBufWriter.writeU1U1(bytecode, slot);
        } else {
            this.bytecodesBufWriter.writeU1U1U2(196, bytecode, slot);
        }
    }

    public void writeIncrement(boolean wide, int slot, int val) {
        if (wide) {
            this.bytecodesBufWriter.writeU2U2U2(50308, slot, val);
        } else {
            this.bytecodesBufWriter.writeU1U1U1(132, slot, val);
        }
    }

    public void writeBranch(Opcode op, Label target) {
        if (op.sizeIfFixed() == 3) {
            this.writeShortJump(op.bytecode(), target);
        } else {
            this.writeLongJump(op.bytecode(), target);
        }
    }

    private void writeLongLabelOffset(int instructionPc, Label label) {
        Label nullOrTarget;
        int jumpOrInstructionPc;
        int targetBci = this.labelToBci(label);
        if (targetBci == -1) {
            jumpOrInstructionPc = instructionPc;
            nullOrTarget = label;
        } else {
            jumpOrInstructionPc = targetBci - instructionPc;
            nullOrTarget = null;
        }
        this.writeParsedLongLabel(jumpOrInstructionPc, nullOrTarget);
    }

    private void writeShortJump(int bytecode, Label target) {
        Label nullOrTarget;
        int jumpOrInstructionPc;
        int instructionPc = this.curPc();
        int targetBci = this.labelToBci(target);
        if (targetBci == -1) {
            jumpOrInstructionPc = instructionPc;
            nullOrTarget = target;
        } else {
            jumpOrInstructionPc = targetBci - instructionPc;
            nullOrTarget = null;
        }
        if (this.transformDeferredJumps || this.transformKnownJumps && nullOrTarget == null && jumpOrInstructionPc < Short.MIN_VALUE) {
            this.fixShortJump(bytecode, jumpOrInstructionPc, nullOrTarget);
        } else {
            this.bytecodesBufWriter.writeU1(bytecode);
            this.writeParsedShortLabel(jumpOrInstructionPc, nullOrTarget);
        }
    }

    private void writeLongJump(int bytecode, Label target) {
        int instructionPc = this.curPc();
        this.bytecodesBufWriter.writeU1(bytecode);
        this.writeLongLabelOffset(instructionPc, target);
    }

    private void fixShortJump(int bytecode, int jumpOrInstructionPc, Label nullOrTarget) {
        if (bytecode == 167) {
            this.bytecodesBufWriter.writeU1(200);
            this.writeParsedLongLabel(jumpOrInstructionPc, nullOrTarget);
        } else if (bytecode == 168) {
            this.bytecodesBufWriter.writeU1(201);
            this.writeParsedLongLabel(jumpOrInstructionPc, nullOrTarget);
        } else {
            this.bytecodesBufWriter.writeU1U2(BytecodeHelpers.reverseBranchOpcode(bytecode), 8);
            this.bytecodesBufWriter.writeU1(200);
            jumpOrInstructionPc = nullOrTarget == null ? (jumpOrInstructionPc -= 3) : (jumpOrInstructionPc += 3);
            this.writeParsedLongLabel(jumpOrInstructionPc, nullOrTarget);
        }
    }

    private void writeParsedShortLabel(int jumpOrInstructionPc, Label nullOrTarget) {
        if (nullOrTarget == null) {
            if ((short)jumpOrInstructionPc != jumpOrInstructionPc) {
                throw new LabelOverflowException();
            }
            this.bytecodesBufWriter.writeU2(jumpOrInstructionPc);
        } else {
            int pc = this.bytecodesBufWriter.skip(2);
            this.addLabel(new DeferredLabel(pc, 2, jumpOrInstructionPc, nullOrTarget));
        }
    }

    private void writeParsedLongLabel(int jumpOrInstructionPc, Label nullOrTarget) {
        if (nullOrTarget == null) {
            this.bytecodesBufWriter.writeInt(jumpOrInstructionPc);
        } else {
            int pc = this.bytecodesBufWriter.skip(4);
            this.addLabel(new DeferredLabel(pc, 4, jumpOrInstructionPc, nullOrTarget));
        }
    }

    public void writeLookupSwitch(Label defaultTarget, List<SwitchCase> cases) {
        int instructionPc = this.curPc();
        this.bytecodesBufWriter.writeU1(171);
        int pad = 4 - this.curPc() % 4;
        if (pad != 4) {
            this.bytecodesBufWriter.skip(pad);
        }
        this.writeLongLabelOffset(instructionPc, defaultTarget);
        this.bytecodesBufWriter.writeInt(cases.size());
        cases = new ArrayList<SwitchCase>(cases);
        cases.sort(new Comparator<SwitchCase>(){

            @Override
            public int compare(SwitchCase c1, SwitchCase c2) {
                return Integer.compare(c1.caseValue(), c2.caseValue());
            }
        });
        for (SwitchCase c : cases) {
            this.bytecodesBufWriter.writeInt(c.caseValue());
            Label target = c.target();
            this.writeLongLabelOffset(instructionPc, target);
        }
    }

    public void writeTableSwitch(int low, int high, Label defaultTarget, List<SwitchCase> cases) {
        int instructionPc = this.curPc();
        this.bytecodesBufWriter.writeU1(170);
        int pad = 4 - this.curPc() % 4;
        if (pad != 4) {
            this.bytecodesBufWriter.skip(pad);
        }
        this.writeLongLabelOffset(instructionPc, defaultTarget);
        this.bytecodesBufWriter.writeIntInt(low, high);
        HashMap<Integer, Label> caseMap = new HashMap<Integer, Label>(cases.size());
        for (SwitchCase c : cases) {
            caseMap.put(c.caseValue(), c.target());
        }
        for (long l = (long)low; l <= (long)high; ++l) {
            Label target = caseMap.getOrDefault((int)l, defaultTarget);
            this.writeLongLabelOffset(instructionPc, target);
        }
    }

    public void writeFieldAccess(Opcode opcode, FieldRefEntry ref) {
        this.bytecodesBufWriter.writeIndex(opcode.bytecode(), ref);
    }

    public void writeInvokeNormal(Opcode opcode, MemberRefEntry ref) {
        this.bytecodesBufWriter.writeIndex(opcode.bytecode(), ref);
    }

    public void writeInvokeInterface(Opcode opcode, InterfaceMethodRefEntry ref, int count) {
        this.bytecodesBufWriter.writeIndex(opcode.bytecode(), ref);
        this.bytecodesBufWriter.writeU1U1(count, 0);
    }

    public void writeInvokeDynamic(InvokeDynamicEntry ref) {
        this.bytecodesBufWriter.writeU1U2U2(186, this.bytecodesBufWriter.cpIndex(ref), 0);
    }

    public void writeNewObject(ClassEntry type) {
        this.bytecodesBufWriter.writeIndex(187, type);
    }

    public void writeNewPrimitiveArray(int newArrayCode) {
        this.bytecodesBufWriter.writeU1U1(188, newArrayCode);
    }

    public void writeNewReferenceArray(ClassEntry type) {
        this.bytecodesBufWriter.writeIndex(189, type);
    }

    public void writeNewMultidimensionalArray(int dimensions, ClassEntry type) {
        this.bytecodesBufWriter.writeIndex(197, type);
        this.bytecodesBufWriter.writeU1(dimensions);
    }

    public void writeTypeCheck(Opcode opcode, ClassEntry type) {
        this.bytecodesBufWriter.writeIndex(opcode.bytecode(), type);
    }

    public void writeArgumentConstant(Opcode opcode, int value) {
        if (opcode.sizeIfFixed() == 3) {
            this.bytecodesBufWriter.writeU1U2(opcode.bytecode(), value);
        } else {
            this.bytecodesBufWriter.writeU1U1(opcode.bytecode(), value);
        }
    }

    public void writeAdaptLoadConstant(Opcode opcode, LoadableConstantEntry value) {
        LoadableConstantEntry pe = AbstractPoolEntry.maybeClone(this.constantPool, value);
        int index = pe.index();
        if (pe != value && opcode != Opcode.LDC2_W) {
            opcode = index <= 255 ? Opcode.LDC : Opcode.LDC_W;
        }
        this.writeDirectLoadConstant(opcode, pe);
    }

    public void writeDirectLoadConstant(Opcode opcode, LoadableConstantEntry pe) {
        assert (!opcode.isWide() && this.canWriteDirect(pe.constantPool()));
        int index = pe.index();
        if (opcode.sizeIfFixed() == 3) {
            this.bytecodesBufWriter.writeU1U2(opcode.bytecode(), index);
        } else {
            this.bytecodesBufWriter.writeU1U1(opcode.bytecode(), index);
        }
    }

    @Override
    public Label getLabel(int bci) {
        throw new UnsupportedOperationException("Lookup by BCI not supported by CodeBuilder");
    }

    @Override
    public int labelToBci(Label label) {
        LabelImpl lab = (LabelImpl)label;
        LabelContext context = lab.labelContext();
        if (context == this) {
            return lab.getBCI();
        }
        return this.labelToBci(context, lab);
    }

    private int labelToBci(LabelContext context, LabelImpl lab) {
        if (context == this.mruParent) {
            return this.mruParentTable[lab.getBCI()] - 1;
        }
        if (context instanceof CodeAttribute) {
            final CodeAttribute parent = (CodeAttribute)((Object)context);
            if (this.parentMap == null) {
                this.parentMap = new IdentityHashMap<CodeAttribute, int[]>();
            }
            int[] table = this.parentMap.computeIfAbsent(parent, new Function<CodeAttribute, int[]>(){

                @Override
                public int[] apply(CodeAttribute x) {
                    return new int[parent.codeLength() + 1];
                }
            });
            this.mruParent = parent;
            this.mruParentTable = table;
            return this.mruParentTable[lab.getBCI()] - 1;
        }
        if (context instanceof BufferedCodeBuilder) {
            return lab.getBCI();
        }
        throw new IllegalStateException(String.format("Unexpected label context %s in =%s", context, this));
    }

    public void setLineNumber(int lineNo) {
        if (this.lineNumberWriter == null) {
            this.lineNumberWriter = new DedupLineNumberTableAttribute(this.constantPool, this.context);
        }
        this.lineNumberWriter.writeLineNumber(this.curPc(), lineNo);
    }

    public void setLabelTarget(Label label) {
        this.setLabelTarget(label, this.curPc());
    }

    @Override
    public void setLabelTarget(Label label, int bci) {
        LabelImpl lab = (LabelImpl)label;
        if (lab.labelContext() == this) {
            if (lab.getBCI() != -1) {
                throw new IllegalArgumentException("Setting label target for already-set label");
            }
            lab.setBCI(bci);
        } else {
            this.setLabelTarget(lab, bci);
        }
    }

    private void setLabelTarget(LabelImpl lab, int bci) {
        LabelContext context = lab.labelContext();
        if (context == this.mruParent) {
            this.mruParentTable[lab.getBCI()] = bci + 1;
        } else if (context instanceof CodeAttribute) {
            final CodeAttribute parent = (CodeAttribute)((Object)context);
            if (this.parentMap == null) {
                this.parentMap = new IdentityHashMap<CodeAttribute, int[]>();
            }
            int[] table = this.parentMap.computeIfAbsent(parent, new Function<CodeAttribute, int[]>(){

                @Override
                public int[] apply(CodeAttribute x) {
                    return new int[parent.codeLength() + 1];
                }
            });
            this.mruParent = parent;
            this.mruParentTable = table;
            table[lab.getBCI()] = bci + 1;
        } else if (context instanceof BufferedCodeBuilder) {
            lab.setBCI(bci);
        } else {
            throw new IllegalStateException(String.format("Unexpected label context %s in =%s", context, this));
        }
    }

    public void addCharacterRange(CharacterRange element) {
        if (this.characterRangesCount >= this.characterRanges.length) {
            int newCapacity = this.characterRangesCount + 8;
            this.characterRanges = Arrays.copyOf(this.characterRanges, newCapacity);
        }
        this.characterRanges[this.characterRangesCount++] = element;
    }

    public void addLabel(DeferredLabel label) {
        if (this.deferredLabelsCount >= this.deferredLabels.length) {
            int newCapacity = this.deferredLabelsCount + 8;
            this.deferredLabels = Arrays.copyOf(this.deferredLabels, newCapacity);
        }
        this.deferredLabels[this.deferredLabelsCount++] = label;
    }

    public void addHandler(ExceptionCatch element) {
        AbstractPseudoInstruction.ExceptionCatchImpl el = (AbstractPseudoInstruction.ExceptionCatchImpl)element;
        ClassEntry type = el.catchTypeEntry();
        if (type != null && !this.constantPool.canWriteDirect(type.constantPool())) {
            el = new AbstractPseudoInstruction.ExceptionCatchImpl(element.handler(), element.tryStart(), element.tryEnd(), AbstractPoolEntry.maybeClone(this.constantPool, type));
        }
        this.handlers.add(el);
    }

    public void addLocalVariable(LocalVariable element) {
        if (this.localVariablesCount >= this.localVariables.length) {
            int newCapacity = this.localVariablesCount + 8;
            this.localVariables = Arrays.copyOf(this.localVariables, newCapacity);
        }
        this.localVariables[this.localVariablesCount++] = element;
    }

    public void addLocalVariableType(LocalVariableType element) {
        if (this.localVariableTypesCount >= this.localVariableTypes.length) {
            int newCapacity = this.localVariableTypesCount + 8;
            this.localVariableTypes = Arrays.copyOf(this.localVariableTypes, newCapacity);
        }
        this.localVariableTypes[this.localVariableTypesCount++] = element;
    }

    public String toString() {
        return String.format("CodeBuilder[id=%d]", System.identityHashCode(this));
    }

    @Override
    public CodeBuilder return_() {
        this.bytecodesBufWriter.writeU1(177);
        return this;
    }

    @Override
    public CodeBuilder return_(TypeKind tk) {
        this.bytecodesBufWriter.writeU1(BytecodeHelpers.returnBytecode(tk));
        return this;
    }

    @Override
    public CodeBuilder storeLocal(TypeKind tk, int slot) {
        return switch (tk) {
            default -> throw new IncompatibleClassChangeError();
            case TypeKind.INT, TypeKind.SHORT, TypeKind.BYTE, TypeKind.CHAR, TypeKind.BOOLEAN -> this.istore(slot);
            case TypeKind.LONG -> this.lstore(slot);
            case TypeKind.DOUBLE -> this.dstore(slot);
            case TypeKind.FLOAT -> this.fstore(slot);
            case TypeKind.REFERENCE -> this.astore(slot);
            case TypeKind.VOID -> throw new IllegalArgumentException("void");
        };
    }

    @Override
    public CodeBuilder labelBinding(Label label) {
        this.setLabelTarget(label, this.curPc());
        return this;
    }

    @Override
    public CodeBuilder loadLocal(TypeKind tk, int slot) {
        return switch (tk) {
            default -> throw new IncompatibleClassChangeError();
            case TypeKind.INT, TypeKind.SHORT, TypeKind.BYTE, TypeKind.CHAR, TypeKind.BOOLEAN -> this.iload(slot);
            case TypeKind.LONG -> this.lload(slot);
            case TypeKind.DOUBLE -> this.dload(slot);
            case TypeKind.FLOAT -> this.fload(slot);
            case TypeKind.REFERENCE -> this.aload(slot);
            case TypeKind.VOID -> throw new IllegalArgumentException("void");
        };
    }

    @Override
    public CodeBuilder invoke(Opcode opcode, MemberRefEntry ref) {
        if (opcode == Opcode.INVOKEINTERFACE) {
            int slots = Util.parameterSlots(Util.methodTypeSymbol(ref.type())) + 1;
            this.writeInvokeInterface(opcode, (InterfaceMethodRefEntry)ref, slots);
        } else {
            this.writeInvokeNormal(opcode, ref);
        }
        return this;
    }

    @Override
    public CodeBuilder invokespecial(ClassDesc owner, String name, MethodTypeDesc type) {
        this.bytecodesBufWriter.writeIndex(183, this.constantPool().methodRefEntry(owner, name, type));
        return this;
    }

    @Override
    public CodeBuilder invokestatic(ClassDesc owner, String name, MethodTypeDesc type) {
        this.bytecodesBufWriter.writeIndex(184, this.constantPool().methodRefEntry(owner, name, type));
        return this;
    }

    @Override
    public CodeBuilder invokevirtual(ClassDesc owner, String name, MethodTypeDesc type) {
        this.bytecodesBufWriter.writeIndex(182, this.constantPool().methodRefEntry(owner, name, type));
        return this;
    }

    @Override
    public CodeBuilder getfield(ClassDesc owner, String name, ClassDesc type) {
        this.bytecodesBufWriter.writeIndex(180, this.constantPool().fieldRefEntry(owner, name, type));
        return this;
    }

    @Override
    public CodeBuilder fieldAccess(Opcode opcode, FieldRefEntry ref) {
        this.bytecodesBufWriter.writeIndex(opcode.bytecode(), ref);
        return this;
    }

    @Override
    public CodeBuilder arrayLoad(TypeKind tk) {
        this.bytecodesBufWriter.writeU1(BytecodeHelpers.arrayLoadBytecode(tk));
        return this;
    }

    @Override
    public CodeBuilder arrayStore(TypeKind tk) {
        this.bytecodesBufWriter.writeU1(BytecodeHelpers.arrayStoreBytecode(tk));
        return this;
    }

    @Override
    public CodeBuilder branch(Opcode op, Label target) {
        this.writeBranch(op, target);
        return this;
    }

    @Override
    public CodeBuilder nop() {
        this.bytecodesBufWriter.writeU1(0);
        return this;
    }

    @Override
    public CodeBuilder aconst_null() {
        this.bytecodesBufWriter.writeU1(1);
        return this;
    }

    @Override
    public CodeBuilder aload(int slot) {
        if (slot >= 0 && slot <= 3) {
            this.bytecodesBufWriter.writeU1(42 + slot);
        } else {
            this.writeLocalVar(25, slot);
        }
        return this;
    }

    @Override
    public CodeBuilder anewarray(ClassEntry entry) {
        this.writeNewReferenceArray(entry);
        return this;
    }

    @Override
    public CodeBuilder arraylength() {
        this.bytecodesBufWriter.writeU1(190);
        return this;
    }

    @Override
    public CodeBuilder areturn() {
        this.bytecodesBufWriter.writeU1(176);
        return this;
    }

    @Override
    public CodeBuilder astore(int slot) {
        if (slot >= 0 && slot <= 3) {
            this.bytecodesBufWriter.writeU1(75 + slot);
        } else {
            this.writeLocalVar(58, slot);
        }
        return this;
    }

    @Override
    public CodeBuilder athrow() {
        this.bytecodesBufWriter.writeU1(191);
        return this;
    }

    @Override
    public CodeBuilder bipush(int b) {
        BytecodeHelpers.validateBipush(b);
        this.bytecodesBufWriter.writeU1U1(16, b);
        return this;
    }

    @Override
    public CodeBuilder checkcast(ClassEntry type) {
        this.bytecodesBufWriter.writeIndex(192, type);
        return this;
    }

    @Override
    public CodeBuilder d2f() {
        this.bytecodesBufWriter.writeU1(144);
        return this;
    }

    @Override
    public CodeBuilder d2i() {
        this.bytecodesBufWriter.writeU1(142);
        return this;
    }

    @Override
    public CodeBuilder d2l() {
        this.bytecodesBufWriter.writeU1(143);
        return this;
    }

    @Override
    public CodeBuilder dadd() {
        this.bytecodesBufWriter.writeU1(99);
        return this;
    }

    @Override
    public CodeBuilder dcmpg() {
        this.bytecodesBufWriter.writeU1(152);
        return this;
    }

    @Override
    public CodeBuilder dcmpl() {
        this.bytecodesBufWriter.writeU1(151);
        return this;
    }

    @Override
    public CodeBuilder dconst_0() {
        this.bytecodesBufWriter.writeU1(14);
        return this;
    }

    @Override
    public CodeBuilder dconst_1() {
        this.bytecodesBufWriter.writeU1(15);
        return this;
    }

    @Override
    public CodeBuilder ddiv() {
        this.bytecodesBufWriter.writeU1(111);
        return this;
    }

    @Override
    public CodeBuilder dload(int slot) {
        if (slot >= 0 && slot <= 3) {
            this.bytecodesBufWriter.writeU1(38 + slot);
        } else {
            this.writeLocalVar(24, slot);
        }
        return this;
    }

    @Override
    public CodeBuilder dmul() {
        this.bytecodesBufWriter.writeU1(107);
        return this;
    }

    @Override
    public CodeBuilder dneg() {
        this.bytecodesBufWriter.writeU1(119);
        return this;
    }

    @Override
    public CodeBuilder drem() {
        this.bytecodesBufWriter.writeU1(115);
        return this;
    }

    @Override
    public CodeBuilder dreturn() {
        this.bytecodesBufWriter.writeU1(175);
        return this;
    }

    @Override
    public CodeBuilder dstore(int slot) {
        if (slot >= 0 && slot <= 3) {
            this.bytecodesBufWriter.writeU1(71 + slot);
        } else {
            this.writeLocalVar(57, slot);
        }
        return this;
    }

    @Override
    public CodeBuilder dsub() {
        this.bytecodesBufWriter.writeU1(103);
        return this;
    }

    @Override
    public CodeBuilder dup() {
        this.bytecodesBufWriter.writeU1(89);
        return this;
    }

    @Override
    public CodeBuilder dup2() {
        this.bytecodesBufWriter.writeU1(92);
        return this;
    }

    @Override
    public CodeBuilder dup2_x1() {
        this.bytecodesBufWriter.writeU1(93);
        return this;
    }

    @Override
    public CodeBuilder dup2_x2() {
        this.bytecodesBufWriter.writeU1(94);
        return this;
    }

    @Override
    public CodeBuilder dup_x1() {
        this.bytecodesBufWriter.writeU1(90);
        return this;
    }

    @Override
    public CodeBuilder dup_x2() {
        this.bytecodesBufWriter.writeU1(91);
        return this;
    }

    @Override
    public CodeBuilder f2d() {
        this.bytecodesBufWriter.writeU1(141);
        return this;
    }

    @Override
    public CodeBuilder f2i() {
        this.bytecodesBufWriter.writeU1(139);
        return this;
    }

    @Override
    public CodeBuilder f2l() {
        this.bytecodesBufWriter.writeU1(140);
        return this;
    }

    @Override
    public CodeBuilder fadd() {
        this.bytecodesBufWriter.writeU1(98);
        return this;
    }

    @Override
    public CodeBuilder fcmpg() {
        this.bytecodesBufWriter.writeU1(150);
        return this;
    }

    @Override
    public CodeBuilder fcmpl() {
        this.bytecodesBufWriter.writeU1(149);
        return this;
    }

    @Override
    public CodeBuilder fconst_0() {
        this.bytecodesBufWriter.writeU1(11);
        return this;
    }

    @Override
    public CodeBuilder fconst_1() {
        this.bytecodesBufWriter.writeU1(12);
        return this;
    }

    @Override
    public CodeBuilder fconst_2() {
        this.bytecodesBufWriter.writeU1(13);
        return this;
    }

    @Override
    public CodeBuilder fdiv() {
        this.bytecodesBufWriter.writeU1(110);
        return this;
    }

    @Override
    public CodeBuilder fload(int slot) {
        if (slot >= 0 && slot <= 3) {
            this.bytecodesBufWriter.writeU1(34 + slot);
        } else {
            this.writeLocalVar(23, slot);
        }
        return this;
    }

    @Override
    public CodeBuilder fmul() {
        this.bytecodesBufWriter.writeU1(106);
        return this;
    }

    @Override
    public CodeBuilder fneg() {
        this.bytecodesBufWriter.writeU1(118);
        return this;
    }

    @Override
    public CodeBuilder frem() {
        this.bytecodesBufWriter.writeU1(114);
        return this;
    }

    @Override
    public CodeBuilder freturn() {
        this.bytecodesBufWriter.writeU1(174);
        return this;
    }

    @Override
    public CodeBuilder fstore(int slot) {
        if (slot >= 0 && slot <= 3) {
            this.bytecodesBufWriter.writeU1(67 + slot);
        } else {
            this.writeLocalVar(56, slot);
        }
        return this;
    }

    @Override
    public CodeBuilder fsub() {
        this.bytecodesBufWriter.writeU1(102);
        return this;
    }

    @Override
    public CodeBuilder getstatic(ClassDesc owner, String name, ClassDesc type) {
        this.bytecodesBufWriter.writeIndex(178, this.constantPool().fieldRefEntry(owner, name, type));
        return this;
    }

    @Override
    public CodeBuilder goto_(Label target) {
        this.writeShortJump(167, target);
        return this;
    }

    @Override
    public CodeBuilder i2b() {
        this.bytecodesBufWriter.writeU1(145);
        return this;
    }

    @Override
    public CodeBuilder i2c() {
        this.bytecodesBufWriter.writeU1(146);
        return this;
    }

    @Override
    public CodeBuilder i2d() {
        this.bytecodesBufWriter.writeU1(135);
        return this;
    }

    @Override
    public CodeBuilder i2f() {
        this.bytecodesBufWriter.writeU1(134);
        return this;
    }

    @Override
    public CodeBuilder i2l() {
        this.bytecodesBufWriter.writeU1(133);
        return this;
    }

    @Override
    public CodeBuilder i2s() {
        this.bytecodesBufWriter.writeU1(147);
        return this;
    }

    @Override
    public CodeBuilder iadd() {
        this.bytecodesBufWriter.writeU1(96);
        return this;
    }

    @Override
    public CodeBuilder iand() {
        this.bytecodesBufWriter.writeU1(126);
        return this;
    }

    @Override
    public CodeBuilder iconst_0() {
        this.bytecodesBufWriter.writeU1(3);
        return this;
    }

    @Override
    public CodeBuilder iconst_1() {
        this.bytecodesBufWriter.writeU1(4);
        return this;
    }

    @Override
    public CodeBuilder iconst_2() {
        this.bytecodesBufWriter.writeU1(5);
        return this;
    }

    @Override
    public CodeBuilder iconst_3() {
        this.bytecodesBufWriter.writeU1(6);
        return this;
    }

    @Override
    public CodeBuilder iconst_4() {
        this.bytecodesBufWriter.writeU1(7);
        return this;
    }

    @Override
    public CodeBuilder iconst_5() {
        this.bytecodesBufWriter.writeU1(8);
        return this;
    }

    @Override
    public CodeBuilder iconst_m1() {
        this.bytecodesBufWriter.writeU1(2);
        return this;
    }

    @Override
    public CodeBuilder idiv() {
        this.bytecodesBufWriter.writeU1(108);
        return this;
    }

    @Override
    public CodeBuilder if_acmpeq(Label target) {
        this.writeShortJump(165, target);
        return this;
    }

    @Override
    public CodeBuilder if_acmpne(Label target) {
        this.writeShortJump(166, target);
        return this;
    }

    @Override
    public CodeBuilder if_icmpeq(Label target) {
        this.writeShortJump(159, target);
        return this;
    }

    @Override
    public CodeBuilder if_icmpge(Label target) {
        this.writeShortJump(162, target);
        return this;
    }

    @Override
    public CodeBuilder if_icmpgt(Label target) {
        this.writeShortJump(163, target);
        return this;
    }

    @Override
    public CodeBuilder if_icmple(Label target) {
        this.writeShortJump(164, target);
        return this;
    }

    @Override
    public CodeBuilder if_icmplt(Label target) {
        this.writeShortJump(161, target);
        return this;
    }

    @Override
    public CodeBuilder if_icmpne(Label target) {
        this.writeShortJump(160, target);
        return this;
    }

    @Override
    public CodeBuilder ifnonnull(Label target) {
        this.writeShortJump(199, target);
        return this;
    }

    @Override
    public CodeBuilder ifnull(Label target) {
        this.writeShortJump(198, target);
        return this;
    }

    @Override
    public CodeBuilder ifeq(Label target) {
        this.writeShortJump(153, target);
        return this;
    }

    @Override
    public CodeBuilder ifge(Label target) {
        this.writeShortJump(156, target);
        return this;
    }

    @Override
    public CodeBuilder ifgt(Label target) {
        this.writeShortJump(157, target);
        return this;
    }

    @Override
    public CodeBuilder ifle(Label target) {
        this.writeShortJump(158, target);
        return this;
    }

    @Override
    public CodeBuilder iflt(Label target) {
        this.writeShortJump(155, target);
        return this;
    }

    @Override
    public CodeBuilder ifne(Label target) {
        this.writeShortJump(154, target);
        return this;
    }

    @Override
    public CodeBuilder iinc(int slot, int val) {
        this.writeIncrement(BytecodeHelpers.validateAndIsWideIinc(slot, val), slot, val);
        return this;
    }

    @Override
    public CodeBuilder iload(int slot) {
        if (slot >= 0 && slot <= 3) {
            this.bytecodesBufWriter.writeU1(26 + slot);
        } else {
            this.writeLocalVar(21, slot);
        }
        return this;
    }

    @Override
    public CodeBuilder imul() {
        this.bytecodesBufWriter.writeU1(104);
        return this;
    }

    @Override
    public CodeBuilder ineg() {
        this.bytecodesBufWriter.writeU1(116);
        return this;
    }

    @Override
    public CodeBuilder instanceOf(ClassEntry target) {
        this.bytecodesBufWriter.writeIndex(193, target);
        return this;
    }

    @Override
    public CodeBuilder invokedynamic(InvokeDynamicEntry ref) {
        this.writeInvokeDynamic(ref);
        return this;
    }

    @Override
    public CodeBuilder invokeinterface(InterfaceMethodRefEntry ref) {
        this.writeInvokeInterface(Opcode.INVOKEINTERFACE, ref, Util.parameterSlots(ref.typeSymbol()) + 1);
        return this;
    }

    @Override
    public CodeBuilder invokespecial(InterfaceMethodRefEntry ref) {
        this.bytecodesBufWriter.writeIndex(183, ref);
        return this;
    }

    @Override
    public CodeBuilder invokespecial(MethodRefEntry ref) {
        this.bytecodesBufWriter.writeIndex(183, ref);
        return this;
    }

    @Override
    public CodeBuilder invokestatic(InterfaceMethodRefEntry ref) {
        this.bytecodesBufWriter.writeIndex(184, ref);
        return this;
    }

    @Override
    public CodeBuilder invokestatic(MethodRefEntry ref) {
        this.bytecodesBufWriter.writeIndex(184, ref);
        return this;
    }

    @Override
    public CodeBuilder invokevirtual(MethodRefEntry ref) {
        this.bytecodesBufWriter.writeIndex(182, ref);
        return this;
    }

    @Override
    public CodeBuilder ior() {
        this.bytecodesBufWriter.writeU1(128);
        return this;
    }

    @Override
    public CodeBuilder irem() {
        this.bytecodesBufWriter.writeU1(112);
        return this;
    }

    @Override
    public CodeBuilder ireturn() {
        this.bytecodesBufWriter.writeU1(172);
        return this;
    }

    @Override
    public CodeBuilder ishl() {
        this.bytecodesBufWriter.writeU1(120);
        return this;
    }

    @Override
    public CodeBuilder ishr() {
        this.bytecodesBufWriter.writeU1(122);
        return this;
    }

    @Override
    public CodeBuilder istore(int slot) {
        if (slot >= 0 && slot <= 3) {
            this.bytecodesBufWriter.writeU1(59 + slot);
        } else {
            this.writeLocalVar(54, slot);
        }
        return this;
    }

    @Override
    public CodeBuilder isub() {
        this.bytecodesBufWriter.writeU1(100);
        return this;
    }

    @Override
    public CodeBuilder iushr() {
        this.bytecodesBufWriter.writeU1(124);
        return this;
    }

    @Override
    public CodeBuilder ixor() {
        this.bytecodesBufWriter.writeU1(130);
        return this;
    }

    @Override
    public CodeBuilder lookupswitch(Label defaultTarget, List<SwitchCase> cases) {
        this.writeLookupSwitch(defaultTarget, cases);
        return this;
    }

    @Override
    public CodeBuilder l2d() {
        this.bytecodesBufWriter.writeU1(138);
        return this;
    }

    @Override
    public CodeBuilder l2f() {
        this.bytecodesBufWriter.writeU1(137);
        return this;
    }

    @Override
    public CodeBuilder l2i() {
        this.bytecodesBufWriter.writeU1(136);
        return this;
    }

    @Override
    public CodeBuilder ladd() {
        this.bytecodesBufWriter.writeU1(97);
        return this;
    }

    @Override
    public CodeBuilder land() {
        this.bytecodesBufWriter.writeU1(127);
        return this;
    }

    @Override
    public CodeBuilder lcmp() {
        this.bytecodesBufWriter.writeU1(148);
        return this;
    }

    @Override
    public CodeBuilder lconst_0() {
        this.bytecodesBufWriter.writeU1(9);
        return this;
    }

    @Override
    public CodeBuilder lconst_1() {
        this.bytecodesBufWriter.writeU1(10);
        return this;
    }

    @Override
    public CodeBuilder ldc(LoadableConstantEntry entry) {
        LoadableConstantEntry direct = AbstractPoolEntry.maybeClone(this.constantPool, entry);
        this.writeDirectLoadConstant(BytecodeHelpers.ldcOpcode(direct), direct);
        return this;
    }

    @Override
    public CodeBuilder ldiv() {
        this.bytecodesBufWriter.writeU1(109);
        return this;
    }

    @Override
    public CodeBuilder lload(int slot) {
        if (slot >= 0 && slot <= 3) {
            this.bytecodesBufWriter.writeU1(30 + slot);
        } else {
            this.writeLocalVar(22, slot);
        }
        return this;
    }

    @Override
    public CodeBuilder lmul() {
        this.bytecodesBufWriter.writeU1(105);
        return this;
    }

    @Override
    public CodeBuilder lneg() {
        this.bytecodesBufWriter.writeU1(117);
        return this;
    }

    @Override
    public CodeBuilder lor() {
        this.bytecodesBufWriter.writeU1(129);
        return this;
    }

    @Override
    public CodeBuilder lrem() {
        this.bytecodesBufWriter.writeU1(113);
        return this;
    }

    @Override
    public CodeBuilder lreturn() {
        this.bytecodesBufWriter.writeU1(173);
        return this;
    }

    @Override
    public CodeBuilder lshl() {
        this.bytecodesBufWriter.writeU1(121);
        return this;
    }

    @Override
    public CodeBuilder lshr() {
        this.bytecodesBufWriter.writeU1(123);
        return this;
    }

    @Override
    public CodeBuilder lstore(int slot) {
        if (slot >= 0 && slot <= 3) {
            this.bytecodesBufWriter.writeU1(63 + slot);
        } else {
            this.writeLocalVar(55, slot);
        }
        return this;
    }

    @Override
    public CodeBuilder lsub() {
        this.bytecodesBufWriter.writeU1(101);
        return this;
    }

    @Override
    public CodeBuilder lushr() {
        this.bytecodesBufWriter.writeU1(125);
        return this;
    }

    @Override
    public CodeBuilder lxor() {
        this.bytecodesBufWriter.writeU1(131);
        return this;
    }

    @Override
    public CodeBuilder monitorenter() {
        this.bytecodesBufWriter.writeU1(194);
        return this;
    }

    @Override
    public CodeBuilder monitorexit() {
        this.bytecodesBufWriter.writeU1(195);
        return this;
    }

    @Override
    public CodeBuilder multianewarray(ClassEntry array, int dims) {
        this.writeNewMultidimensionalArray(dims, array);
        return this;
    }

    @Override
    public CodeBuilder new_(ClassEntry clazz) {
        this.writeNewObject(clazz);
        return this;
    }

    @Override
    public CodeBuilder newarray(TypeKind typeKind) {
        int atype = typeKind.newarrayCode();
        if (atype < 0) {
            throw new IllegalArgumentException("Illegal component type: ".concat(typeKind.upperBound().displayName()));
        }
        this.writeNewPrimitiveArray(atype);
        return this;
    }

    @Override
    public CodeBuilder pop() {
        this.bytecodesBufWriter.writeU1(87);
        return this;
    }

    @Override
    public CodeBuilder pop2() {
        this.bytecodesBufWriter.writeU1(88);
        return this;
    }

    @Override
    public CodeBuilder sipush(int s) {
        BytecodeHelpers.validateSipush(s);
        this.bytecodesBufWriter.writeU1U2(17, s);
        return this;
    }

    @Override
    public CodeBuilder swap() {
        this.bytecodesBufWriter.writeU1(95);
        return this;
    }

    @Override
    public CodeBuilder tableswitch(int low, int high, Label defaultTarget, List<SwitchCase> cases) {
        this.writeTableSwitch(low, high, defaultTarget, cases);
        return this;
    }

    private static final class LabelOverflowException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        public LabelOverflowException() {
            super("Label target offset overflow");
        }
    }

    private record DeferredLabel(int labelPc, int size, int instructionPc, Label label) {
    }

    private static class DedupLineNumberTableAttribute
    extends UnboundAttribute.AdHocAttribute<LineNumberTableAttribute> {
        private final BufWriterImpl buf;
        private int lastPc;
        private int lastLine;
        private int writtenLine;

        public DedupLineNumberTableAttribute(ConstantPoolBuilder constantPool, ClassFileImpl context) {
            super(Attributes.lineNumberTable());
            this.buf = new BufWriterImpl(constantPool, context);
            this.lastPc = -1;
            this.writtenLine = -1;
        }

        private void push() {
            if (this.lastPc >= 0 && this.lastLine != this.writtenLine) {
                this.buf.writeU2U2(this.lastPc, this.lastLine);
                this.writtenLine = this.lastLine;
            }
        }

        public void writeLineNumber(int pc, int lineNo) {
            if (this.lastPc != pc && this.lastLine != lineNo) {
                this.push();
                this.lastPc = pc;
            }
            this.lastLine = lineNo;
        }

        @Override
        public void writeBody(BufWriterImpl b) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeTo(BufWriterImpl b) {
            b.writeIndex(b.constantPool().utf8Entry("LineNumberTable"));
            this.push();
            b.writeInt(this.buf.size() + 2);
            b.writeU2(this.buf.size() / 4);
            b.writeBytes(this.buf);
        }

        @Override
        public Utf8Entry attributeName() {
            return this.buf.constantPool().utf8Entry("LineNumberTable");
        }
    }
}

