/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.impl;

import io.github.dmlloyd.classfile.Attribute;
import io.github.dmlloyd.classfile.AttributeMapper;
import io.github.dmlloyd.classfile.AttributedElement;
import io.github.dmlloyd.classfile.Attributes;
import io.github.dmlloyd.classfile.ClassReader;
import io.github.dmlloyd.classfile.CodeElement;
import io.github.dmlloyd.classfile.CustomAttribute;
import io.github.dmlloyd.classfile.Instruction;
import io.github.dmlloyd.classfile.Label;
import io.github.dmlloyd.classfile.MethodModel;
import io.github.dmlloyd.classfile.Opcode;
import io.github.dmlloyd.classfile.attribute.CodeAttribute;
import io.github.dmlloyd.classfile.attribute.RuntimeInvisibleTypeAnnotationsAttribute;
import io.github.dmlloyd.classfile.attribute.RuntimeVisibleTypeAnnotationsAttribute;
import io.github.dmlloyd.classfile.attribute.StackMapTableAttribute;
import io.github.dmlloyd.classfile.attribute.UnknownAttribute;
import io.github.dmlloyd.classfile.constantpool.ClassEntry;
import io.github.dmlloyd.classfile.impl.AbstractBoundLocalVariable;
import io.github.dmlloyd.classfile.impl.AbstractElement;
import io.github.dmlloyd.classfile.impl.AbstractInstruction;
import io.github.dmlloyd.classfile.impl.AbstractPseudoInstruction;
import io.github.dmlloyd.classfile.impl.BoundAttribute;
import io.github.dmlloyd.classfile.impl.BoundCharacterRange;
import io.github.dmlloyd.classfile.impl.BoundLocalVariable;
import io.github.dmlloyd.classfile.impl.BoundLocalVariableType;
import io.github.dmlloyd.classfile.impl.BufWriterImpl;
import io.github.dmlloyd.classfile.impl.BytecodeHelpers;
import io.github.dmlloyd.classfile.impl.DirectCodeBuilder;
import io.github.dmlloyd.classfile.impl.LabelContext;
import io.github.dmlloyd.classfile.impl.LabelImpl;
import io.github.dmlloyd.classfile.impl.LineNumberImpl;
import io.github.dmlloyd.classfile.impl.MethodInfo;
import io.github.dmlloyd.classfile.impl.SplitConstantPool;
import io.github.dmlloyd.classfile.impl.Util;
import io.github.dmlloyd.classfile.instruction.ArrayLoadInstruction;
import io.github.dmlloyd.classfile.instruction.ArrayStoreInstruction;
import io.github.dmlloyd.classfile.instruction.BranchInstruction;
import io.github.dmlloyd.classfile.instruction.ConstantInstruction;
import io.github.dmlloyd.classfile.instruction.ConvertInstruction;
import io.github.dmlloyd.classfile.instruction.DiscontinuedInstruction;
import io.github.dmlloyd.classfile.instruction.ExceptionCatch;
import io.github.dmlloyd.classfile.instruction.LookupSwitchInstruction;
import io.github.dmlloyd.classfile.instruction.MonitorInstruction;
import io.github.dmlloyd.classfile.instruction.NopInstruction;
import io.github.dmlloyd.classfile.instruction.OperatorInstruction;
import io.github.dmlloyd.classfile.instruction.ReturnInstruction;
import io.github.dmlloyd.classfile.instruction.StackInstruction;
import io.github.dmlloyd.classfile.instruction.TableSwitchInstruction;
import io.github.dmlloyd.classfile.instruction.ThrowInstruction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public final class CodeImpl
extends BoundAttribute.BoundCodeAttribute
implements LabelContext {
    static final Instruction[] SINGLETON_INSTRUCTIONS = new Instruction[256];
    List<ExceptionCatch> exceptionTable;
    List<Attribute<?>> attributes;
    LabelImpl[] labels;
    int[] lineNumbers;
    boolean inflated;

    public CodeImpl(AttributedElement enclosing, ClassReader reader, AttributeMapper<CodeAttribute> mapper, int payloadStart) {
        super(enclosing, reader, mapper, payloadStart);
    }

    @Override
    public Label newLabel() {
        throw new UnsupportedOperationException("CodeAttribute only supports fixed labels");
    }

    @Override
    public void setLabelTarget(Label label, int bci) {
        throw new UnsupportedOperationException("CodeAttribute only supports fixed labels");
    }

    @Override
    public Label getLabel(int bci) {
        LabelImpl l;
        if (bci < 0 || bci > this.codeLength) {
            throw new IllegalArgumentException(String.format("Bytecode offset out of range; bci=%d, codeLength=%d", bci, this.codeLength));
        }
        if (this.labels == null) {
            this.labels = new LabelImpl[this.codeLength + 1];
        }
        if ((l = this.labels[bci]) == null) {
            l = this.labels[bci] = new LabelImpl(this, bci);
        }
        return l;
    }

    @Override
    public int labelToBci(Label label) {
        LabelImpl lab = (LabelImpl)label;
        if (lab.labelContext() != this) {
            throw new IllegalArgumentException(String.format("Illegal label reuse; context=%s, label=%s", this, lab.labelContext()));
        }
        return lab.getBCI();
    }

    private void inflateMetadata() {
        if (!this.inflated) {
            if (this.labels == null) {
                this.labels = new LabelImpl[this.codeLength + 1];
            }
            if (this.classReader.context().passLineNumbers()) {
                this.inflateLineNumbers();
            }
            this.inflateJumpTargets();
            this.inflateTypeAnnotations();
            this.inflated = true;
        }
    }

    @Override
    public List<Attribute<?>> attributes() {
        if (this.attributes == null) {
            this.attributes = BoundAttribute.readAttributes(this, this.classReader, this.attributePos, this.classReader.customAttributes());
        }
        return this.attributes;
    }

    @Override
    public void writeTo(BufWriterImpl buf) {
        if (buf.canWriteDirect(this.classReader)) {
            super.writeTo(buf);
        } else {
            DirectCodeBuilder.build((MethodInfo)((Object)this.enclosingMethod), Util.writingAll(this), (SplitConstantPool)buf.constantPool(), buf.context(), null).writeTo(buf);
        }
    }

    @Override
    public Optional<MethodModel> parent() {
        return Optional.of(this.enclosingMethod);
    }

    @Override
    public void forEach(Consumer<? super CodeElement> consumer) {
        Instruction instr;
        Objects.requireNonNull(consumer);
        this.inflateMetadata();
        boolean doLineNumbers = this.lineNumbers != null;
        this.generateCatchTargets(consumer);
        if (this.classReader.context().passDebugElements()) {
            this.generateDebugElements(consumer);
        }
        this.generateUserAttributes(consumer);
        for (int pos = this.codeStart; pos < this.codeEnd; pos += instr.sizeInBytes()) {
            if (this.labels[pos - this.codeStart] != null) {
                consumer.accept(this.labels[pos - this.codeStart]);
            }
            if (doLineNumbers && this.lineNumbers[pos - this.codeStart] != 0) {
                consumer.accept(LineNumberImpl.of(this.lineNumbers[pos - this.codeStart]));
            }
            int bc = this.classReader.readU1(pos);
            instr = this.bcToInstruction(bc, pos);
            consumer.accept(instr);
        }
        if (this.labels[this.codeEnd - this.codeStart] != null) {
            consumer.accept(this.labels[this.codeEnd - this.codeStart]);
        }
        if (doLineNumbers && this.lineNumbers[this.codeEnd - this.codeStart] != 0) {
            consumer.accept(LineNumberImpl.of(this.lineNumbers[this.codeEnd - this.codeStart]));
        }
    }

    @Override
    public List<ExceptionCatch> exceptionHandlers() {
        if (this.exceptionTable == null) {
            this.inflateMetadata();
            this.exceptionTable = new ArrayList<ExceptionCatch>(this.exceptionHandlerCnt);
            this.iterateExceptionHandlers(new ExceptionHandlerAction(){

                @Override
                public void accept(int s, int e, int h, int c) {
                    ClassEntry catchTypeEntry = c == 0 ? null : CodeImpl.this.constantPool().entryByIndex(c, ClassEntry.class);
                    CodeImpl.this.exceptionTable.add(new AbstractPseudoInstruction.ExceptionCatchImpl(CodeImpl.this.getLabel(h), CodeImpl.this.getLabel(s), CodeImpl.this.getLabel(e), catchTypeEntry));
                }
            });
            this.exceptionTable = Collections.unmodifiableList(this.exceptionTable);
        }
        return this.exceptionTable;
    }

    private void generateUserAttributes(Consumer<? super CodeElement> consumer) {
        for (Attribute<?> attr : this.attributes) {
            if (!(attr instanceof CustomAttribute) && !(attr instanceof UnknownAttribute)) continue;
            consumer.accept((CodeElement)((Object)attr));
        }
    }

    public boolean compareCodeBytes(BufWriterImpl buf, int offset, int len) {
        return this.codeLength == len && this.classReader.compare(buf, offset, this.codeStart, this.codeLength);
    }

    private int adjustForObjectOrUninitialized(int bci) {
        int vt = this.classReader.readU1(bci);
        if (vt == 8) {
            this.inflateLabel(this.classReader.readU2(bci + 1));
        }
        return vt == 7 || vt == 8 ? bci + 3 : bci + 1;
    }

    private void inflateLabel(int bci) {
        if (bci < 0 || bci > this.codeLength) {
            throw new IllegalArgumentException(String.format("Bytecode offset out of range; bci=%d, codeLength=%d", bci, this.codeLength));
        }
        if (this.labels[bci] == null) {
            this.labels[bci] = new LabelImpl(this, bci);
        }
    }

    private void inflateLineNumbers() {
        for (Attribute<?> a : this.attributes()) {
            int p;
            if (a.attributeMapper() != Attributes.lineNumberTable()) continue;
            BoundAttribute.BoundLineNumberTableAttribute attr = (BoundAttribute.BoundLineNumberTableAttribute)a;
            if (this.lineNumbers == null) {
                this.lineNumbers = new int[this.codeLength + 1];
            }
            int nLn = this.classReader.readU2(attr.payloadStart);
            int pEnd = p + nLn * 4;
            for (p = attr.payloadStart + 2; p < pEnd; p += 4) {
                int lineNumber;
                int startPc = this.classReader.readU2(p);
                if (startPc > this.codeLength) {
                    throw new IllegalArgumentException(String.format("Line number start_pc out of range; start_pc=%d, codeLength=%d", startPc, this.codeLength));
                }
                this.lineNumbers[startPc] = lineNumber = this.classReader.readU2(p + 2);
            }
        }
    }

    private void inflateJumpTargets() {
        Optional<StackMapTableAttribute> a = this.findAttribute(Attributes.stackMapTable());
        if (a.isEmpty()) {
            if (this.classReader.readU2(6) <= 50) {
                Instruction i;
                block12: for (int pos = this.codeStart; pos < this.codeEnd; pos += i.sizeInBytes()) {
                    i = this.bcToInstruction(this.classReader.readU1(pos), pos);
                    switch (i.opcode().kind()) {
                        case BRANCH: {
                            ((BranchInstruction)i).target();
                            continue block12;
                        }
                        case DISCONTINUED_JSR: {
                            ((DiscontinuedInstruction.JsrInstruction)i).target();
                            continue block12;
                        }
                        case LOOKUP_SWITCH: {
                            LookupSwitchInstruction ls = (LookupSwitchInstruction)i;
                            ls.defaultTarget();
                            ls.cases();
                            continue block12;
                        }
                        case TABLE_SWITCH: {
                            TableSwitchInstruction ts = (TableSwitchInstruction)i;
                            ts.defaultTarget();
                            ts.cases();
                        }
                    }
                }
            }
            return;
        }
        int stackMapPos = ((BoundAttribute)((Object)a.get())).payloadStart;
        int bci = -1;
        int nEntries = this.classReader.readU2(stackMapPos);
        int p = stackMapPos + 2;
        for (int i = 0; i < nEntries; ++i) {
            int offsetDelta;
            int frameType = this.classReader.readU1(p);
            if (frameType < 64) {
                offsetDelta = frameType;
                ++p;
            } else if (frameType < 128) {
                offsetDelta = frameType & 0x3F;
                p = this.adjustForObjectOrUninitialized(p + 1);
            } else {
                switch (frameType) {
                    case 247: {
                        offsetDelta = this.classReader.readU2(p + 1);
                        p = this.adjustForObjectOrUninitialized(p + 3);
                        break;
                    }
                    case 248: 
                    case 249: 
                    case 250: 
                    case 251: {
                        offsetDelta = this.classReader.readU2(p + 1);
                        p += 3;
                        break;
                    }
                    case 252: 
                    case 253: 
                    case 254: {
                        int c;
                        offsetDelta = this.classReader.readU2(p + 1);
                        int k = frameType - 251;
                        p += 3;
                        for (c = 0; c < k; ++c) {
                            p = this.adjustForObjectOrUninitialized(p);
                        }
                        break;
                    }
                    case 255: {
                        int c;
                        offsetDelta = this.classReader.readU2(p + 1);
                        int k = this.classReader.readU2(p += 3);
                        p += 2;
                        for (c = 0; c < k; ++c) {
                            p = this.adjustForObjectOrUninitialized(p);
                        }
                        k = this.classReader.readU2(p);
                        p += 2;
                        for (c = 0; c < k; ++c) {
                            p = this.adjustForObjectOrUninitialized(p);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Bad frame type: " + frameType);
                    }
                }
            }
            this.inflateLabel(bci += offsetDelta + 1);
        }
    }

    private void inflateTypeAnnotations() {
        this.findAttribute(Attributes.runtimeVisibleTypeAnnotations()).ifPresent(RuntimeVisibleTypeAnnotationsAttribute::annotations);
        this.findAttribute(Attributes.runtimeInvisibleTypeAnnotations()).ifPresent(RuntimeInvisibleTypeAnnotationsAttribute::annotations);
    }

    private void generateCatchTargets(final Consumer<? super CodeElement> consumer) {
        this.iterateExceptionHandlers(new ExceptionHandlerAction(){

            @Override
            public void accept(int s, int e, int h, int c) {
                ClassEntry catchType = c == 0 ? null : CodeImpl.this.classReader.entryByIndex(c, ClassEntry.class);
                consumer.accept(new AbstractPseudoInstruction.ExceptionCatchImpl(CodeImpl.this.getLabel(h), CodeImpl.this.getLabel(s), CodeImpl.this.getLabel(e), catchType));
            }
        });
    }

    private void generateDebugElements(Consumer<? super CodeElement> consumer) {
        for (Attribute<?> a : this.attributes()) {
            AbstractElement instruction;
            int pEnd;
            int p;
            int cnt;
            BoundAttribute attr;
            if (a.attributeMapper() == Attributes.characterRangeTable()) {
                attr = (BoundAttribute.BoundCharacterRangeTableAttribute)a;
                cnt = this.classReader.readU2(attr.payloadStart);
                pEnd = p + cnt * 14;
                for (p = attr.payloadStart + 2; p < pEnd; p += 14) {
                    instruction = new BoundCharacterRange(this, p);
                    this.inflateLabel(((BoundCharacterRange)instruction).startPc());
                    this.inflateLabel(((BoundCharacterRange)instruction).endPc() + 1);
                    consumer.accept((CodeElement)((Object)instruction));
                }
                continue;
            }
            if (a.attributeMapper() == Attributes.localVariableTable()) {
                attr = (BoundAttribute.BoundLocalVariableTableAttribute)a;
                cnt = this.classReader.readU2(((BoundAttribute.BoundLocalVariableTableAttribute)attr).payloadStart);
                pEnd = p + cnt * 10;
                for (p = ((BoundAttribute.BoundLocalVariableTableAttribute)attr).payloadStart + 2; p < pEnd; p += 10) {
                    instruction = new BoundLocalVariable(this, p);
                    this.inflateLabel(((AbstractBoundLocalVariable)instruction).startPc());
                    this.inflateLabel(((AbstractBoundLocalVariable)instruction).startPc() + ((AbstractBoundLocalVariable)instruction).length());
                    consumer.accept((CodeElement)((Object)instruction));
                }
                continue;
            }
            if (a.attributeMapper() == Attributes.localVariableTypeTable()) {
                attr = (BoundAttribute.BoundLocalVariableTypeTableAttribute)a;
                cnt = this.classReader.readU2(((BoundAttribute.BoundLocalVariableTypeTableAttribute)attr).payloadStart);
                pEnd = p + cnt * 10;
                for (p = ((BoundAttribute.BoundLocalVariableTypeTableAttribute)attr).payloadStart + 2; p < pEnd; p += 10) {
                    instruction = new BoundLocalVariableType(this, p);
                    this.inflateLabel(((AbstractBoundLocalVariable)instruction).startPc());
                    this.inflateLabel(((AbstractBoundLocalVariable)instruction).startPc() + ((AbstractBoundLocalVariable)instruction).length());
                    consumer.accept((CodeElement)((Object)instruction));
                }
                continue;
            }
            if (a.attributeMapper() == Attributes.runtimeVisibleTypeAnnotations()) {
                consumer.accept((BoundAttribute.BoundRuntimeVisibleTypeAnnotationsAttribute)a);
                continue;
            }
            if (a.attributeMapper() != Attributes.runtimeInvisibleTypeAnnotations()) continue;
            consumer.accept((BoundAttribute.BoundRuntimeInvisibleTypeAnnotationsAttribute)a);
        }
    }

    public void iterateExceptionHandlers(ExceptionHandlerAction a) {
        int p = this.exceptionHandlerPos + 2;
        for (int i = 0; i < this.exceptionHandlerCnt; ++i) {
            a.accept(this.classReader.readU2(p), this.classReader.readU2(p + 2), this.classReader.readU2(p + 4), this.classReader.readU2(p + 6));
            p += 8;
        }
    }

    private Instruction bcToInstruction(int bc, int pos) {
        return switch (bc) {
            case 16 -> new AbstractInstruction.BoundArgumentConstantInstruction(Opcode.BIPUSH, this, pos);
            case 17 -> new AbstractInstruction.BoundArgumentConstantInstruction(Opcode.SIPUSH, this, pos);
            case 18 -> new AbstractInstruction.BoundLoadConstantInstruction(Opcode.LDC, this, pos);
            case 19 -> new AbstractInstruction.BoundLoadConstantInstruction(Opcode.LDC_W, this, pos);
            case 20 -> new AbstractInstruction.BoundLoadConstantInstruction(Opcode.LDC2_W, this, pos);
            case 21 -> new AbstractInstruction.BoundLoadInstruction(Opcode.ILOAD, this, pos);
            case 22 -> new AbstractInstruction.BoundLoadInstruction(Opcode.LLOAD, this, pos);
            case 23 -> new AbstractInstruction.BoundLoadInstruction(Opcode.FLOAD, this, pos);
            case 24 -> new AbstractInstruction.BoundLoadInstruction(Opcode.DLOAD, this, pos);
            case 25 -> new AbstractInstruction.BoundLoadInstruction(Opcode.ALOAD, this, pos);
            case 54 -> new AbstractInstruction.BoundStoreInstruction(Opcode.ISTORE, this, pos);
            case 55 -> new AbstractInstruction.BoundStoreInstruction(Opcode.LSTORE, this, pos);
            case 56 -> new AbstractInstruction.BoundStoreInstruction(Opcode.FSTORE, this, pos);
            case 57 -> new AbstractInstruction.BoundStoreInstruction(Opcode.DSTORE, this, pos);
            case 58 -> new AbstractInstruction.BoundStoreInstruction(Opcode.ASTORE, this, pos);
            case 132 -> new AbstractInstruction.BoundIncrementInstruction(Opcode.IINC, this, pos);
            case 153 -> new AbstractInstruction.BoundBranchInstruction(Opcode.IFEQ, this, pos);
            case 154 -> new AbstractInstruction.BoundBranchInstruction(Opcode.IFNE, this, pos);
            case 155 -> new AbstractInstruction.BoundBranchInstruction(Opcode.IFLT, this, pos);
            case 156 -> new AbstractInstruction.BoundBranchInstruction(Opcode.IFGE, this, pos);
            case 157 -> new AbstractInstruction.BoundBranchInstruction(Opcode.IFGT, this, pos);
            case 158 -> new AbstractInstruction.BoundBranchInstruction(Opcode.IFLE, this, pos);
            case 159 -> new AbstractInstruction.BoundBranchInstruction(Opcode.IF_ICMPEQ, this, pos);
            case 160 -> new AbstractInstruction.BoundBranchInstruction(Opcode.IF_ICMPNE, this, pos);
            case 161 -> new AbstractInstruction.BoundBranchInstruction(Opcode.IF_ICMPLT, this, pos);
            case 162 -> new AbstractInstruction.BoundBranchInstruction(Opcode.IF_ICMPGE, this, pos);
            case 163 -> new AbstractInstruction.BoundBranchInstruction(Opcode.IF_ICMPGT, this, pos);
            case 164 -> new AbstractInstruction.BoundBranchInstruction(Opcode.IF_ICMPLE, this, pos);
            case 165 -> new AbstractInstruction.BoundBranchInstruction(Opcode.IF_ACMPEQ, this, pos);
            case 166 -> new AbstractInstruction.BoundBranchInstruction(Opcode.IF_ACMPNE, this, pos);
            case 167 -> new AbstractInstruction.BoundBranchInstruction(Opcode.GOTO, this, pos);
            case 170 -> new AbstractInstruction.BoundTableSwitchInstruction(Opcode.TABLESWITCH, this, pos);
            case 171 -> new AbstractInstruction.BoundLookupSwitchInstruction(Opcode.LOOKUPSWITCH, this, pos);
            case 178 -> new AbstractInstruction.BoundFieldInstruction(Opcode.GETSTATIC, this, pos);
            case 179 -> new AbstractInstruction.BoundFieldInstruction(Opcode.PUTSTATIC, this, pos);
            case 180 -> new AbstractInstruction.BoundFieldInstruction(Opcode.GETFIELD, this, pos);
            case 181 -> new AbstractInstruction.BoundFieldInstruction(Opcode.PUTFIELD, this, pos);
            case 182 -> new AbstractInstruction.BoundInvokeInstruction(Opcode.INVOKEVIRTUAL, this, pos);
            case 183 -> new AbstractInstruction.BoundInvokeInstruction(Opcode.INVOKESPECIAL, this, pos);
            case 184 -> new AbstractInstruction.BoundInvokeInstruction(Opcode.INVOKESTATIC, this, pos);
            case 185 -> new AbstractInstruction.BoundInvokeInterfaceInstruction(Opcode.INVOKEINTERFACE, this, pos);
            case 186 -> new AbstractInstruction.BoundInvokeDynamicInstruction(Opcode.INVOKEDYNAMIC, this, pos);
            case 187 -> new AbstractInstruction.BoundNewObjectInstruction(this, pos);
            case 188 -> new AbstractInstruction.BoundNewPrimitiveArrayInstruction(Opcode.NEWARRAY, this, pos);
            case 189 -> new AbstractInstruction.BoundNewReferenceArrayInstruction(Opcode.ANEWARRAY, this, pos);
            case 192 -> new AbstractInstruction.BoundTypeCheckInstruction(Opcode.CHECKCAST, this, pos);
            case 193 -> new AbstractInstruction.BoundTypeCheckInstruction(Opcode.INSTANCEOF, this, pos);
            case 196 -> {
                int bclow = this.classReader.readU1(pos + 1);
                switch (bclow) {
                    case 21: {
                        yield new AbstractInstruction.BoundLoadInstruction(Opcode.ILOAD_W, this, pos);
                    }
                    case 22: {
                        yield new AbstractInstruction.BoundLoadInstruction(Opcode.LLOAD_W, this, pos);
                    }
                    case 23: {
                        yield new AbstractInstruction.BoundLoadInstruction(Opcode.FLOAD_W, this, pos);
                    }
                    case 24: {
                        yield new AbstractInstruction.BoundLoadInstruction(Opcode.DLOAD_W, this, pos);
                    }
                    case 25: {
                        yield new AbstractInstruction.BoundLoadInstruction(Opcode.ALOAD_W, this, pos);
                    }
                    case 54: {
                        yield new AbstractInstruction.BoundStoreInstruction(Opcode.ISTORE_W, this, pos);
                    }
                    case 55: {
                        yield new AbstractInstruction.BoundStoreInstruction(Opcode.LSTORE_W, this, pos);
                    }
                    case 56: {
                        yield new AbstractInstruction.BoundStoreInstruction(Opcode.FSTORE_W, this, pos);
                    }
                    case 57: {
                        yield new AbstractInstruction.BoundStoreInstruction(Opcode.DSTORE_W, this, pos);
                    }
                    case 58: {
                        yield new AbstractInstruction.BoundStoreInstruction(Opcode.ASTORE_W, this, pos);
                    }
                    case 132: {
                        yield new AbstractInstruction.BoundIncrementInstruction(Opcode.IINC_W, this, pos);
                    }
                    case 169: {
                        yield new AbstractInstruction.BoundRetInstruction(Opcode.RET_W, this, pos);
                    }
                }
                throw new IllegalArgumentException("unknown wide instruction: " + bclow);
            }
            case 197 -> new AbstractInstruction.BoundNewMultidimensionalArrayInstruction(Opcode.MULTIANEWARRAY, this, pos);
            case 198 -> new AbstractInstruction.BoundBranchInstruction(Opcode.IFNULL, this, pos);
            case 199 -> new AbstractInstruction.BoundBranchInstruction(Opcode.IFNONNULL, this, pos);
            case 200 -> new AbstractInstruction.BoundBranchInstruction(Opcode.GOTO_W, this, pos);
            case 168 -> new AbstractInstruction.BoundJsrInstruction(Opcode.JSR, this, pos);
            case 169 -> new AbstractInstruction.BoundRetInstruction(Opcode.RET, this, pos);
            case 201 -> new AbstractInstruction.BoundJsrInstruction(Opcode.JSR_W, this, pos);
            default -> {
                Instruction instr = SINGLETON_INSTRUCTIONS[bc];
                if (instr == null) {
                    throw new IllegalArgumentException("unknown instruction: " + bc);
                }
                yield instr;
            }
        };
    }

    @Override
    public String toString() {
        return String.format("CodeModel[id=%d]", System.identityHashCode(this));
    }

    static {
        for (Opcode o : Opcode.values()) {
            if (o.sizeIfFixed() != 1) continue;
            int n = o.bytecode();
            CodeImpl.SINGLETON_INSTRUCTIONS[n] = switch (o.kind()) {
                case Opcode.Kind.ARRAY_LOAD -> ArrayLoadInstruction.of(o);
                case Opcode.Kind.ARRAY_STORE -> ArrayStoreInstruction.of(o);
                case Opcode.Kind.CONSTANT -> ConstantInstruction.ofIntrinsic(o);
                case Opcode.Kind.CONVERT -> ConvertInstruction.of(o);
                case Opcode.Kind.LOAD -> new AbstractInstruction.UnboundLoadInstruction(o, BytecodeHelpers.intrinsicLoadSlot(o));
                case Opcode.Kind.MONITOR -> MonitorInstruction.of(o);
                case Opcode.Kind.NOP -> NopInstruction.of();
                case Opcode.Kind.OPERATOR -> OperatorInstruction.of(o);
                case Opcode.Kind.RETURN -> ReturnInstruction.of(o);
                case Opcode.Kind.STACK -> StackInstruction.of(o);
                case Opcode.Kind.STORE -> new AbstractInstruction.UnboundStoreInstruction(o, BytecodeHelpers.intrinsicStoreSlot(o));
                case Opcode.Kind.THROW_EXCEPTION -> ThrowInstruction.of();
                default -> throw new AssertionError((Object)("invalid opcode: " + String.valueOf((Object)o)));
            };
        }
    }

    public static interface ExceptionHandlerAction {
        public void accept(int var1, int var2, int var3, int var4);
    }
}

