/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.fetch;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Clock;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.http.cache.ContentCacheEntry;
import io.gatling.http.cache.Http2PriorKnowledgeSupport$;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.client.Http2PriorKnowledge;
import io.gatling.http.client.Request;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.engine.tx.HttpTx;
import io.gatling.http.engine.tx.HttpTxExecutor;
import io.gatling.http.engine.tx.ResourceTx;
import io.gatling.http.fetch.ResourceAggregator;
import io.gatling.http.fetch.ResourceFetcher;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.protocol.Remote;
import io.gatling.http.protocol.Remote$;
import io.gatling.http.request.HttpRequest;
import io.gatling.http.request.HttpRequestConfig;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t-f!\u0002\u00192\u0005EJ\u0004\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\t\u0011a\u0003!\u0011!Q\u0001\neC\u0001b\u001b\u0001\u0003\u0002\u0003\u0006I\u0001\u001c\u0005\te\u0002\u0011\t\u0011)A\u0005g\"Aa\u000f\u0001B\u0001B\u0003%q\u000f\u0003\u0005{\u0001\t\u0005\t\u0015!\u0003|\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013A\u0011\"!\u0007\u0001\u0005\u0004%I!a\u0007\t\u0011\u0005\r\u0002\u0001)A\u0005\u0003;A\u0011\"!\n\u0001\u0005\u0004%I!a\n\t\u0011\u0005U\u0002\u0001)A\u0005\u0003SA\u0011\"a\u000e\u0001\u0005\u0004%I!a\u0007\t\u0011\u0005e\u0002\u0001)A\u0005\u0003;A1\"a\u000f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002>!Y\u0011Q\n\u0001A\u0002\u0003\u0007I\u0011BA(\u0011-\tY\u0006\u0001a\u0001\u0002\u0003\u0006K!a\u0010\t\u0013\u0005u\u0003A1A\u0005\n\u0005}\u0003\u0002CAA\u0001\u0001\u0006I!!\u0019\t\u0013\u0005\r\u0005A1A\u0005\n\u0005\u0015\u0005\u0002CAJ\u0001\u0001\u0006I!a\"\t\u0013\u0005U\u0005A1A\u0005\n\u0005]\u0005\u0002CAP\u0001\u0001\u0006I!!'\t\u0013\u0005\u0005\u0006A1A\u0005\n\u0005\r\u0006\u0002CAT\u0001\u0001\u0006I!!*\t\u0013\u0005%\u0006\u00011A\u0005\n\u0005]\u0005\"CAV\u0001\u0001\u0007I\u0011BAW\u0011!\t\t\f\u0001Q!\n\u0005e\u0005\"CAZ\u0001\u0001\u0007I\u0011BA[\u0011%\t\u0019\r\u0001a\u0001\n\u0013\t)\r\u0003\u0005\u0002J\u0002\u0001\u000b\u0015BA\\\u0011%\tY\r\u0001b\u0001\n\u0013\ti\r\u0003\u0005\u0002V\u0002\u0001\u000b\u0011BAh\u0011\u001d\t9\u000e\u0001C!\u0003{Aq!!7\u0001\t\u0003\nY\u000eC\u0004\u0002`\u0002!I!!9\t\u000f\u0005E\b\u0001\"\u0003\u0002t\"9\u0011Q \u0001\u0005\n\u0005}\bb\u0002B\u0002\u0001\u0011%!Q\u0001\u0005\b\u0005\u0017\u0001A\u0011\u0002B\u0007\u0011\u001d\u0011y\u0001\u0001C\u0005\u0005#AqAa\u0006\u0001\t\u0013\u0011I\u0002C\u0004\u0003\"\u0001!IAa\t\t\u000f\tE\u0002\u0001\"\u0003\u00034!9!\u0011\u000f\u0001\u0005B\tM\u0004b\u0002BC\u0001\u0011\u0005#q\u0011\u0005\b\u0005/\u0003A\u0011\tBM\u0011\u001d\u0011\u0019\u000b\u0001C!\u0005K\u0013\u0011\u0004R3gCVdGOU3t_V\u00148-Z!hOJ,w-\u0019;pe*\u0011!gM\u0001\u0006M\u0016$8\r\u001b\u0006\u0003iU\nA\u0001\u001b;ua*\u0011agN\u0001\bO\u0006$H.\u001b8h\u0015\u0005A\u0014AA5p'\u0011\u0001!\b\u0011#\u0011\u0005mrT\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\r\u0005s\u0017PU3g!\t\t%)D\u00012\u0013\t\u0019\u0015G\u0001\nSKN|WO]2f\u0003\u001e<'/Z4bi>\u0014\bCA#M\u001b\u00051%BA$I\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tI%*\u0001\u0005usB,7/\u00194f\u0015\u0005Y\u0015aA2p[&\u0011QJ\u0012\u0002\u000e'R\u0014\u0018n\u0019;M_\u001e<\u0017N\\4\u0002\rI|w\u000e\u001e+y\u0007\u0001\u0001\"!\u0015,\u000e\u0003IS!a\u0015+\u0002\u0005QD(BA+4\u0003\u0019)gnZ5oK&\u0011qK\u0015\u0002\u0007\u0011R$\b\u000f\u0016=\u0002!%t\u0017\u000e^5bYJ+7o\\;sG\u0016\u001c\bc\u0001.cK:\u00111\f\u0019\b\u00039~k\u0011!\u0018\u0006\u0003=>\u000ba\u0001\u0010:p_Rt\u0014\"A\u001f\n\u0005\u0005d\u0014a\u00029bG.\fw-Z\u0005\u0003G\u0012\u0014A\u0001T5ti*\u0011\u0011\r\u0010\t\u0003M&l\u0011a\u001a\u0006\u0003QN\nqA]3rk\u0016\u001cH/\u0003\u0002kO\nY\u0001\n\u001e;q%\u0016\fX/Z:u\u0003)AG\u000f\u001e9DC\u000eDWm\u001d\t\u0003[Bl\u0011A\u001c\u0006\u0003_N\nQaY1dQ\u0016L!!\u001d8\u0003\u0015!#H\u000f]\"bG\",7/A\bsKN|WO]2f\r\u0016$8\r[3s!\t\tE/\u0003\u0002vc\ty!+Z:pkJ\u001cWMR3uG\",'/\u0001\biiR\u0004H\u000b_#yK\u000e,Ho\u001c:\u0011\u0005EC\u0018BA=S\u00059AE\u000f\u001e9Uq\u0016CXmY;u_J\fQa\u00197pG.\u00042\u0001`A\u0002\u001b\u0005i(B\u0001@\u0000\u0003\u0011)H/\u001b7\u000b\u0007\u0005\u0005Q'A\u0004d_6lwN\\:\n\u0007\u0005\u0015QPA\u0003DY>\u001c7.\u0001\u0004=S:LGO\u0010\u000b\u000f\u0003\u0017\ti!a\u0004\u0002\u0012\u0005M\u0011QCA\f!\t\t\u0005\u0001C\u0003O\u000f\u0001\u0007\u0001\u000bC\u0003Y\u000f\u0001\u0007\u0011\fC\u0003l\u000f\u0001\u0007A\u000eC\u0003s\u000f\u0001\u00071\u000fC\u0003w\u000f\u0001\u0007q\u000fC\u0003{\u000f\u0001\u000710A\u0005uQJ|G\u000f\u001e7fIV\u0011\u0011Q\u0004\t\u0004w\u0005}\u0011bAA\u0011y\t9!i\\8mK\u0006t\u0017A\u0003;ie>$H\u000f\\3eA\u0005a\u0001\u000e\u001e;q!J|Go\\2pYV\u0011\u0011\u0011\u0006\t\u0005\u0003W\t\t$\u0004\u0002\u0002.)\u0019\u0011qF\u001a\u0002\u0011A\u0014x\u000e^8d_2LA!a\r\u0002.\ta\u0001\n\u001e;q!J|Go\\2pY\u0006i\u0001\u000e\u001e;q!J|Go\\2pY\u0002\nA\u0002\u001b;uaJ*e.\u00192mK\u0012\fQ\u0002\u001b;uaJ*e.\u00192mK\u0012\u0004\u0013aB:fgNLwN\\\u000b\u0003\u0003\u007f\u0001B!!\u0011\u0002J5\u0011\u00111\t\u0006\u0005\u0003w\t)EC\u0002\u0002HU\nAaY8sK&!\u00111JA\"\u0005\u001d\u0019Vm]:j_:\f1b]3tg&|gn\u0018\u0013fcR!\u0011\u0011KA,!\rY\u00141K\u0005\u0004\u0003+b$\u0001B+oSRD\u0011\"!\u0017\u0010\u0003\u0003\u0005\r!a\u0010\u0002\u0007a$\u0013'\u0001\u0005tKN\u001c\u0018n\u001c8!\u0003-\tGN]3bIf\u001cV-\u001a8\u0016\u0005\u0005\u0005\u0004CBA2\u0003[\n\t(\u0004\u0002\u0002f)!\u0011qMA5\u0003\u001diW\u000f^1cY\u0016T1!a\u001b=\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003_\n)GA\u0002TKR\u0004B!a\u001d\u0002~5\u0011\u0011Q\u000f\u0006\u0005\u0003o\nI(A\u0002ve&T1!a\u001f4\u0003\u0019\u0019G.[3oi&!\u0011qPA;\u0005\r)&/[\u0001\rC2\u0014X-\u00193z'\u0016,g\u000eI\u0001\u0018EV4g-\u001a:fIJ+7o\\;sG\u0016\u001c()\u001f%pgR,\"!a\"\u0011\u000f\u0005\r\u0014\u0011RAG3&!\u00111RA3\u0005\ri\u0015\r\u001d\t\u0005\u0003W\ty)\u0003\u0003\u0002\u0012\u00065\"A\u0002*f[>$X-\u0001\rck\u001a4WM]3e%\u0016\u001cx.\u001e:dKN\u0014\u0015\u0010S8ti\u0002\nQ#\\1y\u0007>tg.Z2uS>t7\u000fU3s\u0011>\u001cH/\u0006\u0002\u0002\u001aB\u00191(a'\n\u0007\u0005uEHA\u0002J]R\fa#\\1y\u0007>tg.Z2uS>t7\u000fU3s\u0011>\u001cH\u000fI\u0001\u0016CZ\f\u0017\u000e\\1cY\u0016$vn[3og\nK\bj\\:u+\t\t)\u000b\u0005\u0005\u0002d\u0005%\u0015QRAM\u0003Y\tg/Y5mC\ndW\rV8lK:\u001c()\u001f%pgR\u0004\u0013!\u00069f]\u0012Lgn\u001a*fg>,(oY3t\u0007>,h\u000e^\u0001\u001aa\u0016tG-\u001b8h%\u0016\u001cx.\u001e:dKN\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0003\u0002R\u0005=\u0006\"CA-5\u0005\u0005\t\u0019AAM\u0003Y\u0001XM\u001c3j]\u001e\u0014Vm]8ve\u000e,7oQ8v]R\u0004\u0013\u0001D4m_\n\fGn\u0015;biV\u001cXCAA\\!\u0011\tI,a0\u000e\u0005\u0005m&bAA_\u007f\u0006)1\u000f^1ug&!\u0011\u0011YA^\u0005\u0019\u0019F/\u0019;vg\u0006\u0001r\r\\8cC2\u001cF/\u0019;vg~#S-\u001d\u000b\u0005\u0003#\n9\rC\u0005\u0002Zu\t\t\u00111\u0001\u00028\u0006iq\r\\8cC2\u001cF/\u0019;vg\u0002\nab\u001d;beR$\u0016.\\3ti\u0006l\u0007/\u0006\u0002\u0002PB\u00191(!5\n\u0007\u0005MGH\u0001\u0003M_:<\u0017aD:uCJ$H+[7fgR\fW\u000e\u001d\u0011\u0002\u001d\r,(O]3oiN+7o]5p]\u0006)1\u000f^1siR!\u0011\u0011KAo\u0011\u001d\tYD\ta\u0001\u0003\u007f\tacZ3u\u0011R$\bO\r)sS>\u00148J\\8xY\u0016$w-\u001a\u000b\u0007\u0003G\fY/!<\u0011\t\u0005\u0015\u0018q]\u0007\u0003\u0003sJA!!;\u0002z\t\u0019\u0002\n\u001e;qeA\u0013\u0018n\u001c:L]><H.\u001a3hK\"9\u00111H\u0012A\u0002\u0005}\u0002bBAxG\u0001\u0007\u0011QR\u0001\u0007e\u0016lw\u000e^3\u0002!\r\u0014X-\u0019;f%\u0016\u001cx.\u001e:dKRCH#\u0002)\u0002v\u0006e\bBBA|I\u0001\u0007Q-\u0001\u0005sKN|WO]2f\u0011\u001d\tY\u0010\na\u0001\u0003G\f1\u0003\u001b;uaJ\u0002&/[8s\u0017:|w\u000f\\3eO\u0016\fA\u0003[1oI2,7)Y2iK\u0012\u0014Vm]8ve\u000e,G\u0003BA)\u0005\u0003Aa!a>&\u0001\u0004)\u0017A\u00064fi\u000eDwJ\u001d\"vM\u001a,'OU3t_V\u00148-Z:\u0015\t\u0005E#q\u0001\u0005\u0007\u0005\u00131\u0003\u0019A-\u0002\u0013I,7o\\;sG\u0016\u001c\u0018\u0001\u00023p]\u0016$\"!!\u0015\u0002'M,g\u000e\u001a\"vM\u001a,'/\u001a3SKF,Xm\u001d;\u0015\r\u0005E#1\u0003B\u000b\u0011\u0015A\u0007\u00061\u0001f\u0011\u001d\ty\u000f\u000ba\u0001\u0003\u001b\u000bqC]3mK\u0006\u001cX\rV8lK:\fe\u000eZ\"p]RLg.^3\u0015\r\u0005E#1\u0004B\u000f\u0011\u001d\ty/\u000ba\u0001\u0003\u001bCqAa\b*\u0001\u0004\ti\"A\u0004jg\"#H\u000f\u001d\u001a\u0002\u001fI,7o\\;sG\u00164U\r^2iK\u0012$\"\"!\u0015\u0003&\t\u001d\"\u0011\u0006B\u0017\u0011\u001d\tYD\u000ba\u0001\u0003\u007fAq!a<+\u0001\u0004\ti\tC\u0004\u0003,)\u0002\r!a.\u0002\rM$\u0018\r^;t\u0011\u001d\u0011yC\u000ba\u0001\u0003;\taa]5mK:$\u0018AC2tg\u001a+Go\u00195fIRa\u0011\u0011\u000bB\u001b\u0005o\u0011IDa\u0015\u0003n!9\u0011qO\u0016A\u0002\u0005E\u0004b\u0002B\u0016W\u0001\u0007\u0011q\u0017\u0005\b\u0005wY\u0003\u0019\u0001B\u001f\u00039\u0011Xm\u001d9p]N,7\u000b^1ukN\u0004BAa\u0010\u0003P5\u0011!\u0011\t\u0006\u0004i\t\r#\u0002\u0002B#\u0005\u000f\nQaY8eK\u000eTAA!\u0013\u0003L\u00059\u0001.\u00198eY\u0016\u0014(b\u0001B'o\u0005)a.\u001a;us&!!\u0011\u000bB!\u0005IAE\u000f\u001e9SKN\u0004xN\\:f'R\fG/^:\t\u000f\tU3\u00061\u0001\u0003X\u0005\u0011B.Y:u\u001b>$\u0017NZ5fI>\u0013X\t^1h!\u0015Y$\u0011\fB/\u0013\r\u0011Y\u0006\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\t}#q\r\b\u0005\u0005C\u0012\u0019\u0007\u0005\u0002]y%\u0019!Q\r\u001f\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011IGa\u001b\u0003\rM#(/\u001b8h\u0015\r\u0011)\u0007\u0010\u0005\b\u0005_Z\u0003\u0019\u0001B/\u0003\u001d\u0019wN\u001c;f]R\f\u0001d\u001c8SK\u001e,H.\u0019:SKN|WO]2f\r\u0016$8\r[3e))\t\tF!\u001e\u0003\u0000\t\u0005%1\u0011\u0005\b\u0005ob\u0003\u0019\u0001B=\u0003)\u0011Xm]8ve\u000e,G\u000b\u001f\t\u0004#\nm\u0014b\u0001B?%\nQ!+Z:pkJ\u001cW\r\u0016=\t\u000f\t-B\u00061\u0001\u00028\"9\u00111\b\u0017A\u0002\u0005}\u0002b\u0002B\u0018Y\u0001\u0007\u0011QD\u0001\u0015_:\u001c5o\u001d*fg>,(oY3GKR\u001c\u0007.\u001a3\u0015!\u0005E#\u0011\u0012BF\u0005\u001b\u0013yI!%\u0003\u0014\nU\u0005b\u0002B<[\u0001\u0007!\u0011\u0010\u0005\b\u0005Wi\u0003\u0019AA\\\u0011\u001d\tY$\fa\u0001\u0003\u007fAqAa\f.\u0001\u0004\ti\u0002C\u0004\u0003<5\u0002\rA!\u0010\t\u000f\tUS\u00061\u0001\u0003X!9!qN\u0017A\u0002\tu\u0013AC8o\r>dGn\\<VaR1\u0011\u0011\u000bBN\u0005?CaA!(/\u0001\u0004\u0001\u0016AC8sS\u001eLg.\u00197Uq\"1!\u0011\u0015\u0018A\u0002A\u000b!BZ8mY><X\u000b\u001d+y\u0003AygnQ1dQ\u0016$'+Z:pkJ\u001cW\r\u0006\u0004\u0002R\t\u001d&\u0011\u0016\u0005\b\u0005oz\u0003\u0019\u0001B=\u0011\u0015\u0019v\u00061\u0001Q\u0001")
public final class DefaultResourceAggregator
implements ResourceAggregator,
StrictLogging {
    private final HttpTx rootTx;
    private final List<HttpRequest> initialResources;
    private final HttpCaches httpCaches;
    private final ResourceFetcher resourceFetcher;
    private final HttpTxExecutor httpTxExecutor;
    private final Clock clock;
    private final boolean throttled;
    private final HttpProtocol httpProtocol;
    private final boolean http2Enabled;
    private Session session;
    private final Set<Uri> alreadySeen;
    private final Map<Remote, List<HttpRequest>> bufferedResourcesByHost;
    private final int maxConnectionsPerHost;
    private final Map<Remote, Object> availableTokensByHost;
    private int pendingResourcesCount;
    private Status globalStatus;
    private final long startTimestamp;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private boolean throttled() {
        return this.throttled;
    }

    private HttpProtocol httpProtocol() {
        return this.httpProtocol;
    }

    private boolean http2Enabled() {
        return this.http2Enabled;
    }

    private Session session() {
        return this.session;
    }

    private void session_$eq(Session x$1) {
        this.session = x$1;
    }

    private Set<Uri> alreadySeen() {
        return this.alreadySeen;
    }

    private Map<Remote, List<HttpRequest>> bufferedResourcesByHost() {
        return this.bufferedResourcesByHost;
    }

    private int maxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    private Map<Remote, Object> availableTokensByHost() {
        return this.availableTokensByHost;
    }

    private int pendingResourcesCount() {
        return this.pendingResourcesCount;
    }

    private void pendingResourcesCount_$eq(int x$1) {
        this.pendingResourcesCount = x$1;
    }

    private Status globalStatus() {
        return this.globalStatus;
    }

    private void globalStatus_$eq(Status x$1) {
        this.globalStatus = x$1;
    }

    private long startTimestamp() {
        return this.startTimestamp;
    }

    @Override
    public Session currentSession() {
        return this.session();
    }

    @Override
    public void start(Session session) {
        this.session_$eq(session);
        this.fetchOrBufferResources(this.initialResources);
    }

    private Http2PriorKnowledge getHttp2PriorKnowledge(Session session, Remote remote) {
        if (this.http2Enabled()) {
            return (Http2PriorKnowledge)Http2PriorKnowledgeSupport$.MODULE$.getHttp2PriorKnowledge(session, remote).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return Http2PriorKnowledge.HTTP1_ONLY;
    }

    private HttpTx createResourceTx(HttpRequest resource, Http2PriorKnowledge http2PriorKnowledge) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Create ResourceTx {} {}", new Object[]{resource.requestName(), resource.clientRequest().getUri()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Session x$4 = this.session();
        Request x$1 = resource.clientRequest().copyWithHttp2PriorKnowledge(http2PriorKnowledge);
        String x$2 = resource.copy$default$1();
        HttpRequestConfig x$3 = resource.copy$default$3();
        HttpRequest x$5 = resource.copy(x$2, x$1, x$3);
        Some x$6 = new Some((Object)new ResourceTx(this, resource.requestName(), resource.clientRequest().getUri()));
        boolean x$7 = false;
        Action x$8 = this.rootTx.copy$default$3();
        HttpTx resourceTx = this.rootTx.copy(x$4, x$5, x$8, (Option<ResourceTx>)x$6, 0);
        return resourceTx;
    }

    private void handleCachedResource(HttpRequest resource) {
        BoxedUnit boxedUnit;
        Uri uri = resource.clientRequest().getUri();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Fetching resource {} from cache", (Object)uri);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        boolean silent = resource.isSilent(false);
        ResourceTx resourceTx = new ResourceTx(this, resource.requestName(), uri);
        if (this.httpCaches.isCssCached(uri)) {
            this.onCssResourceFetched(resourceTx, (Status)OK$.MODULE$, this.session(), silent, HttpResponseStatus.NOT_MODIFIED, (Option<String>)None$.MODULE$, "");
            return;
        }
        this.onRegularResourceFetched(resourceTx, (Status)OK$.MODULE$, this.session(), silent);
    }

    private void fetchOrBufferResources(List<HttpRequest> resources) {
        this.alreadySeen().$plus$plus$eq((IterableOnce)resources.map((Function1 & Serializable)x$3 -> x$3.clientRequest().getUri()));
        this.pendingResourcesCount_$eq(this.pendingResourcesCount() + resources.size());
        Tuple2 tuple2 = resources.partition((Function1 & Serializable)resource -> BoxesRunTime.boxToBoolean((boolean)DefaultResourceAggregator.$anonfun$fetchOrBufferResources$3(this, resource)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List cached = (List)tuple2._1();
        List nonCached = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)cached, (Object)nonCached);
        List cached2 = (List)tuple22._1();
        List nonCached2 = (List)tuple22._2();
        cached2.foreach((Function1 & Serializable)resource -> {
            this.handleCachedResource(resource);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map requestsByRemote = nonCached2.groupBy((Function1 & Serializable)resource -> Remote$.MODULE$.apply(resource.clientRequest().getUri()));
        if (this.http2Enabled()) {
            requestsByRemote.foreachEntry((Function2 & Serializable)(remote, res) -> {
                DefaultResourceAggregator.$anonfun$fetchOrBufferResources$6(this, resources, remote, res);
                return BoxedUnit.UNIT;
            });
            return;
        }
        requestsByRemote.foreachEntry((Function2 & Serializable)(remote, res) -> {
            this.fetchAndBufferWithTokens$1(remote, res, Http2PriorKnowledge.HTTP1_ONLY);
            return BoxedUnit.UNIT;
        });
    }

    private void done() {
        Session session;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("All resources were fetched");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (this.rootTx.silent()) {
            session = this.session();
        } else {
            Status status = this.globalStatus();
            KO$ kO$ = KO$.MODULE$;
            Session sessionWithMark = !(status != null ? !status.equals(kO$) : kO$ != null) ? this.session().markAsFailed() : this.session();
            session = sessionWithMark.logGroupRequestTimings(this.startTimestamp(), this.clock.nowMillis());
        }
        Session newSession = session;
        this.rootTx.next().$bang(newSession);
    }

    private void sendBufferedRequest(HttpRequest request, Remote remote) {
        Option<Object> option;
        Some some;
        ContentCacheEntry contentCacheEntry;
        Option<ContentCacheEntry> option2 = this.httpCaches.contentCacheEntry(this.session(), request.clientRequest());
        if (None$.MODULE$.equals(option2)) {
            this.httpTxExecutor.execute(this.createResourceTx(request, this.getHttp2PriorKnowledge(this.session(), remote)));
            return;
        }
        if (option2 instanceof Some && (contentCacheEntry = (ContentCacheEntry)(some = (Some)option2).value()) != null && (option = contentCacheEntry.expires()) instanceof Some) {
            Some some2 = (Some)option;
            long expire = BoxesRunTime.unboxToLong((Object)some2.value());
            if (this.clock.nowMillis() > expire) {
                this.session_$eq(this.httpCaches.clearContentCache(this.session(), request.clientRequest()));
                this.httpTxExecutor.execute(this.createResourceTx(request, this.getHttp2PriorKnowledge(this.session(), remote)));
                return;
            }
        }
        this.handleCachedResource(request);
    }

    private void releaseTokenAndContinue(Remote remote, boolean isHttp2) {
        Some some;
        List list;
        Option option = this.bufferedResourcesByHost().get((Object)remote);
        if (option instanceof Some && Nil$.MODULE$.equals(list = (List)(some = (Some)option).value()) ? true : None$.MODULE$.equals(option)) {
            int availableToken = BoxesRunTime.unboxToInt((Object)this.availableTokensByHost().apply((Object)remote));
            this.availableTokensByHost().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)remote), (Object)(availableToken == this.maxConnectionsPerHost() ? BoxesRunTime.boxToInteger((int)availableToken) : BoxesRunTime.boxToInteger((int)(availableToken + 1)))));
            return;
        }
        if (option instanceof Some) {
            Some some2 = (Some)option;
            List requests = (List)some2.value();
            if (isHttp2) {
                this.bufferedResourcesByHost().remove((Object)remote);
                requests.foreach((Function1 & Serializable)x$6 -> {
                    this.sendBufferedRequest(x$6, remote);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            List list2 = requests;
            if (!(list2 instanceof .colon.colon)) {
                throw new MatchError((Object)list2);
            }
            .colon.colon colon2 = (.colon.colon)list2;
            HttpRequest request = (HttpRequest)colon2.head();
            List tail = colon2.next$access$1();
            Tuple2 tuple2 = new Tuple2((Object)request, (Object)tail);
            HttpRequest request2 = (HttpRequest)tuple2._1();
            List tail2 = (List)tuple2._2();
            this.bufferedResourcesByHost().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)remote), (Object)tail2));
            this.sendBufferedRequest(request2, remote);
            return;
        }
        throw new MatchError((Object)option);
    }

    private void resourceFetched(Session session, Remote remote, Status status, boolean silent) {
        this.pendingResourcesCount_$eq(this.pendingResourcesCount() - 1);
        if (!silent) {
            Status status2 = status;
            KO$ kO$ = KO$.MODULE$;
            if (!(status2 != null ? !status2.equals(kO$) : kO$ != null)) {
                this.globalStatus_$eq((Status)KO$.MODULE$);
            }
        }
        if (this.pendingResourcesCount() == 0) {
            this.done();
            return;
        }
        Http2PriorKnowledge http2PriorKnowledge = this.getHttp2PriorKnowledge(session, remote);
        Http2PriorKnowledge http2PriorKnowledge2 = Http2PriorKnowledge.HTTP2_SUPPORTED;
        this.releaseTokenAndContinue(remote, !(http2PriorKnowledge != null ? !http2PriorKnowledge.equals(http2PriorKnowledge2) : http2PriorKnowledge2 != null));
    }

    private void cssFetched(Uri uri, Status status, HttpResponseStatus responseStatus, Option<String> lastModifiedOrEtag, String content) {
        Status status2 = status;
        OK$ oK$ = OK$.MODULE$;
        if (!(status2 != null ? !status2.equals(oK$) : oK$ != null)) {
            List<HttpRequest> cssResources = this.resourceFetcher.cssFetched(uri, responseStatus, lastModifiedOrEtag, content, this.session(), this.throttled());
            if (cssResources.nonEmpty()) {
                List filtered = cssResources.filterNot((Function1 & Serializable)resource -> BoxesRunTime.boxToBoolean((boolean)DefaultResourceAggregator.$anonfun$cssFetched$1(this, resource)));
                this.fetchOrBufferResources((List<HttpRequest>)filtered);
                return;
            }
            return;
        }
    }

    @Override
    public void onRegularResourceFetched(ResourceTx resourceTx, Status status, Session session, boolean silent) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Resource {} {} was fetched", new Object[]{resourceTx.requestName(), resourceTx.uri()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.session_$eq(session);
        this.resourceFetched(session, Remote$.MODULE$.apply(resourceTx.uri()), status, silent);
    }

    @Override
    public void onCssResourceFetched(ResourceTx resourceTx, Status status, Session session, boolean silent, HttpResponseStatus responseStatus, Option<String> lastModifiedOrEtag, String content) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Css resource {} {} was fetched", new Object[]{resourceTx.requestName(), resourceTx.uri()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.session_$eq(session);
        this.cssFetched(resourceTx.uri(), status, responseStatus, lastModifiedOrEtag, content);
        this.resourceFetched(session, Remote$.MODULE$.apply(resourceTx.uri()), status, silent);
    }

    @Override
    public void onFollowUp(HttpTx originalTx, HttpTx followUpTx) {
        Remote followUpRemote;
        this.session_$eq(followUpTx.session());
        Uri originUri = originalTx.request().clientRequest().getUri();
        Remote originRemote = Remote$.MODULE$.apply(originUri);
        Uri followUpUri = followUpTx.request().clientRequest().getUri();
        Remote remote = followUpRemote = Remote$.MODULE$.apply(followUpUri);
        Remote remote2 = originRemote;
        if (!(remote != null ? !((Object)remote).equals(remote2) : remote2 != null)) {
            this.sendBufferedRequest(followUpTx.request(), followUpRemote);
            return;
        }
        Http2PriorKnowledge http2PriorKnowledge = this.getHttp2PriorKnowledge(this.session(), originRemote);
        Http2PriorKnowledge http2PriorKnowledge2 = Http2PriorKnowledge.HTTP2_SUPPORTED;
        this.releaseTokenAndContinue(originRemote, !(http2PriorKnowledge != null ? !http2PriorKnowledge.equals(http2PriorKnowledge2) : http2PriorKnowledge2 != null));
        this.availableTokensByHost().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)followUpRemote), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.availableTokensByHost().apply((Object)followUpRemote)) - 1))));
        if (BoxesRunTime.unboxToInt((Object)this.availableTokensByHost().apply((Object)followUpRemote)) > 0) {
            this.sendBufferedRequest(followUpTx.request(), followUpRemote);
            return;
        }
        HttpRequest httpRequest = followUpTx.request();
        this.bufferedResourcesByHost().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)followUpRemote), (Object)((List)this.bufferedResourcesByHost().apply((Object)followUpRemote)).$colon$colon((Object)httpRequest)));
    }

    @Override
    public void onCachedResource(ResourceTx resourceTx, HttpTx tx) {
        this.resourceFetched(tx.session(), Remote$.MODULE$.apply(resourceTx.uri()), (Status)OK$.MODULE$, tx.silent());
    }

    private final void fetchAndBufferWithTokens$1(Remote remote, List resources, Http2PriorKnowledge http2PriorKnowledge) {
        int availableTokens = BoxesRunTime.unboxToInt((Object)this.availableTokensByHost().apply((Object)remote));
        Tuple2 tuple2 = resources.splitAt(availableTokens);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List immediate = (List)tuple2._1();
        List buffered = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)immediate, (Object)buffered);
        List immediate2 = (List)tuple22._1();
        List buffered2 = (List)tuple22._2();
        this.fetchHttp1Resources$1(remote, immediate2, http2PriorKnowledge);
        this.bufferResources$1(remote, buffered2);
    }

    private final void fetchHttp1Resources$1(Remote remote, List resources, Http2PriorKnowledge http2PriorKnowledge) {
        this.availableTokensByHost().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)remote), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.availableTokensByHost().apply((Object)remote)) - resources.size()))));
        resources.foreach((Function1 & Serializable)resource -> {
            this.httpTxExecutor.execute(this.createResourceTx(resource, http2PriorKnowledge));
            return BoxedUnit.UNIT;
        });
    }

    private final void bufferResources$1(Remote remote, List resources) {
        List list = (List)this.bufferedResourcesByHost().apply((Object)remote);
        this.bufferedResourcesByHost().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)remote), (Object)resources.$colon$colon$colon(list)));
    }

    public static final /* synthetic */ boolean $anonfun$fetchOrBufferResources$3(DefaultResourceAggregator $this, HttpRequest resource) {
        Option<Object> option;
        Some some;
        ContentCacheEntry contentCacheEntry;
        Option<Object> option2;
        Some some2;
        ContentCacheEntry contentCacheEntry2;
        Request request = resource.clientRequest();
        Option<ContentCacheEntry> option3 = $this.httpCaches.contentCacheEntry($this.session(), request);
        if (None$.MODULE$.equals(option3) ? true : option3 instanceof Some && (contentCacheEntry2 = (ContentCacheEntry)(some2 = (Some)option3).value()) != null && None$.MODULE$.equals(option2 = contentCacheEntry2.expires())) {
            return false;
        }
        if (option3 instanceof Some && (contentCacheEntry = (ContentCacheEntry)(some = (Some)option3).value()) != null && (option = contentCacheEntry.expires()) instanceof Some) {
            Some some3 = (Some)option;
            long expire = BoxesRunTime.unboxToLong((Object)some3.value());
            if ($this.clock.nowMillis() > expire) {
                $this.session_$eq($this.httpCaches.clearContentCache($this.session(), request));
                return false;
            }
        }
        return true;
    }

    public static final /* synthetic */ void $anonfun$fetchOrBufferResources$6(DefaultResourceAggregator $this, List resources$1, Remote remote, List res) {
        Http2PriorKnowledge http2PriorKnowledge;
        Http2PriorKnowledge http2PriorKnowledge2 = http2PriorKnowledge = $this.getHttp2PriorKnowledge($this.session(), remote);
        Http2PriorKnowledge http2PriorKnowledge3 = Http2PriorKnowledge.HTTP2_SUPPORTED;
        if (!(http2PriorKnowledge2 != null ? !http2PriorKnowledge2.equals(http2PriorKnowledge3) : http2PriorKnowledge3 != null)) {
            $this.httpTxExecutor.execute((Iterable<HttpTx>)resources$1.map((Function1 & Serializable)x$5 -> $this.createResourceTx((HttpRequest)x$5, Http2PriorKnowledge.HTTP2_SUPPORTED)));
            return;
        }
        $this.fetchAndBufferWithTokens$1(remote, res, http2PriorKnowledge);
    }

    public static final /* synthetic */ boolean $anonfun$cssFetched$1(DefaultResourceAggregator $this, HttpRequest resource) {
        return $this.alreadySeen().contains((Object)resource.clientRequest().getUri());
    }

    public DefaultResourceAggregator(HttpTx rootTx, List<HttpRequest> initialResources, HttpCaches httpCaches, ResourceFetcher resourceFetcher, HttpTxExecutor httpTxExecutor, Clock clock) {
        this.rootTx = rootTx;
        this.initialResources = initialResources;
        this.httpCaches = httpCaches;
        this.resourceFetcher = resourceFetcher;
        this.httpTxExecutor = httpTxExecutor;
        this.clock = clock;
        StrictLogging.$init$((StrictLogging)this);
        this.throttled = rootTx.request().requestConfig().throttled();
        this.httpProtocol = rootTx.request().requestConfig().httpProtocol();
        this.http2Enabled = this.httpProtocol().enginePart().enableHttp2();
        this.alreadySeen = (Set)Set$.MODULE$.empty();
        this.bufferedResourcesByHost = LinkedHashMap$.MODULE$.empty().withDefaultValue((Object)Nil$.MODULE$);
        this.maxConnectionsPerHost = this.httpProtocol().enginePart().maxConnectionsPerHost();
        this.availableTokensByHost = HashMap$.MODULE$.empty().withDefaultValue((Object)BoxesRunTime.boxToInteger((int)this.maxConnectionsPerHost()));
        this.pendingResourcesCount = 0;
        this.globalStatus = OK$.MODULE$;
        this.startTimestamp = clock.nowMillis();
        Statics.releaseFence();
    }
}

