/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machineconfiguration.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineConfigPoolSpec;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineConfigPoolStatusConfiguration;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineConfigPoolStatusConfigurationBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineConfigPoolStatusConfigurationFluent;
import io.fabric8.openshift.api.model.machineconfiguration.v1.PinnedImageSetRef;
import io.fabric8.openshift.api.model.machineconfiguration.v1.PinnedImageSetRefBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1.PinnedImageSetRefFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachineConfigPoolSpecFluent<A extends MachineConfigPoolSpecFluent<A>>
extends BaseFluent<A> {
    private MachineConfigPoolStatusConfigurationBuilder configuration;
    private LabelSelectorBuilder machineConfigSelector;
    private IntOrStringBuilder maxUnavailable;
    private LabelSelectorBuilder nodeSelector;
    private Boolean paused;
    private ArrayList<PinnedImageSetRefBuilder> pinnedImageSets = new ArrayList();
    private Map<String, Object> additionalProperties;

    public MachineConfigPoolSpecFluent() {
    }

    public MachineConfigPoolSpecFluent(MachineConfigPoolSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachineConfigPoolSpec instance) {
        MachineConfigPoolSpec machineConfigPoolSpec = instance = instance != null ? instance : new MachineConfigPoolSpec();
        if (instance != null) {
            this.withConfiguration(instance.getConfiguration());
            this.withMachineConfigSelector(instance.getMachineConfigSelector());
            this.withMaxUnavailable(instance.getMaxUnavailable());
            this.withNodeSelector(instance.getNodeSelector());
            this.withPaused(instance.getPaused());
            this.withPinnedImageSets(instance.getPinnedImageSets());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public MachineConfigPoolStatusConfiguration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(MachineConfigPoolStatusConfiguration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new MachineConfigPoolStatusConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(MachineConfigPoolStatusConfiguration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new MachineConfigPoolStatusConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(MachineConfigPoolStatusConfiguration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public LabelSelector buildMachineConfigSelector() {
        return this.machineConfigSelector != null ? this.machineConfigSelector.build() : null;
    }

    public A withMachineConfigSelector(LabelSelector machineConfigSelector) {
        this._visitables.remove((Object)"machineConfigSelector");
        if (machineConfigSelector != null) {
            this.machineConfigSelector = new LabelSelectorBuilder(machineConfigSelector);
            this._visitables.get((Object)"machineConfigSelector").add(this.machineConfigSelector);
        } else {
            this.machineConfigSelector = null;
            this._visitables.get((Object)"machineConfigSelector").remove(this.machineConfigSelector);
        }
        return (A)((Object)this);
    }

    public boolean hasMachineConfigSelector() {
        return this.machineConfigSelector != null;
    }

    public MachineConfigSelectorNested<A> withNewMachineConfigSelector() {
        return new MachineConfigSelectorNested(null);
    }

    public MachineConfigSelectorNested<A> withNewMachineConfigSelectorLike(LabelSelector item) {
        return new MachineConfigSelectorNested(item);
    }

    public MachineConfigSelectorNested<A> editMachineConfigSelector() {
        return this.withNewMachineConfigSelectorLike(Optional.ofNullable(this.buildMachineConfigSelector()).orElse(null));
    }

    public MachineConfigSelectorNested<A> editOrNewMachineConfigSelector() {
        return this.withNewMachineConfigSelectorLike(Optional.ofNullable(this.buildMachineConfigSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public MachineConfigSelectorNested<A> editOrNewMachineConfigSelectorLike(LabelSelector item) {
        return this.withNewMachineConfigSelectorLike(Optional.ofNullable(this.buildMachineConfigSelector()).orElse(item));
    }

    public IntOrString buildMaxUnavailable() {
        return this.maxUnavailable != null ? this.maxUnavailable.build() : null;
    }

    public A withMaxUnavailable(IntOrString maxUnavailable) {
        this._visitables.remove((Object)"maxUnavailable");
        if (maxUnavailable != null) {
            this.maxUnavailable = new IntOrStringBuilder(maxUnavailable);
            this._visitables.get((Object)"maxUnavailable").add(this.maxUnavailable);
        } else {
            this.maxUnavailable = null;
            this._visitables.get((Object)"maxUnavailable").remove(this.maxUnavailable);
        }
        return (A)((Object)this);
    }

    public boolean hasMaxUnavailable() {
        return this.maxUnavailable != null;
    }

    public A withNewMaxUnavailable(Object value) {
        return this.withMaxUnavailable(new IntOrString(value));
    }

    public MaxUnavailableNested<A> withNewMaxUnavailable() {
        return new MaxUnavailableNested(null);
    }

    public MaxUnavailableNested<A> withNewMaxUnavailableLike(IntOrString item) {
        return new MaxUnavailableNested(item);
    }

    public MaxUnavailableNested<A> editMaxUnavailable() {
        return this.withNewMaxUnavailableLike(Optional.ofNullable(this.buildMaxUnavailable()).orElse(null));
    }

    public MaxUnavailableNested<A> editOrNewMaxUnavailable() {
        return this.withNewMaxUnavailableLike(Optional.ofNullable(this.buildMaxUnavailable()).orElse(new IntOrStringBuilder().build()));
    }

    public MaxUnavailableNested<A> editOrNewMaxUnavailableLike(IntOrString item) {
        return this.withNewMaxUnavailableLike(Optional.ofNullable(this.buildMaxUnavailable()).orElse(item));
    }

    public LabelSelector buildNodeSelector() {
        return this.nodeSelector != null ? this.nodeSelector.build() : null;
    }

    public A withNodeSelector(LabelSelector nodeSelector) {
        this._visitables.remove((Object)"nodeSelector");
        if (nodeSelector != null) {
            this.nodeSelector = new LabelSelectorBuilder(nodeSelector);
            this._visitables.get((Object)"nodeSelector").add(this.nodeSelector);
        } else {
            this.nodeSelector = null;
            this._visitables.get((Object)"nodeSelector").remove(this.nodeSelector);
        }
        return (A)((Object)this);
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public NodeSelectorNested<A> withNewNodeSelector() {
        return new NodeSelectorNested(null);
    }

    public NodeSelectorNested<A> withNewNodeSelectorLike(LabelSelector item) {
        return new NodeSelectorNested(item);
    }

    public NodeSelectorNested<A> editNodeSelector() {
        return this.withNewNodeSelectorLike(Optional.ofNullable(this.buildNodeSelector()).orElse(null));
    }

    public NodeSelectorNested<A> editOrNewNodeSelector() {
        return this.withNewNodeSelectorLike(Optional.ofNullable(this.buildNodeSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public NodeSelectorNested<A> editOrNewNodeSelectorLike(LabelSelector item) {
        return this.withNewNodeSelectorLike(Optional.ofNullable(this.buildNodeSelector()).orElse(item));
    }

    public Boolean getPaused() {
        return this.paused;
    }

    public A withPaused(Boolean paused) {
        this.paused = paused;
        return (A)((Object)this);
    }

    public boolean hasPaused() {
        return this.paused != null;
    }

    public A addToPinnedImageSets(int index, PinnedImageSetRef item) {
        if (this.pinnedImageSets == null) {
            this.pinnedImageSets = new ArrayList();
        }
        PinnedImageSetRefBuilder builder = new PinnedImageSetRefBuilder(item);
        if (index < 0 || index >= this.pinnedImageSets.size()) {
            this._visitables.get((Object)"pinnedImageSets").add(builder);
            this.pinnedImageSets.add(builder);
        } else {
            this._visitables.get((Object)"pinnedImageSets").add(builder);
            this.pinnedImageSets.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPinnedImageSets(int index, PinnedImageSetRef item) {
        if (this.pinnedImageSets == null) {
            this.pinnedImageSets = new ArrayList();
        }
        PinnedImageSetRefBuilder builder = new PinnedImageSetRefBuilder(item);
        if (index < 0 || index >= this.pinnedImageSets.size()) {
            this._visitables.get((Object)"pinnedImageSets").add(builder);
            this.pinnedImageSets.add(builder);
        } else {
            this._visitables.get((Object)"pinnedImageSets").add(builder);
            this.pinnedImageSets.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPinnedImageSets(PinnedImageSetRef ... items) {
        if (this.pinnedImageSets == null) {
            this.pinnedImageSets = new ArrayList();
        }
        for (PinnedImageSetRef item : items) {
            PinnedImageSetRefBuilder builder = new PinnedImageSetRefBuilder(item);
            this._visitables.get((Object)"pinnedImageSets").add(builder);
            this.pinnedImageSets.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPinnedImageSets(Collection<PinnedImageSetRef> items) {
        if (this.pinnedImageSets == null) {
            this.pinnedImageSets = new ArrayList();
        }
        for (PinnedImageSetRef item : items) {
            PinnedImageSetRefBuilder builder = new PinnedImageSetRefBuilder(item);
            this._visitables.get((Object)"pinnedImageSets").add(builder);
            this.pinnedImageSets.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPinnedImageSets(PinnedImageSetRef ... items) {
        if (this.pinnedImageSets == null) {
            return (A)((Object)this);
        }
        for (PinnedImageSetRef item : items) {
            PinnedImageSetRefBuilder builder = new PinnedImageSetRefBuilder(item);
            this._visitables.get((Object)"pinnedImageSets").remove((Object)builder);
            this.pinnedImageSets.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPinnedImageSets(Collection<PinnedImageSetRef> items) {
        if (this.pinnedImageSets == null) {
            return (A)((Object)this);
        }
        for (PinnedImageSetRef item : items) {
            PinnedImageSetRefBuilder builder = new PinnedImageSetRefBuilder(item);
            this._visitables.get((Object)"pinnedImageSets").remove((Object)builder);
            this.pinnedImageSets.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPinnedImageSets(Predicate<PinnedImageSetRefBuilder> predicate) {
        if (this.pinnedImageSets == null) {
            return (A)((Object)this);
        }
        Iterator<PinnedImageSetRefBuilder> each = this.pinnedImageSets.iterator();
        List visitables = this._visitables.get((Object)"pinnedImageSets");
        while (each.hasNext()) {
            PinnedImageSetRefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<PinnedImageSetRef> buildPinnedImageSets() {
        return this.pinnedImageSets != null ? MachineConfigPoolSpecFluent.build(this.pinnedImageSets) : null;
    }

    public PinnedImageSetRef buildPinnedImageSet(int index) {
        return this.pinnedImageSets.get(index).build();
    }

    public PinnedImageSetRef buildFirstPinnedImageSet() {
        return this.pinnedImageSets.get(0).build();
    }

    public PinnedImageSetRef buildLastPinnedImageSet() {
        return this.pinnedImageSets.get(this.pinnedImageSets.size() - 1).build();
    }

    public PinnedImageSetRef buildMatchingPinnedImageSet(Predicate<PinnedImageSetRefBuilder> predicate) {
        for (PinnedImageSetRefBuilder item : this.pinnedImageSets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPinnedImageSet(Predicate<PinnedImageSetRefBuilder> predicate) {
        for (PinnedImageSetRefBuilder item : this.pinnedImageSets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPinnedImageSets(List<PinnedImageSetRef> pinnedImageSets) {
        if (this.pinnedImageSets != null) {
            this._visitables.get((Object)"pinnedImageSets").clear();
        }
        if (pinnedImageSets != null) {
            this.pinnedImageSets = new ArrayList();
            for (PinnedImageSetRef item : pinnedImageSets) {
                this.addToPinnedImageSets(item);
            }
        } else {
            this.pinnedImageSets = null;
        }
        return (A)((Object)this);
    }

    public A withPinnedImageSets(PinnedImageSetRef ... pinnedImageSets) {
        if (this.pinnedImageSets != null) {
            this.pinnedImageSets.clear();
            this._visitables.remove((Object)"pinnedImageSets");
        }
        if (pinnedImageSets != null) {
            for (PinnedImageSetRef item : pinnedImageSets) {
                this.addToPinnedImageSets(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPinnedImageSets() {
        return this.pinnedImageSets != null && !this.pinnedImageSets.isEmpty();
    }

    public A addNewPinnedImageSet(String name) {
        return this.addToPinnedImageSets(new PinnedImageSetRef(name));
    }

    public PinnedImageSetsNested<A> addNewPinnedImageSet() {
        return new PinnedImageSetsNested(-1, null);
    }

    public PinnedImageSetsNested<A> addNewPinnedImageSetLike(PinnedImageSetRef item) {
        return new PinnedImageSetsNested(-1, item);
    }

    public PinnedImageSetsNested<A> setNewPinnedImageSetLike(int index, PinnedImageSetRef item) {
        return new PinnedImageSetsNested(index, item);
    }

    public PinnedImageSetsNested<A> editPinnedImageSet(int index) {
        if (this.pinnedImageSets.size() <= index) {
            throw new RuntimeException("Can't edit pinnedImageSets. Index exceeds size.");
        }
        return this.setNewPinnedImageSetLike(index, this.buildPinnedImageSet(index));
    }

    public PinnedImageSetsNested<A> editFirstPinnedImageSet() {
        if (this.pinnedImageSets.size() == 0) {
            throw new RuntimeException("Can't edit first pinnedImageSets. The list is empty.");
        }
        return this.setNewPinnedImageSetLike(0, this.buildPinnedImageSet(0));
    }

    public PinnedImageSetsNested<A> editLastPinnedImageSet() {
        int index = this.pinnedImageSets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last pinnedImageSets. The list is empty.");
        }
        return this.setNewPinnedImageSetLike(index, this.buildPinnedImageSet(index));
    }

    public PinnedImageSetsNested<A> editMatchingPinnedImageSet(Predicate<PinnedImageSetRefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.pinnedImageSets.size(); ++i) {
            if (!predicate.test(this.pinnedImageSets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching pinnedImageSets. No match found.");
        }
        return this.setNewPinnedImageSetLike(index, this.buildPinnedImageSet(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineConfigPoolSpecFluent that = (MachineConfigPoolSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.machineConfigSelector, that.machineConfigSelector)) {
            return false;
        }
        if (!Objects.equals(this.maxUnavailable, that.maxUnavailable)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals(this.paused, that.paused)) {
            return false;
        }
        if (!Objects.equals(this.pinnedImageSets, that.pinnedImageSets)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configuration, this.machineConfigSelector, this.maxUnavailable, this.nodeSelector, this.paused, this.pinnedImageSets, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(String.valueOf((Object)this.configuration) + ",");
        }
        if (this.machineConfigSelector != null) {
            sb.append("machineConfigSelector:");
            sb.append(String.valueOf(this.machineConfigSelector) + ",");
        }
        if (this.maxUnavailable != null) {
            sb.append("maxUnavailable:");
            sb.append(String.valueOf(this.maxUnavailable) + ",");
        }
        if (this.nodeSelector != null) {
            sb.append("nodeSelector:");
            sb.append(String.valueOf(this.nodeSelector) + ",");
        }
        if (this.paused != null) {
            sb.append("paused:");
            sb.append(this.paused + ",");
        }
        if (this.pinnedImageSets != null && !this.pinnedImageSets.isEmpty()) {
            sb.append("pinnedImageSets:");
            sb.append(String.valueOf(this.pinnedImageSets) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withPaused() {
        return this.withPaused(true);
    }

    public class PinnedImageSetsNested<N>
    extends PinnedImageSetRefFluent<PinnedImageSetsNested<N>>
    implements Nested<N> {
        PinnedImageSetRefBuilder builder;
        int index;

        PinnedImageSetsNested(int index, PinnedImageSetRef item) {
            this.index = index;
            this.builder = new PinnedImageSetRefBuilder(this, item);
        }

        public N and() {
            return (N)MachineConfigPoolSpecFluent.this.setToPinnedImageSets(this.index, this.builder.build());
        }

        public N endPinnedImageSet() {
            return this.and();
        }
    }

    public class NodeSelectorNested<N>
    extends LabelSelectorFluent<NodeSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        NodeSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)MachineConfigPoolSpecFluent.this.withNodeSelector(this.builder.build());
        }

        public N endNodeSelector() {
            return this.and();
        }
    }

    public class MaxUnavailableNested<N>
    extends IntOrStringFluent<MaxUnavailableNested<N>>
    implements Nested<N> {
        IntOrStringBuilder builder;

        MaxUnavailableNested(IntOrString item) {
            this.builder = new IntOrStringBuilder((IntOrStringFluent)this, item);
        }

        public N and() {
            return (N)MachineConfigPoolSpecFluent.this.withMaxUnavailable(this.builder.build());
        }

        public N endMaxUnavailable() {
            return this.and();
        }
    }

    public class MachineConfigSelectorNested<N>
    extends LabelSelectorFluent<MachineConfigSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        MachineConfigSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)MachineConfigPoolSpecFluent.this.withMachineConfigSelector(this.builder.build());
        }

        public N endMachineConfigSelector() {
            return this.and();
        }
    }

    public class ConfigurationNested<N>
    extends MachineConfigPoolStatusConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        MachineConfigPoolStatusConfigurationBuilder builder;

        ConfigurationNested(MachineConfigPoolStatusConfiguration item) {
            this.builder = new MachineConfigPoolStatusConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)MachineConfigPoolSpecFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

