/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access;

import io.fabric8.maven.docker.access.AuthConfig;
import io.fabric8.maven.docker.access.BuildOptions;
import io.fabric8.maven.docker.access.ContainerCreateConfig;
import io.fabric8.maven.docker.access.CreateImageOptions;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.access.NetworkCreateConfig;
import io.fabric8.maven.docker.access.VolumeCreateConfig;
import io.fabric8.maven.docker.access.log.LogCallback;
import io.fabric8.maven.docker.access.log.LogGetHandle;
import io.fabric8.maven.docker.config.ArchiveCompression;
import io.fabric8.maven.docker.config.Arguments;
import io.fabric8.maven.docker.log.LogOutputSpec;
import io.fabric8.maven.docker.model.Container;
import io.fabric8.maven.docker.model.ContainerDetails;
import io.fabric8.maven.docker.model.ExecDetails;
import io.fabric8.maven.docker.model.Image;
import io.fabric8.maven.docker.model.Network;
import java.io.File;
import java.util.List;

public interface DockerAccess {
    public void start() throws DockerAccessException;

    public void shutdown();

    public String getServerApiVersion() throws DockerAccessException;

    public String getNativePlatform();

    public ContainerDetails getContainer(String var1) throws DockerAccessException;

    public ExecDetails getExecContainer(String var1) throws DockerAccessException;

    public boolean hasImage(String var1) throws DockerAccessException;

    public String getImageId(String var1) throws DockerAccessException;

    public List<String> getImageTags(String var1) throws DockerAccessException;

    public List<Container> listContainers(boolean var1) throws DockerAccessException;

    public List<Container> getContainersForImage(String var1, boolean var2) throws DockerAccessException;

    public void startExecContainer(String var1, LogOutputSpec var2) throws DockerAccessException;

    public String createExecContainer(String var1, Arguments var2) throws DockerAccessException;

    public String createContainer(ContainerCreateConfig var1, String var2) throws DockerAccessException;

    public void startContainer(String var1) throws DockerAccessException;

    public void stopContainer(String var1, int var2) throws DockerAccessException;

    public void killContainer(String var1) throws DockerAccessException;

    public void copyArchiveToContainer(String var1, File var2, String var3) throws DockerAccessException;

    public void copyArchiveFromContainer(String var1, String var2, File var3) throws DockerAccessException;

    public void getLogSync(String var1, LogCallback var2);

    public LogGetHandle getLogAsync(String var1, LogCallback var2);

    public void removeContainer(String var1, boolean var2) throws DockerAccessException;

    public List<Image> listImages(boolean var1) throws DockerAccessException;

    public void loadImage(String var1, File var2) throws DockerAccessException;

    public void pullImage(String var1, AuthConfig var2, String var3, CreateImageOptions var4) throws DockerAccessException;

    public void pushImage(String var1, AuthConfig var2, String var3, int var4) throws DockerAccessException;

    public void buildImage(String var1, File var2, BuildOptions var3) throws DockerAccessException;

    public void tag(String var1, String var2, boolean var3) throws DockerAccessException;

    public boolean removeImage(String var1, boolean var2) throws DockerAccessException;

    public void saveImage(String var1, String var2, ArchiveCompression var3) throws DockerAccessException;

    public List<Network> listNetworks() throws DockerAccessException;

    public String createNetwork(NetworkCreateConfig var1) throws DockerAccessException;

    public boolean removeNetwork(String var1) throws DockerAccessException;

    public String createVolume(VolumeCreateConfig var1) throws DockerAccessException;

    public void removeVolume(String var1) throws DockerAccessException;
}

