/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.AstNode;
import io.cucumber.gherkin.LineSpan;
import io.cucumber.gherkin.Locations;
import io.cucumber.gherkin.Parser;
import io.cucumber.gherkin.ParserException;
import io.cucumber.gherkin.Token;
import io.cucumber.messages.IdGenerator;
import io.cucumber.messages.types.Background;
import io.cucumber.messages.types.Comment;
import io.cucumber.messages.types.DataTable;
import io.cucumber.messages.types.DocString;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.FeatureChild;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.RuleChild;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.TableCell;
import io.cucumber.messages.types.TableRow;
import io.cucumber.messages.types.Tag;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;

final class GherkinDocumentBuilder
implements Parser.Builder<GherkinDocument> {
    private final List<Comment> comments = new ArrayList<Comment>();
    private final IdGenerator idGenerator;
    private String uri;
    private Deque<AstNode> stack;

    GherkinDocumentBuilder(IdGenerator idGenerator, String uri) {
        this.idGenerator = idGenerator;
        this.reset(uri);
    }

    @Override
    public void reset(String uri) {
        this.uri = uri;
        this.stack = new ArrayDeque<AstNode>();
        this.stack.push(new AstNode(Parser.RuleType.None));
    }

    private AstNode currentNode() {
        return this.stack.peek();
    }

    @Override
    public void build(Token token) {
        if (token.matchedType == Parser.TokenType.Comment) {
            Comment comment = new Comment(token.location, token.matchedText);
            this.comments.add(comment);
        } else {
            this.currentNode().add(token.matchedType.ruleType, token);
        }
    }

    @Override
    public void startRule(Parser.RuleType ruleType) {
        this.stack.push(new AstNode(ruleType));
    }

    @Override
    public void endRule(Parser.RuleType ruleType) {
        AstNode node = this.stack.pop();
        Object transformedNode = this.getTransformedNode(node);
        this.currentNode().add(node.ruleType, transformedNode);
    }

    private Object getTransformedNode(AstNode node) {
        switch (node.ruleType) {
            case Step: {
                Token stepLine = node.getToken(Parser.TokenType.StepLine);
                return new Step(stepLine.location, stepLine.matchedKeyword, stepLine.keywordType, stepLine.matchedText, (DocString)node.getSingle(Parser.RuleType.DocString, null), (DataTable)node.getSingle(Parser.RuleType.DataTable, null), this.idGenerator.newId());
            }
            case DocString: {
                Token separatorToken = node.getTokens(Parser.TokenType.DocStringSeparator).get(0);
                String mediaType = separatorToken.matchedText.isEmpty() ? null : separatorToken.matchedText;
                List<Token> lineTokens = node.getTokens(Parser.TokenType.Other);
                String content = GherkinDocumentBuilder.joinMatchedText(lineTokens, lineTokens.size());
                return new DocString(separatorToken.location, mediaType, content, separatorToken.matchedKeyword);
            }
            case DataTable: {
                List<TableRow> rows = this.getTableRows(node);
                return new DataTable(rows.get(0).getLocation(), rows);
            }
            case Background: {
                Token backgroundLine = node.getToken(Parser.TokenType.BackgroundLine);
                return new Background(backgroundLine.location, backgroundLine.matchedKeyword, backgroundLine.matchedText, this.getDescription(node), this.getSteps(node), this.idGenerator.newId());
            }
            case ScenarioDefinition: {
                AstNode scenarioNode = node.getSingle(Parser.RuleType.Scenario, null);
                Token scenarioLine = scenarioNode.getToken(Parser.TokenType.ScenarioLine);
                return new Scenario(scenarioLine.location, this.getTags(node), scenarioLine.matchedKeyword, scenarioLine.matchedText, this.getDescription(scenarioNode), this.getSteps(scenarioNode), scenarioNode.getItems(Parser.RuleType.ExamplesDefinition), this.idGenerator.newId());
            }
            case ExamplesDefinition: {
                AstNode examplesNode = node.getSingle(Parser.RuleType.Examples, null);
                Token examplesLine = examplesNode.getToken(Parser.TokenType.ExamplesLine);
                List rows = examplesNode.getSingle(Parser.RuleType.ExamplesTable, null);
                TableRow tableHeader = rows != null && !rows.isEmpty() ? (TableRow)rows.get(0) : null;
                List tableBody = rows != null && !rows.isEmpty() ? rows.subList(1, rows.size()) : Collections.emptyList();
                return new Examples(examplesLine.location, this.getTags(node), examplesLine.matchedKeyword, examplesLine.matchedText, this.getDescription(examplesNode), tableHeader, tableBody, this.idGenerator.newId());
            }
            case ExamplesTable: {
                return this.getTableRows(node);
            }
            case Description: {
                int toIndex;
                List<Token> lineTokens = node.getTokens(Parser.TokenType.Other);
                for (toIndex = lineTokens.size(); toIndex > 0 && lineTokens.get((int)(toIndex - 1)).line.isEmpty(); --toIndex) {
                }
                return GherkinDocumentBuilder.joinMatchedText(lineTokens, toIndex);
            }
            case Feature: {
                AstNode header = node.getSingle(Parser.RuleType.FeatureHeader, new AstNode(Parser.RuleType.FeatureHeader));
                if (header == null) {
                    return null;
                }
                List<Tag> tags = this.getTags(header);
                Token featureLine = header.getToken(Parser.TokenType.FeatureLine);
                if (featureLine == null) {
                    return null;
                }
                ArrayList<FeatureChild> children = new ArrayList<FeatureChild>();
                Background background = node.getSingle(Parser.RuleType.Background, null);
                if (background != null) {
                    children.add(new FeatureChild(null, background, null));
                }
                for (Scenario scenario : node.getItems(Parser.RuleType.ScenarioDefinition)) {
                    children.add(new FeatureChild(null, null, scenario));
                }
                for (Rule rule : node.getItems(Parser.RuleType.Rule)) {
                    children.add(new FeatureChild(rule, null, null));
                }
                return new Feature(featureLine.location, tags, featureLine.matchedLanguage, featureLine.matchedKeyword, featureLine.matchedText, this.getDescription(header), children);
            }
            case Rule: {
                AstNode header = node.getSingle(Parser.RuleType.RuleHeader, new AstNode(Parser.RuleType.RuleHeader));
                if (header == null) {
                    return null;
                }
                Token ruleLine = header.getToken(Parser.TokenType.RuleLine);
                if (ruleLine == null) {
                    return null;
                }
                ArrayList<RuleChild> children = new ArrayList<RuleChild>();
                List<Tag> tags = this.getTags(header);
                Background background = node.getSingle(Parser.RuleType.Background, null);
                if (background != null) {
                    children.add(new RuleChild(background, null));
                }
                List scenarios = node.getItems(Parser.RuleType.ScenarioDefinition);
                for (Scenario scenario : scenarios) {
                    children.add(new RuleChild(null, scenario));
                }
                return new Rule(ruleLine.location, tags, ruleLine.matchedKeyword, ruleLine.matchedText, this.getDescription(header), children, this.idGenerator.newId());
            }
            case GherkinDocument: {
                Feature feature = node.getSingle(Parser.RuleType.Feature, null);
                return new GherkinDocument(this.uri, feature, this.comments);
            }
        }
        return node;
    }

    private static String joinMatchedText(List<Token> lineTokens, int toIndex) {
        StringBuilder content = new StringBuilder(100 * lineTokens.size());
        for (int i = 0; i < toIndex; ++i) {
            Token lineToken = lineTokens.get(i);
            content.append(lineToken.matchedText).append('\n');
        }
        int contentLength = content.length();
        if (contentLength > 0) {
            content.setLength(contentLength - 1);
        }
        return content.toString();
    }

    private List<TableRow> getTableRows(AstNode node) {
        List<Token> tokens = node.getTokens(Parser.TokenType.TableRow);
        int tokenSize = tokens.size();
        ArrayList<TableRow> rows = new ArrayList<TableRow>(tokenSize);
        for (int i = 0; i < tokenSize; ++i) {
            Token token = tokens.get(i);
            rows.add(new TableRow(token.location, this.getCells(token), this.idGenerator.newId()));
        }
        this.ensureCellCount(rows);
        return rows;
    }

    private void ensureCellCount(List<TableRow> rows) {
        if (rows.isEmpty()) {
            return;
        }
        int firstRowCellsSize = rows.get(0).getCells().size();
        int rowsSize = rows.size();
        for (int i = 0; i < rowsSize; ++i) {
            TableRow row = rows.get(i);
            if (row.getCells().size() == firstRowCellsSize) continue;
            throw new ParserException.AstBuilderException("inconsistent cell count within the table", row.getLocation());
        }
    }

    private List<TableCell> getCells(Token token) {
        List<LineSpan> matchedItems = token.matchedItems;
        int itemSize = matchedItems.size();
        ArrayList<TableCell> cells = new ArrayList<TableCell>(itemSize);
        for (int i = 0; i < itemSize; ++i) {
            LineSpan cellItem = matchedItems.get(i);
            TableCell tableCell = new TableCell(Locations.atColumn(token.location, cellItem.column), cellItem.text);
            cells.add(tableCell);
        }
        return cells;
    }

    private List<Step> getSteps(AstNode node) {
        return node.getItems(Parser.RuleType.Step);
    }

    private String getDescription(AstNode node) {
        return node.getSingle(Parser.RuleType.Description, "");
    }

    private List<Tag> getTags(AstNode node) {
        AstNode tagsNode = node.getSingle(Parser.RuleType.Tags, null);
        if (tagsNode == null) {
            return Collections.emptyList();
        }
        List<Token> tokens = tagsNode.getTokens(Parser.TokenType.TagLine);
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (Token token : tokens) {
            for (LineSpan tagItem : token.matchedItems) {
                tags.add(new Tag(Locations.atColumn(token.location, tagItem.column), tagItem.text, this.idGenerator.newId()));
            }
        }
        return tags;
    }

    @Override
    public GherkinDocument getResult() {
        return this.currentNode().getSingle(Parser.RuleType.GherkinDocument, null);
    }
}

