/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components.messagelist;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.Uses;
import com.vaadin.flow.component.messages.MessageList;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.server.Command;
import in.virit.color.HexColor;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.vaadin.firitin.components.RichText;

@Tag(value="vaadin-message")
@Uses(value=MessageList.class)
public class MarkdownMessage
extends Component
implements HasStyle,
HasSize {
    private static final String PLACEHOLDER = "...";
    private UI ui;
    private String previousHtml;
    private boolean autoScroll = true;
    private Element content = new Element("div");
    private Element scrollHelper = new Element("div");
    private MarkdownStrategy markdownStrategy;

    public MarkdownMessage(String name, LocalDateTime timestamp, in.virit.color.Color color) {
        this.getElement().setProperty("userName", name);
        this.getElement().setProperty("time", timestamp.format(DateTimeFormatter.ofPattern("YYYY-MM-dd hh:mm")));
        this.getElement().appendChild(new Element[]{this.content, this.scrollHelper});
        if (color != null) {
            this.setAvatarColor(color);
        }
        this.content.getStyle().setWhiteSpace(Style.WhiteSpace.NORMAL);
    }

    public MarkdownMessage(String name) {
        this(name, LocalDateTime.now(), Color.AVATAR_PRESETS[0]);
        this.setMarkdown(null);
    }

    public MarkdownMessage(String name, LocalDateTime timestamp) {
        this(name, timestamp, Color.AVATAR_PRESETS[0]);
        this.setMarkdown(null);
    }

    public MarkdownMessage(String name, in.virit.color.Color avatarColor) {
        this(name, LocalDateTime.now(), avatarColor);
        this.setMarkdown(null);
    }

    public MarkdownMessage(String markdown, String name, in.virit.color.Color avatarColor) {
        this(name, LocalDateTime.now(), avatarColor);
        this.setMarkdown(markdown);
    }

    public MarkdownMessage(String markdown, String name) {
        this(name, LocalDateTime.now(), Color.AVATAR_PRESETS[name.hashCode() % Color.AVATAR_PRESETS.length]);
        this.setMarkdown(markdown);
    }

    public MarkdownMessage(String markdown, String name, LocalDateTime timestamp) {
        this(name, timestamp, null);
        this.setMarkdown(markdown);
    }

    public void setAvatarColor(in.virit.color.Color color) {
        this.getElement().getStyle().set("--vaadin-avatar-user-color", color.toString());
        this.getElement().executeJs("\n$0.querySelector('vaadin-avatar').style.setProperty('--vaadin-avatar-user-color', null);$0.querySelector('vaadin-avatar').setAttribute('has-color-index', true);", new Object[0]);
    }

    public void setUserColorIndex(int index) {
        this.getElement().setProperty("userColorIndex", (double)index);
    }

    protected MarkdownStrategy getMarkdownStrategy() {
        if (this.markdownStrategy == null) {
            this.markdownStrategy = new MarkdownItStrategy();
        }
        return this.markdownStrategy;
    }

    protected void setMarkdown(String markdown, boolean uiAccess) {
        this.getMarkdownStrategy().setMarkdown(markdown, uiAccess);
    }

    public void setMarkdown(String markdown) {
        this.setMarkdown(markdown, false);
    }

    private void appendHtml(String html) {
        this.getElement().executeJs("if(this.curHtml) {\n    this.curHtml = this.curHtml + $0;\n} else {\n    this.curHtml = $0;\n}\n$1.innerHTML = this.curHtml;\n", new Object[]{html, this.content});
    }

    private void appendHtml(String html, int replaceFrom) {
        this.getElement().executeJs("this.curHtml = this.curHtml ? this.curHtml.substring(0, $2) + $0 : $0;\n$1.innerHTML = this.curHtml;\n", new Object[]{html, this.content, replaceFrom});
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.ui = attachEvent.getUI();
    }

    public UI getUi() {
        if (this.ui == null) {
            this.ui = this.ui.getUI().orElseGet(() -> UI.getCurrent());
        }
        return this.ui;
    }

    public void appendMarkdown(String markdownSnippet) {
        this.appendMarkdown(markdownSnippet, false);
    }

    public void appendMarkdownAsync(String markdownSnippet) {
        this.appendMarkdown(markdownSnippet, true);
    }

    protected void appendMarkdown(String markdownSnippet, boolean uiAccess) {
        this.getMarkdownStrategy().appendMarkdown(markdownSnippet, uiAccess);
    }

    public boolean isAutoScroll() {
        return this.autoScroll;
    }

    public void setAutoScroll(boolean autoScroll) {
        this.autoScroll = autoScroll;
    }

    protected void doAutoScroll() {
        if (this.autoScroll) {
            this.scrollHelper.executeJs("    if(this.scrollIntoViewIfNeeded) {\n        this.scrollIntoViewIfNeeded();\n    } else {\n        // FF\n        this.scrollIntoView();\n    }\n", new Object[0]);
        }
    }

    public static interface Color {
        public static final in.virit.color.Color[] AVATAR_PRESETS = new in.virit.color.Color[]{HexColor.of((String)"#df0b92"), HexColor.of((String)"#650acc"), HexColor.of((String)"#097faa"), HexColor.of((String)"#ad6200"), HexColor.of((String)"#bf16f3"), HexColor.of((String)"#084391"), HexColor.of((String)"#078836")};
    }

    static interface MarkdownStrategy {
        public void appendMarkdown(String var1, boolean var2);

        public void setMarkdown(String var1, boolean var2);
    }

    class MarkdownItStrategy
    implements MarkdownStrategy {
        MarkdownItStrategy() {
        }

        @Override
        public void appendMarkdown(String markdown, boolean uiAccess) {
            Command & Serializable c = (Command & Serializable)() -> {
                RichText.MarkdownItStrategy.ensureMarkdownIt();
                MarkdownMessage.this.content.executeJs("    const md = window.markdownit(); \n    const input = $0;\n    if(this.markdown) {\n        this.markdown = this.markdown + input;\n    } else {\n        this.markdown = input;\n    }\n    const html = md.render(this.markdown);\n    this.innerHTML = html;\n", new Object[]{markdown});
            };
            if (uiAccess) {
                MarkdownMessage.this.getUi().access((Command)c);
            } else {
                c.execute();
            }
        }

        @Override
        public void setMarkdown(String markdown, boolean uiAccess) {
            Command & Serializable c = (Command & Serializable)() -> {
                RichText.MarkdownItStrategy.ensureMarkdownIt();
                MarkdownMessage.this.content.executeJs("    const md = window.markdownit(); \n    const input = $0;\n    this.markdown = input;\n    const html = md.render(input);\n    this.innerHTML = html;\n", new Object[]{markdown == null ? "" : markdown});
            };
            if (uiAccess) {
                MarkdownMessage.this.getUi().access((Command)c);
            } else {
                c.execute();
            }
        }
    }
}

